/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.VarElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebuggableFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.FilledExpressionSlot;
import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleLineFrame;
import bluej.stride.operations.FrameOperation;
import bluej.stride.operations.ToggleBooleanProperty;
import bluej.stride.slots.AccessPermissionSlot;
import bluej.stride.slots.ChoiceSlot;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.FocusParent;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.SlotValueListener;
import bluej.stride.slots.VariableNameDefTextSlot;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public class VarFrame
extends SingleLineFrame
implements CodeFrame<VarElement>,
DebuggableFrame {
    private static final String STATIC_NAME = "static";
    private static final String FINAL_NAME = "final";
    private static final String TOGGLE_STATIC_VAR = "toggleStaticVar";
    private static final String TOGGLE_FINAL_VAR = "toggleFinalVar";
    private final BooleanProperty accessModifier = new SimpleBooleanProperty(false);
    private final ChoiceSlot<AccessPermission> access;
    private final SlotLabel staticLabel = new SlotLabel("static ", new String[0]);
    private final BooleanProperty staticModifier = new SimpleBooleanProperty(false);
    private final SlotLabel finalLabel = new SlotLabel("final ", new String[0]);
    private final BooleanProperty finalModifier = new SimpleBooleanProperty(false);
    private final TypeSlot slotType;
    private final VariableNameDefTextSlot slotName;
    private final BooleanProperty showingValue = new SimpleBooleanProperty(false);
    private final SlotLabel assignLabel = new SlotLabel("\u21d0", new String[0]);
    private final ExpressionSlot<FilledExpressionSlotFragment> slotValue;
    private final BooleanProperty slotValueBlank = new SimpleBooleanProperty(true);
    private VarElement element;
    private final BooleanProperty hasKeyboardFocus = new SimpleBooleanProperty(false);
    private final BooleanProperty inInterfaceProperty = new SimpleBooleanProperty(false);

    VarFrame(InteractionManager editor, boolean isFinal, boolean isStatic) {
        super(editor, "var ", "var-");
        this.staticModifier.set(isStatic);
        this.finalModifier.set(isFinal);
        this.modifiers.put(STATIC_NAME, this.staticModifier);
        this.modifiers.put(FINAL_NAME, this.finalModifier);
        this.headerCaptionLabel.setAnimateCaption(false);
        this.slotName = new VariableNameDefTextSlot(editor, this, this.getHeaderRow(), () -> this.isField(this.getParentCanvas()), "var-name-");
        this.slotName.addValueListener(new SlotValueListener(){

            @Override
            public boolean valueChanged(HeaderItem slot, String oldValue, String newValue, FocusParent<HeaderItem> parent) {
                return true;
            }

            @Override
            public void deletePressedAtEnd(HeaderItem slot) {
                VarFrame.this.deleteAtEnd(VarFrame.this.getHeaderRow(), slot);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void backSpacePressedAtStart(HeaderItem slot) {
                VarFrame.this.backspaceAtStart(VarFrame.this.getHeaderRow(), slot);
            }
        });
        this.slotName.setPromptText("name");
        this.slotType = new TypeSlot(editor, this, this, this.getHeaderRow(), TypeSlot.Role.DECLARATION, "var-type-");
        this.slotType.setSimplePromptText("type");
        this.slotType.addClosingChar(' ');
        this.access = new AccessPermissionSlot(editor, this, this.getHeaderRow(), "var-access-");
        this.access.setValue(AccessPermission.PRIVATE);
        this.slotValue = new FilledExpressionSlot(editor, this, this, this.getHeaderRow(), "var-value-");
        this.slotValue.bindTargetType(this.slotType.javaProperty());
        this.slotValue.setSimplePromptText("value");
        this.slotValue.onLostFocus(this::checkForEmptySlot);
        JavaFXUtil.addChangeListener(this.showingValue, showing -> {
            if (!showing.booleanValue()) {
                this.slotValue.cleanup();
            }
        });
        FXRunnable runAddValSlot = () -> this.getHeaderRow().focusRight(this.slotName);
        this.slotName.addValueListener(new SlotTraversalChars(runAddValSlot, SlotTraversalChars.ASSIGN_LHS.getChars()));
        this.getHeaderRow().bindContentsConcat((ObservableList<ObservableList<? extends HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{FXCollections.observableArrayList((Object[])new SlotLabel[]{this.headerCaptionLabel}), JavaFXUtil.listBool((BooleanExpression)this.accessModifier, this.access), JavaFXUtil.listBool((BooleanExpression)this.staticModifier, this.staticLabel), JavaFXUtil.listBool((BooleanExpression)this.finalModifier, this.finalLabel), FXCollections.observableArrayList((Object[])new EditableSlot[]{this.slotType, this.slotName}), JavaFXUtil.listBool((BooleanExpression)this.showingValue, this.assignLabel, this.slotValue), FXCollections.observableArrayList((Object[])new SlotLabel[]{this.previewSemi})}));
        JavaFXUtil.addChangeListener(this.staticModifier, b -> editor.modifiedFrame(this, false));
        JavaFXUtil.addChangeListener(this.finalModifier, b -> editor.modifiedFrame(this, false));
        this.hasKeyboardFocus.bind((ObservableValue)this.accessModifier.and(this.access.effectivelyFocusedProperty()).or(this.slotType.effectivelyFocusedProperty()).or(this.slotName.effectivelyFocusedProperty()).or(this.slotValue.effectivelyFocusedProperty()));
        this.slotValue.onTextPropertyChange(s -> this.slotValueBlank.set(s.isEmpty()));
        ReadOnlyBooleanProperty keyFocusDelayed = JavaFXUtil.delay((ObservableBooleanValue)this.hasKeyboardFocus, Duration.ZERO, Duration.millis((double)100.0));
        this.showingValue.bind((ObservableValue)this.inInterfaceProperty.or((ObservableBooleanValue)keyFocusDelayed).or((ObservableBooleanValue)this.slotValueBlank.not()));
    }

    public VarFrame(InteractionManager editor, AccessPermissionFragment accessValue, boolean staticModifier, boolean finalModifier, TypeSlotFragment varType, NameDefSlotFragment varName, FilledExpressionSlotFragment varValue, boolean enabled) {
        this(editor, finalModifier, staticModifier);
        this.accessModifier.set(accessValue != null);
        if (accessValue != null) {
            this.access.setValue(accessValue.getValue());
        }
        this.slotType.setText(varType);
        this.slotName.setText(varName);
        if (varValue != null) {
            this.slotValue.setText(varValue);
        }
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    public void regenerateCode() {
        boolean generateValue = this.showingValue.get() && (!this.slotValue.getText().isEmpty() || this.slotValue.isCurrentlyCompleting());
        this.element = new VarElement(this, this.accessModifier.get() ? new AccessPermissionFragment(this.access.getValue(AccessPermission.EMPTY)) : null, this.staticModifier.get(), this.finalModifier.get(), (TypeSlotFragment)this.slotType.getSlotElement(), (NameDefSlotFragment)this.slotName.getSlotElement(), generateValue ? (FilledExpressionSlotFragment)this.slotValue.getSlotElement() : null, this.frameEnabledProperty.get());
    }

    @Override
    public VarElement getCode() {
        return this.element;
    }

    public static FrameFactory<VarFrame> getFactory() {
        return new FrameFactory<VarFrame>(){

            @Override
            public VarFrame createBlock(InteractionManager editor) {
                return new VarFrame(editor, false, false);
            }

            @Override
            public Class<VarFrame> getBlockClass() {
                return VarFrame.class;
            }
        };
    }

    public static FrameFactory<VarFrame> getLocalConstantFactory() {
        return new FrameFactory<VarFrame>(){

            @Override
            public VarFrame createBlock(InteractionManager editor) {
                return new VarFrame(editor, true, false);
            }

            @Override
            public Class<VarFrame> getBlockClass() {
                return VarFrame.class;
            }
        };
    }

    public static FrameFactory<VarFrame> getClassConstantFactory() {
        return new FrameFactory<VarFrame>(){

            @Override
            public VarFrame createBlock(InteractionManager editor) {
                return new VarFrame(editor, true, true);
            }

            @Override
            public Class<VarFrame> getBlockClass() {
                return VarFrame.class;
            }
        };
    }

    public static FrameFactory<VarFrame> getInterfaceConstantFactory() {
        return new FrameFactory<VarFrame>(){

            @Override
            public VarFrame createBlock(InteractionManager editor) {
                return new VarFrame(editor, false, false);
            }

            @Override
            public Class<VarFrame> getBlockClass() {
                return VarFrame.class;
            }
        };
    }

    @Override
    public void updateAppearance(FrameCanvas parentCanvas) {
        super.updateAppearance(parentCanvas);
        if (parentCanvas == null) {
            return;
        }
        this.inInterfaceProperty.setValue(Boolean.valueOf(this.isInInterface(parentCanvas)));
        if (this.isField(parentCanvas)) {
            if (this.inInterfaceProperty.getValue().booleanValue()) {
                this.addStyleClass("interface-var-frame");
            } else {
                this.accessModifier.set(true);
                this.addStyleClass("class-var-frame");
            }
            this.headerCaptionLabel.setText("");
        } else {
            this.staticModifier.set(false);
            this.accessModifier.set(false);
            this.removeStyleClass(this.isInInterface(parentCanvas) ? "interface-var-frame" : "class-var-frame");
            this.headerCaptionLabel.setText("var ");
            JavaFXUtil.setPseudoclass("bj-transparent", this.isAfterVarFrame(parentCanvas), this.headerCaptionLabel.getNode());
        }
    }

    private boolean isAfterVarFrame(FrameCanvas parentCanvas) {
        Frame frameBefore = parentCanvas.getFrameBefore(this.getCursorBefore());
        for (int counter = 0; frameBefore != null && !frameBefore.isEffectiveFrame() && counter < 2; ++counter) {
            frameBefore = parentCanvas.getFrameBefore(frameBefore.getCursorBefore());
        }
        return frameBefore instanceof VarFrame;
    }

    private boolean isField(FrameCanvas parentCanvas) {
        if (parentCanvas == null) {
            return false;
        }
        return parentCanvas.getParent().getChildKind(parentCanvas) == CanvasParent.CanvasKind.FIELDS;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<FrameOperation> getContextOperations() {
        ArrayList<FrameOperation> operations = new ArrayList<FrameOperation>(super.getContextOperations());
        operations.addAll(this.getStaticFinalOperations());
        return operations;
    }

    @Override
    public List<String> getDeclaredVariablesAfter() {
        String name = this.slotName.getText();
        if (name.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(name);
    }

    @Override
    public EditableSlot getErrorShowRedirect() {
        return this.slotName;
    }

    @Override
    public void focusName() {
        this.slotName.requestFocus(Focus.LEFT);
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        super.setViewNoOverride(oldView, newView, animateProgress);
        if (newView == Frame.View.JAVA_PREVIEW) {
            this.headerCaptionLabel.shrinkHorizontally(animateProgress);
        } else {
            this.headerCaptionLabel.growHorizontally(animateProgress);
        }
        this.assignLabel.setText(newView == Frame.View.JAVA_PREVIEW ? "=" : "\u21d0");
    }

    @Override
    public boolean tryRestoreTo(CodeElement codeElement) {
        if (codeElement instanceof VarElement) {
            VarElement nme = (VarElement)codeElement;
            this.staticModifier.set(nme.isStatic());
            this.finalModifier.set(nme.isFinal());
            this.slotType.setText(nme.getType());
            this.slotName.setText(nme.getName());
            if (nme.getValue() != null) {
                this.slotValue.setText(nme.getValue());
            } else if (this.slotValue != null) {
                this.slotValue.setText("");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.slotType.requestFocus();
        return true;
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas innerCanvas, FrameCursor cursorInCanvas) {
        ArrayList<ExtensionDescription> extensions = new ArrayList<ExtensionDescription>(super.getAvailableExtensions(innerCanvas, cursorInCanvas));
        if (!this.inInterfaceProperty.getValue().booleanValue()) {
            this.getStaticFinalOperations().forEach(op -> extensions.add(new ExtensionDescription((ToggleBooleanProperty)op, this, true, ExtensionDescription.ExtensionSource.BEFORE, ExtensionDescription.ExtensionSource.AFTER, ExtensionDescription.ExtensionSource.MODIFIER, ExtensionDescription.ExtensionSource.SELECTION)));
        }
        return extensions;
    }

    private List<ToggleBooleanProperty> getStaticFinalOperations() {
        ArrayList<ToggleBooleanProperty> operations = new ArrayList<ToggleBooleanProperty>();
        operations.add(new ToggleBooleanProperty(this.getEditor(), TOGGLE_FINAL_VAR, FINAL_NAME, 'n'));
        if (this.isField(this.getParentCanvas())) {
            operations.add(new ToggleBooleanProperty(this.getEditor(), TOGGLE_STATIC_VAR, STATIC_NAME, 's'));
        }
        return operations;
    }

    @Override
    public Stream<EditableSlot> getPossiblyHiddenSlotsDirect() {
        return Stream.of(this.access, this.slotValue);
    }
}

