/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.frames.BlankFrame;
import bluej.stride.framedjava.frames.BreakFrame;
import bluej.stride.framedjava.frames.CallFrame;
import bluej.stride.framedjava.frames.CaseFrame;
import bluej.stride.framedjava.frames.CommentFrame;
import bluej.stride.framedjava.frames.ConstructorFrame;
import bluej.stride.framedjava.frames.ForeachFrame;
import bluej.stride.framedjava.frames.IfFrame;
import bluej.stride.framedjava.frames.ImportFrame;
import bluej.stride.framedjava.frames.MethodProtoFrame;
import bluej.stride.framedjava.frames.NormalMethodFrame;
import bluej.stride.framedjava.frames.ReturnFrame;
import bluej.stride.framedjava.frames.StrideCategory;
import bluej.stride.framedjava.frames.SwitchFrame;
import bluej.stride.framedjava.frames.ThrowFrame;
import bluej.stride.framedjava.frames.TryFrame;
import bluej.stride.framedjava.frames.VarFrame;
import bluej.stride.framedjava.frames.WhileFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameDictionary;
import bluej.stride.generic.FrameTypeCheck;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StrideDictionary
extends FrameDictionary<StrideCategory> {
    private static StrideDictionary instance = new StrideDictionary();
    private Map<String, Character> extensions = new HashMap<String, Character>();
    public static final char ABSTRACT_EXTENSION_CHAR = 'b';
    public static final char DEFAULT_EXTENSION_CHAR = 'd';
    public static final char EXTENDS_EXTENSION_CHAR = 'e';
    public static final char IMPLEMENTS_EXTENSION_CHAR = 'i';
    public static final char THIS_EXTENSION_CHAR = 't';
    public static final char SUPER_EXTENSION_CHAR = 'u';
    public static final char THROWS_EXTENSION_CHAR = 'o';

    public static StrideDictionary getDictionary() {
        return instance;
    }

    private StrideDictionary() {
        super(Arrays.asList(new FrameDictionary.Entry<StrideCategory>(' ', CallFrame.getFactory(), false, StrideCategory.CALL, "stride.dictionary.call.method.name", "stride.dictionary.call.method.description"), new FrameDictionary.Entry<StrideCategory>('\n', BlankFrame.getFactory(), false, StrideCategory.BLANK, "stride.dictionary.blank.name", "stride.dictionary.blank.description"), new FrameDictionary.Entry<StrideCategory>('/', CommentFrame.getFactory(), false, StrideCategory.COMMENT, "stride.dictionary.comment.name", "stride.dictionary.comment.description"), new FrameDictionary.Entry<StrideCategory>('=', AssignFrame.getFactory(), false, StrideCategory.ASSIGNMENT, "stride.dictionary.assignment", "stride.dictionary.assignment"), new FrameDictionary.Entry<StrideCategory>('a', MethodProtoFrame.getFactory(), false, StrideCategory.INTERFACE_METHOD, "stride.dictionary.abstract.method.name", "stride.dictionary.abstract.method.interface.description", false), new FrameDictionary.Entry<StrideCategory>('a', MethodProtoFrame.getFactory(), false, StrideCategory.CLASS_METHOD, "stride.dictionary.abstract.method.name", "stride.dictionary.abstract.method.class.description"), new FrameDictionary.Entry<StrideCategory>('b', BreakFrame.getFactory(), false, StrideCategory.BREAK, "stride.dictionary.break.name", "stride.dictionary.break.description"), new FrameDictionary.Entry<StrideCategory>('c', ConstructorFrame.getFactory(), false, StrideCategory.CONSTRUCTOR, "stride.dictionary.constructor.name", "stride.dictionary.constructor.description"), new FrameDictionary.Entry<StrideCategory>('c', CaseFrame.getFactory(), false, StrideCategory.CASE, "stride.dictionary.case.name", "stride.dictionary.case.description"), new FrameDictionary.Entry<StrideCategory>('c', VarFrame.getLocalConstantFactory(), false, StrideCategory.VAR_LOCAL, "stride.dictionary.constant.name", "stride.dictionary.constant.description"), new FrameDictionary.Entry<StrideCategory>('c', VarFrame.getClassConstantFactory(), false, StrideCategory.CONSTANT_CLASS_FIELD, "stride.dictionary.constant.name", "stride.dictionary.constant.description"), new FrameDictionary.Entry<StrideCategory>('c', VarFrame.getInterfaceConstantFactory(), false, StrideCategory.CONSTANT_INTERFACE_FIELD, "stride.dictionary.constant.name", "stride.dictionary.constant.description"), new FrameDictionary.Entry<StrideCategory>('f', ForeachFrame.getFactory(), true, StrideCategory.LOOP, "stride.dictionary.for.each.name", "stride.dictionary.for.each.description"), new FrameDictionary.Entry<StrideCategory>('i', IfFrame.getFactory(), true, StrideCategory.CONDITIONAL, "stride.dictionary.if.name", "stride.dictionary.if.description"), new FrameDictionary.Entry<StrideCategory>('i', ImportFrame.getFactory(), false, StrideCategory.IMPORT, "stride.dictionary.import.name", "stride.dictionary.import.description"), new FrameDictionary.Entry<StrideCategory>('m', NormalMethodFrame.getFactory(), false, StrideCategory.CLASS_METHOD, "stride.dictionary.method.name", "stride.dictionary.method.description"), new FrameDictionary.Entry<StrideCategory>('m', MethodProtoFrame.getFactory(), false, StrideCategory.INTERFACE_METHOD, "stride.dictionary.abstarct.name", "stride.dictionary.abstract.method.interface.description"), new FrameDictionary.Entry<StrideCategory>('r', ReturnFrame.getFactory(), false, StrideCategory.RETURN, "stride.dictionary.return.name", "stride.dictionary.return.description"), new FrameDictionary.Entry<StrideCategory>('s', SwitchFrame.getFactory(), false, StrideCategory.SWITCH, "stride.dictionary.switch.name", "stride.dictionary.switch.description"), new FrameDictionary.Entry<StrideCategory>('v', VarFrame.getFactory(), false, StrideCategory.VAR, "stride.dictionary.variable.name", "stride.dictionary.variable.description"), new FrameDictionary.Entry<StrideCategory>('w', WhileFrame.getFactory(), true, StrideCategory.LOOP, "stride.dictionary.while.name", "stride.dictionary.while.description"), new FrameDictionary.Entry<StrideCategory>('x', ThrowFrame.getFactory(), false, StrideCategory.THROW, "stride.dictionary.throw.name", "stride.dictionary.throw.description"), new FrameDictionary.Entry<StrideCategory>('y', TryFrame.getFactory(), true, StrideCategory.TRY, "stride.dictionary.try.name", "stride.dictionary.try.description")));
        this.extensions.put("catch", Character.valueOf('c'));
        this.extensions.put("else", Character.valueOf('e'));
        this.extensions.put("elseif", Character.valueOf('l'));
        this.extensions.put("finally", Character.valueOf('n'));
    }

    public StrideCategory[] getCategories() {
        return StrideCategory.values();
    }

    @Override
    public String[] getCategoryNames() {
        String[] names = new String[StrideCategory.values().length];
        for (int i = 0; i < names.length; ++i) {
            String str = StrideCategory.values()[i].toString();
            names[i] = str.substring(0, 1) + str.substring(1).toLowerCase();
        }
        return names;
    }

    private static FrameTypeCheck checkCategories(StrideCategory ... categories) {
        final List<StrideCategory> categoryList = Arrays.asList(categories);
        return new FrameTypeCheck(){

            @Override
            public boolean canInsert(StrideCategory category) {
                return categoryList.contains((Object)category);
            }

            @Override
            public boolean canPlace(Class<? extends Frame> type) {
                return StrideDictionary.getDictionary().getAllBlocks().stream().filter(e -> categoryList.contains(e.getCategory())).anyMatch(p -> p.getBlockClass().equals(type));
            }
        };
    }

    public static FrameTypeCheck checkStatement() {
        return StrideDictionary.checkCategories(StrideCategory.CONDITIONAL, StrideCategory.VAR, StrideCategory.VAR_LOCAL, StrideCategory.BLANK, StrideCategory.COMMENT, StrideCategory.LOOP, StrideCategory.ASSIGNMENT, StrideCategory.CALL, StrideCategory.BREAK, StrideCategory.SWITCH, StrideCategory.THROW, StrideCategory.TRY, StrideCategory.RETURN);
    }

    public static FrameTypeCheck checkClassField() {
        return StrideDictionary.checkCategories(StrideCategory.VAR, StrideCategory.CONSTANT_CLASS_FIELD, StrideCategory.BLANK, StrideCategory.COMMENT);
    }

    public static FrameTypeCheck checkInterfaceField() {
        return StrideDictionary.checkCategories(StrideCategory.CONSTANT_INTERFACE_FIELD, StrideCategory.BLANK, StrideCategory.COMMENT);
    }

    public static FrameTypeCheck checkConstructor() {
        return StrideDictionary.checkCategories(StrideCategory.CONSTRUCTOR, StrideCategory.COMMENT);
    }

    public static FrameTypeCheck checkClassMethod() {
        return StrideDictionary.checkCategories(StrideCategory.CLASS_METHOD, StrideCategory.COMMENT);
    }

    public static FrameTypeCheck checkInterfaceMethod() {
        return StrideDictionary.checkCategories(StrideCategory.INTERFACE_METHOD, StrideCategory.COMMENT);
    }

    public static FrameTypeCheck checkImport() {
        return StrideDictionary.checkCategories(StrideCategory.IMPORT);
    }

    public char getExtensionChar(String tailCanvasCaption) {
        return this.extensions.get(tailCanvasCaption).charValue();
    }
}

