/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.editor.stride.BirdseyeManager;
import bluej.parser.entity.EntityResolver;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.elements.InterfaceElement;
import bluej.stride.framedjava.frames.ConstructorFrame;
import bluej.stride.framedjava.frames.MethodProtoFrame;
import bluej.stride.framedjava.frames.StrideDictionary;
import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.TopLevelDocumentMultiCanvasFrame;
import bluej.stride.operations.CopyFrameAsImageOperation;
import bluej.stride.operations.CopyFrameAsJavaOperation;
import bluej.stride.operations.CopyFrameAsStrideOperation;
import bluej.stride.operations.CustomFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.ExtendsList;
import bluej.stride.slots.Focus;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.TextSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import threadchecker.OnThread;
import threadchecker.Tag;

public class InterfaceFrame
extends TopLevelDocumentMultiCanvasFrame<InterfaceElement> {
    private final ExtendsList extendsList;

    public InterfaceFrame(InteractionManager editor, EntityResolver projectResolver, String packageName, List<ImportElement> imports, JavadocUnit documentation, NameDefSlotFragment interfaceName, List<TypeSlotFragment> extendsTypes, boolean enabled) {
        super(editor, projectResolver, "interface", "interface-", packageName, imports, documentation, interfaceName, enabled);
        this.extendsList = new ExtendsList(this, () -> {
            TypeSlot s = new TypeSlot(editor, this, this, this.getHeaderRow(), TypeSlot.Role.INTERFACE, "interface-");
            s.setSimplePromptText("interface type");
            return s;
        }, () -> this.getCanvases().findFirst().ifPresent(c -> c.getFirstCursor().requestFocus()), editor);
        extendsTypes.forEach(t -> this.extendsList.addTypeSlotAtEnd(t.getContent(), false));
        this.extendsList.focusedProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.extendsList.ensureAtLeastOneSlot();
            } else {
                this.extendsList.clearIfSingleEmpty();
            }
        });
        this.getHeaderRow().bindContentsConcat((ObservableList<ObservableList<? extends HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{FXCollections.observableArrayList((Object[])new SlotLabel[]{this.headerCaptionLabel}), FXCollections.observableArrayList((Object[])new TextSlot[]{this.paramName}), this.extendsList.getHeaderItems()}));
    }

    @Override
    protected Frame findASpecialMethod() {
        return null;
    }

    @Override
    public synchronized void regenerateCode() {
        List<CodeElement> fields = this.getMembers(this.fieldsCanvas);
        List<CodeElement> methods = this.getMembers(this.methodsCanvas);
        List<ImportElement> imports = Utility.mapList(this.getMembers(this.importCanvas), e -> (ImportElement)e);
        this.element = new InterfaceElement(this, this.projectResolver, (NameDefSlotFragment)this.paramName.getSlotElement(), this.extendsList.getTypes(), fields, methods, new JavadocUnit(this.getDocumentation()), this.packageNameLabel == null ? null : this.packageNameLabel.getText(), imports, this.frameEnabledProperty.get());
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public synchronized @OnThread(value=Tag.Any, ignoreParent=true) InterfaceElement getCode() {
        return (InterfaceElement)this.element;
    }

    @Override
    public List<FrameOperation> getContextOperations() {
        ArrayList<FrameOperation> ops = new ArrayList<FrameOperation>();
        ops.add(new CopyFrameAsStrideOperation(this.editor));
        ops.add(new CopyFrameAsImageOperation(this.editor));
        ops.add(new CopyFrameAsJavaOperation(this.editor));
        ops.add(new CustomFrameOperation(this.getEditor(), "addExtends", Arrays.asList("Add 'extends'"), EditableSlot.MenuItemOrder.TOGGLE_EXTENDS, this, () -> this.extendsList.addTypeSlotAtEnd("", true)));
        List<TypeSlotFragment> types = this.extendsList.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            int index = i;
            TypeSlotFragment type = types.get(i);
            CustomFrameOperation removeOp = new CustomFrameOperation(this.getEditor(), "removeExtends", Arrays.asList("Remove 'extends " + type.getContent() + "'"), EditableSlot.MenuItemOrder.TOGGLE_EXTENDS, this, () -> this.extendsList.removeIndex(index));
            removeOp.setWideCustomItem(true);
            ops.add(removeOp);
        }
        return ops;
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursorInCanvas) {
        ExtensionDescription extendsExtension = null;
        if (this.fieldsCanvas.equals(canvas) || canvas == null) {
            extendsExtension = new ExtensionDescription('e', "Add extends declaration", () -> this.extendsList.addTypeSlotAtEnd("", true), true, ExtensionDescription.ExtensionSource.INSIDE_FIRST, ExtensionDescription.ExtensionSource.MODIFIER);
        }
        return Utility.nonNulls(Arrays.asList(extendsExtension));
    }

    @Override
    public void saved() {
    }

    @Override
    public BirdseyeManager prepareBirdsEyeView(SharedTransition animate) {
        return null;
    }

    @Override
    public void addExtendsClassOrInterface(String className) {
        this.extendsList.addTypeSlotAtEnd(className, false);
    }

    @Override
    public void addImplements(String className) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeExtendsClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeExtendsOrImplementsInterface(String interfaceName) {
        List<TypeSlotFragment> extendsTypes = this.extendsList.getTypes();
        for (int i = 0; i < extendsTypes.size(); ++i) {
            if (!extendsTypes.get(i).getContent().equals(interfaceName)) continue;
            this.extendsList.removeIndex(i);
            return;
        }
    }

    @Override
    public boolean canDoBirdseye() {
        return false;
    }

    @Override
    public void addDefaultConstructor() {
        throw new IllegalAccessError();
    }

    @Override
    public List<ConstructorFrame> getConstructors() {
        return Collections.emptyList();
    }

    @Override
    public List<MethodProtoFrame> getMethods() {
        return this.methodsCanvas.getBlocksSubtype(MethodProtoFrame.class);
    }

    @Override
    public Stream<FrameCanvas> getPersistentCanvases() {
        return this.getCanvases();
    }

    @Override
    public FrameTypeCheck check(FrameCanvas canvas) {
        if (canvas == this.fieldsCanvas) {
            return StrideDictionary.checkInterfaceField();
        }
        if (canvas == this.methodsCanvas) {
            return StrideDictionary.checkInterfaceMethod();
        }
        throw new IllegalStateException("Asking about canvas unknown to InterfaceFrame");
    }

    @Override
    public CanvasParent.CanvasKind getChildKind(FrameCanvas c) {
        if (c == this.fieldsCanvas) {
            return CanvasParent.CanvasKind.FIELDS;
        }
        if (c == this.methodsCanvas) {
            return CanvasParent.CanvasKind.METHODS;
        }
        return CanvasParent.CanvasKind.STATEMENTS;
    }

    @Override
    public void restore(InterfaceElement target) {
        this.paramName.setText(target.getName());
        this.extendsList.setTypes(target.getExtends());
        this.importCanvas.restore(target.getImports(), this.editor);
        this.fieldsCanvas.restore(target.getFields(), this.editor);
        this.methodsCanvas.restore(target.getMethods(), this.editor);
    }

    @Override
    protected FrameContentRow makeHeader(String stylePrefix) {
        return new FrameContentRow(this, stylePrefix){

            @Override
            public boolean focusRightEndFromNext() {
                InterfaceFrame.this.extendsList.ensureAtLeastOneSlot();
                Utility.findLast(InterfaceFrame.this.extendsList.getTypeSlots()).get().requestFocus(Focus.RIGHT);
                return true;
            }
        };
    }

    @Override
    protected List<FrameContentRow> getLabelRows() {
        return Arrays.asList(this.importRow, this.fieldsLabelRow, this.methodsLabelRow);
    }

    @Override
    protected List<SlotLabel> getCanvasLabels() {
        return Arrays.asList(this.importsLabel, this.fieldsLabel, this.methodsLabel);
    }
}

