/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.frames.DebugVarInfo;
import bluej.stride.framedjava.frames.WhileFrame;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import threadchecker.OnThread;
import threadchecker.Tag;

public class DebugInfo {
    private final IdentityHashMap<FrameCursor, Display> displays = new IdentityHashMap();
    private @OnThread(value=Tag.Any, requireSynchronized=true) Map<String, DebugVarInfo> prevState;
    private @OnThread(value=Tag.Any, requireSynchronized=true) Map<String, DebugVarInfo> state;
    private final SimpleBooleanProperty showVars = new SimpleBooleanProperty(false);
    private int stateIndex;

    @OnThread(value=Tag.Any)
    public DebugInfo() {
    }

    @OnThread(value=Tag.Any)
    public synchronized void addVarState(Map<String, DebugVarInfo> state, int index) {
        this.prevState = this.state;
        this.state = state;
        this.stateIndex = index;
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized Display getInfoDisplay(FrameCursor f, Node frameNode, String stylePrefix, boolean isBeforeBreakpointFrame) {
        if (this.displays.containsKey(f)) {
            this.displays.get(f).addState(this.prevState, this.state, this.stateIndex);
            return this.displays.get(f);
        }
        Display d = new Display(this.prevState, this.state, this.stateIndex, frameNode, stylePrefix, isBeforeBreakpointFrame);
        Frame frame = f.getFrameAfter();
        while (frame != null) {
            FrameCursor cursor;
            if ((frame = (Frame)Optional.ofNullable(frame.getParentCanvas()).map(FrameCanvas::getParent).map(CanvasParent::getFrame).orElse(null)) == null || !(frame instanceof WhileFrame) || !this.displays.containsKey(cursor = frame.getCursorBefore())) continue;
            this.displays.get(cursor).addChild(d);
        }
        this.displays.put(f, d);
        return d;
    }

    public void removeAllDisplays(List<Node> disps) {
        Iterator<Map.Entry<FrameCursor, Display>> it = this.displays.entrySet().iterator();
        while (it.hasNext()) {
            if (!disps.contains(it.next().getValue())) continue;
            it.remove();
        }
    }

    public void hideAllDisplays() {
        this.displays.forEach((cursor, display) -> cursor.getParentCanvas().getSpecialBefore((FrameCursor)cursor).getChildren().remove(display));
        this.displays.clear();
    }

    public void bindVarVisible(ObservableBooleanValue showVars) {
        this.showVars.bind((ObservableValue)showVars);
    }

    public class Display
    extends AnchorPane
    implements HighlightedBreakpoint {
        private final ObservableList<Pane> varDisplay = FXCollections.observableArrayList();
        private final ArrayList<Integer> varIndexes = new ArrayList();
        private final Node frameNode;
        private final SimpleIntegerProperty curDisplay = new SimpleIntegerProperty(-1);
        private final Label curCounter;
        private final boolean isBreakpointFrame;
        private final ObservableList<Display> children = FXCollections.observableArrayList();
        private final BooleanBinding showControls;
        private Display parent = null;

        @OnThread(value=Tag.FXPlatform)
        public Display(Map<String, DebugVarInfo> prevVars, Map<String, DebugVarInfo> vars, int varIndex, Node frameNode, String stylePrefix, boolean isBreakpointFrame) {
            this.isBreakpointFrame = isBreakpointFrame;
            this.frameNode = frameNode;
            HBox controls = new HBox();
            this.curCounter = new Label("1/1");
            this.curCounter.textProperty().bind((ObservableValue)this.curDisplay.add(1).asString().concat((Object)"/").concat((Object)Bindings.size(this.varDisplay).asString()));
            Label leftArrow = new Label("<");
            Label rightArrow = new Label(">");
            JavaFXUtil.addStyleClass((Styleable)this.curCounter, "debug-info-number");
            JavaFXUtil.addStyleClass((Styleable)leftArrow, "debug-info-arrow");
            JavaFXUtil.addStyleClass((Styleable)rightArrow, "debug-info-arrow");
            leftArrow.setOnMouseClicked(e -> {
                this.left();
                e.consume();
            });
            rightArrow.setOnMouseClicked(e -> {
                this.right();
                e.consume();
            });
            controls.getChildren().addAll((Object[])new Node[]{leftArrow, this.curCounter, rightArrow});
            AnchorPane.setTopAnchor((Node)controls, (Double)2.0);
            AnchorPane.setRightAnchor((Node)controls, (Double)5.0);
            this.showControls = Bindings.size(this.varDisplay).greaterThan(1).and((ObservableBooleanValue)Bindings.isNotEmpty(this.children));
            controls.managedProperty().bind((ObservableValue)this.showControls);
            controls.visibleProperty().bind((ObservableValue)this.showControls);
            this.getChildren().add((Object)controls);
            JavaFXUtil.addStyleClass((Styleable)this, "debug-info-surround");
            if (stylePrefix != null && !stylePrefix.isEmpty()) {
                JavaFXUtil.setPseudoclass("bj-" + stylePrefix + "debug", true, new Node[]{this});
            }
            this.curDisplay.addListener((prop, prev, now) -> {
                if (prev.intValue() >= 0 && prev.intValue() < this.varDisplay.size()) {
                    this.getChildren().remove(this.varDisplay.get(prev.intValue()));
                }
                if (now.intValue() >= 0 && now.intValue() < this.varDisplay.size()) {
                    this.getChildren().add(0, this.varDisplay.get(now.intValue()));
                }
                this.updateChildren();
            });
            this.varDisplay.addListener(c -> {
                if (this.parent == null && this.curDisplay.get() == this.varDisplay.size() - 1) {
                    this.getChildren().add(0, this.varDisplay.get(this.curDisplay.get()));
                }
            });
            this.addState(prevVars, vars, varIndex);
        }

        @OnThread(value=Tag.FXPlatform)
        private Pane makeDisplay(Map<String, DebugVarInfo> prevVars, Map<String, DebugVarInfo> vars) {
            GridPane disp = new GridPane();
            disp.setHgap(20.0);
            JavaFXUtil.addStyleClass((Styleable)disp, "debug-info-rows");
            int index = 0;
            for (Map.Entry<String, DebugVarInfo> var : vars.entrySet()) {
                DebugVarInfo prev = prevVars == null ? null : prevVars.get(var.getKey());
                HBox row = new HBox();
                Label k = new Label(var.getKey() + ": ");
                k.getStyleClass().add((Object)"debug-info-text");
                Node v = var.getValue().getDisplay(prev);
                v.getStyleClass().add((Object)"debug-info-text");
                row.getChildren().addAll((Object[])new Node[]{k, v});
                disp.add((Node)row, index % 3, index / 3);
                row.getStyleClass().add((Object)"debug-info");
                row.managedProperty().bind((ObservableValue)DebugInfo.this.showVars);
                row.visibleProperty().bind((ObservableValue)DebugInfo.this.showVars);
                ++index;
            }
            return disp;
        }

        @OnThread(value=Tag.FXPlatform)
        public void addState(Map<String, DebugVarInfo> prevVars, Map<String, DebugVarInfo> vars, int varIndex) {
            Pane disp = this.makeDisplay(prevVars, vars);
            this.varIndexes.add(varIndex);
            this.varDisplay.add((Object)disp);
            if (this.parent == null) {
                this.curDisplay.set(this.varDisplay.size() - 1);
            }
            AnchorPane.setTopAnchor((Node)disp, (Double)1.0);
            AnchorPane.setLeftAnchor((Node)disp, (Double)1.0);
            AnchorPane.setBottomAnchor((Node)disp, (Double)1.0);
            AnchorPane.setRightAnchor((Node)disp, (Double)1.0);
            JavaFXUtil.setPseudoclass("bj-highlight", false, DebugInfo.this.displays.values().toArray(new Node[0]));
            JavaFXUtil.setPseudoclass("bj-highlight", true, new Node[]{this});
            this.pulse();
        }

        private void left() {
            if (this.curDisplay.get() > 0) {
                this.curDisplay.set(this.curDisplay.get() - 1);
            }
        }

        private void right() {
            if (this.curDisplay.get() < this.varDisplay.size() - 1) {
                this.curDisplay.set(this.curDisplay.get() + 1);
            }
        }

        private void pulse() {
        }

        @Override
        public void removeHighlight() {
        }

        @Override
        public Node getNode() {
            return this;
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public double getYOffset() {
            return 5.0;
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public double getYOffsetOfTurnBack() {
            return this.frameNode.localToScene(this.frameNode.getBoundsInLocal()).getMaxY() - 5.0 - this.localToScene(this.getBoundsInLocal()).getMinY();
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public boolean isBreakpointFrame() {
            return this.isBreakpointFrame;
        }

        public void addChild(Display child) {
            if (!this.children.contains((Object)child)) {
                this.children.add((Object)child);
                child.parent = this;
                child.varDisplay.addListener(c -> this.updateChildren());
            }
        }

        private void updateChildren() {
            for (Display child : this.children) {
                int lowerBound = this.curDisplay.get() >= 0 ? (this.isLatest() && this.curDisplay.get() >= 1 ? this.varIndexes.get(this.curDisplay.get() - 1).intValue() : this.varIndexes.get(this.curDisplay.get()).intValue()) : -1;
                int upperBound = this.curDisplay.get() + 1 < this.varIndexes.size() ? this.varIndexes.get(this.curDisplay.get() + 1) : Integer.MAX_VALUE;
                child.curDisplay.set(child.varIndexes.indexOf(child.varIndexes.stream().filter(varIndex -> varIndex >= lowerBound && varIndex <= upperBound).findFirst().orElse(-1)));
            }
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public boolean showExec(int index) {
            if (this.curDisplay.get() < 0) {
                return false;
            }
            if (this.curDisplay.get() < this.varDisplay.size()) {
                if (!this.varIndexes.isEmpty() && this.varIndexes.get(0) == index && !this.children.isEmpty()) {
                    return true;
                }
                if (this.varIndexes.get(this.curDisplay.get()) == index && (this.children.isEmpty() || this.isLatest())) {
                    return true;
                }
                if (this.curDisplay.get() + 1 < this.varIndexes.size() && this.varIndexes.get(this.curDisplay.get() + 1) == index && !this.children.isEmpty()) {
                    return true;
                }
            }
            return false;
        }

        private boolean isLatest() {
            return this.varIndexes.get(this.curDisplay.get()) >= this.children.stream().mapToInt(c -> c.varIndexes.isEmpty() ? -1 : c.varIndexes.get(c.varIndexes.size() - 1)).max().orElse(-1);
        }
    }
}

