/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.compiler.Diagnostic;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.errors.Correction;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.FixSuggestion;
import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.frames.ClassFrame;
import bluej.stride.framedjava.frames.VarFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javafx.collections.ObservableList;
import threadchecker.OnThread;
import threadchecker.Tag;

public class UndeclaredVariableLvalueError
extends DirectSlotError {
    private final AssignFrame assignFrame;
    private final List<Correction> corrections = new ArrayList<Correction>();
    private final String varName;

    public UndeclaredVariableLvalueError(StringSlotFragment slotFragment, AssignFrame assignFrame, Set<String> possibleCorrections) {
        super(slotFragment, Diagnostic.DiagnosticOrigin.STRIDE_LATE);
        this.assignFrame = assignFrame;
        this.corrections.addAll(Correction.winnowAndCreateCorrections(assignFrame.getLHS().getText(), possibleCorrections.stream().map(Correction.SimpleCorrectionInfo::new), s -> assignFrame.getLHS().setText((String)s)));
        this.varName = assignFrame.getLHS().getText();
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getMessage() {
        return "Undeclared variable: " + this.varName;
    }

    public List<FixSuggestion> getFixSuggestions() {
        ArrayList<FixSuggestion> fixes = new ArrayList<FixSuggestion>();
        fixes.add(new ChangeAssignmentToDeclarationAndInitialisation());
        fixes.add(new AddFieldDeclaration());
        fixes.addAll(this.corrections);
        return fixes;
    }

    @Override
    public boolean isJavaPos() {
        return false;
    }

    private class AddFieldDeclaration
    extends FixSuggestion {
        private AddFieldDeclaration() {
        }

        @Override
        public String getDescription() {
            return "Declare field in class";
        }

        @Override
        public void execute() {
            FrameCursor cursorAfter;
            ClassFrame classFrame = (ClassFrame)ASTUtility.getTopLevelElement(UndeclaredVariableLvalueError.this.assignFrame.getCode()).getFrame();
            ObservableList<Frame> members = classFrame.getfieldsCanvas().getBlockContents();
            Optional<Frame> firstNonField = members.stream().filter(f -> !(f instanceof VarFrame)).findFirst();
            cursorAfter = firstNonField.isPresent() ? (cursorAfter = classFrame.getfieldsCanvas().getCursorBefore(firstNonField.get())) : classFrame.getfieldsCanvas().getLastCursor();
            classFrame.getfieldsCanvas().insertBlockBefore(new VarFrame(UndeclaredVariableLvalueError.this.assignFrame.getEditor(), null, false, false, new TypeSlotFragment("", ""), new NameDefSlotFragment(UndeclaredVariableLvalueError.this.assignFrame.getLHS().getText()), null, true), cursorAfter);
        }
    }

    private class ChangeAssignmentToDeclarationAndInitialisation
    extends FixSuggestion {
        private ChangeAssignmentToDeclarationAndInitialisation() {
        }

        @Override
        public String getDescription() {
            return "Declare variable here";
        }

        @Override
        public void execute() {
            UndeclaredVariableLvalueError.this.assignFrame.getParentCanvas().replaceBlock(UndeclaredVariableLvalueError.this.assignFrame, new VarFrame(UndeclaredVariableLvalueError.this.assignFrame.getEditor(), null, false, false, new TypeSlotFragment("", ""), new NameDefSlotFragment(UndeclaredVariableLvalueError.this.assignFrame.getLHS().getText()), new FilledExpressionSlotFragment((ExpressionSlotFragment)UndeclaredVariableLvalueError.this.assignFrame.getRHS().getSlotElement()), true));
        }
    }
}

