/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.convert;

import bluej.parser.JavaParser;
import bluej.parser.ParseFailure;
import bluej.parser.lexer.LocatableToken;
import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.SuperThis;
import bluej.stride.framedjava.ast.SuperThisFragment;
import bluej.stride.framedjava.ast.ThrowsTypeFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.convert.ConversionWarning;
import bluej.stride.framedjava.convert.Expression;
import bluej.stride.framedjava.convert.ExpressionBuilder;
import bluej.stride.framedjava.convert.FieldOrVarBuilder;
import bluej.stride.framedjava.convert.Mask;
import bluej.stride.framedjava.convert.MethodBuilder;
import bluej.stride.framedjava.convert.Modifier;
import bluej.stride.framedjava.convert.TryBuilder;
import bluej.stride.framedjava.convert.TypeDefHandler;
import bluej.stride.framedjava.elements.BreakElement;
import bluej.stride.framedjava.elements.CaseElement;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.CommentElement;
import bluej.stride.framedjava.elements.ConstructorElement;
import bluej.stride.framedjava.elements.ForeachElement;
import bluej.stride.framedjava.elements.IfElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.elements.InterfaceElement;
import bluej.stride.framedjava.elements.MethodProtoElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.elements.ReturnElement;
import bluej.stride.framedjava.elements.SwitchElement;
import bluej.stride.framedjava.elements.ThrowElement;
import bluej.stride.framedjava.elements.TryElement;
import bluej.stride.framedjava.elements.VarElement;
import bluej.stride.framedjava.elements.WhileElement;
import bluej.utility.JavaUtils;
import bluej.utility.Utility;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JavaStrideParser
extends JavaParser {
    private final String source;
    private final Stack<ExpressionBuilder> expressionHandlers = new Stack();
    private final Stack<StatementHandler> statementHandlers = new Stack();
    private final Stack<ArgumentListHandler> argumentHandlers = new Stack();
    private final Stack<TypeDefHandler> typeDefHandlers = new Stack();
    private final Stack<MethodBuilder> methods = new Stack();
    private final Stack<String> prevTypes = new Stack();
    private final Stack<Consumer<String>> typeHandlers = new Stack();
    private final Stack<IfBuilder> ifHandlers = new Stack();
    private final Stack<SwitchHandler> switchHandlers = new Stack();
    private final Stack<ForHandler> forHandlers = new Stack();
    private final Stack<FieldOrVarBuilder> curField = new Stack();
    private final Stack<List<Modifier>> modifiers = new Stack();
    private final boolean testing;
    private final WarningManager warnings = new WarningManager();
    private final StatementHandler result = new StatementHandler(false){

        @Override
        public void endBlock() {
        }
    };
    private Stack<TryBuilder> tries = new Stack();
    private String pkg;
    private final List<String> imports = new ArrayList<String>();

    public JavaStrideParser(String java, boolean testing) {
        super(new StringReader(java), true);
        this.source = java;
        this.testing = testing;
        this.statementHandlers.push(this.result);
    }

    public List<ConversionWarning> getWarnings() {
        return this.warnings.warnings;
    }

    @Override
    protected void beginWhileLoop(LocatableToken token) {
        super.beginWhileLoop(token);
        this.withExpression(exp -> this.withStatement(new StatementHandler(true, (Expression)exp){
            final /* synthetic */ Expression val$exp;
            {
                this.val$exp = expression;
                super(expectingSingle);
            }

            @Override
            public void endBlock() {
                JavaStrideParser.this.foundStatement(new WhileElement(null, this.val$exp.toFilled(), this.getContent(false), true));
            }
        }));
    }

    @Override
    protected void beginIfStmt(LocatableToken token) {
        super.beginIfStmt(token);
        this.withExpression(exp -> this.ifHandlers.add(new IfBuilder((Expression)exp)));
    }

    @Override
    protected void beginIfCondBlock(LocatableToken token) {
        super.beginIfCondBlock(token);
        this.ifHandlers.peek().addCondBlock();
    }

    @Override
    protected void gotElseIf(LocatableToken token) {
        super.gotElseIf(token);
        this.ifHandlers.peek().addElseIf();
    }

    @Override
    protected void endIfStmt(LocatableToken token, boolean included) {
        super.endIfStmt(token, included);
        this.ifHandlers.pop().endIf();
    }

    @Override
    protected void gotReturnStatement(boolean hasValue) {
        super.gotReturnStatement(hasValue);
        if (hasValue) {
            this.withExpression(exp -> this.foundStatement(new ReturnElement(null, exp.toOptional(), true)));
        } else {
            this.foundStatement(new ReturnElement(null, null, true));
        }
    }

    @Override
    protected void gotEmptyStatement() {
        super.gotEmptyStatement();
        this.foundStatements(Collections.emptyList());
    }

    @Override
    protected void gotStatementExpression() {
        super.gotStatementExpression();
        this.withExpression(e -> this.foundStatement(e.toStatement()));
    }

    @Override
    protected void beginExpression(LocatableToken token) {
        super.beginExpression(token);
        if (!this.expressionHandlers.isEmpty()) {
            this.expressionHandlers.peek().expressionBegun(token);
        }
    }

    @Override
    protected void endExpression(LocatableToken token, boolean emptyExpression) {
        super.endExpression(token, emptyExpression);
        if (!this.expressionHandlers.isEmpty() && this.expressionHandlers.peek().expressionEnd(token)) {
            this.expressionHandlers.pop();
        }
    }

    @Override
    protected void gotBinaryOperator(LocatableToken token) {
        super.gotBinaryOperator(token);
        if (!this.expressionHandlers.isEmpty()) {
            this.expressionHandlers.peek().binaryOperator(token);
        }
    }

    @Override
    protected void gotUnaryOperator(LocatableToken token) {
        super.gotUnaryOperator(token);
        if (!this.expressionHandlers.isEmpty()) {
            this.expressionHandlers.peek().unaryOperator(token);
        }
    }

    @Override
    protected void gotPostOperator(LocatableToken token) {
        super.gotPostOperator(token);
        if (!this.expressionHandlers.isEmpty()) {
            this.expressionHandlers.peek().postOperator(token);
        }
    }

    @Override
    protected void beginStmtblockBody(LocatableToken token) {
        super.beginStmtblockBody(token);
        this.withStatement(new StatementHandler(false){

            @Override
            public void endBlock() {
                JavaStrideParser.this.foundStatements(this.getContent(false));
            }
        });
    }

    @Override
    protected void endStmtblockBody(LocatableToken token, boolean included) {
        super.endStmtblockBody(token, included);
        this.statementHandlers.pop().endBlock();
    }

    @Override
    protected void beginThrows(LocatableToken token) {
        super.beginThrows(token);
        this.typeHandlers.push(type -> this.methods.peek().throwsTypes.add((String)type));
    }

    @Override
    protected void endThrows() {
        super.endThrows();
        this.typeHandlers.pop();
    }

    @Override
    protected void gotMethodTypeParamsBegin() {
        super.gotMethodTypeParamsBegin();
        this.warnings.add(new ConversionWarning.UnsupportedFeature("generic methods"));
    }

    @Override
    protected void gotConstructorDecl(LocatableToken token, LocatableToken hiddenToken) {
        super.gotConstructorDecl(token, hiddenToken);
        this.methods.push(new MethodBuilder(null, null, this.modifiers.peek(), this.statementHandlers.peek().getJavadoc()));
    }

    @Override
    protected void gotMethodDeclaration(LocatableToken nameToken, LocatableToken hiddenToken) {
        super.gotMethodDeclaration(nameToken, hiddenToken);
        this.methods.push(new MethodBuilder(this.prevTypes.pop(), nameToken.getText(), this.modifiers.peek(), this.statementHandlers.peek().getJavadoc()));
    }

    @Override
    protected void beginMethodBody(LocatableToken token) {
        super.beginMethodBody(token);
        this.methods.peek().hasBody = true;
        this.withStatement(new StatementHandler(false){

            @Override
            public void endBlock() {
            }
        });
    }

    @Override
    protected void endMethodDecl(LocatableToken token, boolean included) {
        super.endMethodDecl(token, included);
        MethodBuilder details = this.methods.pop();
        List<CodeElement> body = details.hasBody ? this.statementHandlers.pop().getContent(false) : null;
        String name = details.name;
        List<ThrowsTypeFragment> throwsTypes = details.throwsTypes.stream().map(t -> new ThrowsTypeFragment(JavaStrideParser.toType(t))).collect(Collectors.toList());
        List<Modifier> modifiers = details.modifiers;
        AccessPermission permission = JavaStrideParser.removeAccess(modifiers, AccessPermission.PROTECTED);
        if (name != null) {
            boolean _final = modifiers.removeIf(t -> t.isKeyword("final"));
            boolean _static = modifiers.removeIf(t -> t.isKeyword("static"));
            modifiers.removeIf(t -> t.isKeyword("abstract"));
            modifiers.removeIf(t -> t.isAnnotation("@Override"));
            this.warnUnsupportedModifiers("method", modifiers);
            String type = details.type;
            if (details.hasBody) {
                this.foundStatement(new NormalMethodElement(null, new AccessPermissionFragment(permission), _static, _final, JavaStrideParser.toType(type), new NameDefSlotFragment(name), details.parameters, throwsTypes, body, new JavadocUnit(details.comment), true));
            } else {
                this.foundStatement(new MethodProtoElement(null, JavaStrideParser.toType(type), new NameDefSlotFragment(name), details.parameters, throwsTypes, new JavadocUnit(details.comment), true));
            }
        } else {
            this.warnUnsupportedModifiers("method", modifiers);
            SuperThis delegate = SuperThis.fromString(details.constructorCall);
            Expression delegateArgs = delegate == null ? null : new Expression(details.constructorArgs, " , ", this.warnings::add);
            this.foundStatement(new ConstructorElement(null, new AccessPermissionFragment(permission), details.parameters, throwsTypes, delegate == null ? null : new SuperThisFragment(delegate), delegateArgs == null ? null : delegateArgs.toSuperThis(), body, new JavadocUnit(details.comment), true));
        }
    }

    private static TypeSlotFragment toType(String t) {
        if (t == null) {
            return null;
        }
        return new TypeSlotFragment(t, t);
    }

    private void warnUnsupportedModifiers(String context, List<Modifier> modifiers) {
        modifiers.forEach(t -> this.warnings.add(new ConversionWarning.UnsupportedModifier(context, t.toString())));
    }

    private static AccessPermission removeAccess(List<Modifier> modifiers, AccessPermission defaultAccess) {
        AccessPermission permission = defaultAccess;
        if (modifiers.removeIf(t -> t.isKeyword("private"))) {
            permission = AccessPermission.PRIVATE;
        }
        if (modifiers.removeIf(t -> t.isKeyword("protected"))) {
            permission = AccessPermission.PROTECTED;
        }
        if (modifiers.removeIf(t -> t.isKeyword("public"))) {
            permission = AccessPermission.PUBLIC;
        }
        return permission;
    }

    @Override
    protected void gotTypeSpec(List<LocatableToken> tokens) {
        super.gotTypeSpec(tokens);
        String type = tokens.stream().map(LocatableToken::getText).collect(Collectors.joining());
        if (!this.typeHandlers.isEmpty()) {
            this.typeHandlers.peek().accept(type);
        } else {
            this.prevTypes.add(type);
        }
    }

    @Override
    protected void gotMethodParameter(LocatableToken token, LocatableToken ellipsisToken) {
        super.gotMethodParameter(token, ellipsisToken);
        if (ellipsisToken != null) {
            this.warnings.add(new ConversionWarning.UnsupportedFeature("varargs"));
        }
        String type = this.prevTypes.pop();
        this.methods.peek().parameters.add(new ParamFragment(JavaStrideParser.toType(type), new NameDefSlotFragment(token.getText())));
    }

    @Override
    protected void gotConstructorCall(LocatableToken token) {
        super.gotConstructorCall(token);
        MethodBuilder method = this.methods.peek();
        method.constructorCall = token.getText();
        this.expressionHandlers.pop();
        this.withExpression(e -> {});
        this.withArgumentList(args -> {
            method.constructorArgs = args;
        });
    }

    @Override
    protected void gotDeclBegin(LocatableToken token) {
        super.gotDeclBegin(token);
        this.modifiers.push(new ArrayList());
    }

    @Override
    protected void beginFormalParameter(LocatableToken token) {
        super.beginFormalParameter(token);
        this.modifiers.push(new ArrayList());
    }

    @Override
    protected void modifiersConsumed() {
        super.modifiersConsumed();
        this.modifiers.pop();
    }

    @Override
    protected void gotModifier(LocatableToken token) {
        super.gotModifier(token);
        if (!this.modifiers.isEmpty()) {
            this.modifiers.peek().add(new Modifier.KeywordModifier(token));
        }
    }

    @Override
    protected void gotAnnotation(List<LocatableToken> annName, boolean paramsFollow) {
        super.gotAnnotation(annName, paramsFollow);
        if (!this.modifiers.isEmpty()) {
            Modifier.AnnotationModifier ann = new Modifier.AnnotationModifier(annName);
            this.modifiers.peek().add(ann);
            if (paramsFollow) {
                this.withArgumentList(exps -> ann.setParams((List<Expression>)exps));
            }
        }
    }

    @Override
    protected void beginFieldDeclarations(LocatableToken first) {
        super.beginFieldDeclarations(first);
        this.curField.push(new FieldOrVarBuilder(this.prevTypes.pop(), this.modifiers.peek()));
    }

    @Override
    protected void gotField(LocatableToken first, LocatableToken idToken, boolean initExpressionFollows) {
        super.gotField(first, idToken, initExpressionFollows);
        this.handleFieldOrVar(idToken, initExpressionFollows, AccessPermission.PROTECTED);
    }

    @Override
    protected void gotVariableDecl(LocatableToken first, LocatableToken idToken, boolean inited) {
        super.gotVariableDecl(first, idToken, inited);
        this.curField.push(new FieldOrVarBuilder(this.prevTypes.pop(), this.modifiers.peek()));
        this.handleFieldOrVar(idToken, inited, null);
    }

    @Override
    protected void gotArrayDeclarator() {
        super.gotArrayDeclarator();
        if (!this.prevTypes.isEmpty()) {
            this.prevTypes.push(this.prevTypes.pop() + "[]");
        }
    }

    private void handleFieldOrVar(LocatableToken idToken, boolean initExpressionFollows, AccessPermission defaultAccess) {
        FieldOrVarBuilder details = this.curField.peek();
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>(details.modifiers);
        AccessPermission permission = JavaStrideParser.removeAccess(modifiers, defaultAccess);
        boolean _final = modifiers.removeIf(t -> t.isKeyword("final"));
        boolean _static = modifiers.removeIf(t -> t.isKeyword("static"));
        this.warnUnsupportedModifiers("variable", modifiers);
        Consumer<Expression> handler = e -> this.foundStatement(new VarElement(null, permission == null ? null : new AccessPermissionFragment(permission), _static, _final, JavaStrideParser.toType(details.type), new NameDefSlotFragment(idToken.getText()), e == null ? null : e.toFilled(), true));
        if (initExpressionFollows) {
            this.withExpression(handler);
        } else {
            handler.accept(null);
        }
    }

    @Override
    protected void gotSubsequentField(LocatableToken first, LocatableToken idToken, boolean initFollows) {
        super.gotSubsequentField(first, idToken, initFollows);
        this.handleFieldOrVar(idToken, initFollows, AccessPermission.PROTECTED);
    }

    @Override
    protected void gotSubsequentVar(LocatableToken first, LocatableToken idToken, boolean inited) {
        super.gotSubsequentVar(first, idToken, inited);
        this.handleFieldOrVar(idToken, inited, null);
    }

    @Override
    protected void endFieldDeclarations(LocatableToken token, boolean included) {
        super.endFieldDeclarations(token, included);
        this.curField.pop();
    }

    @Override
    protected void gotTopLevelDecl(LocatableToken token) {
        super.gotTopLevelDecl(token);
        this.withTypeDef(td -> this.foundStatement((CodeElement)td), false);
    }

    @Override
    protected void gotInnerType(LocatableToken start) {
        super.gotInnerType(start);
        this.withTypeDef(inner -> {}, true);
        this.warnings.add(new ConversionWarning.UnsupportedFeature("inner " + start.getText()));
    }

    @Override
    protected void gotTypeDef(LocatableToken firstToken, int tdType) {
        super.gotTypeDef(firstToken, tdType);
        if (tdType == 5) {
            return;
        }
        this.typeDefHandlers.peek().typeDefBegun(firstToken);
        List<Modifier> modifiers = this.modifiers.peek();
        switch (tdType) {
            case 0: {
                this.typeDefHandlers.peek().startedClass(modifiers, this.statementHandlers.peek().getJavadoc());
                break;
            }
            case 1: {
                this.typeDefHandlers.peek().startedInterface(modifiers, this.statementHandlers.peek().getJavadoc());
                break;
            }
            case 3: {
                this.warnings.add(new ConversionWarning.UnsupportedFeature("annotation"));
                break;
            }
            case 2: {
                this.warnings.add(new ConversionWarning.UnsupportedFeature("enum"));
                break;
            }
            default: {
                throw new ParseFailure("Typedef parse failure");
            }
        }
    }

    @Override
    protected void gotTypeDefEnd(LocatableToken token, boolean included) {
        super.gotTypeDefEnd(token, included);
        if (!this.typeDefHandlers.isEmpty()) {
            this.typeDefHandlers.pop().typeDefEnd(token);
        }
    }

    @Override
    protected void beginTypeDefExtends(LocatableToken extendsToken) {
        super.beginTypeDefExtends(extendsToken);
        this.typeHandlers.push(type -> this.typeDefHandlers.peek().typeDefExtends((String)type));
    }

    @Override
    protected void endTypeDefExtends() {
        super.endTypeDefExtends();
        this.typeHandlers.pop();
    }

    @Override
    protected void beginTypeDefImplements(LocatableToken implementsToken) {
        super.beginTypeDefImplements(implementsToken);
        this.typeHandlers.push(type -> this.typeDefHandlers.peek().typeDefImplements((String)type));
    }

    @Override
    protected void endTypeDefImplements() {
        super.endTypeDefImplements();
        this.typeHandlers.pop();
    }

    @Override
    protected void gotTypeDefName(LocatableToken nameToken) {
        super.gotTypeDefName(nameToken);
        if (!this.typeDefHandlers.isEmpty()) {
            this.typeDefHandlers.peek().gotName(nameToken.getText());
        }
    }

    @Override
    protected void beginTypeBody(LocatableToken leftCurlyToken) {
        super.beginTypeBody(leftCurlyToken);
        this.withStatement(new StatementHandler(false){

            @Override
            public void endBlock() {
            }
        });
    }

    @Override
    protected void endTypeBody(LocatableToken endCurlyToken, boolean included) {
        super.endTypeBody(endCurlyToken, included);
        List<CodeElement> content = this.statementHandlers.pop().getContent(false);
        if (!this.typeDefHandlers.isEmpty()) {
            this.typeDefHandlers.peek().gotContent(content);
        }
    }

    @Override
    protected void gotPackage(List<LocatableToken> pkgTokens) {
        super.gotPackage(pkgTokens);
        this.pkg = pkgTokens.stream().map(LocatableToken::getText).collect(Collectors.joining());
    }

    @Override
    public void gotComment(LocatableToken token) {
        super.gotComment(token);
        this.statementHandlers.peek().gotComment(token);
        if (!this.expressionHandlers.isEmpty()) {
            this.expressionHandlers.forEach(handler -> {
                handler.beginMask(token);
                handler.endMask(token);
            });
        }
    }

    private static String processComment(String comment) {
        comment = comment.startsWith("//") ? comment.substring(2).trim() : JavaUtils.javadocToString(comment).trim();
        comment = Arrays.stream(Utility.split(comment, System.getProperty("line.separator"))).map(String::trim).reduce((a, b) -> {
            String string = a = a.isEmpty() ? "\n" : a;
            if (a.endsWith("\n")) {
                return a + (b.isEmpty() ? "\n" : b);
            }
            if (b.isEmpty()) {
                return a + "\n";
            }
            return a + " " + b;
        }).orElse("");
        return comment;
    }

    @Override
    protected void gotBreakContinue(LocatableToken keywordToken, LocatableToken labelToken) {
        super.gotBreakContinue(keywordToken, labelToken);
        if (keywordToken.getType() == 115) {
            this.foundStatement(new BreakElement(null, true));
            if (labelToken != null) {
                this.warnings.add(new ConversionWarning.UnsupportedFeature("break label"));
            }
        } else {
            this.warnings.add(new ConversionWarning.UnsupportedFeature(keywordToken.getText()));
        }
    }

    @Override
    protected void gotThrow(LocatableToken token) {
        super.gotThrow(token);
        this.withExpression(e -> this.foundStatement(new ThrowElement(null, e.toFilled(), true)));
    }

    @Override
    protected void beginTryCatchSmt(LocatableToken token, boolean hasResource) {
        super.beginTryCatchSmt(token, hasResource);
        if (hasResource) {
            this.warnings.add(new ConversionWarning.UnsupportedFeature("try-with-resource"));
        }
        this.tries.push(new TryBuilder());
    }

    @Override
    protected void beginTryBlock(LocatableToken token) {
        super.beginTryBlock(token);
        this.withStatement(new StatementHandler(false){

            @Override
            public void endBlock() {
                ((TryBuilder)((JavaStrideParser)JavaStrideParser.this).tries.peek()).tryContent.addAll(this.getContent(false));
            }
        });
    }

    @Override
    protected void endTryBlock(LocatableToken token, boolean included) {
        super.endTryBlock(token, included);
        this.statementHandlers.pop().endBlock();
    }

    @Override
    protected void gotCatchFinally(LocatableToken token) {
        super.gotCatchFinally(token);
        if (token.getType() == 125) {
            this.tries.peek().catchTypes.push(new ArrayList());
        } else {
            this.withStatement(new StatementHandler(true){

                @Override
                public void endBlock() {
                    ((TryBuilder)((JavaStrideParser)JavaStrideParser.this).tries.peek()).finallyContents = new ArrayList<CodeElement>(this.getContent(false));
                }
            });
        }
    }

    @Override
    protected void gotCatchVarName(LocatableToken token) {
        super.gotCatchVarName(token);
        this.tries.peek().catchNames.add(token.getText());
        this.tries.peek().catchTypes.peek().add(this.prevTypes.pop());
        this.withStatement(new StatementHandler(true){

            @Override
            public void endBlock() {
                ((TryBuilder)((JavaStrideParser)JavaStrideParser.this).tries.peek()).catchBlocks.add(this.getContent(false));
            }
        });
    }

    @Override
    protected void gotMultiCatch(LocatableToken token) {
        super.gotMultiCatch(token);
        this.tries.peek().catchTypes.peek().add(this.prevTypes.pop());
    }

    @Override
    protected void endTryCatchStmt(LocatableToken token, boolean included) {
        super.endTryCatchStmt(token, included);
        TryBuilder details = this.tries.pop();
        ArrayList<TypeSlotFragment> catchTypes = new ArrayList<TypeSlotFragment>();
        ArrayList<NameDefSlotFragment> catchNames = new ArrayList<NameDefSlotFragment>();
        ArrayList<List<CodeElement>> catchBlocks = new ArrayList<List<CodeElement>>();
        for (int i = 0; i < details.catchNames.size(); ++i) {
            int iFinal = i;
            ((List)details.catchTypes.get(i)).forEach(type -> {
                catchTypes.add(new TypeSlotFragment((String)type, (String)type));
                catchNames.add(new NameDefSlotFragment(details.catchNames.get(iFinal)));
                catchBlocks.add(new ArrayList(details.catchBlocks.get(iFinal)));
            });
        }
        this.foundStatement(new TryElement(null, details.tryContent, catchTypes, catchNames, catchBlocks, details.finallyContents, true));
    }

    @Override
    protected void gotImport(List<LocatableToken> tokens, boolean isStatic, LocatableToken importToken, LocatableToken semiColonToken) {
        super.gotImport(tokens, isStatic, importToken, semiColonToken);
        this.imports.add(tokens.stream().map(LocatableToken::getText).collect(Collectors.joining()));
    }

    @Override
    protected void gotWildcardImport(List<LocatableToken> tokens, boolean isStatic, LocatableToken importToken, LocatableToken semiColonToken) {
        super.gotWildcardImport(tokens, isStatic, importToken, semiColonToken);
        this.imports.add(tokens.stream().map(LocatableToken::getText).collect(Collectors.joining()) + ".*");
    }

    @Override
    protected void beginSwitchStmt(LocatableToken token) {
        super.beginSwitchStmt(token);
        this.switchHandlers.push(new SwitchHandler());
        this.withExpression(e -> this.switchHandlers.peek().gotSwitchExpression((Expression)e));
    }

    @Override
    protected void beginSwitchBlock(LocatableToken token) {
        super.beginSwitchBlock(token);
        this.switchHandlers.peek().beginBlock();
    }

    @Override
    protected void gotSwitchCase() {
        super.gotSwitchCase();
        this.withExpression(e -> this.switchHandlers.peek().gotCase((Expression)e));
    }

    @Override
    protected void gotSwitchDefault() {
        super.gotSwitchDefault();
        this.switchHandlers.peek().gotDefault();
    }

    @Override
    protected void endSwitchBlock(LocatableToken token) {
        super.endSwitchBlock(token);
        this.statementHandlers.pop().endBlock();
    }

    @Override
    protected void beginForLoop(LocatableToken token) {
        super.beginForLoop(token);
        this.forHandlers.push(new ForHandler());
        this.modifiers.push(new ArrayList());
    }

    @Override
    protected void gotForInit(LocatableToken first, LocatableToken idToken) {
        super.gotForInit(first, idToken);
        this.forHandlers.peek().gotType(this.prevTypes.pop(), this.modifiers.peek());
        this.forHandlers.peek().gotName(idToken.getText());
    }

    @Override
    protected void gotSubsequentForInit(LocatableToken first, LocatableToken idToken, boolean initFollows) {
        super.gotSubsequentForInit(first, idToken, initFollows);
        this.forHandlers.peek().gotName(idToken.getText());
        if (initFollows) {
            this.withExpression(e -> this.forHandlers.peek().gotVarInit((Expression)e));
        }
    }

    @Override
    protected void determinedForLoop(boolean forEachLoop, boolean initFollows) {
        super.determinedForLoop(forEachLoop, initFollows);
        if (forEachLoop) {
            this.withExpression(e -> this.forHandlers.peek().gotEach((Expression)e));
        } else if (initFollows) {
            this.withExpression(e -> this.forHandlers.peek().gotVarInit((Expression)e));
        }
    }

    @Override
    protected void gotForIncrement(boolean isPresent) {
        super.gotForIncrement(isPresent);
        if (isPresent) {
            this.withExpression(e -> this.forHandlers.peek().gotPost((Expression)e));
        }
    }

    @Override
    protected void gotForTest(boolean isPresent) {
        super.gotForTest(isPresent);
        if (isPresent) {
            this.withExpression(e -> this.forHandlers.peek().gotCondition((Expression)e));
        }
    }

    @Override
    protected void beginForLoopBody(LocatableToken token) {
        super.beginForLoopBody(token);
        this.withStatement(new StatementHandler(true){

            @Override
            public void endBlock() {
                JavaStrideParser.this.foundStatements(((ForHandler)JavaStrideParser.this.forHandlers.pop()).end(this.getContent(false)));
            }
        });
    }

    @Override
    protected void beginArgumentList(LocatableToken token) {
        super.beginArgumentList(token);
        if (!this.argumentHandlers.isEmpty()) {
            this.argumentHandlers.peek().argumentListBegun();
        }
    }

    @Override
    protected void endArgumentList(LocatableToken token) {
        super.endArgumentList(token);
        if (!this.argumentHandlers.isEmpty()) {
            this.argumentHandlers.peek().argumentListEnd();
        }
    }

    @Override
    protected void endArgument() {
        super.endArgument();
        if (!this.argumentHandlers.isEmpty()) {
            this.argumentHandlers.peek().gotArgument();
        }
    }

    @Override
    protected void gotAssert() {
        super.gotAssert();
        this.warnings.add(new ConversionWarning.UnsupportedFeature("assert"));
    }

    @Override
    protected void beginSynchronizedBlock(LocatableToken token) {
        super.beginSynchronizedBlock(token);
        this.warnings.add(new ConversionWarning.UnsupportedFeature("synchronized"));
    }

    @Override
    protected void beginInitBlock(LocatableToken first, LocatableToken lcurly) {
        super.beginInitBlock(first, lcurly);
        this.warnings.add(new ConversionWarning.UnsupportedFeature("initializer block"));
        this.withStatement(new StatementHandler(false){

            @Override
            public void endBlock() {
            }
        });
    }

    @Override
    protected void endInitBlock(LocatableToken rcurly, boolean included) {
        super.endInitBlock(rcurly, included);
        this.statementHandlers.pop();
    }

    @Override
    protected void beginAnonClassBody(LocatableToken token, boolean isEnumMember) {
        super.beginAnonClassBody(token, isEnumMember);
        this.beginExpressionMask(token);
        this.warnings.add(new ConversionWarning.UnsupportedFeature("anonymous class"));
        this.withStatement(new StatementHandler(false){

            @Override
            public void endBlock() {
            }
        });
    }

    private void beginExpressionMask(LocatableToken from) {
        if (!this.expressionHandlers.isEmpty()) {
            this.expressionHandlers.peek().beginMask(from);
        }
    }

    private void endExpressionMask(LocatableToken from) {
        if (!this.expressionHandlers.isEmpty()) {
            this.expressionHandlers.peek().endMask(from);
        }
    }

    @Override
    protected void endAnonClassBody(LocatableToken token, boolean included) {
        super.endAnonClassBody(token, included);
        this.statementHandlers.pop();
        this.endExpressionMask(token);
    }

    @Override
    protected void gotLambdaFormalName(LocatableToken name) {
        super.gotLambdaFormalName(name);
        this.warnUnsupportedModifiers("lambda parameter", this.modifiers.peek());
        this.modifiers.peek().forEach(mod -> {
            this.expressionHandlers.peek().beginMask(mod.getStart());
            this.expressionHandlers.peek().endMask(mod.getEnd());
        });
    }

    @Override
    protected void gotLambdaFormalParam() {
        super.gotLambdaFormalParam();
        this.modifiers.push(new ArrayList());
    }

    @Override
    protected void gotLambdaFormalType(List<LocatableToken> tokens) {
        super.gotLambdaFormalType(tokens);
        this.warnings.add(new ConversionWarning.UnsupportedFeature("lambda parameter type"));
        this.expressionHandlers.peek().beginMask(tokens.get(0));
        this.expressionHandlers.peek().endMask(tokens.get(tokens.size() - 1));
    }

    @Override
    protected void beginLambda(boolean lambdaIsBlock, LocatableToken openCurly) {
        super.beginLambda(lambdaIsBlock, openCurly);
        if (lambdaIsBlock) {
            this.warnings.add(new ConversionWarning.UnsupportedFeature("lambda block"));
            this.beginExpressionMask(openCurly);
            this.withStatement(new StatementHandler(true){

                @Override
                public void endBlock() {
                }
            });
        }
    }

    @Override
    protected void endLambda(LocatableToken closeCurly) {
        super.endLambda(closeCurly);
        if (closeCurly != null) {
            this.endExpressionMask(closeCurly);
        }
    }

    @Override
    protected void gotQuestionColon(LocatableToken token) {
        super.gotQuestionColon(token);
        this.expressionHandlers.peek().beginMask(token);
        this.expressionHandlers.peek().endMask(token);
    }

    @Override
    protected void gotQuestionOperator(LocatableToken token) {
        super.gotQuestionOperator(token);
        this.warnings.add(new ConversionWarning.UnsupportedFeature("conditional operator (.. ? .. : ..)"));
        this.expressionHandlers.peek().beginMask(token);
        this.expressionHandlers.peek().endMask(token);
    }

    private String getText(LocatableToken start, LocatableToken endExcl, List<Mask> masks) {
        if (masks.isEmpty()) {
            return this.source.substring(start.getPosition(), endExcl.getPosition());
        }
        int prev = start.getPosition();
        StringBuilder r = new StringBuilder();
        for (Mask m : masks) {
            if (m.getStart().getPosition() < prev || m.getEnd().getPosition() > endExcl.getPosition()) continue;
            r.append(this.source.substring(prev, m.getStart().getPosition()));
            prev = m.getEnd().getPosition() + m.getEnd().getLength();
        }
        r.append(this.source.substring(prev, endExcl.getPosition()));
        return r.toString();
    }

    private void withExpression(Consumer<Expression> handler) {
        this.expressionHandlers.push(new ExpressionBuilder(handler, this::getText, this.warnings::add));
    }

    private List<ImportElement> importsForCU() {
        return this.imports.stream().filter(imp -> !imp.equals("lang.stride.*")).map(imp -> new ImportElement((String)imp, null, true)).collect(Collectors.toList());
    }

    private void withTypeDef(final Consumer<CodeElement> handler, final boolean inner) {
        this.typeDefHandlers.push(new TypeDefHandler(){
            TypeDefDelegate delegate = null;

            @Override
            public void typeDefBegun(LocatableToken start) {
            }

            @Override
            public void typeDefEnd(LocatableToken end) {
                if (this.delegate != null) {
                    handler.accept(this.delegate.end());
                }
            }

            @Override
            public void startedClass(List<Modifier> modifiers, String doc) {
                this.delegate = new ClassDelegate(inner ? Collections.emptyList() : modifiers, doc);
                if (!inner) {
                    ((StatementHandler)JavaStrideParser.this.statementHandlers.peek()).stealComments().forEach(this.delegate::gotContent);
                }
            }

            @Override
            public void startedInterface(List<Modifier> modifiers, String doc) {
                this.delegate = new InterfaceDelegate(inner ? Collections.emptyList() : modifiers, doc);
                if (!inner) {
                    ((StatementHandler)JavaStrideParser.this.statementHandlers.peek()).stealComments().forEach(this.delegate::gotContent);
                }
            }

            @Override
            public void gotName(String name) {
                if (this.delegate != null) {
                    this.delegate.gotName(name);
                }
            }

            @Override
            public void gotContent(List<CodeElement> content) {
                if (this.delegate != null) {
                    content.forEach(this.delegate::gotContent);
                }
            }

            @Override
            public void typeDefImplements(String type) {
                if (this.delegate != null) {
                    this.delegate.gotImplements(type);
                }
            }

            @Override
            public void typeDefExtends(String type) {
                if (this.delegate != null) {
                    this.delegate.gotExtends(type);
                }
            }
        });
    }

    private void withStatement(StatementHandler handler) {
        this.statementHandlers.push(handler);
    }

    private void withArgumentList(Consumer<List<Expression>> argHandler) {
        this.argumentHandlers.push(new ArgumentListHandler(argHandler));
    }

    private void foundStatement(CodeElement statement) {
        this.foundStatements(Collections.singletonList(statement));
    }

    private void foundStatements(List<CodeElement> statements) {
        this.statementHandlers.pop().foundStatement(statements);
    }

    @Override
    protected void finishedCU(int state) {
        if (state == 1) {
            this.result.foundStatement(Utility.mapList(this.imports, i -> new ImportElement((String)i, null, true)));
        }
    }

    public List<CodeElement> getCodeElements() {
        return this.result.getContent(true);
    }

    private class ArgumentListHandler {
        private final List<Expression> args = new ArrayList<Expression>();
        private int outstanding = 0;
        private final Consumer<List<Expression>> argHandler;

        public ArgumentListHandler(Consumer<List<Expression>> argHandler) {
            this.argHandler = argHandler;
        }

        public void argumentListBegun() {
            ++this.outstanding;
            if (this.outstanding == 1) {
                JavaStrideParser.this.withExpression(this.args::add);
            }
        }

        public void gotArgument() {
            if (this.outstanding == 1) {
                JavaStrideParser.this.withExpression(this.args::add);
            }
        }

        public void argumentListEnd() {
            if (this.outstanding == 1) {
                JavaStrideParser.this.expressionHandlers.pop();
                this.argHandler.accept(this.args);
                JavaStrideParser.this.argumentHandlers.pop();
            }
            --this.outstanding;
        }
    }

    private class ClassDelegate
    implements TypeDefDelegate {
        private final List<Modifier> modifiers;
        private final String doc;
        private String name;
        private final List<CodeElement> fields = new ArrayList<CodeElement>();
        private final List<CodeElement> constructors = new ArrayList<CodeElement>();
        private final List<CodeElement> methods = new ArrayList<CodeElement>();
        private final List<CommentElement> pendingComments = new ArrayList<CommentElement>();
        private String extendsType;
        private final List<String> implementsTypes = new ArrayList<String>();

        public ClassDelegate(List<Modifier> modifiers, String doc) {
            this.modifiers = new ArrayList<Modifier>(modifiers);
            this.doc = doc;
        }

        @Override
        public void gotName(String name) {
            this.name = name;
        }

        @Override
        public void gotExtends(String type) {
            this.extendsType = type;
        }

        @Override
        public void gotImplements(String type) {
            this.implementsTypes.add(type);
        }

        @Override
        public void gotContent(CodeElement element) {
            if (element instanceof VarElement) {
                this.fields.addAll(this.pendingComments);
                this.fields.add(element);
            } else if (element instanceof ConstructorElement) {
                this.constructors.addAll(this.pendingComments);
                this.constructors.add(element);
            } else if (element instanceof NormalMethodElement || element instanceof MethodProtoElement) {
                this.methods.addAll(this.pendingComments);
                this.methods.add(element);
            } else {
                if (element instanceof CommentElement) {
                    this.pendingComments.add((CommentElement)element);
                    return;
                }
                JavaStrideParser.this.warnings.add(new ConversionWarning.UnsupportedFeature(element.getClass().toString()), t -> this.pendingComments.add(new CommentElement(JavaStrideParser.processComment(t.getText()))));
                return;
            }
            this.pendingComments.clear();
        }

        @Override
        public CodeElement end() {
            if (!this.methods.isEmpty()) {
                this.methods.addAll(this.pendingComments);
            } else if (!this.constructors.isEmpty()) {
                this.constructors.addAll(this.pendingComments);
            } else {
                this.fields.addAll(this.pendingComments);
            }
            this.pendingComments.clear();
            boolean _abstract = this.modifiers.removeIf(t -> t.isKeyword("abstract"));
            this.modifiers.removeIf(t -> t.isKeyword("public"));
            JavaStrideParser.this.warnUnsupportedModifiers("class", this.modifiers);
            return new ClassElement(null, null, _abstract, new NameDefSlotFragment(this.name), JavaStrideParser.toType(this.extendsType), this.implementsTypes.stream().map(t -> JavaStrideParser.toType(t)).collect(Collectors.toList()), this.fields, this.constructors, this.methods, new JavadocUnit(this.doc), JavaStrideParser.this.pkg == null ? null : JavaStrideParser.this.pkg, JavaStrideParser.this.importsForCU(), true);
        }
    }

    private class InterfaceDelegate
    implements TypeDefDelegate {
        private final List<Modifier> modifiers;
        private final String doc;
        private String name;
        private final List<CodeElement> fields = new ArrayList<CodeElement>();
        private final List<CodeElement> methods = new ArrayList<CodeElement>();
        private final List<CommentElement> pendingComments = new ArrayList<CommentElement>();
        private final List<String> extendsTypes = new ArrayList<String>();

        public InterfaceDelegate(List<Modifier> modifiers, String doc) {
            this.modifiers = new ArrayList<Modifier>(modifiers);
            this.doc = doc;
        }

        @Override
        public void gotName(String name) {
            this.name = name;
        }

        @Override
        public void gotExtends(String type) {
            this.extendsTypes.add(type);
        }

        @Override
        public void gotImplements(String type) {
        }

        @Override
        public void gotContent(CodeElement element) {
            if (element instanceof VarElement) {
                this.fields.addAll(this.pendingComments);
                this.fields.add(element);
            } else if (element instanceof MethodProtoElement) {
                this.methods.addAll(this.pendingComments);
                this.methods.add(element);
            } else {
                if (element instanceof CommentElement) {
                    this.pendingComments.add((CommentElement)element);
                    return;
                }
                JavaStrideParser.this.warnings.add(new ConversionWarning.UnsupportedFeature(element.getClass().toString()), t -> this.pendingComments.add(new CommentElement(JavaStrideParser.processComment(t.getText()))));
                return;
            }
            this.pendingComments.clear();
        }

        @Override
        public CodeElement end() {
            if (!this.methods.isEmpty()) {
                this.methods.addAll(this.pendingComments);
            } else {
                this.fields.addAll(this.pendingComments);
            }
            this.pendingComments.clear();
            this.modifiers.removeIf(t -> t.isKeyword("public"));
            JavaStrideParser.this.warnUnsupportedModifiers("interface", this.modifiers);
            return new InterfaceElement(null, null, new NameDefSlotFragment(this.name), this.extendsTypes.stream().map(t -> JavaStrideParser.toType(t)).collect(Collectors.toList()), this.fields, this.methods, new JavadocUnit(this.doc), JavaStrideParser.this.pkg == null ? null : JavaStrideParser.this.pkg, JavaStrideParser.this.importsForCU(), true);
        }
    }

    private static interface TypeDefDelegate {
        public void gotName(String var1);

        public CodeElement end();

        public void gotContent(CodeElement var1);

        public void gotImplements(String var1);

        public void gotExtends(String var1);
    }

    private class IfBuilder {
        private final ArrayList<List<CodeElement>> blocks = new ArrayList();
        private final ArrayList<FilledExpressionSlotFragment> conditions = new ArrayList();

        public IfBuilder(Expression condition) {
            this.conditions.add(condition.toFilled());
        }

        public void addCondBlock() {
            JavaStrideParser.this.withStatement(new StatementHandler(true){

                @Override
                public void endBlock() {
                    IfBuilder.this.blocks.add(this.getContent(false));
                }
            });
        }

        public void addElseIf() {
            JavaStrideParser.this.withExpression(e -> this.conditions.add(e.toFilled()));
        }

        public void endIf() {
            JavaStrideParser.this.foundStatement(new IfElement(null, this.conditions.get(0), this.blocks.get(0), this.conditions.subList(1, this.conditions.size()), this.blocks.subList(1, this.conditions.size()), this.blocks.size() > this.conditions.size() ? this.blocks.get(this.blocks.size() - 1) : null, true));
        }
    }

    private abstract class StatementHandler {
        private final List<CodeElement> content = new ArrayList<CodeElement>();
        private final List<LocatableToken> comments = new ArrayList<LocatableToken>();
        private final boolean expectingSingle;

        public StatementHandler(boolean expectingSingle) {
            this.expectingSingle = expectingSingle;
            if (!JavaStrideParser.this.statementHandlers.isEmpty()) {
                StatementHandler prev = (StatementHandler)JavaStrideParser.this.statementHandlers.peek();
                int curPosition = this.getCurPosition();
                Predicate<LocatableToken> afterCurPosition = t -> t.getPosition() >= curPosition;
                this.comments.addAll(prev.comments.stream().filter(afterCurPosition).collect(Collectors.toList()));
                prev.comments.removeIf(afterCurPosition);
            }
        }

        public final void foundStatement(List<CodeElement> statements) {
            CommentElement el = this.collateComments(false);
            if (el != null) {
                this.content.add(el);
            }
            this.content.addAll(statements);
            if (!this.expectingSingle) {
                JavaStrideParser.this.withStatement(this);
            } else {
                this.endBlock();
            }
        }

        public final List<CodeElement> getContent(boolean eof) {
            CommentElement el = this.collateComments(eof);
            if (el != null) {
                this.content.add(el);
            }
            if (!this.comments.isEmpty()) {
                this.comments.forEach(((StatementHandler)JavaStrideParser.this.statementHandlers.peek())::gotComment);
            }
            return this.content;
        }

        public final void gotComment(LocatableToken token) {
            this.comments.add(token);
        }

        private CommentElement collateComments(boolean eof) {
            int curPosition = this.getCurPosition();
            Predicate<LocatableToken> behindCurPosition = t -> eof || t.getPosition() < curPosition;
            if (!this.comments.stream().anyMatch(behindCurPosition)) {
                return null;
            }
            CommentElement el = new CommentElement(this.comments.stream().filter(behindCurPosition).map(LocatableToken::getText).map(x$0 -> JavaStrideParser.processComment(x$0)).collect(Collectors.joining(" ")));
            this.comments.removeIf(behindCurPosition);
            return el;
        }

        private int getCurPosition() {
            return Optional.ofNullable(JavaStrideParser.this.getTokenStream().getMostRecent()).map(LocatableToken::getPosition).orElse(0);
        }

        public abstract void endBlock();

        public final String getJavadoc() {
            if (!this.comments.isEmpty() && this.comments.get(this.comments.size() - 1).getText().startsWith("/**")) {
                return JavaStrideParser.processComment(this.comments.remove(this.comments.size() - 1).getText());
            }
            return null;
        }

        public List<CodeElement> stealComments() {
            return Stream.of(this.collateComments(false)).filter(c -> c != null).collect(Collectors.toList());
        }
    }

    private class ForHandler {
        private String type;
        private final List<String> vars = new ArrayList<String>();
        private final List<Expression> inits = new ArrayList<Expression>();
        private boolean isEach;
        private Expression eachVar;
        private Expression post;
        private Expression condition;

        private ForHandler() {
        }

        public void gotType(String type, List<Modifier> modifiers) {
            this.type = type;
            modifiers.removeIf(t -> t.isKeyword("final"));
            JavaStrideParser.this.warnUnsupportedModifiers("for-loop", modifiers);
        }

        public void gotName(String name) {
            this.vars.add(name);
            this.inits.add(null);
        }

        public void gotEach(Expression e) {
            this.isEach = true;
            this.eachVar = e;
        }

        public void gotVarInit(Expression e) {
            this.inits.set(this.vars.size() - 1, e);
        }

        public List<CodeElement> end(List<CodeElement> content) {
            if (this.isEach) {
                return Arrays.asList(new ForeachElement(null, new TypeSlotFragment(this.type, this.type), new NameDefSlotFragment(this.vars.get(0)), this.eachVar.toFilled(), content, true));
            }
            if (this.type != null && this.type.equals("int") && this.vars.size() == 1 && this.inits.size() == 1 && this.inits.get(0).isIntegerLiteral() && this.condition != null && this.condition.lessThanIntegerLiteral(this.vars.get(0)) && this.post != null && this.post.isIncrementByOne(this.vars.get(0))) {
                String lowerBound = this.inits.get(0).getJava();
                String upperBound = this.condition.getUpperBound();
                return Collections.singletonList(new ForeachElement(null, new TypeSlotFragment("int", "int"), new NameDefSlotFragment(this.vars.get(0)), new FilledExpressionSlotFragment(lowerBound + ".." + upperBound, "lang.stride.Utility.makeRange(" + lowerBound + ", " + upperBound + ")"), content, true));
            }
            ArrayList<CodeElement> initAndLoop = new ArrayList<CodeElement>();
            for (int i = 0; i < this.vars.size(); ++i) {
                initAndLoop.add(new VarElement(null, null, false, false, JavaStrideParser.toType(this.type), new NameDefSlotFragment(this.vars.get(i)), this.inits.get(i) == null ? null : this.inits.get(i).toFilled(), true));
            }
            ArrayList<CodeElement> loopBody = new ArrayList<CodeElement>(content);
            if (this.post != null) {
                loopBody.add(this.post.toStatement());
            }
            initAndLoop.add(new WhileElement(null, this.condition != null ? this.condition.toFilled() : new FilledExpressionSlotFragment("true", "true"), loopBody, true));
            return initAndLoop;
        }

        public void gotPost(Expression e) {
            this.post = e;
        }

        public void gotCondition(Expression e) {
            this.condition = e;
        }
    }

    private class SwitchHandler {
        private Expression expression;
        private final List<Expression> cases = new ArrayList<Expression>();
        private final List<List<CodeElement>> caseContents = new ArrayList<List<CodeElement>>();
        private List<CodeElement> defaultContents;
        private boolean inDefault;

        private SwitchHandler() {
        }

        public void gotSwitchExpression(Expression e) {
            this.expression = e;
        }

        public SwitchElement end() {
            ArrayList<CaseElement> caseFrames = new ArrayList<CaseElement>();
            for (int i = 0; i < this.cases.size(); ++i) {
                caseFrames.add(new CaseElement(null, this.cases.get(i).toFilled(), this.caseContents.get(i), true));
            }
            return new SwitchElement(null, this.expression.toFilled(), caseFrames, this.defaultContents, true);
        }

        public void beginBlock() {
            JavaStrideParser.this.withStatement(this.newHandler());
        }

        private StatementHandler newHandler() {
            return new StatementHandler(false){

                @Override
                public void endBlock() {
                    SwitchHandler.this.storePrevCode(this);
                    JavaStrideParser.this.foundStatement(((SwitchHandler)JavaStrideParser.this.switchHandlers.pop()).end());
                }
            };
        }

        public void gotCase(Expression e) {
            this.storePrevCode(null);
            this.cases.add(e);
            JavaStrideParser.this.withStatement(this.newHandler());
        }

        private void storePrevCode(StatementHandler handler) {
            List<CodeElement> prevContent = (handler == null ? (StatementHandler)JavaStrideParser.this.statementHandlers.pop() : handler).getContent(false);
            if (!this.cases.isEmpty() || this.inDefault) {
                if (this.inDefault) {
                    this.defaultContents.addAll(prevContent);
                } else {
                    this.caseContents.add(prevContent);
                }
            }
        }

        public void gotDefault() {
            this.storePrevCode(null);
            this.inDefault = true;
            this.defaultContents = new ArrayList<CodeElement>();
            JavaStrideParser.this.withStatement(this.newHandler());
        }
    }

    private class WarningManager {
        private final List<ConversionWarning> warnings = new ArrayList<ConversionWarning>();

        private WarningManager() {
        }

        public void add(ConversionWarning warning) {
            this.add(warning, JavaStrideParser.this::gotComment);
        }

        public void add(ConversionWarning warning, Consumer<LocatableToken> commentAdd) {
            this.warnings.add(warning);
            LocatableToken dummyToken = new LocatableToken(166, "// " + (JavaStrideParser.this.testing ? "WARNING:" + warning.getClass().getName() : warning.getMessage()));
            dummyToken.setPosition(-1, -1, -1, -1, -1, dummyToken.getText().length());
            commentAdd.accept(dummyToken);
        }
    }
}

