/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.convert;

import bluej.parser.lexer.LocatableToken;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.OptionalExpressionSlotFragment;
import bluej.stride.framedjava.ast.SuperThisParamsExpressionFragment;
import bluej.stride.framedjava.convert.ConversionWarning;
import bluej.stride.framedjava.convert.Expression;
import bluej.stride.framedjava.convert.Mask;
import bluej.stride.framedjava.elements.AssignElement;
import bluej.stride.framedjava.elements.CodeElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;

class ExpressionBuilder {
    private LocatableToken start;
    private int outstanding = 0;
    private final Consumer<Expression> handler;
    private final TriFunction<LocatableToken, LocatableToken, List<Mask>, String> getText;
    private LocatableToken assignOp;
    private List<Integer> incDec = new ArrayList<Integer>();
    private final Consumer<ConversionWarning> addWarning;
    private final Stack<Mask> curMasks = new Stack();
    private final List<Mask> completeMasks = new ArrayList<Mask>();

    ExpressionBuilder(Consumer<Expression> handler, TriFunction<LocatableToken, LocatableToken, List<Mask>, String> getText, Consumer<ConversionWarning> addWarning) {
        this.handler = handler;
        this.getText = getText;
        this.addWarning = addWarning;
    }

    void expressionBegun(LocatableToken start) {
        if (this.outstanding == 0) {
            this.start = start;
        }
        ++this.outstanding;
    }

    boolean expressionEnd(LocatableToken end) {
        --this.outstanding;
        if (this.outstanding == 0) {
            if (this.assignOp == null) {
                String java = this.getText.apply(this.start, end, this.completeMasks);
                this.handler.accept(new Expression(java, this.incDec, this.addWarning));
            } else {
                String wholeJava = this.getText.apply(this.start, end, this.completeMasks);
                final String lhs = this.getText.apply(this.start, this.assignOp, this.completeMasks).trim();
                final String rhs = this.assignOp.getText().equals("=") ? this.getText.apply(this.assignOp, end, this.completeMasks).substring(this.assignOp.getText().length()) : lhs + " " + this.assignOp.getText().substring(0, this.assignOp.getText().length() - 1) + " " + this.getText.apply(this.assignOp, end, this.completeMasks).substring(this.assignOp.getText().length());
                this.handler.accept(new Expression(wholeJava, this.incDec, this.addWarning){

                    @Override
                    FilledExpressionSlotFragment toFilled() {
                        ExpressionBuilder.this.addWarning.accept(new ConversionWarning.UnsupportedFeature(ExpressionBuilder.this.assignOp.getText() + " in expression"));
                        return super.toFilled();
                    }

                    @Override
                    OptionalExpressionSlotFragment toOptional() {
                        ExpressionBuilder.this.addWarning.accept(new ConversionWarning.UnsupportedFeature(ExpressionBuilder.this.assignOp.getText() + " in expression"));
                        return super.toOptional();
                    }

                    @Override
                    SuperThisParamsExpressionFragment toSuperThis() {
                        ExpressionBuilder.this.addWarning.accept(new ConversionWarning.UnsupportedFeature(ExpressionBuilder.this.assignOp.getText() + " in expression"));
                        return super.toSuperThis();
                    }

                    @Override
                    public CodeElement toStatement() {
                        return new AssignElement(null, new Expression(lhs, ExpressionBuilder.this.incDec, (Consumer<ConversionWarning>)ExpressionBuilder.this.addWarning).toFilled(), new Expression(rhs, Collections.emptyList(), (Consumer<ConversionWarning>)ExpressionBuilder.this.addWarning).toFilled(), true);
                    }
                });
            }
            return true;
        }
        return false;
    }

    public void binaryOperator(LocatableToken opToken) {
        switch (opToken.getType()) {
            case 98: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                if (this.outstanding == 1) {
                    this.assignOp = opToken;
                    break;
                }
                this.addWarning.accept(new ConversionWarning.UnsupportedFeature(opToken.getText() + " in expression"));
                break;
            }
            default: {
                return;
            }
        }
    }

    public void unaryOperator(LocatableToken token) {
        if (token.getType() == 151 || token.getType() == 152) {
            this.incDec.add(token.getType());
        }
    }

    public void postOperator(LocatableToken token) {
        this.unaryOperator(token);
    }

    public void beginMask(LocatableToken from) {
        this.curMasks.push(new Mask(from));
    }

    public void endMask(LocatableToken to) {
        Mask mask = this.curMasks.pop();
        if (this.curMasks.isEmpty()) {
            mask.setEnd(to);
            this.completeMasks.add(mask);
        }
    }

    public static interface TriFunction<T1, T2, T3, R> {
        public R apply(T1 var1, T2 var2, T3 var3);
    }
}

