/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.parser.JavaParser;
import bluej.parser.ParseFailure;
import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.LocatableToken;
import bluej.stride.framedjava.convert.ConversionWarning;
import bluej.stride.framedjava.convert.JavaStrideParser;
import bluej.stride.framedjava.elements.CodeElement;
import java.io.StringReader;
import java.util.List;
import java.util.function.Consumer;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class Parser {
    private static final String DUMMY_STEM = "code__dummy__gf3gen__";

    public static boolean parseableAsType(String s) {
        return Parser.parseableAs(s, p -> p.parseTypeSpec(true));
    }

    public static boolean parseableAs(String s, Consumer<JavaParser> parse) {
        JavaParser p = new JavaParser(new StringReader(s), false);
        try {
            parse.accept(p);
            LocatableToken tok = p.getTokenStream().nextToken();
            return tok.getType() == 1;
        }
        catch (ParseFailure pf) {
            return false;
        }
    }

    public static boolean isDummyName(String name) {
        return name.startsWith(DUMMY_STEM);
    }

    public static boolean parseableAsNameDef(String s) {
        JavaLexer lexer = new JavaLexer(new StringReader(s));
        LocatableToken t = lexer.nextToken();
        LocatableToken t2 = lexer.nextToken();
        return t.getType() == 69 && t2.getType() == 1;
    }

    public static boolean parseableAsExpression(String e) {
        return Parser.parseAsExpression(new JavaParser(new StringReader(e), false));
    }

    public static boolean parseAsExpression(JavaParser p) {
        try {
            p.parseExpression();
            LocatableToken tok = p.getTokenStream().nextToken();
            if (tok.getType() != 1) {
                return false;
            }
        }
        catch (ParseFailure pf) {
            return false;
        }
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    public static ConversionResult javaToStride(String java, JavaContext context, boolean testing) throws ParseFailure {
        JavaStrideParser parser;
        switch (context) {
            case CLASS_MEMBER: {
                parser = new JavaStrideParser(java + "}", testing);
                parser.parseClassBody();
                break;
            }
            case STATEMENT: {
                parser = new JavaStrideParser(java, testing);
                while (parser.getTokenStream().LA(1).getType() != 1) {
                    parser.parseStatement();
                }
                break;
            }
            case TOP_LEVEL: {
                parser = new JavaStrideParser(java, testing);
                parser.parseCU();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new ConversionResult(parser.getCodeElements(), parser.getWarnings());
    }

    public static class ConversionResult {
        private final List<CodeElement> elements;
        private final List<ConversionWarning> warnings;

        private ConversionResult(List<CodeElement> elements, List<ConversionWarning> warnings) {
            this.elements = elements;
            this.warnings = warnings;
        }

        public List<CodeElement> getElements() {
            return this.elements;
        }

        public List<ConversionWarning> getWarnings() {
            return this.warnings;
        }
    }

    public static enum JavaContext {
        STATEMENT,
        CLASS_MEMBER,
        TOP_LEVEL;

    }

    public static class DummyNameGenerator {
        private int index = 0;

        public String generateNewDummyName() {
            return Parser.DUMMY_STEM + this.index++;
        }
    }
}

