/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.Config;
import bluej.editor.EditorManager;
import bluej.utility.javafx.JavaFXUtil;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableIntegerValue;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class PrefMgr {
    public static final String HIGHLIGHTING = "bluej.editor.syntaxHilighting";
    public static final String AUTO_INDENT = "bluej.editor.autoIndent";
    public static final String LINENUMBERS = "bluej.editor.displayLineNumbers";
    public static final String MAKE_BACKUP = "bluej.editor.makeBackup";
    public static final String MATCH_BRACKETS = "bluej.editor.matchBrackets";
    public static final String LINK_LIB = "doctool.linkToStandardLib";
    public static final String SHOW_TEST_TOOLS = "bluej.testing.showtools";
    public static final String SHOW_TEAM_TOOLS = "bluej.teamwork.showtools";
    public static final String SHOW_TEXT_EVAL = "bluej.startWithTextEval";
    public static final String SHOW_UNCHECKED = "bluej.compiler.showunchecked";
    public static final String SCOPE_HIGHLIGHTING_STRENGTH = "bluej.editor.scopeHilightingStrength";
    public static final String NAVIVIEW_EXPANDED = "bluej.naviviewExpanded.default";
    public static final String ACCESSIBILITY_SUPPORT = "bluej.accessibility.support";
    public static final String START_WITH_SUDO = "bluej.startWithSudo";
    public static final String STRIDE_SIDEBAR_SHOWING = "bluej.editor.stride.sidebarShowing";
    public static final int MIN_EDITOR_FONT_SIZE = 6;
    public static final int MAX_EDITOR_FONT_SIZE = 160;
    public static final int DEFAULT_STRIDE_FONT_SIZE = 11;
    public static final int DEFAULT_JAVA_FONT_SIZE = 10;
    private static final String editorFontPropertyName = "bluej.editor.font";
    private static final String editorMacFontPropertyName = "bluej.editor.MacOS.font";
    private static final String editorFontSizePropertyName = "bluej.editor.fontsize";
    private static final int NUM_RECENT_PROJECTS = Config.getPropInteger("bluej.numberOfRecentProjects", 12);
    private static @OnThread(value=Tag.Swing) Font popupMenuFont;
    private static @OnThread(value=Tag.Swing) Font italicMenuFont;
    private static final @OnThread(value=Tag.FX) IntegerProperty editorFontSize;
    private static final StringProperty editorStandardFont;
    private static @OnThread(value=Tag.FX) IntegerProperty strideFontSize;
    private static final @OnThread(value=Tag.FXPlatform) IntegerProperty highlightStrength;
    private static boolean isNaviviewExpanded;
    private static @OnThread(value=Tag.Any) String projectDirectory;
    private static @OnThread(value=Tag.Any, requireSynchronized=true) List<String> recentProjects;
    private static @OnThread(value=Tag.Any, requireSynchronized=true) HashMap<String, String> flags;
    private static @OnThread(value=Tag.FXPlatform) HashMap<String, BooleanProperty> flagProperties;
    private static @OnThread(value=Tag.FX) StringExpression editorFontCSS;
    private static @OnThread(value=Tag.FX) StringExpression editorFontSizeOnlyCSS;

    private PrefMgr() {
    }

    public static boolean initializeisNavivewExpanded() {
        return Boolean.parseBoolean(Config.getPropString(NAVIVIEW_EXPANDED, String.valueOf(!Config.isRaspberryPi())));
    }

    @OnThread(value=Tag.Any)
    public static File getProjectDirectory() {
        File dir = new File(projectDirectory);
        if (dir.exists() && dir.isDirectory()) {
            return dir;
        }
        return new File(System.getProperty("user.home"));
    }

    @OnThread(value=Tag.Any)
    public static void setProjectDirectory(String newDir) {
        projectDirectory = newDir;
        Config.putPropString("bluej.projectPath", newDir);
    }

    @OnThread(value=Tag.Any)
    public static synchronized List<String> getRecentProjects() {
        return new ArrayList<String>(recentProjects);
    }

    public static synchronized void addRecentProject(File projectDir) {
        if (Config.isGreenfoot() && Config.isGreenfootStartupProject(projectDir)) {
            return;
        }
        String projectName = projectDir.getAbsolutePath();
        recentProjects.remove(projectName);
        if (recentProjects.size() == NUM_RECENT_PROJECTS) {
            recentProjects.remove(NUM_RECENT_PROJECTS - 1);
        }
        recentProjects.add(0, projectName);
        for (int i = 0; i < recentProjects.size(); ++i) {
            Config.putPropString("bluej.recentProject" + i, recentProjects.get(i));
        }
    }

    @OnThread(value=Tag.Swing)
    public static Font getStandoutMenuFont() {
        return italicMenuFont;
    }

    @OnThread(value=Tag.Swing)
    public static Font getPopupMenuFont() {
        return popupMenuFont;
    }

    @OnThread(value=Tag.Any)
    public static synchronized boolean getFlag(String flag) {
        String value = flags.get(flag);
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    @OnThread(value=Tag.FXPlatform)
    public static BooleanExpression flagProperty(String flagName) {
        return (BooleanExpression)flagProperties.computeIfAbsent(flagName, f -> new SimpleBooleanProperty(PrefMgr.getFlag(f)));
    }

    @OnThread(value=Tag.Any)
    public static synchronized void setFlag(String flag, boolean enabled) {
        String value = String.valueOf(enabled);
        String systemDefault = Config.getDefaultPropString(flag, "");
        if (systemDefault.length() > 0 && Boolean.valueOf(systemDefault) == enabled) {
            Config.removeProperty(flag);
        } else {
            Config.putPropString(flag, value);
        }
        flags.put(flag, value);
        JavaFXUtil.runNowOrLater(() -> {
            BooleanProperty prop = flagProperties.get(flag);
            if (prop != null) {
                prop.set(enabled);
            }
        });
    }

    private static List<String> readRecentProjects() {
        ArrayList<String> projects = new ArrayList<String>(NUM_RECENT_PROJECTS);
        for (int i = 0; i < NUM_RECENT_PROJECTS; ++i) {
            String projectName = Config.getPropString("bluej.recentProject" + i, "");
            if (projectName.length() <= 0) continue;
            projects.add(projectName);
        }
        return projects;
    }

    public static void setEditorFontSize(int size) {
        if (size > 0) {
            PrefMgr.initEditorFontSize(size);
            EditorManager.getEditorManager().refreshAll();
        }
    }

    private static void initEditorFontSize(int size) {
        if (size > 0 && size != editorFontSize.get()) {
            editorFontSize.set(size);
            Config.putPropInteger(editorFontSizePropertyName, size);
            String font = Config.isMacOS() ? Config.getPropString(editorMacFontPropertyName, "Roboto Mono") : Config.getPropString(editorFontPropertyName, "Roboto Mono");
            editorStandardFont.set((Object)font);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static IntegerProperty getEditorFontSize() {
        return editorFontSize;
    }

    @OnThread(value=Tag.FXPlatform)
    public static StringExpression getEditorFontCSS(boolean includeFamily) {
        if (editorFontCSS == null) {
            editorFontSizeOnlyCSS = Bindings.concat((Object[])new Object[]{"-fx-font-size: ", editorFontSize, "pt;"});
            editorFontCSS = Bindings.concat((Object[])new Object[]{"-fx-font-size: ", editorFontSize, "pt;", "-fx-font-family: \"", editorStandardFont, "\";"});
        }
        return includeFamily ? editorFontCSS : editorFontSizeOnlyCSS;
    }

    @OnThread(value=Tag.FXPlatform)
    public static ObservableIntegerValue getScopeHighlightStrength() {
        return highlightStrength;
    }

    public static void setScopeHighlightStrength(int strength) {
        highlightStrength.set(strength);
        Config.putPropInteger(SCOPE_HIGHLIGHTING_STRENGTH, strength);
    }

    public static boolean getNaviviewExpanded() {
        return isNaviviewExpanded;
    }

    public static void setNaviviewExpanded(boolean expanded) {
        isNaviviewExpanded = expanded;
        Config.putPropString(NAVIVIEW_EXPANDED, String.valueOf(expanded));
    }

    @OnThread(value=Tag.FX)
    public static IntegerProperty strideFontSizeProperty() {
        if (strideFontSize == null) {
            String fontSizePropName = "bluej.stride.editor.fontSize";
            int sizeFromConfig = Config.getPropInteger(fontSizePropName, 11);
            int clampedSize = Math.max(6, Math.min(160, sizeFromConfig));
            strideFontSize = new SimpleIntegerProperty(clampedSize);
            strideFontSize.addListener((a, b, newVal) -> Config.putPropInteger(fontSizePropName, newVal.intValue()));
        }
        return strideFontSize;
    }

    static {
        editorFontSize = new SimpleIntegerProperty(10);
        editorStandardFont = new SimpleStringProperty("Roboto Mono");
        strideFontSize = null;
        highlightStrength = new SimpleIntegerProperty(0);
        isNaviviewExpanded = true;
        flags = new HashMap();
        flagProperties = new HashMap();
        PrefMgr.initEditorFontSize(Config.getPropInteger(editorFontSizePropertyName, 12));
        JavaFXUtil.addChangeListener(editorFontSize, size -> Config.putPropInteger(editorFontSizePropertyName, size.intValue()));
        int menuFontSize = Config.getPropInteger("bluej.menu.fontsize", 12);
        Font menuFont = Config.getFont("bluej.menu.font", "SansSerif", menuFontSize);
        italicMenuFont = menuFont.deriveFont(2);
        popupMenuFont = menuFont.deriveFont(0);
        highlightStrength.set(Config.getPropInteger(SCOPE_HIGHLIGHTING_STRENGTH, 20));
        isNaviviewExpanded = PrefMgr.initializeisNavivewExpanded();
        projectDirectory = Config.getPropString("bluej.projectPath", System.getProperty("user.home"));
        recentProjects = PrefMgr.readRecentProjects();
        flags.put(HIGHLIGHTING, Config.getPropString(HIGHLIGHTING, "true"));
        flags.put(AUTO_INDENT, Config.getPropString(AUTO_INDENT, "false"));
        flags.put(LINENUMBERS, Config.getPropString(LINENUMBERS, "false"));
        flags.put(MAKE_BACKUP, Config.getPropString(MAKE_BACKUP, "false"));
        flags.put(MATCH_BRACKETS, Config.getPropString(MATCH_BRACKETS, "true"));
        flags.put(LINK_LIB, Config.getPropString(LINK_LIB, "true"));
        flags.put(SHOW_TEST_TOOLS, Config.getPropString(SHOW_TEST_TOOLS, "false"));
        flags.put(SHOW_TEAM_TOOLS, Config.getPropString(SHOW_TEAM_TOOLS, "false"));
        flags.put(SHOW_TEXT_EVAL, Config.getPropString(SHOW_TEXT_EVAL, "false"));
        flags.put(SHOW_UNCHECKED, Config.getPropString(SHOW_UNCHECKED, "true"));
        flags.put(ACCESSIBILITY_SUPPORT, Config.getPropString(ACCESSIBILITY_SUPPORT, "false"));
        flags.put(START_WITH_SUDO, Config.getPropString(START_WITH_SUDO, "true"));
        flags.put(STRIDE_SIDEBAR_SHOWING, Config.getPropString(STRIDE_SIDEBAR_SHOWING, "true"));
    }
}

