/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target.role;

import bluej.Config;
import bluej.debugmgr.ConstructAction;
import bluej.debugmgr.objectbench.InvokeAction;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.prefmgr.PrefMgr;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javafx.collections.ObservableList;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class ClassRole {
    public static final String CLASS_ROLE_NAME = null;

    @OnThread(value=Tag.Any)
    public String getRoleName() {
        return CLASS_ROLE_NAME;
    }

    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, int modifiers, String prefix) {
    }

    public void load(Properties props, String prefix) throws NumberFormatException {
    }

    @OnThread(value=Tag.Any)
    public String getStereotypeLabel() {
        return null;
    }

    public boolean generateSkeleton(String template, Package pkg, String name, String sourceFile) {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        translations.put("CLASSNAME", name);
        if (pkg.isUnnamedPackage()) {
            translations.put("PKGLINE", "");
        } else {
            translations.put("PKGLINE", "package " + pkg.getQualifiedName() + ";" + Config.nl + Config.nl);
        }
        translations.put("PKGNAME", pkg.getQualifiedName());
        try {
            File dest = new File(sourceFile);
            if (dest.exists()) {
                pkg.showError("duplicate-name");
                return false;
            }
            BlueJFileReader.translateFile(Config.getClassTemplateFile(template), new File(sourceFile), translations, Charset.forName("UTF-8"), pkg.getProject().getProjectCharset());
            return true;
        }
        catch (IOException e) {
            pkg.showError("skeleton-error");
            Debug.reportError("The default skeleton for the class could not be generated");
            Debug.reportError("Exception: " + e);
            return false;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean createRoleMenu(ObservableList<MenuItem> menu, ClassTarget ct, Class<?> cl, DependentTarget.State state) {
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean createRoleMenuEnd(ObservableList<MenuItem> menu, ClassTarget ct, DependentTarget.State state) {
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean createClassConstructorMenu(ObservableList<MenuItem> menu, ClassTarget ct, Class<?> cl) {
        View view = View.getView(cl);
        if (!Modifier.isAbstract(cl.getModifiers())) {
            ViewFilter filter = new ViewFilter(196613);
            CallableView[] constructors = view.getConstructors();
            if (ClassRole.createMenuItems(menu, constructors, filter, 0, constructors.length, "new ", (InvokeListener)ct)) {
                return true;
            }
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean createClassStaticMenu(ObservableList<MenuItem> menu, ClassTarget ct, boolean hasSource, Class<?> cl) {
        View view = View.getView(cl);
        ViewFilter filter = new ViewFilter(65549);
        CallableView[] allMethods = view.getAllMethods();
        return ClassRole.createMenuItems(menu, allMethods, filter, 0, allMethods.length, "", (InvokeListener)ct);
    }

    @OnThread(value=Tag.FXPlatform)
    private static boolean createMenuItems(ObservableList<MenuItem> menu, CallableView[] members, ViewFilter filter, int first, int last, String prefix, InvokeListener il) {
        boolean hasEntries = false;
        int itemHeight = 28;
        int itemsOnScreen = (int)Config.screenBounds.getHeight() / itemHeight;
        int sizeLimit = itemsOnScreen / 2;
        for (int i = first; i < last; ++i) {
            try {
                MenuItem menuItem;
                CallableView m = members[last - i - 1];
                if (!filter.accept(m)) continue;
                if (m instanceof MethodView) {
                    menuItem = new MenuItem(prefix + m.getLongDesc());
                    menuItem.setOnAction(e -> il.executeMethod((MethodView)m));
                    int itemCount = menu.size();
                    if (itemCount >= sizeLimit) {
                        Menu subMenu = new Menu(Config.getString("pkgmgr.classmenu.moreMethods"));
                        menu.add((Object)subMenu);
                        menu = subMenu.getItems();
                    }
                    menu.add((Object)menuItem);
                    hasEntries = true;
                    continue;
                }
                if (!(m instanceof ConstructorView)) continue;
                menuItem = new MenuItem(prefix + m.getLongDesc());
                menu.add((Object)menuItem);
                menuItem.setOnAction(e -> il.callConstructor((ConstructorView)m));
                hasEntries = true;
                continue;
            }
            catch (Exception e2) {
                Debug.reportError("Exception accessing methods: " + e2);
                e2.printStackTrace();
            }
        }
        return hasEntries;
    }

    @OnThread(value=Tag.SwingIsFX)
    public static boolean createMenuItems(JPopupMenu menu, CallableView[] members, ViewFilter filter, int first, int last, String prefix, InvokeListener il) {
        boolean hasEntries = false;
        for (int i = first; i < last; ++i) {
            try {
                CallableView m = members[last - i - 1];
                if (!filter.accept(m)) continue;
                AbstractAction callAction = null;
                if (m instanceof MethodView) {
                    callAction = new InvokeAction((MethodView)m, il, prefix + m.getLongDesc());
                } else if (m instanceof ConstructorView) {
                    callAction = new ConstructAction((ConstructorView)m, il, prefix + m.getLongDesc());
                }
                if (callAction == null) continue;
                JMenuItem item = menu.add(callAction);
                item.setFont(PrefMgr.getPopupMenuFont());
                hasEntries = true;
                continue;
            }
            catch (Exception e) {
                Debug.reportError("Exception accessing methods: " + e);
                e.printStackTrace();
            }
        }
        return hasEntries;
    }

    public void run(PkgMgrFrame pmf, ClassTarget ct, String param) {
    }

    public List<File> getAllFiles(ClassTarget ct) {
        ArrayList<File> rlist = new ArrayList<File>();
        rlist.add(ct.getClassFile());
        rlist.addAll(Utility.mapList(ct.getAllSourceFilesJavaLast(), sf -> sf.file));
        rlist.add(ct.getContextFile());
        rlist.add(ct.getDocumentationFile());
        File[] innerClasses = ct.getInnerClassFiles();
        Collections.addAll(rlist, innerClasses);
        return rlist;
    }

    @OnThread(value=Tag.Any)
    public abstract boolean canConvertToStride();
}

