/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.pkgmgr.LayoutComparer;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.EditableTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javafx.geometry.Point2D;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class DependentTarget
extends EditableTarget {
    private final @OnThread(value=Tag.Any) AtomicReference<State> state = new AtomicReference<State>(State.NEEDS_COMPILE);
    private @OnThread(value=Tag.Any, requireSynchronized=true) List<UsesDependency> inUses = new ArrayList<UsesDependency>();
    private @OnThread(value=Tag.Any, requireSynchronized=true) List<UsesDependency> outUses = new ArrayList<UsesDependency>();
    private @OnThread(value=Tag.Any, requireSynchronized=true) List<Dependency> parents = new ArrayList<Dependency>();
    private @OnThread(value=Tag.Any, requireSynchronized=true) List<Dependency> children = new ArrayList<Dependency>();
    protected @OnThread(value=Tag.Any, requireSynchronized=true) DependentTarget assoc = null;

    public DependentTarget(Package pkg, String identifierName) {
        super(pkg, identifierName);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setPos(int x, int y) {
        super.setPos(x, y);
        this.recalcDependentPositions();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.recalcDependentPositions();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        if (this.getAssociation() != null) {
            String assocName = this.getAssociation().getIdentifierName();
            props.put(prefix + ".association", assocName);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void setAssociation(DependentTarget t) {
        this.assoc = t;
        if (this.assoc != null && this.assoc.isMoveable()) {
            this.assoc.setIsMoveable(false);
        }
        if (this.assoc != null && this.assoc.isResizable()) {
            this.assoc.setResizable(false);
        }
    }

    @OnThread(value=Tag.Any, requireSynchronized=true)
    public synchronized @OnThread(value=Tag.Any, requireSynchronized=true) DependentTarget getAssociation() {
        return this.assoc;
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void addDependencyOut(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            if (this.outUses.contains(d)) {
                return;
            }
            this.outUses.add((UsesDependency)d);
            if (recalc) {
                this.recalcOutUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            if (this.parents.contains(d)) {
                return;
            }
            this.parents.add(d);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void addDependencyIn(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            if (this.inUses.contains(d)) {
                return;
            }
            this.inUses.add((UsesDependency)d);
            if (recalc) {
                this.recalcInUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            if (this.children.contains(d)) {
                return;
            }
            this.children.add(d);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void removeDependencyOut(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.outUses.remove(d);
            if (recalc) {
                this.recalcOutUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            this.parents.remove(d);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void removeDependencyIn(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.inUses.remove(d);
            if (recalc) {
                this.recalcInUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            this.children.remove(d);
        }
    }

    @OnThread(value=Tag.Any)
    public synchronized Collection<Dependency> dependencies() {
        ArrayList<Dependency> d = new ArrayList<Dependency>();
        d.addAll(this.parents);
        d.addAll(this.outUses);
        return d;
    }

    @OnThread(value=Tag.Any)
    public synchronized Collection<Dependency> dependents() {
        ArrayList<Dependency> d = new ArrayList<Dependency>();
        d.addAll(this.children);
        d.addAll(this.inUses);
        return d;
    }

    @OnThread(value=Tag.Any, requireSynchronized=true)
    public synchronized @OnThread(value=Tag.Any, requireSynchronized=true) List<Dependency> getParents() {
        return Collections.unmodifiableList(new ArrayList<Dependency>(this.parents));
    }

    @OnThread(value=Tag.Any)
    public synchronized List<Dependency> getChildrenDependencies() {
        return Collections.unmodifiableList(new ArrayList<Dependency>(this.children));
    }

    @OnThread(value=Tag.Any)
    public synchronized List<Dependency> dependentsAsList() {
        LinkedList<Dependency> list = new LinkedList<Dependency>();
        list.addAll(this.inUses);
        list.addAll(this.outUses);
        list.addAll(this.children);
        list.addAll(this.parents);
        return list;
    }

    @OnThread(value=Tag.Any)
    public synchronized List<UsesDependency> usesDependencies() {
        return Collections.unmodifiableList(new ArrayList<UsesDependency>(this.outUses));
    }

    @OnThread(value=Tag.FXPlatform)
    protected synchronized void removeAllOutDependencies() {
        if (!this.outUses.isEmpty()) {
            Dependency[] outUsesArray = new Dependency[this.outUses.size()];
            this.outUses.toArray(outUsesArray);
            for (int i = 0; i < outUsesArray.length; ++i) {
                this.getPackage().removeDependency(outUsesArray[i], false);
            }
        }
        this.removeInheritDependencies();
    }

    @OnThread(value=Tag.FXPlatform)
    protected synchronized void removeInheritDependencies() {
        if (!this.parents.isEmpty()) {
            Dependency[] parentsArray = new Dependency[this.parents.size()];
            this.parents.toArray(parentsArray);
            for (int i = 0; i < parentsArray.length; ++i) {
                this.getPackage().removeDependency(parentsArray[i], false);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    protected synchronized void removeAllInDependencies() {
        int i;
        if (!this.inUses.isEmpty()) {
            Dependency[] inUsesArray = new Dependency[this.inUses.size()];
            this.inUses.toArray(inUsesArray);
            for (i = 0; i < inUsesArray.length; ++i) {
                this.getPackage().removeDependency(inUsesArray[i], false);
            }
        }
        if (!this.children.isEmpty()) {
            Dependency[] childrenArray = new Dependency[this.children.size()];
            this.children.toArray(childrenArray);
            for (i = 0; i < childrenArray.length; ++i) {
                this.getPackage().removeDependency(childrenArray[i], false);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void recalcOutUses() {
        List<UsesDependency> visibleOutUses = DependentTarget.getVisibleUsesDependencies(this.usesDependencies());
        Collections.sort(visibleOutUses, new LayoutComparer(this, false));
        int cy = this.getY() + this.getHeight() / 2;
        int n_top = 0;
        int n_bottom = 0;
        for (int i = visibleOutUses.size() - 1; i >= 0; --i) {
            DependentTarget to = ((Dependency)visibleOutUses.get(i)).getTo();
            int to_cy = to.getY() + to.getHeight() / 2;
            if (to_cy < cy) {
                ++n_top;
                continue;
            }
            ++n_bottom;
        }
        int top_left = this.getX() + (this.getWidth() - (n_top - 1) * 5) / 2;
        int bottom_left = this.getX() + (this.getWidth() - (n_bottom - 1) * 5) / 2;
        for (int i = 0; i < n_top + n_bottom; ++i) {
            UsesDependency d = visibleOutUses.get(i);
            int to_cy = d.getTo().getY() + d.getTo().getHeight() / 2;
            if (to_cy < cy) {
                d.setSourceCoords(top_left, (double)this.getY() - 2.5, true);
                top_left += 5;
                continue;
            }
            d.setSourceCoords(bottom_left, (double)(this.getY() + this.getHeight()) + 2.5, false);
            bottom_left += 5;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void recalcInUses() {
        List<UsesDependency> visibleInUses = DependentTarget.getVisibleUsesDependencies(this.inUses);
        Collections.sort(visibleInUses, new LayoutComparer(this, true));
        int cx = this.getX() + this.getWidth() / 2;
        int n_left = 0;
        int n_right = 0;
        for (int i = visibleInUses.size() - 1; i >= 0; --i) {
            DependentTarget from = ((Dependency)visibleInUses.get(i)).getFrom();
            int from_cx = from.getX() + from.getWidth() / 2;
            if (from_cx < cx) {
                ++n_left;
                continue;
            }
            ++n_right;
        }
        int left_top = this.getY() + (this.getHeight() - (n_left - 1) * 10) / 2;
        int right_top = this.getY() + (this.getHeight() - (n_right - 1) * 10) / 2;
        for (int i = 0; i < n_left + n_right; ++i) {
            UsesDependency d = visibleInUses.get(i);
            int from_cx = d.getFrom().getX() + d.getFrom().getWidth() / 2;
            if (from_cx < cx) {
                d.setDestCoords(this.getX() - 4, left_top, true);
                left_top += 10;
                continue;
            }
            d.setDestCoords(this.getX() + this.getWidth() + 4, right_top, false);
            right_top += 10;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private static List<UsesDependency> getVisibleUsesDependencies(List<UsesDependency> usesDependencies) {
        ArrayList<UsesDependency> result = new ArrayList<UsesDependency>();
        for (UsesDependency incomingUsesDependency : usesDependencies) {
            if (!incomingUsesDependency.isVisible()) continue;
            result.add(incomingUsesDependency);
        }
        return result;
    }

    @OnThread(value=Tag.FXPlatform)
    public Point2D getAttachment(double angle) {
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double tan = sin / cos;
        double m = (double)this.getHeight() / (double)this.getWidth();
        double radius = Math.abs(tan) < m ? 0.5 * (double)this.getWidth() / Math.abs(cos) : 0.5 * (double)this.getHeight() / Math.abs(sin);
        Point2D p = new Point2D((double)(this.getX() + this.getWidth() / 2 + (int)(radius * cos)), (double)(this.getY() + this.getHeight() / 2 - (int)(radius * sin)));
        return p;
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void recalcDependentPositions() {
        this.recalcInUses();
        this.recalcOutUses();
        for (Dependency dependency : this.inUses) {
            dependency.getFrom().recalcOutUses();
        }
        for (Dependency dependency : this.outUses) {
            dependency.getTo().recalcInUses();
        }
        this.updateAssociatePosition();
    }

    @OnThread(value=Tag.FXPlatform)
    protected void updateAssociatePosition() {
        DependentTarget t = this.getAssociation();
        if (t != null) {
            t.setPos(this.getX() + 30, this.getY() - 30);
            if (this.isResizable()) {
                t.setSize(this.getWidth(), this.getHeight());
            }
            t.recalcDependentPositions();
        }
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    @OnThread(value=Tag.Any)
    public State getState() {
        return this.state.get();
    }

    public void markModified() {
        if (this.getState() == State.COMPILED) {
            this.setState(State.NEEDS_COMPILE);
        }
    }

    public void setState(State newState) {
        this.state.set(newState);
        this.repaint();
        this.redraw();
    }

    @OnThread(value=Tag.Any)
    public static enum State {
        COMPILED,
        NEEDS_COMPILE,
        HAS_ERROR;

    }
}

