/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.collect.DiagnosticWithShown;
import bluej.collect.StrideEditReason;
import bluej.compiler.CompileInputFile;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.debugger.RunOnThread;
import bluej.debugger.gentype.Reflective;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.editor.EditorWatcher;
import bluej.editor.TextEditor;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameCatalogue;
import bluej.editor.stride.FrameEditor;
import bluej.extensions.BClass;
import bluej.extensions.BClassTarget;
import bluej.extensions.BDependency;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.SourceType;
import bluej.extensions.event.ClassEvent;
import bluej.extensions.event.ClassTargetEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ClassExtensionMenu;
import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.FXMenuManager;
import bluej.parser.ParseFailure;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.PackageResolver;
import bluej.parser.entity.ParsedReflective;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.ParsedTypeNode;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.SourceInfo;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.AbstractClassRole;
import bluej.pkgmgr.target.role.ClassRole;
import bluej.pkgmgr.target.role.EnumClassRole;
import bluej.pkgmgr.target.role.InterfaceClassRole;
import bluej.pkgmgr.target.role.StdClassRole;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.convert.ConversionWarning;
import bluej.stride.framedjava.convert.ConvertResultDialog;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.generic.Frame;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileEditor;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ResizableCanvas;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ClassTarget
extends DependentTarget
implements InvokeListener {
    static final int MIN_WIDTH = 60;
    static final int MIN_HEIGHT = 30;
    private static final String editStr = Config.getString("pkgmgr.classmenu.edit");
    private static final String compileStr = Config.getString("pkgmgr.classmenu.compile");
    private static final String inspectStr = Config.getString("pkgmgr.classmenu.inspect");
    private static final String removeStr = Config.getString("pkgmgr.classmenu.remove");
    private static final String convertToJavaStr = Config.getString("pkgmgr.classmenu.convertToJava");
    private static final String convertToStrideStr = Config.getString("pkgmgr.classmenu.convertToStride");
    private static final String createTestStr = Config.getString("pkgmgr.classmenu.createTest");
    private static final String launchFXStr = Config.getString("pkgmgr.classmenu.launchFX");
    private static final String STEREOTYPE_OPEN = "\u00ab";
    private static final String STEREOTYPE_CLOSE = "\u00bb";
    private static final double RESIZE_CORNER_GAP = 4.0;
    private static String TEMP_FILE_EXTENSION = "-temp";
    private @OnThread(value=Tag.FXPlatform) ClassRole role = new StdClassRole();
    private @OnThread(value=Tag.FXPlatform) boolean openWithInterface = false;
    private SourceInfo sourceInfo = new SourceInfo();
    private @OnThread(value=Tag.FXPlatform) boolean isAbstract;
    private @OnThread(value=Tag.FXPlatform) Optional<Boolean> isNaviviewExpanded = Optional.empty();
    private final @OnThread(value=Tag.FXPlatform) List<Integer> cachedBreakpoints = new ArrayList<Integer>();
    private boolean analysing = false;
    private @OnThread(value=Tag.FXPlatform) boolean isMoveable = true;
    private SourceType sourceAvailable;
    private boolean hasBeenOpened = false;
    private @OnThread(value=Tag.FXPlatform) String typeParameters = "";
    private @OnThread(value=Tag.FXPlatform) Map<String, String> properties = new HashMap<String, String>();
    private boolean recordedAsOpen = false;
    private @OnThread(value=Tag.FXPlatform) boolean visible = true;
    public static final String MENU_STYLE_INBUILT = "class-action-inbuilt";
    private static @OnThread(value=Tag.FXPlatform) String[] pseudos;
    private @OnThread(value=Tag.FX) ResizableCanvas canvas;
    private @OnThread(value=Tag.FXPlatform) Label stereotypeLabel;
    private @OnThread(value=Tag.FXPlatform) boolean isFront = true;
    private static @OnThread(value=Tag.FX) Image greyStripeImage;
    private static @OnThread(value=Tag.FX) Image redStripeImage;
    private static final int GREY_STRIPE_SEPARATION = 12;
    private static final int RED_STRIPE_SEPARATION = 16;
    private static final int STRIPE_THICKNESS = 3;
    private static final @OnThread(value=Tag.FX) Color RED_STRIPE;
    private static final @OnThread(value=Tag.FX) Color GREY_STRIPE;
    private @OnThread(value=Tag.FXPlatform) boolean showingInterface;
    private @OnThread(value=Tag.FXPlatform) boolean drawingExtends = false;
    private @OnThread(value=Tag.FXPlatform) Label nameLabel;
    private @OnThread(value=Tag.SwingIsFX) BClass singleBClass;
    private @OnThread(value=Tag.SwingIsFX) BClassTarget singleBClassTarget;

    public ClassTarget(Package pkg, String baseName) {
        this(pkg, baseName, null);
    }

    public ClassTarget(Package pkg, String baseName, String template) {
        super(pkg, baseName);
        if (pseudos == null) {
            pseudos = Utility.mapList(Arrays.asList(StdClassRole.class, UnitTestClassRole.class, AbstractClassRole.class, InterfaceClassRole.class, EnumClassRole.class), ClassTarget::pseudoFor).toArray(new String[0]);
        }
        JavaFXUtil.addStyleClass((Styleable)this.pane, "class-target");
        this.nameLabel = new Label(baseName);
        JavaFXUtil.addStyleClass((Styleable)this.nameLabel, "class-target-name");
        this.nameLabel.setMaxWidth(9999.0);
        this.stereotypeLabel = new Label();
        this.stereotypeLabel.setMaxWidth(9999.0);
        this.stereotypeLabel.visibleProperty().bind((ObservableValue)this.stereotypeLabel.textProperty().isNotEmpty());
        this.stereotypeLabel.managedProperty().bind((ObservableValue)this.stereotypeLabel.textProperty().isNotEmpty());
        JavaFXUtil.addStyleClass((Styleable)this.stereotypeLabel, "class-target-extra");
        this.pane.setTop((Node)new VBox(new Node[]{this.stereotypeLabel, this.nameLabel}));
        this.canvas = new ResizableCanvas(){

            @Override
            @OnThread(value=Tag.FX)
            public void resize(double width, double height) {
                super.resize(width, height);
                ClassTarget.this.redraw();
            }
        };
        this.pane.setCenter((Node)this.canvas);
        this.calcSourceAvailable();
        if (template != null) {
            if (template.startsWith("unittest")) {
                this.setRole(new UnitTestClassRole(true));
            } else if (template.startsWith("abstract")) {
                this.setRole(new AbstractClassRole());
            } else if (template.startsWith("interface")) {
                this.setRole(new InterfaceClassRole());
            } else if (template.startsWith("enum")) {
                this.setRole(new EnumClassRole());
            } else {
                this.setRole(new StdClassRole());
            }
        }
        JavaFXUtil.addChangeListener(this.canvas.sceneProperty(), scene -> {
            this.nameLabel.applyCss();
            this.updateSize();
        });
    }

    private void calcSourceAvailable() {
        if (this.getFrameSourceFile().canRead()) {
            this.sourceAvailable = SourceType.Stride;
        } else if (this.getJavaSourceFile().canRead()) {
            this.sourceAvailable = SourceType.Java;
        } else {
            this.sourceAvailable = SourceType.NONE;
            this.setState(DependentTarget.State.COMPILED);
        }
    }

    @OnThread(value=Tag.SwingIsFX)
    public final BClass getBClass() {
        if (this.singleBClass == null) {
            this.singleBClass = ExtensionBridge.newBClass((ClassTarget)this);
        }
        return this.singleBClass;
    }

    @OnThread(value=Tag.SwingIsFX)
    public final BClassTarget getBClassTarget() {
        if (this.singleBClassTarget == null) {
            this.singleBClassTarget = ExtensionBridge.newBClassTarget((ClassTarget)this);
        }
        return this.singleBClassTarget;
    }

    @OnThread(value=Tag.Any)
    public String getQualifiedName() {
        return this.getPackage().getQualifiedName(this.getBaseName());
    }

    @OnThread(value=Tag.Any)
    public String getBaseName() {
        return this.getIdentifierName();
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public Reflective getTypeRefelective() {
        ParsedTypeNode ptn;
        TextEditor textEditor;
        if (this.isCompiled()) {
            Class<?> cl = this.getPackage().loadClass(this.getQualifiedName());
            if (cl != null) {
                return new JavaReflective(cl);
            }
            return null;
        }
        JavaParentNode node = null;
        if (this.getEditor() != null && (textEditor = this.editor.assumeText()) != null) {
            node = textEditor.getParsedNode();
        }
        if (node != null && (ptn = (ParsedTypeNode)node.getTypeNode(this.getBaseName())) != null) {
            return new ParsedReflective(ptn);
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return super.getDisplayName() + this.getTypeParameters();
    }

    @OnThread(value=Tag.FXPlatform)
    private String getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public void setState(DependentTarget.State newState) {
        if (this.getState() != newState) {
            String qualifiedName = this.getQualifiedName();
            Project proj = this.getPackage().getProject();
            proj.removeInspectorInstance(qualifiedName);
            if (newState == DependentTarget.State.COMPILED && this.editor != null) {
                this.editor.reInitBreakpoints();
            }
            ClassEvent event = new ClassEvent(0, this.getPackage(), this.getBClass(), newState == DependentTarget.State.COMPILED, newState == DependentTarget.State.HAS_ERROR);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
            super.setState(newState);
        }
    }

    public void markCompiling(boolean clearErrorState, int compilationSequence) {
        if (clearErrorState && this.getState() == DependentTarget.State.HAS_ERROR) {
            this.setState(DependentTarget.State.NEEDS_COMPILE);
        }
        if (this.getSourceType() == SourceType.Stride) {
            this.getEditor();
        }
        if (this.editor != null && this.editor.compileStarted(compilationSequence)) {
            this.markKnownError(true);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public ClassRole getRole() {
        return this.role;
    }

    protected final void setRole(ClassRole newRole) {
        if (this.role == null || this.role.getRoleName() != newRole.getRoleName()) {
            boolean shouldBeFront;
            this.role = newRole;
            String select = ClassTarget.pseudoFor(this.role.getClass());
            String stereotype = this.role.getStereotypeLabel();
            this.isFront = shouldBeFront = this.role == null || !(this.role instanceof UnitTestClassRole);
            JavaFXUtil.selectPseudoClass((Node)this.pane, Arrays.asList(pseudos).indexOf(select), pseudos);
            if (stereotype != null) {
                this.stereotypeLabel.setText(STEREOTYPE_OPEN + stereotype + STEREOTYPE_CLOSE);
            } else {
                this.stereotypeLabel.setText("");
            }
        }
    }

    @OnThread(value=Tag.Any)
    private static String pseudoFor(Class<? extends ClassRole> aClass) {
        String name = aClass.getSimpleName();
        if (name.endsWith("ClassRole")) {
            name = name.substring(0, name.length() - "ClassRole".length());
        }
        return "bj-" + name.toLowerCase();
    }

    public static boolean isJunit4TestClass(Class<?> cl) {
        ClassLoader clLoader = cl.getClassLoader();
        try {
            Class<?> beforeClass = Class.forName("org.junit.Before", false, clLoader);
            Class<?> afterClass = Class.forName("org.junit.After", false, clLoader);
            Class<?> testClass = Class.forName("org.junit.Test", false, clLoader);
            Method[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getAnnotation(beforeClass) != null) {
                    return true;
                }
                if (methods[i].getAnnotation(afterClass) != null) {
                    return true;
                }
                if (methods[i].getAnnotation(testClass) == null) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return false;
    }

    public void determineRole(Class<?> cl) {
        if (cl != null) {
            this.isAbstract = Modifier.isAbstract(cl.getModifiers());
            ClassLoader clLoader = cl.getClassLoader();
            Class junitClass = null;
            if (clLoader != null) {
                try {
                    junitClass = clLoader.loadClass("junit.framework.TestCase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
            if (junitClass == null) {
                junitClass = TestCase.class;
            }
            if (junitClass.isAssignableFrom(cl)) {
                this.setRole(new UnitTestClassRole(false));
            } else if (Modifier.isInterface(cl.getModifiers())) {
                this.setRole(new InterfaceClassRole());
            } else if (JavaUtils.getJavaUtils().isEnum(cl)) {
                this.setRole(new EnumClassRole());
            } else if (this.isAbstract) {
                this.setRole(new AbstractClassRole());
            } else if (ClassTarget.isJunit4TestClass(cl)) {
                this.setRole(new UnitTestClassRole(true));
            } else {
                this.setRole(new StdClassRole());
            }
        } else {
            this.isAbstract = false;
            ClassInfo classInfo = this.sourceInfo.getInfoIfAvailable();
            if (classInfo != null) {
                if (classInfo.isUnitTest()) {
                    this.setRole(new UnitTestClassRole(false));
                } else if (classInfo.isInterface()) {
                    this.setRole(new InterfaceClassRole());
                } else if (classInfo.isEnum()) {
                    this.setRole(new EnumClassRole());
                } else if (classInfo.isAbstract()) {
                    this.setRole(new AbstractClassRole());
                } else if (!(this.role instanceof UnitTestClassRole)) {
                    this.setRole(new StdClassRole());
                }
            }
        }
    }

    @Override
    public void load(Properties props, String prefix) {
        String typeParams;
        super.load(props, prefix);
        String type = props.getProperty(prefix + ".type");
        String intf = props.getProperty(prefix + ".showInterface");
        this.openWithInterface = Boolean.valueOf(intf);
        if ("UnitTestTarget".equals(type)) {
            this.setRole(new UnitTestClassRole(false));
        } else if ("UnitTestTargetJunit4".equals(type)) {
            this.setRole(new UnitTestClassRole(true));
        } else if ("AbstractTarget".equals(type)) {
            this.setRole(new AbstractClassRole());
        } else if ("InterfaceTarget".equals(type)) {
            this.setRole(new InterfaceClassRole());
        } else if ("EnumTarget".equals(type)) {
            this.setRole(new EnumClassRole());
        }
        this.getRole().load(props, prefix);
        String value = props.getProperty(prefix + ".naviview.expanded");
        if (value != null) {
            this.setNaviviewExpanded(Boolean.parseBoolean(value));
            this.setProperty("naviviewExpandedProperty", String.valueOf(value));
        }
        if ((typeParams = props.getProperty(prefix + ".typeParameters")) == null) {
            this.analyseSource();
        } else {
            this.typeParameters = typeParams;
        }
        this.cachedBreakpoints.clear();
        try {
            String s;
            int i = 0;
            while ((s = props.getProperty(prefix + ".breakpoint." + Integer.toString(i), "")) != null && !s.isEmpty()) {
                this.cachedBreakpoints.add(Integer.parseInt(s));
                ++i;
            }
        }
        catch (NumberFormatException e) {
            Debug.reportError("Error parsing breakpoint line number", e);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        if (this.getRole().getRoleName() != null) {
            props.put(prefix + ".type", this.getRole().getRoleName());
        }
        boolean intf = this.openWithInterface = this.showingInterface;
        if (this.getProperty("naviviewExpandedProperty") != null) {
            props.put(prefix + ".naviview.expanded", String.valueOf(this.getProperty("naviviewExpandedProperty")));
        } else if (this.isNaviviewExpanded.isPresent()) {
            props.put(prefix + ".naviview.expanded", String.valueOf(this.isNaviviewExpanded()));
        }
        props.put(prefix + ".typeParameters", this.getTypeParameters());
        props.put(prefix + ".showInterface", Boolean.valueOf(intf).toString());
        List breakpoints = this.editor != null && this.editor instanceof FrameEditor ? ((FrameEditor)this.editor).getBreakpoints() : this.cachedBreakpoints;
        for (int i = 0; i < breakpoints.size(); ++i) {
            props.put(prefix + ".breakpoint." + i, ((Integer)breakpoints.get(i)).toString());
        }
        this.getRole().save(props, 0, prefix);
    }

    public void reload() {
        this.calcSourceAvailable();
        if (this.sourceAvailable != SourceType.NONE) {
            if (this.editor != null) {
                this.editor.reloadFile();
            } else {
                this.analyseSource();
            }
        }
    }

    public boolean upToDate() {
        File src = this.getSourceFile();
        File clss = this.getClassFile();
        if (this.sourceAvailable == SourceType.NONE) {
            return true;
        }
        return clss.exists() && (!src.exists() || src.lastModified() <= clss.lastModified());
    }

    public void fixSourceModificationDate() {
        if (this.sourceAvailable == SourceType.NONE) {
            return;
        }
        File src = this.getSourceFile();
        long now = Instant.now().toEpochMilli();
        if (src.exists() && src.lastModified() > now + 1000L) {
            src.setLastModified(now);
        }
    }

    public void invalidate() {
        if (this.hasSourceCode()) {
            this.markModified();
        }
        for (Dependency d : this.dependents()) {
            ClassTarget dependent = (ClassTarget)d.getFrom();
            if (!dependent.isCompiled() || !dependent.hasSourceCode()) continue;
            dependent.invalidate();
        }
    }

    public boolean isInterface() {
        return this.getRole() instanceof InterfaceClassRole;
    }

    public boolean isUnitTest() {
        return this.getRole() instanceof UnitTestClassRole;
    }

    public boolean isEnum() {
        return this.getRole() instanceof EnumClassRole;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean hasSourceCode() {
        return this.sourceAvailable != SourceType.NONE;
    }

    public SourceType getSourceType() {
        return this.sourceAvailable;
    }

    public File getJavaSourceFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + "." + SourceType.Java.toString().toLowerCase());
    }

    public File getFrameSourceFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + "." + SourceType.Stride.toString().toLowerCase());
    }

    @Override
    public File getSourceFile() {
        switch (this.sourceAvailable) {
            case Java: {
                return this.getJavaSourceFile();
            }
            case Stride: {
                return this.getFrameSourceFile();
            }
        }
        return null;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean isVisible() {
        return this.visible;
    }

    public void markCompiled(boolean classesKept) {
        if (this.editor != null) {
            this.editor.compileFinished(false, classesKept);
        }
        this.setState(DependentTarget.State.COMPILED);
    }

    public Collection<SourceFileInfo> getAllSourceFilesJavaLast() {
        ArrayList<SourceFileInfo> list = new ArrayList<SourceFileInfo>();
        if (this.sourceAvailable.equals((Object)SourceType.Stride)) {
            list.add(new SourceFileInfo(this.getFrameSourceFile(), SourceType.Stride));
        }
        list.add(new SourceFileInfo(this.getJavaSourceFile(), SourceType.Java));
        return list;
    }

    public File getContextFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".ctxt");
    }

    public File getClassFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".class");
    }

    public File getDocumentationFile() {
        String filename = this.getJavaSourceFile().getPath();
        String docFilename = this.getPackage().getProject().getDocumentationFile(filename);
        return new File(docFilename);
    }

    public File[] getInnerClassFiles() {
        File[] files = this.getPackage().getPath().listFiles(new InnerClassFileFilter());
        return files;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Editor getEditor() {
        boolean withInterface = this.openWithInterface;
        return this.getEditor(withInterface);
    }

    /*
     * Unable to fully structure code
     */
    @OnThread(value=Tag.FXPlatform)
    private Editor getEditor(boolean showInterface) {
        block7: {
            if (this.editor != null) break block7;
            docFilename = this.getDocumentationFile().getPath();
            if (this.sourceAvailable == SourceType.NONE) {
                filename = null;
                showInterface = true;
                if (!new File(docFilename).exists()) {
                    return null;
                }
            } else {
                filename = this.getSourceFile().getPath();
            }
            project = this.getPackage().getProject();
            resolver = new PackageResolver(project.getEntityResolver(), this.getPackage().getQualifiedName());
            if (this.sourceAvailable == SourceType.Java) ** GOTO lbl17
            if (this.sourceAvailable == SourceType.NONE) {
lbl17:
                // 2 sources

                this.editor = EditorManager.getEditorManager().openClass(filename, docFilename, project.getProjectCharset(), this.getBaseName(), (FXSupplier<FXTabbedEditor>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getDefaultFXTabbedEditor(), ()Lbluej/editor/stride/FXTabbedEditor;)((Project)project), (EditorWatcher)this, this.isCompiled(), (EntityResolver)resolver, project.getJavadocResolver(), (FXPlatformRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordEditorOpen(), ()V)((ClassTarget)this));
            } else if (this.sourceAvailable == SourceType.Stride) {
                frameSourceFile = this.getFrameSourceFile();
                javaSourceFile = this.getJavaSourceFile();
                javadocResolver = project.getJavadocResolver();
                pkg = this.getPackage();
                openCallback = (FXPlatformRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordEditorOpen(), ()V)((ClassTarget)this);
                this.editor = new FrameEditor(frameSourceFile, javaSourceFile, (EditorWatcher)this, (EntityResolver)resolver, javadocResolver, pkg, openCallback);
            }
            if (this.editor != null) {
                this.editor.showInterface(showInterface);
            }
        }
        return this.editor;
    }

    private void recordEditorOpen() {
        if (!this.hasBeenOpened) {
            this.hasBeenOpened = true;
            switch (this.sourceAvailable) {
                case Java: {
                    Config.recordEditorOpen(Config.SourceType.Java);
                    break;
                }
                case Stride: {
                    Config.recordEditorOpen(Config.SourceType.Stride);
                    break;
                }
            }
        }
    }

    @Override
    public void ensureSaved() throws IOException {
        if (this.editor == null && this.sourceAvailable == SourceType.Stride) {
            this.getEditor();
        }
        super.ensureSaved();
    }

    private void inspect() {
        final PkgMgrFrame pmf = PkgMgrFrame.findFrame(this.getPackage());
        final Project proj = this.getPackage().getProject();
        new Thread(){

            @Override
            @OnThread(value=Tag.Unique)
            public void run() {
                try {
                    FXPlatformSupplier<DebuggerClass> clss = ClassTarget.this.getPackage().getDebugger().getClass(ClassTarget.this.getQualifiedName(), true);
                    Platform.runLater(() -> proj.getClassInspectorInstance((DebuggerClass)clss.get(), ClassTarget.this.getPackage(), (Window)pmf.getFXWindow(), ClassTarget.this.getNode()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }.start();
    }

    @Override
    public void modificationEvent(Editor editor) {
        this.invalidate();
        this.removeBreakpoints();
        if (this.getPackage().getProject().getDebugger() != null) {
            this.getPackage().getProject().getDebugger().removeBreakpointsForClass(this.getQualifiedName());
        }
        if (this.isCompiled()) {
            this.setState(DependentTarget.State.NEEDS_COMPILE);
        }
        this.sourceInfo.setSourceModified();
    }

    @Override
    public void saveEvent(Editor editor) {
        ClassInfo info = this.analyseSource();
        if (info != null) {
            this.updateTargetFile(info);
        }
        this.determineRole(null);
    }

    @Override
    public String breakpointToggleEvent(int lineNo, boolean set) {
        if (this.isCompiled()) {
            String possibleError = this.getPackage().getDebugger().toggleBreakpoint(this.getQualifiedName(), lineNo, set, null);
            if (possibleError == null && this.getPackage() != null) {
                DataCollector.debuggerBreakpointToggle(this.getPackage(), this.getSourceFile(), lineNo, set);
            }
            return possibleError;
        }
        return Config.getString("pkgmgr.breakpointMsg");
    }

    @Override
    public void clearAllBreakpoints() {
        Package pkg = this.getPackage();
        if (pkg != null) {
            pkg.getDebugger().removeBreakpointsForClass(this.getQualifiedName());
        }
    }

    public void removeBreakpoints() {
        if (this.editor != null) {
            this.editor.removeBreakpoints();
        }
    }

    public void reInitBreakpoints() {
        if (this.editor != null && this.isCompiled()) {
            this.editor.reInitBreakpoints();
        } else if (this.isCompiled() && this.sourceAvailable == SourceType.Stride) {
            ArrayList<Integer> breakpoints = new ArrayList<Integer>(this.cachedBreakpoints);
            for (Integer line : breakpoints) {
                this.breakpointToggleEvent(line, true);
            }
        }
    }

    public void removeStepMark() {
        if (this.editor != null) {
            this.editor.removeStepMark();
        }
    }

    public boolean isCompiled() {
        return this.getState() == DependentTarget.State.COMPILED;
    }

    @OnThread(value=Tag.Any)
    public void scheduleCompilation(boolean immediate, CompileReason reason, CompileType type) {
        if (Config.isGreenfoot()) {
            this.getPackage().getProject().scheduleCompilation(immediate, reason, type, this.getPackage());
        } else {
            this.getPackage().getProject().scheduleCompilation(immediate, reason, type, this);
        }
    }

    public void endCompile() {
        Class<?> cl = this.getPackage().loadClass(this.getQualifiedName());
        this.determineRole(cl);
        this.analyseDependencies(cl);
    }

    public boolean generateSkeleton(String template, SourceType sourceType) {
        boolean success;
        if (template == null) {
            Debug.reportError("generate class skeleton error");
            return false;
        }
        switch (sourceType) {
            case Java: {
                success = this.role.generateSkeleton(template, this.getPackage(), this.getBaseName(), this.getJavaSourceFile().getPath());
                break;
            }
            case Stride: {
                this.addStride(Loader.buildTopLevelElement(template, this.getPackage().getProject().getEntityResolver(), this.getBaseName(), this.getPackage().getBaseName()));
                success = true;
                break;
            }
            default: {
                success = false;
            }
        }
        if (success) {
            this.setState(DependentTarget.State.NEEDS_COMPILE);
            this.sourceAvailable = sourceType;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enforcePackage(String packageName) throws IOException {
        if (!JavaNames.isQualifiedIdentifier(packageName)) {
            throw new IllegalArgumentException();
        }
        ClassInfo info = this.sourceInfo.getInfo(this.getSourceFile(), this.getPackage());
        if (info == null) {
            return;
        }
        String semiReplacement = null;
        String nameReplacement = null;
        String pkgStatementReplacement = null;
        if (packageName.length() == 0) {
            if (!info.hasPackageStatement()) return;
            semiReplacement = "";
            nameReplacement = "";
            pkgStatementReplacement = "";
        } else if (info.hasPackageStatement()) {
            if (info.getPackage().equals(packageName)) {
                return;
            }
            nameReplacement = packageName;
        } else {
            semiReplacement = ";\n\n";
            nameReplacement = packageName;
            pkgStatementReplacement = "package ";
        }
        FileEditor fed = new FileEditor(this.getSourceFile());
        if (semiReplacement != null) {
            Selection selSemi = info.getPackageSemiSelection();
            fed.replaceSelection(selSemi, semiReplacement);
        }
        if (nameReplacement != null) {
            Selection selName = info.getPackageNameSelection();
            fed.replaceSelection(selName, nameReplacement);
        }
        if (pkgStatementReplacement != null) {
            Selection selStatement = info.getPackageStatementSelection();
            fed.replaceSelection(selStatement, pkgStatementReplacement);
        }
        fed.save();
    }

    public ClassInfo analyseSource() {
        if (this.analysing) {
            return null;
        }
        this.analysing = true;
        ClassInfo info = this.sourceInfo.getInfo(this.getJavaSourceFile(), this.getPackage());
        if (info != null) {
            this.determineRole(null);
            this.setTypeParameters(info);
            this.analyseDependencies(info);
        }
        this.analysing = false;
        return info;
    }

    private void updateTargetFile(ClassInfo info) {
        if (this.analyseClassName(info)) {
            if (this.nameEqualsIgnoreCase(info.getName())) {
                this.doClassNameChange(info.getName() + TEMP_FILE_EXTENSION);
            }
            this.doClassNameChange(info.getName());
        }
        if (this.analysePackageName(info)) {
            this.doPackageNameChange(info.getPackage());
        }
    }

    public void setTypeParameters(ClassInfo info) {
        String newTypeParameters = "";
        if (info.hasTypeParameter()) {
            Iterator<String> i = info.getTypeParameterTexts().iterator();
            newTypeParameters = "<" + i.next();
            while (i.hasNext()) {
                newTypeParameters = newTypeParameters + "," + i.next();
            }
            newTypeParameters = newTypeParameters + ">";
        }
        if (!newTypeParameters.equals(this.typeParameters)) {
            this.typeParameters = newTypeParameters;
            this.updateSize();
        }
    }

    public boolean analyseClassName(ClassInfo info) {
        String newName = info.getName();
        if (newName == null || newName.length() == 0) {
            return false;
        }
        return !this.getBaseName().equals(newName);
    }

    public boolean analysePackageName(ClassInfo info) {
        String newName = info.getPackage();
        return !this.getPackage().getQualifiedName().equals(newName);
    }

    public void analyseDependencies(ClassInfo info) {
        this.removeAllOutDependencies();
        this.removeInheritDependencies();
        String pkgPrefix = this.getPackage().getQualifiedName();
        String string = pkgPrefix = pkgPrefix.length() == 0 ? pkgPrefix : pkgPrefix + ".";
        if (info.getSuperclass() != null) {
            this.setSuperClass(info.getSuperclass());
        }
        List<String> vect = info.getImplements();
        for (String name : vect) {
            this.addInterface(name);
        }
        vect = info.getUsed();
        for (String name : vect) {
            DependentTarget used = this.getPackage().getDependentTarget(name);
            if (used == null || used.getAssociation() == this || this.getAssociation() == used) continue;
            this.getPackage().addDependency(new UsesDependency(this.getPackage(), this, used));
        }
    }

    public void analyseDependencies(Class<?> cl) {
        if (cl != null) {
            this.removeInheritDependencies();
            Class<?> superClass = cl.getSuperclass();
            if (superClass != null) {
                this.setSuperClass(superClass.getName());
            }
            Class<?>[] interfaces = cl.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.addInterface(interfaces[i].getName());
            }
        }
    }

    private void setSuperClass(String superName) {
        String pkgPrefix = this.getPackage().getQualifiedName();
        if (superName.startsWith(pkgPrefix)) {
            int prefixLen = pkgPrefix.length();
            prefixLen = prefixLen == 0 ? 0 : prefixLen + 1;
            superName = superName.substring(prefixLen);
            DependentTarget superclass = this.getPackage().getDependentTarget(superName);
            if (superclass != null) {
                this.getPackage().addDependency(new ExtendsDependency(this.getPackage(), this, superclass));
                if (superclass.getState() != DependentTarget.State.COMPILED) {
                    this.markModified();
                }
            }
        }
    }

    private void addInterface(String interfaceName) {
        String pkgPrefix = this.getPackage().getQualifiedName();
        if (interfaceName.startsWith(pkgPrefix)) {
            int dotlen = pkgPrefix.length();
            dotlen = dotlen == 0 ? 0 : dotlen + 1;
            interfaceName = interfaceName.substring(dotlen);
            DependentTarget interfce = this.getPackage().getDependentTarget(interfaceName);
            if (interfce != null) {
                this.getPackage().addDependency(new ImplementsDependency(this.getPackage(), this, interfce));
                if (interfce.getState() != DependentTarget.State.COMPILED) {
                    this.markModified();
                }
            }
        }
    }

    private boolean doClassNameChange(String newName) {
        if (this.getPackage().getTarget(newName) != null) {
            this.getPackage().showError("duplicate-name");
            return false;
        }
        File oldJavaSourceFile = this.getJavaSourceFile();
        File newJavaSourceFile = new File(this.getPackage().getPath(), newName + "." + SourceType.Java.toString().toLowerCase());
        try {
            BDependency bDependency;
            String filename;
            File oldFrameSourceFile = null;
            File newFrameSourceFile = null;
            this.getPackage().updateTargetIdentifier(this, this.getIdentifierName(), newName);
            if (this.getSourceType().equals((Object)SourceType.Stride)) {
                newFrameSourceFile = new File(this.getPackage().getPath(), newName + "." + SourceType.Stride.toString().toLowerCase());
                oldFrameSourceFile = this.getFrameSourceFile();
                FileUtility.copyFile(oldFrameSourceFile, newFrameSourceFile);
                filename = newFrameSourceFile.getAbsolutePath();
            } else {
                filename = newJavaSourceFile.getAbsolutePath();
            }
            FileUtility.copyFile(oldJavaSourceFile, newJavaSourceFile);
            String javaFilename = newJavaSourceFile.getAbsolutePath();
            String docFilename = this.getPackage().getProject().getDocumentationFile(javaFilename);
            this.getEditor().changeName(newName, filename, javaFilename, docFilename);
            this.deleteSourceFiles();
            this.getClassFile().delete();
            this.getContextFile().delete();
            this.getDocumentationFile().delete();
            String oldName = this.getIdentifierName();
            this.setIdentifierName(newName);
            this.setDisplayName(newName);
            this.updateSize();
            BClass bClass = this.getBClass();
            ExtensionBridge.ChangeBClassName((BClass)bClass, (String)this.getQualifiedName());
            BClassTarget bClassTarget = this.getBClassTarget();
            ExtensionBridge.changeBClassTargetName((BClassTarget)bClassTarget, (String)this.getQualifiedName());
            for (Dependency outgoingDependency : this.dependencies()) {
                bDependency = outgoingDependency.getBDependency();
                ExtensionBridge.changeBDependencyOriginName((BDependency)bDependency, (String)this.getQualifiedName());
            }
            for (Dependency incomingDependency : this.dependents()) {
                bDependency = incomingDependency.getBDependency();
                ExtensionBridge.changeBDependencyTargetName((BDependency)bDependency, (String)this.getQualifiedName());
            }
            DataCollector.renamedClass(this.getPackage(), oldFrameSourceFile, newFrameSourceFile, oldJavaSourceFile, newJavaSourceFile);
            ClassEvent event = new ClassEvent(1, this.getPackage(), this.getBClass(), oldName);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private void deleteSourceFiles() {
        if (this.getSourceType().equals((Object)SourceType.Stride)) {
            this.getJavaSourceFile().delete();
        }
        this.getSourceFile().delete();
    }

    private boolean nameEqualsIgnoreCase(String newName) {
        return this.getBaseName().equalsIgnoreCase(newName);
    }

    private void doPackageNameChange(String newName) {
        boolean packageNameClash;
        Project proj = this.getPackage().getProject();
        Package dstPkg = proj.getPackage(newName);
        boolean packageInvalid = dstPkg == null;
        boolean bl = packageNameClash = dstPkg != null && dstPkg.getTarget(this.getBaseName()) != null;
        if (packageInvalid) {
            DialogManager.showErrorFX(null, "package-name-invalid");
        } else if (packageNameClash) {
            DialogManager.showErrorFX(null, "package-name-clash");
        } else if (DialogManager.askQuestionFX(null, "package-name-changed") == 0) {
            dstPkg.importFile(this.getSourceFile());
            this.prepareForRemoval();
            this.getPackage().removeTarget(this);
            this.close();
            return;
        }
        try {
            this.enforcePackage(this.getPackage().getQualifiedName());
            this.getEditor().reloadFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @OnThread(value=Tag.Any)
    private void updateSize() {
        Platform.runLater(() -> {
            String displayName = this.getDisplayName();
            int width = ClassTarget.calculateWidth((Labeled)this.nameLabel, displayName);
            this.setSize(width, this.getHeight());
            this.repaint();
        });
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void popupMenu(int x, int y, PackageEditor graphEditor) {
        Class<?> cl = null;
        if (this.getState() == DependentTarget.State.COMPILED && (cl = this.getPackage().loadClass(this.getQualifiedName())) == null && this.sourceAvailable != SourceType.NONE) {
            this.getClassFile().delete();
            this.invalidate();
        }
        if (this.getState() != DependentTarget.State.COMPILED) {
            cl = null;
        }
        Class<?> clFinal = cl;
        ClassRole roleFinal = this.role;
        SourceType sourceAvailableFinal = this.sourceAvailable;
        boolean docExists = this.getDocumentationFile().exists();
        SwingUtilities.invokeLater(() -> {
            ExtensionsManager extMgr = ExtensionsManager.getInstance();
            Platform.runLater(() -> this.withMenu(clFinal, roleFinal, sourceAvailableFinal, docExists, menu -> {
                this.showingMenu((ContextMenu)menu);
                menu.show((Node)this.pane, (double)x, (double)y);
            }, extMgr));
        });
    }

    @OnThread(value=Tag.FXPlatform)
    protected void withMenu(Class<?> cl, ClassRole roleRef, SourceType source, boolean docExists, FXPlatformConsumer<ContextMenu> withMenu, ExtensionsManager extMgr) {
        ContextMenu menu = new ContextMenu();
        roleRef.createRoleMenu((ObservableList<MenuItem>)menu.getItems(), this, cl, this.getState());
        if (cl != null) {
            if (Application.class.isAssignableFrom(cl)) {
                menu.getItems().add((Object)JavaFXUtil.withStyleClass(JavaFXUtil.makeMenuItem(launchFXStr, () -> {
                    PackageEditor ed = this.getPackage().getEditor();
                    Window fxWindow = ed.getFXWindow();
                    if (this.getPackage().getProject().getRunOnThread() == null) {
                        int result = DialogManager.askQuestionFX(fxWindow, "run-on-fx");
                        if (result == 0) {
                            this.getPackage().getProject().setRunOnThread(RunOnThread.FX);
                        } else {
                            this.getPackage().getProject().setRunOnThread(RunOnThread.DEFAULT);
                        }
                    }
                    CompletableFuture<FXPlatformSupplier<DebuggerResult>> result = this.getPackage().getDebugger().launchFXApp(cl.getName());
                    this.putFXLaunchResult(ed, fxWindow, result);
                }, null), MENU_STYLE_INBUILT));
            }
            if (roleRef.createClassConstructorMenu((ObservableList<MenuItem>)menu.getItems(), this, cl)) {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            if (roleRef.createClassStaticMenu((ObservableList<MenuItem>)menu.getItems(), this, source != SourceType.NONE, cl)) {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
        }
        boolean sourceOrDocExists = source != SourceType.NONE || docExists;
        menu.getItems().add((Object)new EditAction(sourceOrDocExists));
        menu.getItems().add((Object)new CompileAction(source != SourceType.NONE));
        menu.getItems().add((Object)new InspectAction(cl != null));
        menu.getItems().add((Object)new RemoveAction());
        if (source == SourceType.Stride) {
            menu.getItems().add((Object)new ConvertToJavaAction());
        } else if (source == SourceType.Java && roleRef.canConvertToStride()) {
            menu.getItems().add((Object)new ConvertToStrideAction());
        }
        roleRef.createRoleMenuEnd((ObservableList<MenuItem>)menu.getItems(), this, this.getState());
        FXMenuManager menuManager = new FXMenuManager(menu, extMgr, (ExtensionMenu)new ClassExtensionMenu(this));
        SwingUtilities.invokeLater(() -> {
            menuManager.addExtensionMenu(this.getPackage().getProject());
            Platform.runLater(() -> withMenu.accept(menu));
        });
    }

    private void putFXLaunchResult(final PackageEditor ed, final Window fxWindow, CompletableFuture<FXPlatformSupplier<DebuggerResult>> result) {
        result.thenAccept((Consumer)new Consumer<FXPlatformSupplier<DebuggerResult>>(){

            @Override
            @OnThread(value=Tag.Worker)
            public void accept(FXPlatformSupplier<DebuggerResult> supplier) {
                Platform.runLater(() -> {
                    DebuggerResult r = (DebuggerResult)supplier.get();
                    switch (r.getExitStatus()) {
                        case 0: {
                            DebuggerObject obj = r.getResultObject();
                            ed.raisePutOnBenchEvent(fxWindow, obj, obj.getGenType(), null, false, Optional.empty());
                        }
                    }
                });
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    public void promptAndConvertJavaToStride() {
        File javaSourceFile = this.getJavaSourceFile();
        Charset projectCharset = this.getPackage().getProject().getProjectCharset();
        Stage window = null;
        if (this.pane.getScene() != null) {
            window = (Stage)this.pane.getScene().getWindow();
        }
        if (JavaFXUtil.confirmDialog("convert.to.stride.title", "convert.to.stride.message", window, true)) {
            try {
                List<CodeElement> elements;
                Parser.ConversionResult javaConvertResult = Parser.javaToStride(Files.readAllLines(javaSourceFile.toPath(), projectCharset).stream().collect(Collectors.joining("\n")), Parser.JavaContext.TOP_LEVEL, false);
                if (!javaConvertResult.getWarnings().isEmpty()) {
                    new ConvertResultDialog(javaConvertResult.getWarnings().stream().map(ConversionWarning::getMessage).collect(Collectors.toList())).showAndWait();
                }
                if ((elements = javaConvertResult.getElements()).size() != 1 || !(elements.get(0) instanceof TopLevelCodeElement)) {
                    JavaFXUtil.errorDialog("convert.to.stride.error.title", "convert.to.stride.error.message");
                    return;
                }
                this.addStride((TopLevelCodeElement)((Object)elements.get(0)));
                DataCollector.convertJavaToStride(this.getPackage(), javaSourceFile, this.getFrameSourceFile());
            }
            catch (ParseFailure | IOException pf) {
                Debug.reportError(pf);
                new ConvertResultDialog(pf.getMessage()).showAndWait();
            }
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void doubleClick() {
        this.open();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setSize(int width, int height) {
        int w = Math.max(width, 60);
        int h = Math.max(height, 30);
        super.setSize(w, h);
        if (this.assoc != null) {
            this.assoc.setSize(w, h);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void setVisible(boolean vis) {
        if (vis != this.visible) {
            this.visible = vis;
            this.pane.setVisible(vis);
            SwingUtilities.invokeLater(() -> {
                ClassTargetEvent event = new ClassTargetEvent(this, this.getPackage(), vis);
                ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
            });
        }
    }

    @Override
    @OnThread(value=Tag.FX)
    protected void redraw() {
        GraphicsContext g = this.canvas.getGraphicsContext2D();
        double width = this.canvas.getWidth();
        double height = this.canvas.getHeight();
        g.clearRect(0.0, 0.0, width, height);
        if (this.getState() != DependentTarget.State.COMPILED) {
            if (this.hasKnownError()) {
                int size = 160;
                if (redStripeImage == null) {
                    redStripeImage = JavaFXUtil.createImage(size, size, gImage -> {
                        JavaFXUtil.stripeRect(gImage, 0, 0, size, size, 13, 3, false, RED_STRIPE);
                        JavaFXUtil.stripeRect(gImage, 0, 0, size, size, 13, 3, true, RED_STRIPE);
                    });
                }
                g.setFill((Paint)new ImagePattern(redStripeImage, 0.0, 0.0, (double)size, (double)size, false));
                g.fillRect(0.0, 0.0, width, height);
            } else {
                int size = 120;
                if (greyStripeImage == null) {
                    greyStripeImage = JavaFXUtil.createImage(size, size, gImage -> JavaFXUtil.stripeRect(gImage, 0, 0, size, size, 9, 3, false, GREY_STRIPE));
                }
                g.setFill((Paint)new ImagePattern(greyStripeImage, 0.0, 0.0, (double)size, (double)size, false));
                g.fillRect(0.0, 0.0, width, height);
            }
        }
        if (this.selected && this.isResizable()) {
            g.setStroke((Paint)Color.BLACK);
            g.setLineDashes(new double[0]);
            g.setLineWidth(1.0);
            g.strokeLine(width - 16.0, height, width, height - 16.0);
            g.strokeLine(width - 16.0 + 4.0, height, width, height - 16.0 + 4.0);
        }
    }

    private void prepareForRemoval() {
        if (this.editor != null) {
            this.editor.close();
        }
        for (Target o : this.getPackage().getVertices()) {
            DependentTarget d;
            if (!(o instanceof DependentTarget) || !this.equals((d = (DependentTarget)o).getAssociation())) continue;
            d.setAssociation(null);
        }
        this.invalidate();
        this.removeAllInDependencies();
        this.removeAllOutDependencies();
        this.prepareFilesForRemoval();
    }

    public void prepareFilesForRemoval() {
        List<File> allFiles = this.getRole().getAllFiles(this);
        Iterator<File> i = allFiles.iterator();
        while (i.hasNext()) {
            i.next().delete();
        }
    }

    public void generateDoc() {
        this.getPackage().generateDocumentation(this);
    }

    @Override
    public void remove() {
        File frameSourceFile = this.getSourceType().equals((Object)SourceType.Stride) ? this.getFrameSourceFile() : null;
        File javaSourceFile = this.getJavaSourceFile();
        this.prepareForRemoval();
        Package pkg = this.getPackage();
        pkg.removeTarget(this);
        DataCollector.removeClass(pkg, frameSourceFile, javaSourceFile);
        if (Config.isGreenfoot()) {
            pkg.rebuild();
        }
    }

    public void convertStrideToJava() {
        File srcFile;
        if (this.sourceAvailable != SourceType.Stride) {
            throw new IllegalStateException("Cannot convert non-Stride from Stride to Java");
        }
        if (this.editor != null) {
            this.editor.close();
            try {
                this.editor.saveJavaWithoutWarning();
            }
            catch (IOException e) {
                Debug.reportError(e);
            }
            this.editor = null;
        }
        if ((srcFile = this.getSourceFile()).exists()) {
            srcFile.delete();
        }
        this.sourceAvailable = SourceType.Java;
        DataCollector.convertStrideToJava(this.getPackage(), srcFile, this.getSourceFile());
    }

    private void addStride(TopLevelCodeElement element) {
        if (this.editor != null) {
            this.editor.close();
            this.editor = null;
        }
        File strideFile = this.getFrameSourceFile();
        try {
            Files.write(strideFile.toPath(), Arrays.asList(Utility.splitLines(Utility.serialiseCodeToString(element.toXML()))), Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            Debug.reportError(e);
            JavaFXUtil.errorDialog(Config.getString("convert.to.stride.title"), e.getMessage());
            return;
        }
        this.sourceAvailable = SourceType.Stride;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isMoveable() {
        return this.isMoveable;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setIsMoveable(boolean isMoveable) {
        this.isMoveable = isMoveable;
    }

    @Override
    public void executeMethod(MethodView mv) {
        this.getPackage().getEditor().raiseMethodCallEvent(this, mv);
    }

    @Override
    public void callConstructor(ConstructorView cv) {
        this.getPackage().getEditor().raiseMethodCallEvent(this, cv);
    }

    private boolean checkDebuggerState() {
        return PkgMgrFrame.createFrame(this.getPackage(), null).checkDebuggerState();
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean isNaviviewExpanded() {
        return this.isNaviviewExpanded.orElse(false);
    }

    public void setNaviviewExpanded(boolean isNaviviewExpanded) {
        this.isNaviviewExpanded = Optional.of(isNaviviewExpanded);
    }

    @OnThread(value=Tag.FXPlatform)
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void recordJavaEdit(String latest, boolean includeOneLineEdits) {
        DataCollector.editJava(this.getPackage(), this.getJavaSourceFile(), latest, includeOneLineEdits);
    }

    public void recordStrideEdit(String latestJava, String latestStride, StrideEditReason reason) {
        DataCollector.editStride(this.getPackage(), this.getJavaSourceFile(), latestJava, this.getFrameSourceFile(), latestStride, reason);
    }

    private File getGeneratedFrom(SourceType recordForSourceType) {
        if (recordForSourceType == SourceType.Java && this.sourceAvailable == SourceType.Stride) {
            return this.getFrameSourceFile();
        }
        return null;
    }

    public void recordClose() {
        DataCollector.closeClass(this.getPackage(), this.getSourceFile());
        this.recordedAsOpen = false;
    }

    public void recordOpen() {
        if (!this.recordedAsOpen) {
            DataCollector.openClass(this.getPackage(), this.getSourceFile());
            this.recordedAsOpen = true;
        }
    }

    public void recordSelected() {
        DataCollector.selectClass(this.getPackage(), this.getSourceFile());
    }

    public CompileInputFile getCompileInputFile() {
        return new CompileInputFile(this.getJavaSourceFile(), this.getSourceFile());
    }

    public void markKnownError(boolean classesKept) {
        if (this.editor != null) {
            this.editor.compileFinished(false, classesKept);
        }
        this.setState(DependentTarget.State.HAS_ERROR);
    }

    @OnThread(value=Tag.Any)
    public boolean hasKnownError() {
        return this.getState() == DependentTarget.State.HAS_ERROR;
    }

    public void recordShowErrorMessage(int identifier, List<String> quickFixes) {
        DataCollector.showErrorMessage(this.getPackage(), identifier, quickFixes);
    }

    public void recordShowErrorIndicators(Collection<Integer> identifiers) {
        DataCollector.showErrorIndicators(this.getPackage(), identifiers);
    }

    public void recordEarlyErrors(List<DiagnosticWithShown> diagnostics, int compilationIdentifier) {
        if (diagnostics.isEmpty()) {
            return;
        }
        DataCollector.compiled(this.getPackage().getProject(), this.getPackage(), new CompileInputFile[]{this.getCompileInputFile()}, diagnostics, false, CompileReason.EARLY, compilationIdentifier);
    }

    public void recordLateErrors(List<DiagnosticWithShown> diagnostics, int compilationIdentifier) {
        if (diagnostics.isEmpty()) {
            return;
        }
        DataCollector.compiled(this.getPackage().getProject(), this.getPackage(), new CompileInputFile[]{this.getCompileInputFile()}, diagnostics, false, CompileReason.LATE, compilationIdentifier);
    }

    public void recordFix(int errorIdentifier, int fixIndex) {
        DataCollector.fixExecuted(this.getPackage(), errorIdentifier, fixIndex);
    }

    public void recordCodeCompletionStarted(Integer lineNumber, Integer columnNumber, String xpath, Integer subIndex, String stem, int codeCompletionId) {
        DataCollector.codeCompletionStarted(this, lineNumber, columnNumber, xpath, subIndex, stem, codeCompletionId);
    }

    public void recordCodeCompletionEnded(Integer lineNumber, Integer columnNumber, String xpath, Integer elementOffset, String stem, String replacement, int codeCompletionId) {
        DataCollector.codeCompletionEnded(this, lineNumber, columnNumber, xpath, elementOffset, stem, replacement, codeCompletionId);
    }

    public void recordUnknownCommandKey(String enclosingFrameXpath, int cursorIndex, char key) {
        DataCollector.unknownFrameCommandKey(this, enclosingFrameXpath, cursorIndex, key);
    }

    public void recordShowHideFrameCatalogue(String enclosingFrameXpath, int cursorIndex, boolean show, FrameCatalogue.ShowReason reason) {
        DataCollector.showHideFrameCatalogue(this.getPackage().getProject(), this.getPackage(), enclosingFrameXpath, cursorIndex, show, reason);
    }

    public void recordViewModeChange(String enclosingFrameXpath, int cursorIndex, Frame.View oldView, Frame.View newView, Frame.ViewChangeReason reason) {
        DataCollector.viewModeChange(this.getPackage(), this.getSourceFile(), enclosingFrameXpath, cursorIndex, oldView, newView, reason);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isFront() {
        return this.isFront;
    }

    public void showingInterface(boolean showing) {
        this.showingInterface = showing;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setCreatingExtends(boolean drawingExtends) {
        this.drawingExtends = drawingExtends;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean cursorAtResizeCorner(MouseEvent e) {
        return super.cursorAtResizeCorner(e) && !this.drawingExtends;
    }

    @Override
    public void setDisplayName(String name) {
        super.setDisplayName(name);
        String newDisplayName = this.getDisplayName();
        this.nameLabel.setText(newDisplayName);
    }

    static {
        RED_STRIPE = Color.rgb((int)170, (int)80, (int)60);
        GREY_STRIPE = Color.rgb((int)158, (int)139, (int)116);
    }

    @OnThread(value=Tag.FXPlatform)
    public class ConvertToStrideAction
    extends MenuItem {
        public ConvertToStrideAction() {
            super(convertToStrideStr);
            this.setOnAction(e -> ClassTarget.this.promptAndConvertJavaToStride());
            JavaFXUtil.addStyleClass((Styleable)this, ClassTarget.MENU_STYLE_INBUILT);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class ConvertToJavaAction
    extends MenuItem {
        public ConvertToJavaAction() {
            super(convertToJavaStr);
            this.setOnAction(this::actionPerformed);
            JavaFXUtil.addStyleClass((Styleable)this, ClassTarget.MENU_STYLE_INBUILT);
        }

        private void actionPerformed(ActionEvent e) {
            if (JavaFXUtil.confirmDialog("convert.to.java.title", "convert.to.java.message", (Stage)ClassTarget.this.pane.getScene().getWindow(), true)) {
                ClassTarget.this.convertStrideToJava();
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class InspectAction
    extends MenuItem {
        public InspectAction(boolean enable) {
            super(inspectStr);
            this.setOnAction(e -> this.actionPerformed((ActionEvent)e));
            this.setDisable(!enable);
            JavaFXUtil.addStyleClass((Styleable)this, ClassTarget.MENU_STYLE_INBUILT);
        }

        @OnThread(value=Tag.FXPlatform)
        private void actionPerformed(ActionEvent e) {
            if (ClassTarget.this.checkDebuggerState()) {
                ClassTarget.this.inspect();
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class RemoveAction
    extends MenuItem {
        public RemoveAction() {
            super(removeStr);
            this.setOnAction(e -> this.actionPerformed((ActionEvent)e));
            JavaFXUtil.addStyleClass((Styleable)this, ClassTarget.MENU_STYLE_INBUILT);
        }

        @OnThread(value=Tag.FXPlatform)
        private void actionPerformed(ActionEvent e) {
            PkgMgrFrame pmf = PkgMgrFrame.findFrame(ClassTarget.this.getPackage());
            if (pmf.askRemoveClass()) {
                ClassTarget.this.getPackage().getEditor().raiseRemoveTargetEvent(ClassTarget.this);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class CompileAction
    extends MenuItem {
        public CompileAction(boolean enable) {
            super(compileStr);
            this.setOnAction(e -> ClassTarget.this.getPackage().compile(ClassTarget.this, CompileReason.USER, CompileType.EXPLICIT_USER_COMPILE));
            this.setDisable(!enable);
            JavaFXUtil.addStyleClass((Styleable)this, ClassTarget.MENU_STYLE_INBUILT);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class EditAction
    extends MenuItem {
        public EditAction(boolean enable) {
            super(editStr);
            this.setOnAction(e -> ClassTarget.this.open());
            this.setDisable(!enable);
            JavaFXUtil.addStyleClass((Styleable)this, ClassTarget.MENU_STYLE_INBUILT);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public class CreateTestAction
    extends MenuItem {
        public CreateTestAction() {
            super(createTestStr);
            this.setOnAction(e -> this.actionPerformed((ActionEvent)e));
            JavaFXUtil.addStyleClass((Styleable)this, ClassTarget.MENU_STYLE_INBUILT);
        }

        @OnThread(value=Tag.FXPlatform)
        private void actionPerformed(ActionEvent e) {
            PkgMgrFrame pmf = PkgMgrFrame.findFrame(ClassTarget.this.getPackage());
            if (pmf != null) {
                ClassTarget ct;
                String testClassName = ClassTarget.this.getIdentifierName() + "Test";
                pmf.createNewClass(testClassName, "unittest", SourceType.Java, true, -1.0, -1.0);
                Target target = ClassTarget.this.getPackage().getTarget(testClassName);
                DependentTarget assoc = null;
                if (target instanceof ClassTarget && (ct = (ClassTarget)target) != null && ct.isUnitTest()) {
                    assoc = (DependentTarget)ClassTarget.this.getPackage().getTarget(ClassTarget.this.getIdentifierName() + "Test");
                }
                DependentTarget assocFinal = assoc;
                PackageEditor pkgEd = ClassTarget.this.getPackage().getEditor();
                if (assocFinal != null) {
                    ClassTarget.this.setAssociation(assocFinal);
                }
                ClassTarget.this.updateAssociatePosition();
                pkgEd.repaint();
            }
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    class InnerClassFileFilter
    implements FileFilter {
        InnerClassFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().startsWith(ClassTarget.this.getBaseName() + "$");
        }
    }

    public static class SourceFileInfo {
        public final File file;
        public final SourceType sourceType;

        public SourceFileInfo(File file, SourceType sourceType) {
            this.file = file;
            this.sourceType = sourceType;
        }
    }
}

