/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.dependency;

import bluej.Config;
import bluej.extensions.BDependency;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.event.DependencyEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.Target;
import java.util.Properties;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public abstract class Dependency {
    public final @OnThread(value=Tag.Any) Target from;
    public final @OnThread(value=Tag.Any) Target to;
    private @OnThread(value=Tag.Any) boolean visible = true;
    Package pkg;
    private static final String removeStr = Config.getString("pkgmgr.classmenu.remove");
    protected boolean selected = false;
    private @OnThread(value=Tag.Swing) BDependency singleBDependency;
    static final int SELECT_DIST = 4;

    @OnThread(value=Tag.Any)
    public Dependency(Package pkg, DependentTarget from, DependentTarget to) {
        this.from = from;
        this.to = to;
        this.pkg = pkg;
    }

    @OnThread(value=Tag.Any)
    public Dependency(Package pkg) {
        this(pkg, (DependentTarget)null, null);
    }

    @OnThread(value=Tag.Any)
    public boolean equals(Object other) {
        if (!(other instanceof Dependency)) {
            return false;
        }
        Dependency d = (Dependency)other;
        return d != null && d.from == this.from && d.to == this.to;
    }

    @OnThread(value=Tag.Any)
    public int hashCode() {
        return this.to.hashCode() - this.from.hashCode();
    }

    @OnThread(value=Tag.Any)
    public DependentTarget getFrom() {
        return (DependentTarget)this.from;
    }

    @OnThread(value=Tag.Any)
    public DependentTarget getTo() {
        return (DependentTarget)this.to;
    }

    @OnThread(value=Tag.SwingIsFX)
    public BDependency getBDependency() {
        if (this.singleBDependency == null) {
            this.singleBDependency = ExtensionBridge.newBDependency((Dependency)this, (BDependency.Type)this.getType());
        }
        return this.singleBDependency;
    }

    @OnThread(value=Tag.Any)
    public abstract BDependency.Type getType();

    @OnThread(value=Tag.Any)
    public Dependency(Package pkg, Properties props, String prefix) throws DependencyNotFoundException {
        this.pkg = pkg;
        String fromName = props.getProperty(prefix + ".from");
        if (fromName == null) {
            throw new DependencyNotFoundException("No 'from' target specified for dependency " + prefix);
        }
        this.from = pkg.getTarget(fromName);
        if (!(this.from instanceof DependentTarget)) {
            throw new DependencyNotFoundException("Failed to find 'from' target " + fromName);
        }
        String toName = props.getProperty(prefix + ".to");
        if (toName == null) {
            throw new DependencyNotFoundException("No 'to' target specified for dependency " + prefix);
        }
        this.to = pkg.getTarget(toName);
        if (!(this.to instanceof DependentTarget)) {
            throw new DependencyNotFoundException("Failed to find 'to' target " + toName);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, String prefix) {
        props.put(prefix + ".from", ((DependentTarget)this.from).getIdentifierName());
        props.put(prefix + ".to", ((DependentTarget)this.to).getIdentifierName());
    }

    public abstract void remove();

    public String toString() {
        return this.getFrom().getIdentifierName() + " --> " + this.getTo().getIdentifierName();
    }

    @OnThread(value=Tag.Any)
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean vis) {
        if (vis != this.visible) {
            this.visible = vis;
            this.pkg.repaint();
            SwingUtilities.invokeLater(() -> {
                DependencyEvent event = new DependencyEvent(this, this.getFrom().getPackage(), vis);
                ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
            });
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.pkg.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean contains(int x, int y) {
        Line line = this.computeLine();
        Rectangle2D bounds = this.getBoxFromLine(line);
        if (!bounds.contains((double)x, (double)y)) {
            return false;
        }
        double theta = Math.atan2(-(line.from.getY() - (double)y), line.from.getX() - (double)x);
        double norm = Dependency.normDist(line.from.getX(), line.from.getY(), x, y, Math.sin(line.angle - theta));
        return norm < 16.0;
    }

    static final double normDist(double ax, double ay, double bx, double by, double scale) {
        return ((ax - bx) * (ax - bx) + (ay - by) * (ay - by)) * scale * scale;
    }

    protected Rectangle2D getBoxFromLine(Line line) {
        double x = Math.min(line.from.getX(), line.to.getX()) - 4.0;
        double y = Math.min(line.from.getY(), line.to.getY()) - 4.0;
        double width = Math.max(line.from.getX(), line.to.getX()) - x + 8.0;
        double height = Math.max(line.from.getY(), line.to.getY()) - y + 8.0;
        return new Rectangle2D(x, y, width, height);
    }

    public Line computeLine() {
        Point2D pFrom = new Point2D((double)(this.from.getX() + this.from.getWidth() / 2), (double)(this.from.getY() + this.from.getHeight() / 2));
        Point2D pTo = new Point2D((double)(this.to.getX() + this.to.getWidth() / 2), (double)(this.to.getY() + this.to.getHeight() / 2));
        double angle = Math.atan2(-(pFrom.getY() - pTo.getY()), pFrom.getX() - pTo.getX());
        pFrom = ((DependentTarget)this.from).getAttachment(angle + Math.PI);
        pTo = ((DependentTarget)this.to).getAttachment(angle);
        return new Line(pFrom, pTo, angle);
    }

    public abstract boolean isRemovable();

    @OnThread(value=Tag.Any)
    public static class DependencyNotFoundException
    extends Exception {
        public DependencyNotFoundException(String s) {
            super(s);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static class Line {
        public Point2D from;
        public Point2D to;
        double angle;

        public Line(Point2D from, Point2D to, double angle) {
            this.from = from;
            this.to = to;
            this.angle = angle;
        }
    }
}

