/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.actions;

import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.actions.PkgMgrAction;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.io.File;
import javafx.stage.Window;

public final class SaveProjectAsAction
extends PkgMgrAction {
    public SaveProjectAsAction(PkgMgrFrame pmf) {
        super(pmf, "menu.package.saveAs");
    }

    @Override
    public void actionPerformed(PkgMgrFrame pmf) {
        pmf.menuCall();
        this.saveAs(pmf, pmf.getProject());
    }

    public void saveAs(PkgMgrFrame frame, Project project) {
        File newName = FileUtility.getSaveProjectFX((Window)frame.getFXWindow(), Config.getString("pkgmgr.saveAs.title"));
        if (newName != null) {
            project.saveAll();
            int result = FileUtility.copyDirectory(project.getProjectDir(), newName);
            switch (result) {
                case 0: {
                    break;
                }
                case 4: {
                    DialogManager.showErrorFX((Window)frame.getFXWindow(), "directory-exists-file");
                    return;
                }
                case 5: {
                    DialogManager.showErrorFX((Window)frame.getFXWindow(), "directory-exists-non-empty");
                    return;
                }
                case 2: 
                case 3: {
                    DialogManager.showErrorFX((Window)frame.getFXWindow(), "cannot-save-project");
                    return;
                }
            }
            PkgMgrFrame.closeProject(project);
            Project openProj = Project.openProject(newName.getAbsolutePath());
            if (openProj != null) {
                Package pkg = openProj.getPackage("");
                PkgMgrFrame pmf = PkgMgrFrame.createFrame(pkg, null);
                pmf.setVisible(true);
            } else {
                Debug.message("Save as: could not open package under new name");
            }
        }
    }
}

