/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.extensions.SourceType;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.javafx.HorizontalRadio;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.dialog.DialogPaneAnimateError;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javafx.application.Platform;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
class NewClassDialog
extends Dialog<NewClassInfo> {
    private final ToggleGroup templateButtons;
    private final Map<RadioButton, TemplateInfo> templates = new IdentityHashMap<RadioButton, TemplateInfo>();
    private final HorizontalRadio<SourceType> language;
    private static List<String> windowsRestrictedWords;
    private final TextField nameField;
    private final DialogPaneAnimateError dialogPane;
    private boolean fieldHasHadContent = false;
    private final Label errorLabel;

    public NewClassDialog(Window parent, SourceType defaultSourceType) {
        this.setTitle(Config.getString("pkgmgr.newClass.title"));
        this.initOwner(parent);
        this.initModality(Modality.WINDOW_MODAL);
        this.errorLabel = JavaFXUtil.withStyleClass(new Label(), "dialog-error-label");
        this.dialogPane = new DialogPaneAnimateError(this.errorLabel, () -> this.updateOKButton(true));
        this.setDialogPane(this.dialogPane);
        Config.addDialogStylesheets(this.getDialogPane());
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        VBox mainPanel = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPanel, "new-class-dialog");
        this.nameField = new TextField();
        this.nameField.setPromptText(Config.getString("pkgmgr.newClass.prompt"));
        JavaFXUtil.addChangeListenerPlatform(this.nameField.textProperty(), s -> {
            this.hideError();
            this.updateOKButton(false);
        });
        HBox nameBox = new HBox(new Node[]{new Label(Config.getString("pkgmgr.newClass.label")), this.nameField});
        JavaFXUtil.addStyleClass((Styleable)nameBox, "new-class-dialog-hbox");
        nameBox.setAlignment(Pos.BASELINE_LEFT);
        mainPanel.getChildren().add((Object)nameBox);
        this.language = new HorizontalRadio<SourceType>(Arrays.asList(SourceType.Java, SourceType.Stride));
        this.language.select(defaultSourceType);
        HBox langBox = new HBox();
        JavaFXUtil.addStyleClass((Styleable)langBox, "new-class-dialog-hbox");
        langBox.getChildren().add((Object)new Label(Config.getString("pkgmgr.newClass.lang")));
        langBox.getChildren().addAll((Object[])new Node[]{this.language.getButtons()});
        langBox.setAlignment(Pos.BASELINE_LEFT);
        mainPanel.getChildren().add((Object)langBox);
        mainPanel.getChildren().add((Object)new Label(Config.getString("pkgmgr.newClass.classType")));
        this.templateButtons = new ToggleGroup();
        this.addClassTypeButtons(parent, (Pane)mainPanel);
        mainPanel.getChildren().add((Object)this.errorLabel);
        JavaFXUtil.addChangeListenerPlatform(this.templateButtons.selectedToggleProperty(), toggle -> {
            this.hideError();
            this.updateOKButton(false);
        });
        JavaFXUtil.addChangeListenerPlatform(this.language.selectedProperty(), language -> {
            this.hideError();
            this.updateOKButton(false);
        });
        this.getDialogPane().setContent((Node)mainPanel);
        this.setResultConverter(buttonType -> {
            if (buttonType == ButtonType.OK) {
                return new NewClassInfo(this.nameField.getText().trim(), this.templates.get(this.templateButtons.getSelectedToggle()).name, (SourceType)this.language.selectedProperty().get());
            }
            return null;
        });
        this.updateOKButton(false);
        this.setOnShown(e -> Platform.runLater(() -> ((TextField)this.nameField).requestFocus()));
    }

    private void addClassTypeButtons(Window parent, Pane panel) {
        TemplatesList templates = new TemplatesList();
        this.addDEFsTemplates(templates, SourceType.Java);
        this.addDEFsTemplates(templates, SourceType.Stride);
        this.addDirectoryTemplates(templates, SourceType.Java, parent);
        boolean first = true;
        for (TemplateInfo template : templates.getTemplates()) {
            String label = Config.getString("pkgmgr.newClass." + template.name, template.name);
            RadioButton button = new RadioButton(label);
            if (first) {
                button.setSelected(true);
            }
            button.setToggleGroup(this.templateButtons);
            this.templates.put(button, template);
            panel.getChildren().add((Object)button);
            first = false;
        }
        JavaFXUtil.addChangeListenerPlatform(this.templateButtons.selectedToggleProperty(), selected -> this.updateOKButton(false));
    }

    private void addDEFsTemplates(TemplatesList templates, SourceType sourceType) {
        String templateString = Config.getPropString("bluej.classTemplates." + sourceType.toString().toLowerCase());
        StringTokenizer tokenizer = new StringTokenizer(templateString);
        while (tokenizer.hasMoreTokens()) {
            templates.addTemplate(tokenizer.nextToken(), sourceType);
        }
    }

    private void addDirectoryTemplates(TemplatesList templates, SourceType sourceType, Window parent) {
        File templateDir = Config.getClassTemplateDir();
        if (!templateDir.exists()) {
            DialogManager.showErrorFX(parent, "error-no-templates");
        } else {
            String templateSuffix = ".tmpl";
            int suffixLength = templateSuffix.length();
            Arrays.asList(templateDir.list()).forEach(file -> {
                if (file.endsWith(templateSuffix)) {
                    String templateName = file.substring(0, file.length() - suffixLength);
                    templates.addTemplate(templateName, sourceType);
                }
            });
        }
    }

    private void updateOKButton(boolean force) {
        String newClassName = this.nameField.getText().trim();
        this.fieldHasHadContent |= !newClassName.equals("");
        Toggle selectedToggle = this.templateButtons.getSelectedToggle();
        TemplateInfo info = this.templates.get(selectedToggle);
        boolean enable = false;
        SourceType sourceType = (SourceType)this.language.selectedProperty().get();
        Properties localProperties = new Properties();
        localProperties.put("LANGUAGE", sourceType.toString());
        if (info == null) {
            this.showError(Config.getString("pkgmgr.newClass.error.noType"), false);
        } else if (((RadioButton)selectedToggle).isDisabled() || !info.sourceTypes.contains(sourceType)) {
            this.showError(Config.getString("pkgmgr.newClass.error.typeNotAvailable", null, localProperties), false);
        } else if (!JavaNames.isIdentifier(newClassName)) {
            if (this.fieldHasHadContent || force) {
                this.showError(Config.getString("pkgmgr.newClass.error.notValidClassName", null, localProperties), true);
            }
        } else if (this.isWindowsRestrictedWord(newClassName)) {
            if (this.fieldHasHadContent || force) {
                this.showError(Config.getString("pkgmgr.newClass.error.windowsRestricted"), true);
            }
        } else {
            this.hideError();
            enable = true;
        }
        this.templates.forEach((radio, templateInfo) -> radio.setVisible(((TemplateInfo)templateInfo).sourceTypes.contains(this.language.selectedProperty().get())));
        this.setOKEnabled(enable);
    }

    private void hideError() {
        this.errorLabel.setText("");
        JavaFXUtil.setPseudoclass("bj-dialog-error", false, new Node[]{this.nameField});
    }

    private void showError(String error, boolean problemIsName) {
        this.errorLabel.setText(error);
        JavaFXUtil.setPseudoclass("bj-dialog-error", problemIsName, new Node[]{this.nameField});
    }

    private void setOKEnabled(boolean okEnabled) {
        this.dialogPane.getOKButton().setDisable(!okEnabled);
    }

    private boolean isWindowsRestrictedWord(String fileName) {
        this.initialiseRestrictedWordList();
        return windowsRestrictedWords.contains(fileName.toUpperCase());
    }

    private void initialiseRestrictedWordList() {
        if (windowsRestrictedWords == null) {
            windowsRestrictedWords = Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");
        }
    }

    @OnThread(value=Tag.Any)
    private static class TemplatesList {
        private final List<TemplateInfo> templates = new ArrayList<TemplateInfo>();

        private TemplatesList() {
        }

        public void addTemplate(String name, SourceType sourceType) {
            TemplateInfo template = this.templates.stream().filter(t -> ((TemplateInfo)t).name.equals(name)).findFirst().orElse(null);
            if (template != null) {
                template.sourceTypes.add(sourceType);
            } else {
                this.templates.add(new TemplateInfo(name, sourceType));
            }
        }

        public List<TemplateInfo> getTemplates() {
            return this.templates;
        }
    }

    @OnThread(value=Tag.Any)
    private static class TemplateInfo {
        private final String name;
        private final Set<SourceType> sourceTypes = new HashSet<SourceType>();

        public TemplateInfo(String name, SourceType sourceType) {
            this.name = name;
            this.sourceTypes.add(sourceType);
        }
    }

    @OnThread(value=Tag.Any)
    public static class NewClassInfo {
        public final String className;
        public final String templateName;
        public final SourceType sourceType;

        private NewClassInfo(String className, String templateName, SourceType sourceType) {
            this.templateName = templateName;
            this.className = className;
            this.sourceType = sourceType;
        }
    }
}

