/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.pkgmgr.PackageFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class GreenfootProjectFile
implements PackageFile {
    private static final String pkgfileName = "project.greenfoot";
    private File dir;
    private File pkgFile;

    @OnThread(value=Tag.Any)
    GreenfootProjectFile(File dir) {
        this.dir = dir;
        this.pkgFile = new File(dir, pkgfileName);
    }

    public String toString() {
        return this.dir.toString() + File.separator + pkgfileName;
    }

    @Override
    public void load(Properties p) throws IOException {
        try (FileInputStream input = null;){
            if (!this.pkgFile.canRead()) {
                throw new IOException("Can't read from project file: " + this.pkgFile);
            }
            input = new FileInputStream(this.pkgFile);
            p.load(input);
        }
    }

    @Override
    public void save(Properties props) throws IOException {
        if (!this.pkgFile.canWrite()) {
            throw new IOException("Greenfoot project file not writable: " + this);
        }
        try {
            Properties greenfootProps = new Properties();
            FileInputStream input = new FileInputStream(this.pkgFile);
            greenfootProps.load(input);
            greenfootProps.putAll((Map<?, ?>)props);
            props.putAll((Map<?, ?>)greenfootProps);
        }
        catch (IOException greenfootProps) {
            // empty catch block
        }
        try (FileOutputStream output = null;){
            output = new FileOutputStream(this.pkgFile);
            String header = "Greenfoot project file";
            props.store(output, header);
        }
    }

    public static boolean exists(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.getPath().endsWith(":\\")) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File packageFile = new File(dir, pkgfileName);
        return packageFile.exists();
    }

    public static boolean isProjectFileName(String fileName) {
        return fileName.endsWith(pkgfileName);
    }

    @Override
    public boolean create() throws IOException {
        File pkgFile = new File(this.dir, pkgfileName);
        if (pkgFile.exists()) {
            return false;
        }
        pkgFile.createNewFile();
        return true;
    }
}

