/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.extensions.SourceType;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class DocuGenerator {
    private static String docDirName = Config.getPropString("doctool.outputdir");
    private static final String projectLogHeader = Config.getPropString("Project documentation");
    private static String classLogHeader = Config.getPropString("Class documentation");
    private static String docCommand = Config.getJDKExecutablePath("doctool.command", "javadoc");
    private static String fixedJavadocParams = Config.getPropString("doctool.options");
    private static String tmpJavadocParams = " -noindex -notree -nohelp -nonavbar";
    private Project project;
    private File projectDir;
    private String projectDirPath;
    private File docDir;
    private String docDirPath;

    private static void generateDoc(String[] call, File result, File log, String header, boolean openBrowser) {
        DocuRunStarter starterThread = new DocuRunStarter(call, result, log, header, openBrowser);
        starterThread.setPriority(1);
        starterThread.start();
        BlueJEvent.raiseEvent(6, null);
    }

    public DocuGenerator(Project project) {
        this.project = project;
        this.projectDir = project.getProjectDir();
        this.projectDirPath = this.projectDir.getPath();
        this.docDir = new File(this.projectDir, docDirName);
        this.docDirPath = this.docDir.getPath();
    }

    public String generateProjectDocu() {
        String docDirStatus = this.testDocDir();
        if (!docDirStatus.equals("")) {
            return docDirStatus;
        }
        File startPage = new File(this.docDir, "index.html");
        File logFile = new File(this.docDir, "logfile.txt");
        if (DocuGenerator.documentationExists(logFile)) {
            int result = DialogManager.askQuestionFX(null, "show-or-generate");
            if (result == 0) {
                SwingUtilities.invokeLater(() -> Utility.openWebBrowser(startPage.getPath()));
                return "";
            }
            if (result == 2) {
                return "";
            }
        }
        ArrayList<String> call = new ArrayList<String>();
        call.add(docCommand);
        call.add("-sourcepath");
        call.add(this.projectDirPath);
        this.addGeneralOptions(call);
        call.add("-doctitle");
        call.add(this.project.getProjectName());
        call.add("-windowtitle");
        call.add(this.project.getProjectName());
        call.addAll(Utility.dequoteCommandLine(fixedJavadocParams));
        this.addLinkParam(call);
        List<String> packageNames = this.project.getPackageNames();
        for (String packageName : packageNames) {
            Package pack = this.project.getPackage(packageName);
            if (!FileUtility.containsFile(pack.getPath(), "." + SourceType.Java.toString().toLowerCase()) || packageName.length() <= 0) continue;
            call.add(packageName);
        }
        List<String> classNames = this.project.getPackage("").getAllClassnamesWithSource();
        String dirName = this.project.getProjectDir().getAbsolutePath();
        Iterator<String> names = classNames.iterator();
        while (names.hasNext()) {
            call.add(dirName + "/" + names.next() + "." + SourceType.Java.toString().toLowerCase());
        }
        String[] javadocCall = call.toArray(new String[0]);
        this.removeStylesheet();
        DocuGenerator.generateDoc(javadocCall, startPage, logFile, projectLogHeader, true);
        return "";
    }

    public void generateClassDocu(String filename) {
        String docDirStatus;
        if (this.docDir == null) {
            BlueJEvent.raiseEvent(8, null);
        }
        if (!(docDirStatus = this.testDocDir()).equals("")) {
            BlueJEvent.raiseEvent(8, null);
        }
        ArrayList<String> call = new ArrayList<String>();
        call.add(docCommand);
        call.addAll(Utility.dequoteCommandLine(fixedJavadocParams));
        call.addAll(Utility.dequoteCommandLine(tmpJavadocParams));
        this.addGeneralOptions(call);
        call.add(filename);
        String[] javadocCall = call.toArray(new String[0]);
        File htmlFile = new File(this.getDocuPath(filename));
        File logFile = new File(this.docDir, "logfile.txt");
        this.removeStylesheet();
        DocuGenerator.generateDoc(javadocCall, htmlFile, logFile, classLogHeader, false);
    }

    private void removeStylesheet() {
        File stylesheet = new File(this.projectDir, "doc/stylesheet.css");
        if (stylesheet.exists()) {
            stylesheet.delete();
        }
    }

    private void addGeneralOptions(List<String> call) {
        String majorVersion = System.getProperty("java.specification.version");
        call.add("-source");
        call.add(majorVersion);
        call.add("-classpath");
        call.add(this.project.getClassLoader().getClassPathAsString());
        call.add("-d");
        call.add(this.docDirPath);
        call.add("-encoding");
        call.add(this.project.getProjectCharset().name());
        call.add("-charset");
        call.add(this.project.getProjectCharset().name());
    }

    public String getDocuPath(String filename) {
        if (filename.startsWith(this.projectDirPath)) {
            filename = filename.substring(this.projectDirPath.length());
        }
        if (filename.endsWith("." + SourceType.Java.toString().toLowerCase())) {
            filename = filename.substring(0, filename.indexOf("." + SourceType.Java.toString().toLowerCase()));
        }
        return this.docDirPath + filename + ".html";
    }

    private String testDocDir() {
        if (this.docDir.exists()) {
            if (!this.docDir.isDirectory()) {
                return DialogManager.getMessage("docdir-blocked-by-file", new String[0]);
            }
        } else {
            try {
                if (!this.docDir.mkdir()) {
                    return DialogManager.getMessage("docdir-not-created", new String[0]);
                }
            }
            catch (SecurityException exc) {
                return DialogManager.getMessage("no-permission-for-docdir", new String[0]);
            }
        }
        return "";
    }

    @OnThread(value=Tag.Any)
    private static boolean documentationExists(File logFile) {
        if (!logFile.exists()) {
            return false;
        }
        try {
            BufferedReader logReader = new BufferedReader(new FileReader(logFile));
            String header = logReader.readLine();
            logReader.close();
            return header == null ? false : header.equals(projectLogHeader);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addLinkParam(List<String> params) {
        String linkToLib = Config.getPropString("doctool.linkToStandardLib");
        if (linkToLib.equals("true")) {
            String docURL = Config.getPropString("bluej.url.javaStdLib");
            if (docURL.endsWith("index.html")) {
                docURL = docURL.substring(0, docURL.length() - "index.html".length());
            }
            params.add("-link");
            params.add(docURL);
        }
    }

    private static class EchoThread
    extends Thread {
        private InputStream readStream;
        private OutputStream outStream;

        @OnThread(value=Tag.Any)
        public EchoThread(InputStream r, OutputStream out) {
            this.readStream = r;
            this.outStream = out;
        }

        @Override
        @OnThread(value=Tag.Unique, ignoreParent=true)
        public void run() {
            try {
                int n;
                byte[] buf = new byte[1024];
                while ((n = this.readStream.read(buf)) != -1) {
                    this.outStream.write(buf, 0, n);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class DocuRunStarter
    extends Thread {
        private String[] docuCall;
        private File showFile;
        private File logFile;
        private String logHeader;
        private boolean openBrowser;
        private static final Object mutex = new Object();

        public DocuRunStarter(String[] call, File result, File log, String header, boolean browse) {
            this.docuCall = call;
            this.showFile = result;
            this.logFile = log;
            this.logHeader = header;
            this.openBrowser = browse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @OnThread(value=Tag.Unique, ignoreParent=true)
        public void run() {
            int exitValue = -1;
            try (PrintWriter logWriter = null;){
                Object object = mutex;
                synchronized (object) {
                    FileOutputStream logStream = new FileOutputStream(this.logFile);
                    logWriter = new PrintWriter(logStream, true);
                    String[] docuCall2 = new String[this.docuCall.length - 1];
                    logWriter.println(this.logHeader);
                    logWriter.println("<---- javadoc command: ---->");
                    for (int i = 0; i < this.docuCall.length; ++i) {
                        logWriter.println(this.docuCall[i]);
                        if (i == 0) continue;
                        docuCall2[i - 1] = this.docuCall[i];
                    }
                    logWriter.println("<---- end of javadoc command ---->");
                    logWriter.flush();
                    Method executeMethod = null;
                    try {
                        Class<?> javadocClass = Class.forName("com.sun.tools.javadoc.Main");
                        executeMethod = javadocClass.getMethod("execute", String.class, PrintWriter.class, PrintWriter.class, PrintWriter.class, String.class, String[].class);
                    }
                    catch (ClassNotFoundException cnfe) {
                        cnfe.printStackTrace();
                    }
                    catch (NoSuchMethodException nsme) {
                        nsme.printStackTrace();
                    }
                    if (executeMethod != null) {
                        try {
                            Integer result = (Integer)executeMethod.invoke(null, "javadoc", logWriter, logWriter, logWriter, "com.sun.tools.doclets.standard.Standard", docuCall2);
                            exitValue = result;
                        }
                        catch (IllegalAccessException iae) {
                            executeMethod = null;
                        }
                        catch (InvocationTargetException ite) {
                            exitValue = -1;
                            ite.printStackTrace(logWriter);
                        }
                    }
                    if (executeMethod == null) {
                        Process docuRun = Runtime.getRuntime().exec(this.docuCall);
                        EchoThread outEcho = new EchoThread(docuRun.getInputStream(), logStream);
                        EchoThread errEcho = new EchoThread(docuRun.getErrorStream(), logStream);
                        outEcho.start();
                        errEcho.start();
                        try {
                            docuRun.waitFor();
                            outEcho.join();
                            errEcho.join();
                            exitValue = docuRun.exitValue();
                        }
                        catch (InterruptedException ie) {
                            logWriter.println("Interrupted while waiting for javadoc process to complete.");
                        }
                    }
                }
                final int finalExitValue = exitValue;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (finalExitValue == 0) {
                            BlueJEvent.raiseEvent(7, null);
                            if (!showFile.exists()) {
                                Debug.message("showfile does not exist - searching");
                                showFile = FileUtility.findFile(showFile.getParentFile(), showFile.getName());
                            }
                            if (openBrowser) {
                                SwingUtilities.invokeLater(() -> Utility.openWebBrowser(showFile.getPath()));
                            }
                        } else {
                            BlueJEvent.raiseEvent(8, null);
                            DialogManager.showMessageWithTextFX(null, "doctool-error", logFile.getPath());
                        }
                    }
                });
            }
        }

        private static /* synthetic */ void lambda$run$0() {
            DialogManager.showMessageFX(null, "severe-doc-trouble");
        }
    }
}

