/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import java.awt.Desktop;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
class AboutBlueJ
extends Dialog<Void> {
    private static final String BLUEJ_URL = "http://www.bluej.org/";

    public AboutBlueJ(Window parent, String version) {
        this.initOwner(parent);
        this.initModality(Modality.WINDOW_MODAL);
        this.setTitle(Config.getString("menu.help.about"));
        this.setDialogPane(new DialogPane(){

            @OnThread(value=Tag.FX)
            protected Node createButtonBar() {
                ButtonBar buttonBar = (ButtonBar)super.createButtonBar();
                buttonBar.setButtonOrder("_C_");
                return buttonBar;
            }
        });
        Config.addDialogStylesheets(this.getDialogPane());
        this.getDialogPane().getButtonTypes().add((Object)ButtonType.CLOSE);
        BorderPane aboutPanel = new BorderPane();
        this.getDialogPane().setContent((Node)aboutPanel);
        JavaFXUtil.addStyleClass((Styleable)aboutPanel, "about-dialog-content");
        Image image = Config.getFixedImageAsFXImage("about-logo.png");
        aboutPanel.setCenter((Node)JavaFXUtil.withStyleClass(new ImageView(image), "about-dialog-image"));
        VBox bottom = JavaFXUtil.withStyleClass(new VBox(), "about-more-info");
        String teamText = "";
        teamText = teamText + "Amjad Altadmri, ";
        teamText = teamText + "Neil Brown, ";
        teamText = teamText + "Hamza Hamza, ";
        teamText = teamText + "Michael K\u00f6lling, ";
        teamText = teamText + "Davin McCall, ";
        teamText = teamText + "Ian Utting";
        bottom.getChildren().add((Object)JavaFXUtil.withStyleClass(new Label(Config.getString("about.theTeam") + " " + teamText), "about-team"));
        bottom.getChildren().add((Object)JavaFXUtil.withStyleClass(new Label(Config.getString("about.bluej.version") + " " + version + "  (" + Config.getString("about.java.version") + " " + System.getProperty("java.version") + ")"), "about-version"));
        bottom.getChildren().add((Object)new Label(Config.getString("about.vm") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")"));
        bottom.getChildren().add((Object)new Label(Config.getString("about.runningOn") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")"));
        Button debugLogShow = new Button(Config.getString("about.openFolder"));
        debugLogShow.setOnAction(e -> SwingUtilities.invokeLater(() -> {
            try {
                if (!Config.isLinux() && Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().open(Config.getUserConfigDir());
                } else if (Config.isLinux()) {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", Config.getUserConfigDir().getAbsolutePath()});
                }
            }
            catch (IOException ex) {
                Debug.reportError(ex);
            }
        }));
        HBox debugLog = new HBox(new Node[]{new Label(Config.getString("about.logfile") + " " + Config.getUserConfigFile(Config.debugLogName)), debugLogShow});
        JavaFXUtil.addStyleClass((Styleable)debugLog, "about-debuglog");
        debugLog.setAlignment(Pos.BASELINE_LEFT);
        bottom.getChildren().add((Object)debugLog);
        try {
            URL bluejURL = new URL(BLUEJ_URL);
            Hyperlink link = new Hyperlink(bluejURL.toString());
            link.setOnMouseClicked(e -> SwingUtilities.invokeLater(() -> Utility.openWebBrowser(bluejURL.toExternalForm())));
            HBox hbox = new HBox(new Node[]{new Label(Config.getString("about.moreInformation")), link});
            hbox.setAlignment(Pos.CENTER);
            JavaFXUtil.addStyleClass((Styleable)hbox, "about-info-link");
            bottom.getChildren().add((Object)hbox);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        aboutPanel.setBottom((Node)bottom);
        this.setResizable(false);
    }
}

