/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.debugger.gentype.GenTypeClass;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.Token;
import bluej.parser.CodeSuggestions;
import bluej.parser.entity.JavaEntity;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.RBTreeNode;
import java.util.Iterator;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class ParsedNode
extends RBTreeNode<ParsedNode> {
    public static final int NODETYPE_NONE = 0;
    public static final int NODETYPE_TYPEDEF = 1;
    public static final int NODETYPE_METHODDEF = 2;
    public static final int NODETYPE_ITERATION = 3;
    public static final int NODETYPE_SELECTION = 4;
    public static final int NODETYPE_FIELD = 5;
    public static final int NODETYPE_EXPRESSION = 6;
    public static final int NODETYPE_COMMENT = 7;
    private NodeTree<ParsedNode> nodeTree = new NodeTree();
    private ParsedNode parentNode;
    private boolean hasAttachedComment;
    protected boolean complete;
    private boolean isInner = false;
    protected static final int ALL_OK = 0;
    protected static final int NODE_GREW = 1;
    protected static final int NODE_SHRUNK = 2;
    protected static final int REMOVE_NODE = 3;

    public ParsedNode() {
    }

    ParsedNode(ParsedNode parentNode) {
        this();
        this.parentNode = parentNode;
    }

    public Iterator<NodeTree.NodeAndPosition<ParsedNode>> getChildren(int offset) {
        return this.nodeTree.iterator(offset);
    }

    public int getNodeType() {
        return 0;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getName() {
        return null;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public boolean growsForward() {
        return false;
    }

    protected abstract boolean marksOwnEnd();

    public void insertNode(ParsedNode child, int position, int size) {
        this.getNodeTree().insertNode(child, position, size);
    }

    public void childChangedName(ParsedNode child, String oldName) {
    }

    public final NodeTree.NodeAndPosition<ParsedNode> findNodeAt(int position, int startpos) {
        return this.nodeTree.findNode(position, startpos);
    }

    public final NodeTree.NodeAndPosition<ParsedNode> findNodeAtOrAfter(int position, int startpos) {
        return this.nodeTree.findNodeAtOrAfter(position, startpos);
    }

    @Override
    public void resize(int newSize) {
        this.getContainingNodeTree().resize(newSize);
    }

    @Override
    public void setSize(int newSize) {
        this.getContainingNodeTree().setSize(newSize);
    }

    public int getOffsetFromParent() {
        if (this.getContainingNodeTree() == null) {
            return 0;
        }
        return this.getContainingNodeTree().getPosition();
    }

    @Override
    public void remove() {
        this.getContainingNodeTree().remove();
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isInner() {
        return this.isInner;
    }

    public void setInner(boolean inner) {
        this.isInner = inner;
    }

    public int getSize() {
        return this.getContainingNodeTree().getNodeSize();
    }

    public abstract int textInserted(MoeSyntaxDocument var1, int var2, int var3, int var4, NodeStructureListener var5);

    public abstract int textRemoved(MoeSyntaxDocument var1, int var2, int var3, int var4, NodeStructureListener var5);

    protected int reparseNode(MoeSyntaxDocument document, int nodePos, int offset, int maxParse, NodeStructureListener listener) {
        return 0;
    }

    public void reparse(MoeSyntaxDocument document, int nodePos, int offset, int maxParse, NodeStructureListener listener) {
        int size = this.getSize();
        int r = this.reparseNode(document, nodePos, offset, maxParse, listener);
        if (r == 3) {
            ParsedNode parent = this.getParentNode();
            parent.removeChild(new NodeTree.NodeAndPosition<ParsedNode>(this, nodePos, this.getSize()), listener);
            document.scheduleReparse(nodePos + size - 1, 0);
        } else if (r == 1 || r == 2) {
            int nsize = this.getSize();
            ParsedNode parent = this.getParentNode();
            if (parent != null) {
                int ppos = nodePos - this.getOffsetFromParent();
                parent.childResized(document, ppos, new NodeTree.NodeAndPosition<ParsedNode>(this, nodePos, nsize));
            }
            document.scheduleReparse(nodePos + nsize, Math.max(size - nsize, 0));
        }
    }

    public abstract Token getMarkTokensFor(int var1, int var2, int var3, MoeSyntaxDocument var4);

    protected ParsedNode getParentNode() {
        return this.parentNode;
    }

    protected NodeTree<ParsedNode> getNodeTree() {
        return this.nodeTree;
    }

    protected void nodeShortened(int newLength) {
    }

    protected void nodeIncomplete() {
    }

    @OnThread(value=Tag.FXPlatform)
    protected boolean growChild(MoeSyntaxDocument document, NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        return false;
    }

    public void childResized(MoeSyntaxDocument document, int nodePos, NodeTree.NodeAndPosition<ParsedNode> child) {
    }

    @OnThread(value=Tag.FXPlatform)
    public CodeSuggestions getExpressionType(int pos, MoeSyntaxDocument document) {
        return this.getExpressionType(pos, 0, null, document);
    }

    @OnThread(value=Tag.FXPlatform)
    protected CodeSuggestions getExpressionType(int pos, int nodePos, JavaEntity defaultType, MoeSyntaxDocument document) {
        GenTypeClass atype;
        NodeTree.NodeAndPosition<ParsedNode> child = this.getNodeTree().findNode(pos, nodePos);
        if (child != null) {
            return child.getNode().getExpressionType(pos, child.getPosition(), defaultType, document);
        }
        GenTypeClass genTypeClass = atype = defaultType != null ? defaultType.getType().asClass() : null;
        if (atype == null) {
            return null;
        }
        boolean isStaticCtxt = defaultType.resolveAsType() != null;
        return new CodeSuggestions(atype, atype, null, isStaticCtxt, true);
    }

    protected final void removeChild(NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        child.getNode().remove();
        this.childRemoved(child, listener);
    }

    protected void childRemoved(NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        listener.nodeRemoved(child);
        ParsedNode.removeChildren(child, listener);
    }

    protected static void removeChildren(NodeTree.NodeAndPosition<ParsedNode> node, NodeStructureListener listener) {
        Iterator<NodeTree.NodeAndPosition<ParsedNode>> i = node.getNode().getChildren(node.getPosition());
        while (i.hasNext()) {
            NodeTree.NodeAndPosition<ParsedNode> nap = i.next();
            listener.nodeRemoved(nap);
            ParsedNode.removeChildren(nap, listener);
        }
    }

    public boolean isCommentAttached() {
        return this.hasAttachedComment;
    }

    public void setCommentAttached(boolean commentAttached) {
        this.hasAttachedComment = commentAttached;
    }
}

