/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.debugger.gentype.Reflective;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.ImportsCollection;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.ValueEntity;
import bluej.parser.nodes.IncrementalParsingNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParseParams;
import bluej.parser.nodes.ParsedNode;
import bluej.utility.JavaNames;
import java.util.List;

public class ParsedCUNode
extends IncrementalParsingNode {
    private EntityResolver parentResolver;
    private ImportsCollection imports = new ImportsCollection();
    private int size = 0;

    public ParsedCUNode() {
        super(null);
    }

    public ParsedCUNode(MoeSyntaxDocument document) {
        super(null);
        this.size = 0;
    }

    public void setParentResolver(EntityResolver parentResolver) {
        this.parentResolver = parentResolver;
    }

    public ImportsCollection getImports() {
        return this.imports;
    }

    public EntityResolver getParentResolver() {
        return this.parentResolver;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void resize(int newSize) {
        this.size = newSize;
    }

    @Override
    public void setSize(int newSize) {
        this.size = newSize;
    }

    @Override
    protected int doPartialParse(ParseParams params, int state) {
        this.last = params.tokenStream.LA(1);
        if (this.checkBoundary(params, this.last)) {
            return 8;
        }
        params.parser.parseCUpart(state);
        return 0;
    }

    @Override
    protected boolean isDelimitingNode(NodeTree.NodeAndPosition<ParsedNode> nap) {
        int nt = nap.getNode().getNodeType();
        return nt != 7;
    }

    @Override
    protected boolean isNodeEndMarker(int tokenType) {
        return false;
    }

    @Override
    protected boolean marksOwnEnd() {
        return true;
    }

    @Override
    public PackageOrClass resolvePackageOrClass(String name, Reflective querySource) {
        PackageOrClass poc = super.resolvePackageOrClass(name, querySource);
        if (poc == null) {
            poc = this.imports.getTypeImport(name);
        }
        if (poc == null && this.parentResolver != null && querySource != null) {
            String prefix = JavaNames.getPrefix(querySource.getName());
            String fqName = JavaNames.combineNames(prefix, name);
            poc = this.parentResolver.resolveQualifiedClass(fqName);
        }
        if (poc == null) {
            poc = this.imports.getTypeImportWC(name);
        }
        if (poc == null && this.parentResolver != null) {
            poc = this.parentResolver.resolveQualifiedClass("java.lang." + name);
        }
        if (poc == null && this.parentResolver != null) {
            return this.parentResolver.resolvePackageOrClass(name, querySource);
        }
        return poc;
    }

    @Override
    public JavaEntity getValueEntity(String name, Reflective querySource) {
        ValueEntity value;
        JavaEntity subEnt;
        List<JavaEntity> simports = this.imports.getStaticImports(name);
        for (JavaEntity importType : simports) {
            if ((importType = importType.resolveAsType()) == null || (subEnt = importType.getSubentity(name, querySource)) == null || (value = subEnt.resolveAsValue()) == null) continue;
            return value;
        }
        simports = this.imports.getStaticWildcardImports();
        for (JavaEntity importType : simports) {
            if ((importType = importType.resolveAsType()) == null || (subEnt = importType.getSubentity(name, querySource)) == null || (value = subEnt.resolveAsValue()) == null) continue;
            return value;
        }
        return this.resolvePackageOrClass(name, querySource);
    }

    @Override
    public TypeEntity resolveQualifiedClass(String name) {
        if (this.parentResolver != null) {
            return this.parentResolver.resolveQualifiedClass(name);
        }
        return null;
    }
}

