/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.CodeSuggestions;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.TparEntity;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.ValueEntity;
import bluej.parser.nodes.JavaParentNode;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MethodNode
extends JavaParentNode {
    private String name;
    private String javadoc;
    private JavaEntity returnType;
    private List<String> paramNames = new ArrayList<String>();
    private List<JavaEntity> paramTypes = new ArrayList<JavaEntity>();
    private List<TparEntity> typeParams = null;
    private boolean isVarArgs = false;
    private int modifiers = 0;

    public MethodNode(JavaParentNode parent, String name, String javadoc) {
        super(parent);
        this.name = name;
        this.javadoc = javadoc;
        this.setCommentAttached(javadoc != null);
    }

    public void setReturnType(JavaEntity returnType) {
        this.returnType = returnType;
    }

    public void addParameter(String name, JavaEntity type) {
        this.paramNames.add(name);
        this.paramTypes.add(type);
    }

    public void setTypeParams(List<TparEntity> typeParams) {
        this.typeParams = typeParams;
    }

    public void setVarArgs(boolean isVarArgs) {
        this.isVarArgs = isVarArgs;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public List<String> getParamNames() {
        return this.paramNames;
    }

    public List<JavaEntity> getParamTypes() {
        return this.paramTypes;
    }

    public String getJavadoc() {
        return this.javadoc;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JavaEntity getReturnType() {
        return this.returnType;
    }

    public List<GenTypeDeclTpar> getTypeParams() {
        if (this.typeParams == null) {
            return null;
        }
        ArrayList<GenTypeDeclTpar> tparList = new ArrayList<GenTypeDeclTpar>(this.typeParams.size());
        for (TparEntity tparEnt : this.typeParams) {
            GenTypeDeclTpar tparType = tparEnt.getType();
            if (tparType == null) continue;
            tparList.add(tparType);
        }
        return tparList;
    }

    @Override
    protected boolean marksOwnEnd() {
        return true;
    }

    @Override
    public JavaEntity getValueEntity(String name, Reflective querySource) {
        JavaEntity paramEntity = this.getParameterEntity(name, querySource);
        if (paramEntity != null) {
            return paramEntity;
        }
        return super.getValueEntity(name, querySource);
    }

    private JavaEntity getParameterEntity(String name, Reflective querySource) {
        Iterator<String> i = this.paramNames.iterator();
        Iterator<JavaEntity> j = this.paramTypes.iterator();
        while (i.hasNext()) {
            if (i.next().equals(name)) {
                TypeEntity tent = j.next().resolveAsType();
                if (tent != null) {
                    return new ValueEntity(name, tent.getType());
                }
                return null;
            }
            j.next();
        }
        return null;
    }

    @Override
    public PackageOrClass resolvePackageOrClass(String name, Reflective querySource) {
        if (this.typeParams != null) {
            for (TparEntity tpar : this.typeParams) {
                if (!tpar.getName().equals(name)) continue;
                return tpar.resolveAsType();
            }
        }
        return super.resolvePackageOrClass(name, querySource);
    }

    @Override
    protected CodeSuggestions getExpressionType(int pos, int nodePos, JavaEntity defaultType, MoeSyntaxDocument document) {
        JavaType dtype;
        if (Modifier.isStatic(this.modifiers) && (dtype = defaultType.getType()) != null) {
            defaultType = new TypeEntity(dtype);
        }
        return super.getExpressionType(pos, nodePos, defaultType, document);
    }
}

