/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.Config;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.Reflective;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.TypeEntity;
import bluej.parser.lexer.LocatableToken;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ImportsCollection {
    private Map<String, LocatableImport> normalImports = new HashMap<String, LocatableImport>();
    private List<LocatableImport> wildcardImports = new ArrayList<LocatableImport>();
    private List<LocatableImport> staticWildcardImports = new ArrayList<LocatableImport>();
    private Map<String, List<LocatableImport>> staticImports = new HashMap<String, List<LocatableImport>>();

    public void clear() {
        this.normalImports.clear();
        this.wildcardImports.clear();
    }

    public void addNormalImport(String name, JavaEntity importEntity, LocatableToken firstToken, LocatableToken lastToken) {
        this.normalImports.put(name, ImportsCollection.getLocatableImport(importEntity, firstToken, lastToken));
    }

    private static LocatableImport getLocatableImport(JavaEntity importEntity, LocatableToken firstToken, LocatableToken lastToken) {
        int start = -1;
        int end = -1;
        if (firstToken != null && lastToken != null) {
            start = firstToken.getPosition();
            end = lastToken.getEndPosition();
        }
        return new LocatableImport(importEntity, start, end);
    }

    public void addWildcardImport(JavaEntity importEntity, LocatableToken firstToken, LocatableToken lastToken) {
        this.wildcardImports.add(ImportsCollection.getLocatableImport(importEntity, firstToken, lastToken));
    }

    public void addStaticImport(String name, JavaEntity importEntity, LocatableToken firstToken, LocatableToken lastToken) {
        List<LocatableImport> l = this.staticImports.get(name);
        if (l == null) {
            l = new ArrayList<LocatableImport>();
            this.staticImports.put(name, l);
        }
        l.add(ImportsCollection.getLocatableImport(importEntity, firstToken, lastToken));
    }

    public void addStaticWildcardImport(TypeEntity importEntity, LocatableToken firstToken, LocatableToken lastToken) {
        this.staticWildcardImports.add(ImportsCollection.getLocatableImport(importEntity, firstToken, lastToken));
    }

    public LocatableImport getImportInfo(String fullTypeName) {
        for (Map.Entry<String, LocatableImport> entry : this.normalImports.entrySet()) {
            if (!fullTypeName.endsWith(entry.getKey()) || !entry.getValue().javaEntity.getName().equals(fullTypeName)) continue;
            return entry.getValue();
        }
        return null;
    }

    @OnThread(value=Tag.FXPlatform)
    public TypeEntity getTypeImport(String name) {
        LocatableImport r = this.normalImports.get(name);
        if (r != null) {
            return r.javaEntity.resolveAsType();
        }
        List<LocatableImport> l = this.staticImports.get(name);
        if (l != null) {
            for (LocatableImport locatableImport : l) {
                TypeEntity rt = locatableImport.javaEntity.resolveAsType();
                if (rt == null || (rt = rt.getPackageOrClassMember(name)) == null) continue;
                return rt;
            }
        }
        return null;
    }

    public List<JavaEntity> getStaticImports(String name) {
        List<LocatableImport> l = this.staticImports.get(name);
        if (l == null) {
            l = Collections.emptyList();
        }
        return Utility.mapList(l, li -> ((LocatableImport)li).javaEntity);
    }

    public List<JavaEntity> getStaticWildcardImports() {
        return Utility.mapList(this.staticWildcardImports, li -> ((LocatableImport)li).javaEntity);
    }

    @OnThread(value=Tag.FXPlatform)
    public TypeEntity getTypeImportWC(String name) {
        PackageOrClass importEntity;
        for (LocatableImport entity : this.wildcardImports) {
            TypeEntity clMember;
            PackageOrClass member;
            importEntity = entity.javaEntity.resolveAsPackageOrClass();
            if (importEntity == null || (member = importEntity.getPackageOrClassMember(name)) == null || (clMember = member.resolveAsType()) == null) continue;
            return clMember;
        }
        for (LocatableImport staticWildcardImport : this.staticWildcardImports) {
            GenTypeClass clType;
            importEntity = staticWildcardImport.javaEntity.resolveAsType();
            if (importEntity == null || (clType = ((TypeEntity)importEntity).getClassType()) == null) continue;
            String innerName = clType.classloaderName() + "$" + name;
            Reflective inner = clType.getReflective().getRelativeClass(innerName);
            if (inner == null) continue;
            return new TypeEntity(new GenTypeClass(inner));
        }
        return null;
    }

    public String toString() {
        JavaEntity importEntity;
        String rr = "";
        for (LocatableImport locatableImport : this.normalImports.values()) {
            importEntity = locatableImport.javaEntity;
            rr = rr + "import ";
            rr = rr + importEntity.getName() + ";" + Config.nl;
        }
        for (LocatableImport wildcardImport : this.wildcardImports) {
            importEntity = (PackageOrClass)wildcardImport.javaEntity;
            rr = rr + "import ";
            rr = rr + importEntity.getName() + ".*;" + Config.nl;
        }
        for (String importName : this.staticImports.keySet()) {
            List<LocatableImport> l = this.staticImports.get(importName);
            for (LocatableImport locatableImport : l) {
                TypeEntity importEntity2 = locatableImport.javaEntity.resolveAsType();
                if (importEntity2 == null) continue;
                rr = rr + "import static " + importEntity2.getName();
                rr = rr + "." + importName + ";" + Config.nl;
            }
        }
        for (LocatableImport staticWildcardImport : this.staticWildcardImports) {
            importEntity = staticWildcardImport.javaEntity;
            rr = rr + "import static " + importEntity.getName();
            rr = rr + ".*;" + Config.nl;
        }
        return rr;
    }

    public static class LocatableImport {
        private final JavaEntity javaEntity;
        private final int start;
        private final int end;

        public LocatableImport(JavaEntity javaEntity, int start, int end) {
            this.javaEntity = javaEntity;
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.end - this.start;
        }
    }
}

