/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.codepad.DeclaredVar;
import bluej.parser.JavaParser;
import bluej.parser.ParseUtils;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.lexer.LocatableToken;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class CodepadVarParser
extends JavaParser {
    private EntityResolver resolver;
    private int arrayCount = 0;
    private int modifiers = 0;
    private boolean gotFirstVar = false;
    private JavaType baseType;
    private List<DeclaredVar> variables = new ArrayList<DeclaredVar>();

    public CodepadVarParser(EntityResolver resolver, Reader reader) {
        super(reader);
        this.resolver = resolver;
    }

    public CodepadVarParser(EntityResolver resolver, String text) {
        this(resolver, new StringReader(text));
    }

    public List<DeclaredVar> getVariables() {
        return this.variables;
    }

    @Override
    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected void gotTypeSpec(List<LocatableToken> tokens) {
        if (!this.gotFirstVar) {
            JavaEntity bent = ParseUtils.getTypeEntity(this.resolver, null, tokens);
            if (bent == null) {
                return;
            }
            if ((bent = bent.resolveAsType()) != null) {
                this.baseType = bent.getType();
            }
        }
    }

    @Override
    protected void gotArrayDeclarator() {
        ++this.arrayCount;
    }

    @Override
    protected void gotVariableDecl(LocatableToken first, LocatableToken idToken, boolean inited) {
        this.gotFirstVar = true;
        if (this.baseType != null) {
            JavaType vtype = this.baseType;
            while (this.arrayCount > 0) {
                vtype = vtype.getArray();
                --this.arrayCount;
            }
            this.variables.add(new DeclaredVar(inited, Modifier.isFinal(this.modifiers), vtype, idToken.getText()));
        }
    }

    @Override
    protected void gotSubsequentVar(LocatableToken first, LocatableToken idToken, boolean inited) {
        if (this.baseType != null) {
            JavaType vtype = this.baseType;
            while (this.arrayCount > 0) {
                vtype = vtype.getArray();
                --this.arrayCount;
            }
            this.variables.add(new DeclaredVar(inited, Modifier.isFinal(this.modifiers), vtype, idToken.getText()));
        }
    }

    @Override
    protected void gotModifier(LocatableToken token) {
        if (!this.gotFirstVar && token.getType() == 39) {
            this.modifiers |= 0x10;
        }
    }
}

