/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.actions.ValidateConnectionAction;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import bluej.utility.javafx.HorizontalRadio;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class TeamSettingsPanel
extends VBox {
    private TeamSettingsController teamSettingsController;
    private TeamSettingsDialog teamSettingsDialog;
    private GridPane personalPane;
    private GridPane locationPane;
    private Label serverLabel = new Label(Config.getString("team.settings.server"));
    private Label prefixLabel = new Label(Config.getString("team.settings.prefix"));
    private Label protocolLabel = new Label(Config.getString("team.settings.protocol"));
    private Label uriLabel = new Label(Config.getString("team.settings.uri"));
    private Label yourNameLabel = new Label(Config.getString("team.settings.yourName"));
    private Label yourEmailLabel = new Label(Config.getString("team.settings.yourEmail"));
    private Label userLabel = new Label(Config.getString("team.settings.user"));
    private Label passwordLabel = new Label(Config.getString("team.settings.password"));
    private Label groupLabel = new Label(Config.getString("team.settings.group"));
    private final HorizontalRadio<TeamSettingsController.ServerType> serverTypes;
    private final TextField serverField = new TextField();
    private final TextField prefixField = new TextField();
    private final ComboBox protocolComboBox = new ComboBox();
    private final TextField uriField = new TextField();
    private final TextField yourNameField = new TextField();
    private final TextField yourEmailField = new TextField();
    private final TextField userField = new TextField();
    private final PasswordField passwordField = new PasswordField();
    private final TextField groupField = new TextField();
    private CheckBox useAsDefault;
    private TeamSettingsController.ServerType selectedServerType = null;

    public TeamSettingsPanel(TeamSettingsController teamSettingsController, TeamSettingsDialog dialog, ObservableList<String> styleClass) {
        this.teamSettingsController = teamSettingsController;
        this.teamSettingsDialog = dialog;
        JavaFXUtil.addStyleClass((Styleable)this, "panel");
        this.serverTypes = new HorizontalRadio<TeamSettingsController.ServerType>(Arrays.asList(TeamSettingsController.ServerType.Subversion, TeamSettingsController.ServerType.Git));
        this.serverTypes.select(TeamSettingsController.ServerType.Subversion);
        HBox serverTypeBox = new HBox();
        JavaFXUtil.addStyleClass((Styleable)serverTypeBox, "serverType-box");
        serverTypeBox.getChildren().add((Object)new Label(Config.getString("team.settings.serverType")));
        serverTypeBox.getChildren().addAll((Object[])new Node[]{this.serverTypes.getButtons()});
        serverTypeBox.setAlignment(Pos.CENTER);
        this.getChildren().add((Object)serverTypeBox);
        this.useAsDefault = new CheckBox(Config.getString("team.settings.rememberSettings"));
        this.locationPane = this.createGridPane();
        this.personalPane = this.createGridPane();
        this.preparePanes((TeamSettingsController.ServerType)((Object)this.serverTypes.selectedProperty().get()));
        JavaFXUtil.addChangeListenerPlatform(this.serverTypes.selectedProperty(), type -> {
            this.preparePanes((TeamSettingsController.ServerType)((Object)type));
            this.updateOKButtonBinding();
        });
        ValidateConnectionAction validateConnectionAction = new ValidateConnectionAction(this, () -> ((TeamSettingsDialog)dialog).getOwner());
        Button validateButton = new Button();
        validateConnectionAction.useButton(PkgMgrFrame.getMostRecent(), (ButtonBase)validateButton);
        this.getChildren().addAll((Object[])new Node[]{this.createPropertiesContainer(Config.getString("team.settings.location"), (Pane)this.locationPane), this.createPropertiesContainer(Config.getString("team.settings.personal"), (Pane)this.personalPane), this.useAsDefault, validateButton});
        this.setupContent();
        this.updateOKButtonBinding();
        if (!teamSettingsController.hasProject()) {
            this.useAsDefault.setSelected(true);
            this.useAsDefault.setDisable(true);
        }
    }

    private GridPane createGridPane() {
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"grid");
        ColumnConstraints column1 = new ColumnConstraints();
        column1.setPrefWidth(102.0);
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setPrefWidth(260.0);
        column2.setHgrow(Priority.ALWAYS);
        pane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        return pane;
    }

    private Pane createPropertiesContainer(String title, Pane gridPane) {
        VBox container = new VBox();
        container.setSpacing(-5.0);
        container.getChildren().addAll((Object[])new Node[]{new Label(title), gridPane});
        return container;
    }

    private void preparePanes(TeamSettingsController.ServerType type) {
        this.prepareLocationPane(type);
        this.preparePersonalPane(type);
        this.setProviderSettings();
        switch (type) {
            case Subversion: {
                this.useAsDefault.setDisable(false);
                break;
            }
            case Git: {
                this.useAsDefault.setSelected(true);
                this.useAsDefault.setDisable(true);
                break;
            }
            default: {
                Debug.reportError((Object)((Object)type) + " is not recognisable as s server type");
            }
        }
    }

    private void preparePersonalPane(TeamSettingsController.ServerType type) {
        this.personalPane.getChildren().clear();
        this.yourNameField.requestFocus();
        switch (type) {
            case Subversion: {
                this.personalPane.addRow(0, new Node[]{this.userLabel, this.userField});
                this.personalPane.addRow(1, new Node[]{this.passwordLabel, this.passwordField});
                this.personalPane.addRow(2, new Node[]{this.groupLabel, this.groupField});
                break;
            }
            case Git: {
                this.personalPane.addRow(0, new Node[]{this.yourNameLabel, this.yourNameField});
                this.personalPane.addRow(1, new Node[]{this.yourEmailLabel, this.yourEmailField});
                this.personalPane.addRow(2, new Node[]{this.userLabel, this.userField});
                this.personalPane.addRow(3, new Node[]{this.passwordLabel, this.passwordField});
                break;
            }
            default: {
                Debug.reportError((Object)((Object)type) + " is not recognisable as s server type");
            }
        }
    }

    private void prepareLocationPane(TeamSettingsController.ServerType type) {
        this.locationPane.getChildren().clear();
        this.protocolComboBox.setEditable(false);
        switch (type) {
            case Subversion: {
                this.locationPane.addRow(0, new Node[]{this.serverLabel, this.serverField});
                this.locationPane.addRow(1, new Node[]{this.prefixLabel, this.prefixField});
                this.locationPane.addRow(2, new Node[]{this.protocolLabel, this.protocolComboBox});
                break;
            }
            case Git: {
                this.locationPane.addRow(0, new Node[]{this.uriLabel, this.uriField});
                break;
            }
            default: {
                Debug.reportError((Object)((Object)type) + " is not recognisable as s server type");
            }
        }
    }

    private void setupContent() {
        String useAsDefault;
        String group;
        String password;
        String yourEmail;
        String yourName;
        String user = this.teamSettingsController.getPropString("bluej.teamsettings.user");
        if (user != null) {
            this.setUser(user);
        }
        if ((yourName = this.teamSettingsController.getPropString("bluej.teamsettings.yourName")) != null) {
            this.setYourName(yourName);
        }
        if ((yourEmail = this.teamSettingsController.getPropString("bluej.teamsettings.yourEmail")) != null) {
            this.setYourEmail(yourEmail);
        }
        if ((password = this.teamSettingsController.getPasswordString()) != null) {
            this.setPassword(password);
        }
        if ((group = this.teamSettingsController.getPropString("bluej.teamsettings.groupname")) != null) {
            this.setGroup(group);
        }
        if ((useAsDefault = this.teamSettingsController.getPropString("bluej.teamsettings.useAsDefault")) != null) {
            this.setUseAsDefault(Boolean.getBoolean(useAsDefault));
        }
        String providerName = this.teamSettingsController.getPropString("bluej.teamsettings.vcs");
        List<TeamworkProvider> teamProviders = this.teamSettingsController.getTeamworkProviders();
        for (int index = 0; index < teamProviders.size(); ++index) {
            TeamworkProvider provider = teamProviders.get(index);
            if (!provider.getProviderName().equalsIgnoreCase(providerName) && (providerName != null || index != 0)) continue;
            this.serverTypes.select(TeamSettingsController.ServerType.valueOf(teamProviders.get(index).getProviderName()));
            if (!provider.needsEmail() || this.teamSettingsController.getProject() == null) break;
            File respositoryRoot = this.teamSettingsController.getProject().getProjectDir();
            this.yourEmailField.setText(provider.getYourEmailFromRepo(respositoryRoot));
            this.yourEmailField.setDisable(true);
            this.yourNameField.setText(provider.getYourNameFromRepo(respositoryRoot));
            this.yourNameField.setDisable(true);
            this.useAsDefault.setSelected(true);
            break;
        }
        this.setProviderSettings();
    }

    private void setProviderSettings() {
        String server;
        String keyBase = "bluej.teamsettings." + this.getSelectedProvider().getProviderName().toLowerCase() + ".";
        String prefix = this.teamSettingsController.getPropString(keyBase + "repositoryPrefix");
        if (prefix != null) {
            this.setPrefix(prefix);
        }
        if ((server = this.teamSettingsController.getPropString(keyBase + "server")) != null) {
            this.setServer(server);
        }
        this.fillProtocolSelections();
        String protocol = this.readProtocolString();
        if (protocol != null) {
            this.setProtocol(protocol);
        }
    }

    private void fillProtocolSelections() {
        TeamSettingsController.ServerType type = (TeamSettingsController.ServerType)((Object)this.serverTypes.selectedProperty().get());
        if (type != this.selectedServerType) {
            this.selectedServerType = type;
            this.protocolComboBox.getItems().clear();
            TeamworkProvider provider = this.teamSettingsController.getTeamworkProvider(type);
            this.protocolComboBox.getItems().addAll(Arrays.asList(provider.getProtocols()));
        }
    }

    private String readProtocolString() {
        String keyBase = "bluej.teamsettings." + this.getSelectedProvider().getProviderName().toLowerCase() + ".";
        return this.teamSettingsController.getPropString(keyBase + "protocol");
    }

    private void setUser(String user) {
        this.userField.setText(user);
    }

    private void setYourName(String yourName) {
        this.yourNameField.setText(yourName);
    }

    private void setYourEmail(String yourEmail) {
        this.yourEmailField.setText(yourEmail);
    }

    private void setPassword(String password) {
        this.passwordField.setText(password);
    }

    private void setGroup(String group) {
        this.groupField.setText(group);
    }

    private void setPrefix(String prefix) {
        this.prefixField.setText(prefix);
    }

    private void setServer(String server) {
        this.serverField.setText(server);
    }

    private void setProtocol(String protocolKey) {
        String protocolLabel = this.getSelectedProvider().getProtocolLabel(protocolKey);
        this.protocolComboBox.getSelectionModel().select((Object)protocolLabel);
    }

    private void setUseAsDefault(boolean use) {
        this.useAsDefault.setSelected(use);
    }

    public TeamworkProvider getSelectedProvider() {
        return this.teamSettingsController.getTeamworkProviders().stream().filter(provider -> provider.getProviderName().equals(((TeamSettingsController.ServerType)((Object)((Object)this.serverTypes.selectedProperty().get()))).name())).findAny().get();
    }

    private String getUser() {
        return this.userField.getText();
    }

    private String getPassword() {
        return this.passwordField.getText();
    }

    private String getGroup() {
        if (this.getSelectedProvider().needsEmail()) {
            return "";
        }
        return this.groupField.getText();
    }

    private String getPrefix() {
        if (this.getSelectedProvider().needsEmail()) {
            try {
                URI uri = new URI(this.uriField.getText());
                return uri.getPath();
            }
            catch (URISyntaxException ex) {
                return null;
            }
        }
        return this.prefixField.getText();
    }

    private String getServer() {
        if (this.getSelectedProvider().needsEmail()) {
            try {
                URI uri = new URI(this.uriField.getText());
                return uri.getHost();
            }
            catch (URISyntaxException ex) {
                return null;
            }
        }
        return this.serverField.getText();
    }

    private String getProtocolKey() {
        if (this.getSelectedProvider().needsEmail()) {
            try {
                URI uri = new URI(this.uriField.getText());
                return uri.getScheme();
            }
            catch (URISyntaxException ex) {
                return null;
            }
        }
        int protocol = this.protocolComboBox.getSelectionModel().getSelectedIndex();
        if (protocol == -1) {
            return null;
        }
        return this.getSelectedProvider().getProtocolKey(protocol);
    }

    public boolean getUseAsDefault() {
        return this.useAsDefault.isSelected();
    }

    private String getYourName() {
        return this.yourNameField.getText();
    }

    private String getYourEmail() {
        return this.yourEmailField.getText();
    }

    public TeamSettings getSettings() {
        TeamSettings result = new TeamSettings(this.getSelectedProvider(), this.getProtocolKey(), this.getServer(), this.getPrefix(), this.getGroup(), this.getUser(), this.getPassword());
        result.setYourEmail(this.getYourEmail());
        result.setYourName(this.getYourName());
        return result;
    }

    private void updateOKButtonBinding() {
        this.teamSettingsDialog.getOkButton().disableProperty().unbind();
        BooleanBinding disabled = this.userField.textProperty().isEmpty();
        switch ((TeamSettingsController.ServerType)((Object)this.serverTypes.selectedProperty().get())) {
            case Subversion: {
                disabled = disabled.or((ObservableBooleanValue)this.serverField.textProperty().isEmpty());
                break;
            }
            case Git: {
                disabled = disabled.or((ObservableBooleanValue)this.uriField.textProperty().isEmpty()).or((ObservableBooleanValue)this.yourNameField.textProperty().isEmpty()).or((ObservableBooleanValue)this.yourEmailField.textProperty().isEmpty()).or((ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.yourEmailField.getText().contains("@"), (Observable[])new Observable[]{this.yourEmailField.textProperty()}));
            }
        }
        this.teamSettingsDialog.getOkButton().disableProperty().bind((ObservableValue)disabled);
    }

    public void disableRepositorySettings() {
        this.serverTypes.setDisable(true);
        this.groupField.setDisable(true);
        this.prefixField.setDisable(true);
        this.serverField.setDisable(true);
        this.protocolComboBox.setDisable(true);
        this.uriField.setDisable(true);
        if (this.uriField.isVisible() && this.uriField.getText().isEmpty()) {
            this.uriField.setText(TeamSettings.getURI(this.readProtocolString(), this.serverField.getText(), this.prefixField.getText()));
        }
        this.groupLabel.setDisable(true);
        this.prefixLabel.setDisable(true);
        this.serverLabel.setDisable(true);
        this.protocolLabel.setDisable(true);
    }
}

