/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.groupwork.TeamStatusInfo;
import bluej.utility.Debug;
import javafx.collections.ObservableList;
import javafx.scene.control.TableCell;
import javafx.scene.paint.Paint;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public class StatusTableCell
extends TableCell<TeamStatusInfo, Object> {
    private final boolean isDVCS;
    private final int column;
    protected ObservableList<TeamStatusInfo> resources;

    public StatusTableCell(boolean isDVCS, int column) {
        this.isDVCS = isDVCS;
        this.column = column;
        this.setText("");
        this.setGraphic(null);
    }

    protected void updateItem(Object v, boolean empty) {
        super.updateItem(v, empty);
        if (v != null) {
            if (v instanceof String) {
                this.setText(String.valueOf(v));
            } else if (v instanceof TeamStatusInfo.Status) {
                TeamStatusInfo.Status status = (TeamStatusInfo.Status)((Object)v);
                this.setText(this.getMessage(status));
                this.setTextFill((Paint)status.getStatusColour());
            } else {
                Debug.reportError("Status Table Cell should be either String or TeamStatusInfo.Status :" + v.toString());
            }
        }
    }

    private String getMessage(TeamStatusInfo.Status status) {
        switch (this.column) {
            case 1: {
                if (this.isDVCS) {
                    return status.getDCVSStatusString(false);
                }
                Debug.reportError("DVCS can't be false here for column = 1");
                break;
            }
            case 2: {
                return this.isDVCS ? status.getDCVSStatusString(true) : status.getStatusString();
            }
        }
        return null;
    }
}

