/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.ui.UpdateStatus;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.Project;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ResourceDescriptor {
    public static String getResource(Project project, TeamStatusInfo info, boolean annotate) {
        String status = info.toString();
        boolean isPkgFile = BlueJPackageFile.isPackageFileName(info.getFile().getName());
        if (isPkgFile) {
            status = Config.getString("team.commit.layout") + " " + project.getPackageForFile(info.getFile());
        }
        if (annotate) {
            TeamStatusInfo.Status infoStatus = info.getStatus();
            switch (infoStatus) {
                case DELETED: {
                    status = status + " (" + Config.getString("team.status.delete") + ")";
                    break;
                }
                case NEEDS_ADD: {
                    status = status + " (" + Config.getString("team.status.add") + ")";
                    break;
                }
                case NEEDS_CHECKOUT: {
                    status = status + " (" + Config.getString("team.status.new") + ")";
                    break;
                }
                case REMOVED: 
                case CONFLICT_LMRD: {
                    status = status + " (" + Config.getString("team.status.removed") + ")";
                    break;
                }
                case NEEDS_MERGE: {
                    if (isPkgFile) break;
                    status = status + " (" + Config.getString("team.status.needsmerge") + ")";
                    break;
                }
            }
            if (!(info.getRemoteStatus() != TeamStatusInfo.Status.NEEDS_CHECKOUT && info.getRemoteStatus() != TeamStatusInfo.Status.DELETED || isPkgFile)) {
                status = status + "(" + Config.getString("team.status.needsupdate") + ")";
            }
        }
        return status;
    }

    public static String getResource(Project project, UpdateStatus updateStatus, boolean annotate) {
        if (updateStatus.infoStatus != null) {
            return ResourceDescriptor.getResource(project, updateStatus.infoStatus, annotate);
        }
        return updateStatus.stringStatus;
    }

    public static String getDCVSResource(Project project, TeamStatusInfo info, boolean annotate, boolean remote) {
        String status = info.toString();
        boolean isPkgFile = BlueJPackageFile.isPackageFileName(info.getFile().getName());
        if (isPkgFile) {
            status = Config.getString("team.commit.layout") + " " + project.getPackageForFile(info.getFile());
        }
        if (annotate) {
            TeamStatusInfo.Status infoStatus = info.getStatus(!remote);
            switch (infoStatus) {
                case DELETED: 
                case NEEDS_ADD: 
                case NEEDS_CHECKOUT: 
                case REMOVED: 
                case CONFLICT_LMRD: 
                case NEEDS_UPDATE: 
                case NEEDS_COMMIT: {
                    status = status + " (" + infoStatus.getDCVSStatusString(remote) + ")";
                    break;
                }
                case NEEDS_MERGE: {
                    if (isPkgFile) break;
                    status = status + " (" + infoStatus.getDCVSStatusString(remote) + ")";
                    break;
                }
            }
        }
        return status;
    }

    public static String getDCVSResource(Project project, UpdateStatus updateStatus, boolean annotate, boolean remote) {
        if (updateStatus.infoStatus != null) {
            return ResourceDescriptor.getDCVSResource(project, updateStatus.infoStatus, annotate, remote);
        }
        return updateStatus.stringStatus;
    }
}

