/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.utility.DialogManager;
import bluej.utility.FXWorker;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.FXPlatformSupplier;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ModuleSelectDialog
extends FXCustomizedDialog<Void> {
    private Repository repository;
    private ModuleListerWorker worker;
    private final ActivityIndicator progressBar = new ActivityIndicator();
    private final TextField moduleField = new TextField();
    private final ListView moduleList = new ListView();
    private boolean wasOk;

    public ModuleSelectDialog(FXPlatformSupplier<Window> owner, Repository repository) {
        super(owner.get(), "team.moduleselect.title", "team-module-select");
        this.repository = repository;
        this.getDialogPane().setContent((Node)this.makeMainPane());
        this.prepareButtonPane();
        DialogManager.centreDialog(this);
    }

    private Pane makeMainPane() {
        this.moduleField.setPrefColumnCount(20);
        HBox moduleBox = new HBox();
        moduleBox.getChildren().addAll((Object[])new Node[]{new Label(Config.getString("team.moduleselect.label")), this.moduleField});
        this.moduleList.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2 && this.moduleList.getItems().contains(event.getSource())) {
                this.wasOk = true;
                this.hide();
            }
        });
        ScrollPane moduleListSP = new ScrollPane((Node)this.moduleList);
        moduleListSP.setFitToWidth(true);
        moduleListSP.setFitToHeight(true);
        Button listButton = new Button(Config.getString("team.moduleselect.show"));
        listButton.setOnAction(event -> {
            listButton.setDisable(true);
            this.startProgressBar();
            this.worker = new ModuleListerWorker();
            this.worker.start();
        });
        HBox moduleListBox = new HBox();
        moduleListBox.getChildren().addAll((Object[])new Node[]{moduleListSP, listButton});
        VBox mainPane = new VBox();
        mainPane.getChildren().addAll((Object[])new Node[]{moduleBox, new Label(Config.getString("team.moduleselect.available")), moduleListBox, this.progressBar});
        return mainPane;
    }

    private void prepareButtonPane() {
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        okButton.disableProperty().bind((ObservableValue)this.moduleField.textProperty().isEmpty());
        okButton.setOnAction(event -> {
            this.wasOk = true;
            this.close();
        });
        this.setOnCloseRequest(event -> {
            if (this.worker != null) {
                this.worker.abort();
            }
        });
    }

    public String getModuleName() {
        if (this.wasOk) {
            return this.moduleField.getText();
        }
        return null;
    }

    private void startProgressBar() {
        this.progressBar.setRunning(true);
    }

    private void stopProgressBar() {
        this.progressBar.setRunning(false);
    }

    private void setModuleList(ObservableList<String> modules) {
        this.moduleList.setItems(modules);
    }

    private class ModuleListerWorker
    extends FXWorker {
        private TeamworkCommand command;
        private TeamworkCommandResult result;
        private ObservableList<String> modules = FXCollections.observableArrayList();

        public ModuleListerWorker() {
            this.command = ModuleSelectDialog.this.repository.getModules((List<String>)this.modules);
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            this.result = this.command.getResult();
            return this.result;
        }

        @Override
        public void finished() {
            ModuleSelectDialog.this.stopProgressBar();
            if (this.command != null) {
                if (this.result != null && !this.result.isError()) {
                    ModuleSelectDialog.this.setModuleList((ObservableList<String>)this.modules);
                } else {
                    TeamUtils.handleServerResponseFX(this.result, ModuleSelectDialog.this.asWindow());
                }
            }
        }

        @Override
        public void abort() {
            if (this.command != null) {
                this.command.cancel();
                this.command = null;
            }
        }
    }
}

