/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.pkgmgr.Project;
import bluej.utility.DialogManager;
import bluej.utility.javafx.FXCustomizedDialog;
import java.util.List;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ConflictsDialog
extends FXCustomizedDialog<Void> {
    private List<String> bluejConflicts;
    private List<String> nonBluejConflicts;
    private Project project;

    public ConflictsDialog(Project project, Window owner, List<String> bluejConflicts, List<String> nonBlueJConflicts) {
        super(owner, "team.conflicts.title", "team-conflicts");
        this.project = project;
        this.bluejConflicts = bluejConflicts;
        this.nonBluejConflicts = nonBlueJConflicts;
        this.getDialogPane().setContent((Node)this.makeMainPane());
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        DialogManager.centreDialog(this);
    }

    private Pane makeMainPane() {
        VBox mainPanel = new VBox();
        Pane bluejConflictsPanel = this.makeConflictsPanel(Config.getString("team.conflicts.classes"), this.bluejConflicts);
        mainPanel.getChildren().add((Object)bluejConflictsPanel);
        Pane nonBluejConflictsPanel = this.makeConflictsPanel(Config.getString("team.conflicts.classes"), this.nonBluejConflicts);
        if (this.nonBluejConflicts.size() > 0) {
            mainPanel.getChildren().add((Object)nonBluejConflictsPanel);
        }
        Button resolveButton = new Button(Config.getString("team.conflicts.show"));
        resolveButton.setOnAction(event -> {
            this.project.openEditorsForSelectedTargets();
            this.close();
        });
        resolveButton.requestFocus();
        resolveButton.setDisable(this.bluejConflicts.size() <= 0);
        mainPanel.getChildren().add((Object)resolveButton);
        return mainPanel;
    }

    private Pane makeConflictsPanel(String headline, List<String> conflicts) {
        VBox labelPanel = new VBox();
        labelPanel.setAlignment(Pos.BASELINE_LEFT);
        VBox conflictsPanel = new VBox();
        conflictsPanel.setAlignment(Pos.BASELINE_LEFT);
        for (String conflict : conflicts) {
            conflictsPanel.getChildren().add((Object)new Label(conflict));
        }
        ScrollPane scrollPane = new ScrollPane((Node)conflictsPanel);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        labelPanel.getChildren().addAll((Object[])new Node[]{new Label(headline), new Separator(Orientation.VERTICAL), scrollPane});
        return labelPanel;
    }
}

