/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.CommitFilter;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.CommitAction;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.CommitAndPushInterface;
import bluej.groupwork.ui.TeamStatusInfoCell;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.DialogManager;
import bluej.utility.FXWorker;
import bluej.utility.Utility;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class CommitCommentsFrame
extends FXCustomizedDialog<Void>
implements CommitAndPushInterface {
    private Project project;
    private Repository repository;
    private CommitAction commitAction;
    private CommitWorker commitWorker;
    private ObservableList<TeamStatusInfo> commitListModel = FXCollections.observableArrayList();
    private Set<TeamStatusInfo> changedLayoutFiles = new HashSet<TeamStatusInfo>();
    private Set<File> packagesToCommmit = new HashSet<File>();
    private final TextArea commitText = new TextArea("");
    private final CheckBox includeLayout = new CheckBox(Config.getString("team.commit.includelayout"));
    private final ActivityIndicator progressBar = new ActivityIndicator();

    public CommitCommentsFrame(Project project, Window owner) {
        super(owner, "team.commit.title", "team-commit-comments");
        this.project = project;
        this.getDialogPane().setContent((Node)this.makeMainPane());
        this.prepareButtonPane();
        DialogManager.centreDialog(this);
    }

    private Pane makeMainPane() {
        ListView commitFiles = new ListView(this.commitListModel);
        commitFiles.setPlaceholder((Node)new Label(Config.getString("team.nocommitfiles")));
        commitFiles.setCellFactory(param -> new TeamStatusInfoCell(this.project));
        commitFiles.setDisable(true);
        ScrollPane fileScrollPane = new ScrollPane((Node)commitFiles);
        fileScrollPane.setFitToWidth(true);
        fileScrollPane.setFitToHeight(true);
        VBox.setMargin((Node)fileScrollPane, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
        this.commitText.setPrefRowCount(20);
        this.commitText.setPrefColumnCount(35);
        VBox.setMargin((Node)this.commitText, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        this.commitAction = new CommitAction(this);
        Button commitButton = new Button();
        this.commitAction.useButton(PkgMgrFrame.getMostRecent(), (ButtonBase)commitButton);
        commitButton.requestFocus();
        this.commitText.disableProperty().bind((ObservableValue)Bindings.isEmpty(this.commitListModel));
        this.commitAction.disabledProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)this.commitText.disabledProperty(), (ObservableBooleanValue)this.commitText.textProperty().isEmpty()));
        this.progressBar.setRunning(false);
        this.includeLayout.setOnAction(event -> {
            CheckBox layoutCheck = (CheckBox)event.getSource();
            if (layoutCheck.isSelected()) {
                this.addModifiedLayouts();
            } else {
                this.removeModifiedLayouts();
            }
        });
        this.includeLayout.setDisable(true);
        HBox commitButtonPane = new HBox();
        JavaFXUtil.addStyleClass((Styleable)commitButtonPane, "button-hbox");
        commitButtonPane.setAlignment(Pos.CENTER_RIGHT);
        commitButtonPane.getChildren().addAll((Object[])new Node[]{this.includeLayout, commitButton, this.progressBar});
        VBox mainPane = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPane, "main-pane");
        mainPane.getChildren().addAll((Object[])new Node[]{new Label(Config.getString("team.commit.files")), fileScrollPane, new Label(Config.getString("team.commit.comment")), this.commitText, commitButtonPane});
        VBox.setVgrow((Node)fileScrollPane, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.commitText, (Priority)Priority.ALWAYS);
        return mainPane;
    }

    private void prepareButtonPane() {
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.setOnCloseRequest(event -> {
            if (this.commitWorker != null) {
                this.commitWorker.abort();
                this.commitAction.cancel();
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.includeLayout.setSelected(false);
            this.includeLayout.setDisable(true);
            this.changedLayoutFiles.clear();
            this.commitListModel.clear();
            this.repository = this.project.getRepository();
            if (this.repository != null) {
                block7: {
                    try {
                        this.project.saveAllEditors();
                        this.project.saveAll();
                    }
                    catch (IOException ioe) {
                        String msg = DialogManager.getMessage("team-error-saving-project", new String[0]);
                        if (msg == null) break block7;
                        String msgFinal = msg = Utility.mergeStrings(msg, ioe.getLocalizedMessage());
                        DialogManager.showErrorTextFX(this.asWindow(), msgFinal);
                    }
                }
                this.startProgress();
                this.commitWorker = new CommitWorker();
                this.commitWorker.start();
                if (!this.isShowing()) {
                    this.show();
                }
            } else {
                this.hide();
            }
        } else {
            this.hide();
        }
    }

    @Override
    public String getComment() {
        return this.commitText.getText();
    }

    public void setComment(String newComment) {
        this.commitText.setText(newComment);
    }

    @Override
    public void reset() {
        this.commitListModel.clear();
        this.setComment("");
    }

    private void removeModifiedLayouts() {
        for (TeamStatusInfo info : this.changedLayoutFiles) {
            if (this.packagesToCommmit.contains(info.getFile().getParentFile())) continue;
            this.commitListModel.remove((Object)info);
        }
    }

    private void addModifiedLayouts() {
        HashSet<File> displayedLayouts = new HashSet<File>();
        for (TeamStatusInfo info : this.changedLayoutFiles) {
            File parentFile = info.getFile().getParentFile();
            if (displayedLayouts.contains(parentFile) || this.packagesToCommmit.contains(parentFile)) continue;
            this.commitListModel.add((Object)info);
            displayedLayouts.add(info.getFile().getParentFile());
        }
    }

    @Override
    public Set<File> getChangedLayoutFiles() {
        return this.changedLayoutFiles.stream().map(TeamStatusInfo::getFile).collect(Collectors.toSet());
    }

    private void removeChangedLayoutFile(File file) {
        Iterator<TeamStatusInfo> it = this.changedLayoutFiles.iterator();
        while (it.hasNext()) {
            TeamStatusInfo info = it.next();
            if (!info.getFile().equals(file)) continue;
            it.remove();
            return;
        }
    }

    @Override
    public Set<TeamStatusInfo> getChangedLayoutInfo() {
        return this.changedLayoutFiles;
    }

    @Override
    public boolean includeLayout() {
        return this.includeLayout != null && this.includeLayout.isSelected();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void startProgress() {
        this.progressBar.setRunning(true);
    }

    @Override
    @OnThread(value=Tag.Any)
    public void stopProgress() {
        JavaFXUtil.runNowOrLater(() -> this.progressBar.setRunning(false));
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    private void setLayoutChanged(boolean hasChanged) {
        this.includeLayout.setDisable(!hasChanged);
    }

    class CommitWorker
    extends FXWorker
    implements StatusListener {
        List<TeamStatusInfo> response = new ArrayList<TeamStatusInfo>();
        TeamworkCommand command;
        TeamworkCommandResult result;
        private boolean aborted;

        public CommitWorker() {
            FileFilter filter = CommitCommentsFrame.this.project.getTeamSettingsController().getFileFilter(true, true);
            this.command = CommitCommentsFrame.this.repository.getStatus(this, filter, false);
        }

        @Override
        @OnThread(value=Tag.Any)
        public void gotStatus(TeamStatusInfo info) {
            this.response.add(info);
        }

        @Override
        @OnThread(value=Tag.Worker)
        public void statusComplete(StatusHandle statusHandle) {
            CommitCommentsFrame.this.commitAction.setStatusHandle(statusHandle);
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            this.result = this.command.getResult();
            return this.response;
        }

        @Override
        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            CommitCommentsFrame.this.stopProgress();
            if (!this.aborted) {
                if (this.result.isError()) {
                    CommitCommentsFrame.this.dialogThenHide(() -> TeamUtils.handleServerResponseFX(this.result, CommitCommentsFrame.this.asWindow()));
                } else if (this.response != null) {
                    HashSet<File> filesToCommit = new HashSet<File>();
                    LinkedHashSet<File> filesToAdd = new LinkedHashSet<File>();
                    HashSet<File> filesToDelete = new HashSet<File>();
                    HashSet<File> mergeConflicts = new HashSet<File>();
                    HashSet<File> deleteConflicts = new HashSet<File>();
                    HashSet<File> otherConflicts = new HashSet<File>();
                    HashSet<File> needsMerge = new HashSet<File>();
                    HashSet<File> modifiedLayoutFiles = new HashSet<File>();
                    List<TeamStatusInfo> info = this.response;
                    this.getCommitFileSets(info, filesToCommit, filesToAdd, filesToDelete, mergeConflicts, deleteConflicts, otherConflicts, needsMerge, modifiedLayoutFiles);
                    if (!(mergeConflicts.isEmpty() && deleteConflicts.isEmpty() && otherConflicts.isEmpty() && needsMerge.isEmpty())) {
                        this.handleConflicts(mergeConflicts, deleteConflicts, otherConflicts, needsMerge);
                        return;
                    }
                    CommitCommentsFrame.this.commitAction.setFiles(filesToCommit);
                    CommitCommentsFrame.this.commitAction.setNewFiles(filesToAdd);
                    CommitCommentsFrame.this.commitAction.setDeletedFiles(filesToDelete);
                }
                if (!CommitCommentsFrame.this.commitListModel.isEmpty()) {
                    CommitCommentsFrame.this.commitText.requestFocus();
                }
            }
        }

        private void handleConflicts(Set<File> mergeConflicts, Set<File> deleteConflicts, Set<File> otherConflicts, Set<File> needsMerge) {
            String filesList;
            String dlgLabel;
            if (!mergeConflicts.isEmpty()) {
                dlgLabel = "team-resolve-merge-conflicts";
                filesList = this.buildConflictsList(mergeConflicts);
            } else if (!deleteConflicts.isEmpty()) {
                dlgLabel = "team-resolve-conflicts-delete";
                filesList = this.buildConflictsList(deleteConflicts);
            } else if (!otherConflicts.isEmpty()) {
                dlgLabel = "team-update-first";
                filesList = this.buildConflictsList(otherConflicts);
            } else {
                CommitCommentsFrame.this.stopProgress();
                CommitCommentsFrame.this.dialogThenHide(() -> DialogManager.showMessageFX(CommitCommentsFrame.this.asWindow(), "team-uptodate-failed"));
                return;
            }
            CommitCommentsFrame.this.stopProgress();
            CommitCommentsFrame.this.dialogThenHide(() -> DialogManager.showMessageWithTextFX(CommitCommentsFrame.this.asWindow(), dlgLabel, filesList));
        }

        private String buildConflictsList(Set<File> conflicts) {
            String filesList = "";
            Iterator<File> i = conflicts.iterator();
            for (int j = 0; j < 10 && i.hasNext(); ++j) {
                File conflictFile = i.next();
                filesList = filesList + "    " + conflictFile.getName() + "\n";
            }
            if (i.hasNext()) {
                filesList = filesList + "    " + Config.getString("team.commit.moreFiles");
            }
            return filesList;
        }

        private void getCommitFileSets(List<TeamStatusInfo> info, Set<File> filesToCommit, Set<File> filesToAdd, Set<File> filesToRemove, Set<File> mergeConflicts, Set<File> deleteConflicts, Set<File> otherConflicts, Set<File> needsMerge, Set<File> modifiedLayoutFiles) {
            CommitFilter filter = new CommitFilter();
            HashMap<File, File> modifiedLayoutDirs = new HashMap<File, File>();
            for (TeamStatusInfo statusInfo : info) {
                File file = statusInfo.getFile();
                boolean isPkgFile = BlueJPackageFile.isPackageFileName(file.getName());
                TeamStatusInfo.Status status = statusInfo.getStatus();
                if (filter.accept(statusInfo, true)) {
                    if (!isPkgFile) {
                        CommitCommentsFrame.this.commitListModel.add((Object)statusInfo);
                        filesToCommit.add(file);
                    } else if (status == TeamStatusInfo.Status.NEEDS_ADD || status == TeamStatusInfo.Status.DELETED || status == TeamStatusInfo.Status.CONFLICT_LDRM) {
                        if (CommitCommentsFrame.this.packagesToCommmit.add(statusInfo.getFile().getParentFile())) {
                            CommitCommentsFrame.this.commitListModel.add((Object)statusInfo);
                            File otherPkgFile = (File)modifiedLayoutDirs.remove(file.getParentFile());
                            if (otherPkgFile != null) {
                                CommitCommentsFrame.this.removeChangedLayoutFile(otherPkgFile);
                                filesToCommit.add(otherPkgFile);
                            }
                        }
                        filesToCommit.add(statusInfo.getFile());
                    } else {
                        File parentFile = file.getParentFile();
                        if (!CommitCommentsFrame.this.packagesToCommmit.contains(parentFile)) {
                            modifiedLayoutFiles.add(file);
                            modifiedLayoutDirs.put(parentFile, file);
                            CommitCommentsFrame.this.changedLayoutFiles.add(statusInfo);
                        } else {
                            filesToCommit.add(file);
                        }
                    }
                    if (status == TeamStatusInfo.Status.NEEDS_ADD) {
                        filesToAdd.add(statusInfo.getFile());
                        continue;
                    }
                    if (status != TeamStatusInfo.Status.DELETED && status != TeamStatusInfo.Status.CONFLICT_LDRM) continue;
                    filesToRemove.add(statusInfo.getFile());
                    continue;
                }
                if (isPkgFile) continue;
                if (status == TeamStatusInfo.Status.HAS_CONFLICTS) {
                    mergeConflicts.add(statusInfo.getFile());
                }
                if (status == TeamStatusInfo.Status.UNRESOLVED || status == TeamStatusInfo.Status.CONFLICT_ADD || status == TeamStatusInfo.Status.CONFLICT_LMRD) {
                    deleteConflicts.add(statusInfo.getFile());
                }
                if (status == TeamStatusInfo.Status.CONFLICT_LDRM) {
                    otherConflicts.add(statusInfo.getFile());
                }
                if (status != TeamStatusInfo.Status.NEEDS_MERGE) continue;
                needsMerge.add(statusInfo.getFile());
            }
            CommitCommentsFrame.this.setLayoutChanged(!CommitCommentsFrame.this.changedLayoutFiles.isEmpty());
        }
    }
}

