/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.CommitFilter;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.CommitAction;
import bluej.groupwork.actions.PushAction;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.CommitAndPushInterface;
import bluej.groupwork.ui.TeamStatusInfoCell;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.DialogManager;
import bluej.utility.FXWorker;
import bluej.utility.Utility;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class CommitAndPushFrame
extends FXCustomizedDialog<Void>
implements CommitAndPushInterface {
    private final Project project;
    private Repository repository;
    private Set<TeamStatusInfo> changedLayoutFiles = new HashSet<TeamStatusInfo>();
    private ObservableList<TeamStatusInfo> commitListModel = FXCollections.observableArrayList();
    private ObservableList<TeamStatusInfo> pushListModel = FXCollections.observableArrayList();
    private final CheckBox includeLayout = new CheckBox(Config.getString("team.commit.includelayout"));
    private final TextArea commitText = new TextArea();
    private final ActivityIndicator progressBar = new ActivityIndicator();
    private final ListView<TeamStatusInfo> pushFiles = new ListView(this.pushListModel);
    private CommitAction commitAction;
    private PushAction pushAction;
    private CommitAndPushWorker commitAndPushWorker;
    private boolean pushWithNoChanges = false;

    public CommitAndPushFrame(Project proj, Window owner) {
        super(owner, "team.commit.dcvs.title", "team-commit-push");
        this.project = proj;
        this.repository = this.project.getTeamSettingsController().trytoEstablishRepository(false);
        this.getDialogPane().setContent((Node)this.makeMainPane());
        this.prepareButtonPane();
        DialogManager.centreDialog(this);
    }

    private Pane makeMainPane() {
        ListView commitFiles = new ListView(this.commitListModel);
        commitFiles.setPlaceholder((Node)new Label(Config.getString("team.nocommitfiles")));
        commitFiles.setCellFactory(param -> new TeamStatusInfoCell(this.project));
        commitFiles.setDisable(true);
        ScrollPane commitFileScrollPane = new ScrollPane((Node)commitFiles);
        commitFileScrollPane.setFitToWidth(true);
        commitFileScrollPane.setFitToHeight(true);
        VBox.setMargin((Node)commitFileScrollPane, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
        this.commitText.setPrefRowCount(20);
        this.commitText.setPrefColumnCount(35);
        VBox.setMargin((Node)this.commitText, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        this.commitAction = new CommitAction(this);
        Button commitButton = new Button();
        this.commitAction.useButton(PkgMgrFrame.getMostRecent(), (ButtonBase)commitButton);
        commitButton.requestFocus();
        this.commitText.disableProperty().bind((ObservableValue)Bindings.isEmpty(this.commitListModel));
        this.commitAction.disabledProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)this.commitText.disabledProperty(), (ObservableBooleanValue)this.commitText.textProperty().isEmpty()));
        this.includeLayout.setOnAction(event -> {
            CheckBox layoutCheck = (CheckBox)event.getSource();
            if (layoutCheck.isSelected()) {
                this.addModifiedLayouts();
            } else {
                this.removeModifiedLayouts();
            }
        });
        this.includeLayout.setDisable(true);
        HBox commitButtonPane = new HBox();
        JavaFXUtil.addStyleClass((Styleable)commitButtonPane, "button-hbox");
        commitButtonPane.setAlignment(Pos.CENTER_RIGHT);
        commitButtonPane.getChildren().addAll((Object[])new Node[]{this.includeLayout, commitButton});
        this.pushAction = new PushAction(this);
        Button pushButton = new Button();
        this.pushAction.useButton(PkgMgrFrame.getMostRecent(), (ButtonBase)pushButton);
        Label pushFilesLabel = new Label(Config.getString("team.commitPush.push.files"));
        this.pushFiles.setCellFactory(param -> new TeamStatusInfoCell(this.project));
        this.pushFiles.setDisable(true);
        ScrollPane pushFileScrollPane = new ScrollPane(this.pushFiles);
        pushFileScrollPane.setFitToWidth(true);
        pushFileScrollPane.setFitToHeight(true);
        HBox pushButtonPane = new HBox();
        this.progressBar.setRunning(false);
        JavaFXUtil.addStyleClass((Styleable)pushButtonPane, "button-hbox");
        pushButtonPane.setAlignment(Pos.CENTER_RIGHT);
        pushButtonPane.getChildren().addAll((Object[])new Node[]{this.progressBar, pushButton});
        VBox mainPane = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPane, "main-pane");
        mainPane.getChildren().addAll((Object[])new Node[]{new Label(Config.getString("team.commitPush.commit.files")), commitFileScrollPane, new Label(Config.getString("team.commit.comment")), this.commitText, commitButtonPane, new Separator(Orientation.HORIZONTAL), pushFilesLabel, pushFileScrollPane, pushButtonPane});
        return mainPane;
    }

    private void prepareButtonPane() {
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.setOnCloseRequest(event -> {
            if (this.commitAndPushWorker != null) {
                this.commitAndPushWorker.abort();
            }
            if (this.commitAction != null) {
                this.commitAction.cancel();
            }
            this.close();
        });
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setVisible(boolean show) {
        if (show) {
            this.commitText.setText("");
            this.includeLayout.setSelected(false);
            this.includeLayout.setDisable(true);
            this.changedLayoutFiles.clear();
            this.commitListModel.clear();
            this.pushAction.setEnabled(false);
            this.pushListModel.clear();
            this.repository = this.project.getTeamSettingsController().trytoEstablishRepository(false);
            if (this.repository != null) {
                block7: {
                    try {
                        this.project.saveAllEditors();
                        this.project.saveAll();
                    }
                    catch (IOException ioe) {
                        String msg = DialogManager.getMessage("team-error-saving-project", new String[0]);
                        if (msg == null) break block7;
                        String msgFinal = msg = Utility.mergeStrings(msg, ioe.getLocalizedMessage());
                        DialogManager.showErrorTextFX(this.asWindow(), msgFinal);
                    }
                }
                this.startProgress();
                this.commitAndPushWorker = new CommitAndPushWorker();
                this.commitAndPushWorker.start();
                if (!this.isShowing()) {
                    this.show();
                }
            } else {
                this.hide();
            }
        } else {
            this.hide();
        }
    }

    public void setComment(String newComment) {
        this.commitText.setText(newComment);
    }

    @Override
    public void reset() {
        this.commitListModel.clear();
        this.pushListModel.clear();
        this.setComment("");
        this.progressBar.setMessage("");
    }

    private void removeModifiedLayouts() {
        this.commitListModel.removeAll(this.changedLayoutFiles);
    }

    @Override
    public String getComment() {
        return this.commitText.getText();
    }

    @Override
    public Set<File> getChangedLayoutFiles() {
        return this.changedLayoutFiles.stream().map(info -> info.getFile()).collect(Collectors.toSet());
    }

    private void removeChangedLayoutFile(File file) {
        this.changedLayoutFiles.removeIf(info -> info.getFile().equals(file));
    }

    @Override
    public Set<TeamStatusInfo> getChangedLayoutInfo() {
        return this.changedLayoutFiles;
    }

    @Override
    public boolean includeLayout() {
        return this.includeLayout != null && this.includeLayout.isSelected();
    }

    private void addModifiedLayouts() {
        HashSet<File> displayedLayouts = new HashSet<File>();
        for (TeamStatusInfo info : this.changedLayoutFiles) {
            File parentFile = info.getFile().getParentFile();
            if (displayedLayouts.contains(parentFile)) continue;
            this.commitListModel.add((Object)info);
            displayedLayouts.add(info.getFile().getParentFile());
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void startProgress() {
        this.progressBar.setRunning(true);
    }

    @Override
    @OnThread(value=Tag.Any)
    public void stopProgress() {
        JavaFXUtil.runNowOrLater(() -> this.progressBar.setRunning(false));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Project getProject() {
        return this.project;
    }

    private void setLayoutChanged(boolean hasChanged) {
        this.includeLayout.setDisable(!hasChanged);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void displayMessage(String msg) {
        this.progressBar.setMessage(msg);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Window asWindow() {
        Scene scene = this.getDialogPane().getScene();
        if (scene == null) {
            return null;
        }
        return scene.getWindow();
    }

    public List<File> getFilesToPush() {
        return Utility.mapList(this.pushListModel, s -> s.getFile());
    }

    class CommitAndPushWorker
    extends FXWorker
    implements StatusListener {
        List<TeamStatusInfo> response = new ArrayList<TeamStatusInfo>();
        TeamworkCommand command;
        TeamworkCommandResult result;
        private boolean aborted;
        private boolean isPushAvailable;

        public CommitAndPushWorker() {
            FileFilter filter = CommitAndPushFrame.this.project.getTeamSettingsController().getFileFilter(true, false);
            this.command = CommitAndPushFrame.this.repository.getStatus(this, filter, false);
        }

        public boolean isPushAvailable() {
            return this.isPushAvailable;
        }

        @Override
        @OnThread(value=Tag.Any)
        public void gotStatus(TeamStatusInfo info) {
            this.response.add(info);
        }

        @Override
        @OnThread(value=Tag.Worker)
        public void statusComplete(StatusHandle statusHandle) {
            CommitAndPushFrame.this.commitAction.setStatusHandle(statusHandle);
            CommitAndPushFrame.this.pushWithNoChanges = statusHandle.pushNeeded();
            CommitAndPushFrame.this.pushAction.setStatusHandle(statusHandle);
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            this.result = this.command.getResult();
            return this.response;
        }

        @Override
        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            CommitAndPushFrame.this.stopProgress();
            if (!this.aborted) {
                if (this.result.isError()) {
                    TeamUtils.handleServerResponseFX(this.result, CommitAndPushFrame.this.asWindow());
                    CommitAndPushFrame.this.hide();
                } else if (this.response != null) {
                    boolean conflicts;
                    HashSet<File> filesToCommit = new HashSet<File>();
                    LinkedHashSet<File> filesToAdd = new LinkedHashSet<File>();
                    HashSet<File> filesToDelete = new HashSet<File>();
                    HashSet<File> mergeConflicts = new HashSet<File>();
                    HashSet<File> deleteConflicts = new HashSet<File>();
                    HashSet<File> otherConflicts = new HashSet<File>();
                    HashSet<File> needsMerge = new HashSet<File>();
                    HashSet<File> modifiedLayoutFiles = new HashSet<File>();
                    List<TeamStatusInfo> info = this.response;
                    this.getCommitFileSets(info, filesToCommit, filesToAdd, filesToDelete, mergeConflicts, deleteConflicts, otherConflicts, needsMerge, modifiedLayoutFiles, false);
                    if (!(mergeConflicts.isEmpty() && deleteConflicts.isEmpty() && otherConflicts.isEmpty() && needsMerge.isEmpty())) {
                        this.handleConflicts(mergeConflicts, deleteConflicts, otherConflicts, needsMerge);
                        return;
                    }
                    CommitAndPushFrame.this.commitAction.setFiles(filesToCommit);
                    CommitAndPushFrame.this.commitAction.setNewFiles(filesToAdd);
                    CommitAndPushFrame.this.commitAction.setDeletedFiles(filesToDelete);
                    this.updateListModel((ObservableList<TeamStatusInfo>)CommitAndPushFrame.this.commitListModel, filesToCommit, info);
                    this.updateListModel((ObservableList<TeamStatusInfo>)CommitAndPushFrame.this.commitListModel, filesToAdd, info);
                    this.updateListModel((ObservableList<TeamStatusInfo>)CommitAndPushFrame.this.commitListModel, filesToDelete, info);
                    HashSet<File> filesToCommitInPush = new HashSet<File>();
                    HashSet<File> filesToAddInPush = new HashSet<File>();
                    HashSet<File> filesToDeleteInPush = new HashSet<File>();
                    HashSet<File> mergeConflictsInPush = new HashSet<File>();
                    HashSet<File> deleteConflictsInPush = new HashSet<File>();
                    HashSet<File> otherConflictsInPush = new HashSet<File>();
                    HashSet<File> needsMergeInPush = new HashSet<File>();
                    HashSet<File> modifiedLayoutFilesInPush = new HashSet<File>();
                    this.getCommitFileSets(info, filesToCommitInPush, filesToAddInPush, filesToDeleteInPush, mergeConflictsInPush, deleteConflictsInPush, otherConflictsInPush, needsMergeInPush, modifiedLayoutFilesInPush, true);
                    this.updateListModel((ObservableList<TeamStatusInfo>)CommitAndPushFrame.this.pushListModel, filesToCommitInPush, info);
                    this.updateListModel((ObservableList<TeamStatusInfo>)CommitAndPushFrame.this.pushListModel, filesToAddInPush, info);
                    this.updateListModel((ObservableList<TeamStatusInfo>)CommitAndPushFrame.this.pushListModel, filesToDeleteInPush, info);
                    this.updateListModel((ObservableList<TeamStatusInfo>)CommitAndPushFrame.this.pushListModel, modifiedLayoutFilesInPush, info);
                    this.isPushAvailable = CommitAndPushFrame.this.pushWithNoChanges || !filesToCommitInPush.isEmpty() || !filesToAddInPush.isEmpty() || !filesToDeleteInPush.isEmpty() || !modifiedLayoutFilesInPush.isEmpty();
                    CommitAndPushFrame.this.pushAction.setEnabled(this.isPushAvailable);
                    boolean bl = conflicts = !mergeConflictsInPush.isEmpty() || !deleteConflictsInPush.isEmpty() || !otherConflictsInPush.isEmpty() || !needsMergeInPush.isEmpty();
                    if (CommitAndPushFrame.this.commitAction.isDisabled() && conflicts) {
                        HashSet<File> conflictingFilesInPush = new HashSet<File>();
                        conflictingFilesInPush.addAll(mergeConflictsInPush);
                        conflictingFilesInPush.addAll(deleteConflictsInPush);
                        conflictingFilesInPush.addAll(otherConflictsInPush);
                        conflictingFilesInPush.addAll(needsMergeInPush);
                        for (File conflictEntry : conflictingFilesInPush) {
                            if (filesToCommit.contains(conflictEntry)) {
                                conflictingFilesInPush.remove(conflictEntry);
                                mergeConflictsInPush.remove(conflictEntry);
                                deleteConflictsInPush.remove(conflictEntry);
                                otherConflictsInPush.remove(conflictEntry);
                                needsMergeInPush.remove(conflictEntry);
                            }
                            if (filesToAdd.contains(conflictEntry)) {
                                conflictingFilesInPush.remove(conflictEntry);
                                mergeConflictsInPush.remove(conflictEntry);
                                deleteConflictsInPush.remove(conflictEntry);
                                otherConflictsInPush.remove(conflictEntry);
                                needsMergeInPush.remove(conflictEntry);
                            }
                            if (!filesToDelete.contains(conflictEntry)) continue;
                            conflictingFilesInPush.remove(conflictEntry);
                            mergeConflictsInPush.remove(conflictEntry);
                            deleteConflictsInPush.remove(conflictEntry);
                            otherConflictsInPush.remove(conflictEntry);
                            needsMergeInPush.remove(conflictEntry);
                        }
                        boolean bl2 = conflicts = !conflictingFilesInPush.isEmpty();
                    }
                    if (CommitAndPushFrame.this.commitAction.isDisabled() && conflicts) {
                        this.handleConflicts(mergeConflictsInPush, deleteConflictsInPush, otherConflictsInPush, null);
                        return;
                    }
                }
                if (!CommitAndPushFrame.this.commitListModel.isEmpty()) {
                    CommitAndPushFrame.this.commitText.requestFocus();
                }
                if (CommitAndPushFrame.this.pushListModel.isEmpty()) {
                    if (this.isPushAvailable) {
                        CommitAndPushFrame.this.pushFiles.setPlaceholder((Node)new Label(Config.getString("team.pushNeeded")));
                    } else {
                        CommitAndPushFrame.this.pushFiles.setPlaceholder((Node)new Label(Config.getString("team.nopushfiles")));
                    }
                }
            }
        }

        private void handleConflicts(Set<File> mergeConflicts, Set<File> deleteConflicts, Set<File> otherConflicts, Set<File> needsMerge) {
            String filesList;
            String dlgLabel;
            if (!mergeConflicts.isEmpty()) {
                dlgLabel = "team-resolve-merge-conflicts";
                filesList = this.buildConflictsList(mergeConflicts);
            } else if (!deleteConflicts.isEmpty()) {
                dlgLabel = "team-resolve-conflicts-delete";
                filesList = this.buildConflictsList(deleteConflicts);
            } else if (!otherConflicts.isEmpty()) {
                dlgLabel = "team-update-first";
                filesList = this.buildConflictsList(otherConflicts);
            } else {
                CommitAndPushFrame.this.stopProgress();
                DialogManager.showMessageFX(CommitAndPushFrame.this.asWindow(), "team-uptodate-failed");
                CommitAndPushFrame.this.hide();
                return;
            }
            CommitAndPushFrame.this.stopProgress();
            DialogManager.showMessageWithTextFX(CommitAndPushFrame.this.asWindow(), dlgLabel, filesList);
            CommitAndPushFrame.this.hide();
        }

        private String buildConflictsList(Set<File> conflicts) {
            String filesList = "";
            Iterator<File> i = conflicts.iterator();
            for (int j = 0; j < 10 && i.hasNext(); ++j) {
                File conflictFile = i.next();
                filesList = filesList + "    " + conflictFile.getName() + "\n";
            }
            if (i.hasNext()) {
                filesList = filesList + "    " + Config.getString("team.commit.moreFiles");
            }
            return filesList;
        }

        private void getCommitFileSets(List<TeamStatusInfo> info, Set<File> filesToCommit, Set<File> filesToAdd, Set<File> filesToRemove, Set<File> mergeConflicts, Set<File> deleteConflicts, Set<File> otherConflicts, Set<File> needsMerge, Set<File> modifiedLayoutFiles, boolean remote) {
            CommitFilter filter = new CommitFilter();
            HashMap<File, File> modifiedLayoutDirs = new HashMap<File, File>();
            for (TeamStatusInfo statusInfo : info) {
                File file = statusInfo.getFile();
                boolean isPkgFile = BlueJPackageFile.isPackageFileName(file.getName());
                TeamStatusInfo.Status status = statusInfo.getStatus(!remote);
                if (filter.accept(statusInfo, !remote)) {
                    if (!isPkgFile) {
                        filesToCommit.add(file);
                    } else if (status == TeamStatusInfo.Status.NEEDS_ADD || status == TeamStatusInfo.Status.DELETED || status == TeamStatusInfo.Status.CONFLICT_LDRM) {
                        filesToCommit.add(file);
                    } else {
                        File parentFile = file.getParentFile();
                        if (!modifiedLayoutDirs.containsKey(parentFile)) {
                            modifiedLayoutFiles.add(file);
                            modifiedLayoutDirs.put(parentFile, file);
                            CommitAndPushFrame.this.changedLayoutFiles.add(statusInfo);
                        } else {
                            filesToCommit.add(file);
                        }
                    }
                    if (status == TeamStatusInfo.Status.NEEDS_ADD) {
                        filesToAdd.add(file);
                        continue;
                    }
                    if (status != TeamStatusInfo.Status.DELETED && status != TeamStatusInfo.Status.CONFLICT_LDRM) continue;
                    filesToRemove.add(file);
                    continue;
                }
                if (isPkgFile) continue;
                if (status == TeamStatusInfo.Status.HAS_CONFLICTS) {
                    mergeConflicts.add(file);
                }
                if (status == TeamStatusInfo.Status.UNRESOLVED || status == TeamStatusInfo.Status.CONFLICT_ADD || status == TeamStatusInfo.Status.CONFLICT_LMRD) {
                    deleteConflicts.add(file);
                }
                if (status == TeamStatusInfo.Status.CONFLICT_LDRM) {
                    otherConflicts.add(file);
                }
                if (status != TeamStatusInfo.Status.NEEDS_MERGE) continue;
                needsMerge.add(file);
            }
            if (!remote) {
                CommitAndPushFrame.this.setLayoutChanged(!CommitAndPushFrame.this.changedLayoutFiles.isEmpty());
            }
        }

        private void updateListModel(ObservableList<TeamStatusInfo> listModel, Set<File> fileSet, List<TeamStatusInfo> info) {
            listModel.addAll((Collection)fileSet.stream().map(file -> this.getTeamStatusInfoFromFile((File)file, info)).filter(Objects::nonNull).filter(statusInfo -> !listModel.contains(statusInfo)).collect(Collectors.toList()));
        }

        private TeamStatusInfo getTeamStatusInfoFromFile(File file, List<TeamStatusInfo> infoList) {
            Optional<TeamStatusInfo> statusInfo = infoList.stream().filter(info -> info.getFile().equals(file)).findFirst();
            return statusInfo.isPresent() ? statusInfo.get() : null;
        }
    }
}

