/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnRepository;
import bluej.groupwork.svn.SvnStatusHandle;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.StatusCallback;
import threadchecker.OnThread;
import threadchecker.Tag;

public class SvnStatusCommand
extends SvnCommand {
    private StatusListener listener;
    private FileFilter filter;
    private long currentRevision = -1L;

    public SvnStatusCommand(SvnRepository repository, StatusListener listener, FileFilter filter, boolean includeRemote) {
        super(repository);
        this.listener = listener;
        this.filter = filter;
    }

    @Override
    @OnThread(value=Tag.Worker)
    protected TeamworkCommandResult doCommand() {
        SVNClientInterface client = this.getClient();
        File projectPath = this.getRepository().getProjectPath().getAbsoluteFile();
        try {
            final LinkedList statusList = new LinkedList();
            client.status(projectPath.getAbsolutePath(), 3, true, true, false, false, new String[0], new StatusCallback(){

                public void doStatus(Status arg0) {
                    statusList.add(arg0);
                }
            });
            Status[] status = statusList.toArray(new Status[statusList.size()]);
            HashSet<File> completed = new HashSet<File>();
            HashMap<File, Set<TeamStatusInfo>> unreported = new HashMap<File, Set<TeamStatusInfo>>();
            for (int i = 0; i < status.length; ++i) {
                String rev;
                File file = new File(status[i].getPath());
                int textStat = status[i].getTextStatus();
                int reposStat = status[i].getRepositoryTextStatus();
                long reposRev = status[i].getReposLastCmtRevisionNumber();
                if (reposRev > this.currentRevision) {
                    this.currentRevision = reposRev;
                }
                TeamStatusInfo rinfo = null;
                if (textStat == 6 || textStat == 4) {
                    rev = "" + status[i].getLastChangedRevisionNumber();
                    rinfo = reposStat == 2 ? new TeamStatusInfo(file, rev, "" + reposRev, TeamStatusInfo.Status.CONFLICT_LDRM) : new TeamStatusInfo(file, rev, "", TeamStatusInfo.Status.DELETED);
                } else if (textStat == 5 || textStat == 0 && reposStat == 0) {
                    if (this.filter.accept(file)) {
                        if (reposStat != 3) {
                            rinfo = new TeamStatusInfo(file, "", "", TeamStatusInfo.Status.NEEDS_ADD);
                            if (file.isDirectory()) {
                                this.statLocalDir(file);
                            }
                        } else {
                            rinfo = new TeamStatusInfo(file, "", "" + status[i].getReposLastCmtRevisionNumber(), TeamStatusInfo.Status.CONFLICT_ADD);
                        }
                    }
                } else if (textStat == 1) {
                    if (reposStat == 0 && status[i].getRevisionNumber() == -1L) {
                        rinfo = new TeamStatusInfo(file, "", "", TeamStatusInfo.Status.NEEDS_COMMIT);
                    } else if (this.filter.accept(file)) {
                        rev = "" + status[i].getLastChangedRevisionNumber();
                        rinfo = reposStat == 4 ? new TeamStatusInfo(file, rev, "", TeamStatusInfo.Status.REMOVED) : (reposStat == 0 && !file.exists() ? new TeamStatusInfo(file, rev, "", TeamStatusInfo.Status.DELETED) : (reposStat == 2 ? new TeamStatusInfo(file, rev, "" + status[i].getReposLastCmtRevisionNumber(), TeamStatusInfo.Status.NEEDS_UPDATE) : new TeamStatusInfo(file, rev, rev, TeamStatusInfo.Status.UP_TO_DATE)));
                    }
                } else if (textStat == 2) {
                    if (this.filter.accept(file)) {
                        rev = "" + status[i].getLastChangedRevisionNumber();
                        rinfo = reposStat == 4 ? new TeamStatusInfo(file, rev, "", TeamStatusInfo.Status.CONFLICT_LMRD) : (reposStat == 2 ? new TeamStatusInfo(file, rev, "", TeamStatusInfo.Status.NEEDS_MERGE) : new TeamStatusInfo(file, rev, rev, TeamStatusInfo.Status.NEEDS_COMMIT));
                    }
                } else if (textStat == 0) {
                    if (reposStat == 3) {
                        rinfo = new TeamStatusInfo(file, "", "" + reposRev, TeamStatusInfo.Status.NEEDS_CHECKOUT);
                    }
                } else if (textStat == 3) {
                    rinfo = new TeamStatusInfo(file, "", "", TeamStatusInfo.Status.NEEDS_COMMIT);
                }
                if (rinfo == null) continue;
                if (!file.exists()) {
                    this.listener.gotStatus(rinfo);
                    continue;
                }
                if (completed.contains(file.getParentFile()) || file.equals(projectPath)) {
                    this.complete(completed, unreported, rinfo);
                    continue;
                }
                HashSet<TeamStatusInfo> s = (HashSet<TeamStatusInfo>)unreported.get(file.getParentFile());
                if (s == null) {
                    s = new HashSet<TeamStatusInfo>();
                }
                s.add(rinfo);
                unreported.put(file.getParentFile(), s);
            }
            this.listener.statusComplete(new SvnStatusHandle(this.getRepository(), this.currentRevision));
            return new TeamworkCommandResult();
        }
        catch (ClientException ce) {
            if (!this.isCancelled()) {
                Debug.reportError("Subversion status command exception", ce);
                return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
            }
            return new TeamworkCommandAborted();
        }
    }

    @OnThread(value=Tag.Worker)
    private void statLocalDir(File dir) {
        File[] subFiles = dir.listFiles(this.filter);
        for (int i = 0; i < subFiles.length; ++i) {
            this.listener.gotStatus(new TeamStatusInfo(subFiles[i], "", "", TeamStatusInfo.Status.NEEDS_ADD));
            if (!subFiles[i].isDirectory()) continue;
            this.statLocalDir(subFiles[i]);
        }
    }

    @OnThread(value=Tag.Worker)
    private void complete(Set<File> completed, Map<File, Set<TeamStatusInfo>> unreported, TeamStatusInfo rinfo) {
        this.listener.gotStatus(rinfo);
        TeamStatusInfo.Status rinfoStat = rinfo.getStatus();
        File file = rinfo.getFile();
        if (file.isDirectory()) {
            completed.add(file);
            Set<TeamStatusInfo> entries = unreported.remove(file);
            if (entries == null) {
                entries = Collections.emptySet();
            }
            for (TeamStatusInfo status : entries) {
                TeamStatusInfo.Status einfoStat = status.getStatus();
                if (rinfoStat == TeamStatusInfo.Status.CONFLICT_LMRD || rinfoStat == TeamStatusInfo.Status.REMOVED) {
                    if (einfoStat == TeamStatusInfo.Status.DELETED || einfoStat == TeamStatusInfo.Status.NEEDS_CHECKOUT) continue;
                    if (einfoStat == TeamStatusInfo.Status.NEEDS_ADD) {
                        einfoStat = TeamStatusInfo.Status.CONFLICT_LMRD;
                    } else if (einfoStat == TeamStatusInfo.Status.NEEDS_COMMIT) {
                        einfoStat = TeamStatusInfo.Status.CONFLICT_LMRD;
                    } else if (einfoStat == TeamStatusInfo.Status.NEEDS_MERGE) {
                        einfoStat = TeamStatusInfo.Status.CONFLICT_LMRD;
                    } else if (einfoStat == TeamStatusInfo.Status.NEEDS_UPDATE) {
                        einfoStat = TeamStatusInfo.Status.REMOVED;
                    } else if (einfoStat == TeamStatusInfo.Status.UP_TO_DATE) {
                        einfoStat = TeamStatusInfo.Status.REMOVED;
                    }
                    this.complete(completed, unreported, new TeamStatusInfo(status.getFile(), status.getLocalVersion(), status.getRepositoryVersion(), einfoStat));
                    continue;
                }
                this.complete(completed, unreported, status);
            }
        }
    }
}

