/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.Config;
import bluej.groupwork.git.GitTreeException;
import bluej.utility.Debug;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GitUtilities {
    public static RevTree getTree(Repository repo, ObjectId objID) throws IncorrectObjectTypeException, IOException {
        RevTree tree;
        try (RevWalk walk = new RevWalk(repo);){
            RevCommit commit = walk.parseCommit((AnyObjectId)objID);
            tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
        }
        return tree;
    }

    public static List<DiffEntry> getDiffs(Git repo, String masterString, RevCommit forkPoint) {
        ArrayList<DiffEntry> diffs;
        block16: {
            if (forkPoint == null) {
                return Collections.emptyList();
            }
            diffs = new ArrayList<DiffEntry>();
            try {
                ObjectId master = repo.getRepository().resolve(masterString);
                RevTree masterTree = GitUtilities.getTree(repo.getRepository(), master);
                ObjectId branchBId = repo.getRepository().resolve(forkPoint.getName());
                RevTree ForkTree = GitUtilities.getTree(repo.getRepository(), branchBId);
                if (ForkTree == null) break block16;
                try (ObjectReader reader = repo.getRepository().newObjectReader();){
                    CanonicalTreeParser masterTreeIter = new CanonicalTreeParser();
                    masterTreeIter.reset(reader, (AnyObjectId)masterTree);
                    CanonicalTreeParser forkTreeIter = new CanonicalTreeParser();
                    forkTreeIter.reset(reader, (AnyObjectId)ForkTree);
                    DiffFormatter df = new DiffFormatter((OutputStream)new ByteArrayOutputStream());
                    df.setRepository(repo.getRepository());
                    List entries = df.scan((AbstractTreeIterator)forkTreeIter, (AbstractTreeIterator)masterTreeIter);
                    entries.stream().forEach(entry -> diffs.add((DiffEntry)entry));
                }
            }
            catch (IncorrectObjectTypeException ex) {
                Debug.reportError(ex.getMessage());
            }
            catch (IOException | RevisionSyntaxException ex) {
                Debug.reportError(ex.getMessage());
            }
        }
        return diffs;
    }

    public static RevCommit findForkPoint(Repository repository, String base, String tip) throws IOException {
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit tipCommit = walk.lookupCommit((AnyObjectId)repository.resolve(tip));
            ReflogReader reflogReader = repository.getReflogReader(base);
            if (reflogReader == null) {
                RevCommit revCommit = null;
                return revCommit;
            }
            List reflog = reflogReader.getReverseEntries();
            if (reflog.isEmpty()) {
                RevCommit revCommit = null;
                return revCommit;
            }
            for (int i = 0; i <= reflog.size(); ++i) {
                ObjectId id = i < reflog.size() ? ((ReflogEntry)reflog.get(i)).getNewId() : ((ReflogEntry)reflog.get(i - 1)).getOldId();
                RevCommit commit = walk.lookupCommit((AnyObjectId)id);
                if (!walk.isMergedInto(commit, tipCommit)) continue;
                walk.parseBody((RevObject)commit);
                RevCommit revCommit = commit;
                return revCommit;
            }
        }
        return null;
    }

    public static String getFileNameFromDiff(DiffEntry entry) {
        if (entry == null) {
            return "";
        }
        String result = entry.getChangeType() != DiffEntry.ChangeType.DELETE ? entry.getNewPath() : entry.getOldPath();
        return result;
    }

    public static DiffEntry getDiffFromList(DiffEntry entry, List<DiffEntry> list) {
        File entryFile = new File(GitUtilities.getFileNameFromDiff(entry));
        return GitUtilities.getDiffFromList(entryFile, list);
    }

    @OnThread(value=Tag.Any)
    public static DiffEntry getDiffFromList(File entryFile, List<DiffEntry> list) {
        for (DiffEntry e : list) {
            File fe = new File(GitUtilities.getFileNameFromDiff(e));
            if (!entryFile.equals(fe)) continue;
            return e;
        }
        return null;
    }

    public static boolean isAheadOnly(Git repo) throws IOException {
        BranchTrackingStatus bts = BranchTrackingStatus.of((Repository)repo.getRepository(), (String)repo.getRepository().getBranch());
        if (bts == null) {
            return false;
        }
        int aheadCount = bts.getAheadCount();
        int behindCount = bts.getBehindCount();
        return behindCount == 0 && aheadCount > 0;
    }

    public static int getAheadCount(Git repo) throws IOException, GitTreeException {
        BranchTrackingStatus bts = BranchTrackingStatus.of((Repository)repo.getRepository(), (String)repo.getRepository().getBranch());
        if (bts == null) {
            throw new GitTreeException(Config.getString("team.error.noHeadBranch"));
        }
        int aheadCount = bts.getAheadCount();
        return aheadCount;
    }

    public static boolean isBehindOnly(Git repo) throws IOException {
        BranchTrackingStatus bts = BranchTrackingStatus.of((Repository)repo.getRepository(), (String)repo.getRepository().getBranch());
        if (bts == null) {
            return false;
        }
        int aheadCount = bts.getAheadCount();
        int behindCount = bts.getBehindCount();
        return aheadCount == 0 && behindCount > 0;
    }

    public static int getBehindCount(Git repo) throws IOException, GitTreeException {
        BranchTrackingStatus bts = BranchTrackingStatus.of((Repository)repo.getRepository(), (String)repo.getRepository().getBranch());
        if (bts == null) {
            return 0;
        }
        int behindCount = bts.getBehindCount();
        return behindCount;
    }
}

