/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitRepository;
import bluej.utility.DialogManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;

public class GitPushChangesCommand
extends GitCommand {
    public GitPushChangesCommand(GitRepository repository) {
        super(repository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TeamworkCommandResult getResult() {
        try (Git repo = Git.open((File)this.getRepository().getProjectPath());){
            RemoteRefUpdate remoteRefUpdate;
            PushCommand push = repo.push();
            this.disableFingerprintCheck((TransportCommand)push);
            Iterable pushResults = push.call();
            Iterator iterator = pushResults.iterator();
            block17: while (true) {
                if (!iterator.hasNext()) return new TeamworkCommandResult();
                PushResult r = (PushResult)iterator.next();
                Collection updates = r.getRemoteUpdates();
                Iterator iterator2 = updates.iterator();
                do {
                    if (!iterator2.hasNext()) continue block17;
                } while ((remoteRefUpdate = (RemoteRefUpdate)iterator2.next()).getStatus() == RemoteRefUpdate.Status.OK || remoteRefUpdate.getStatus() == RemoteRefUpdate.Status.UP_TO_DATE);
                break;
            }
            if (remoteRefUpdate.getMessage() == null) {
                String message = DialogManager.getMessage("team-uptodate-failed", new String[0]);
                TeamworkCommandError teamworkCommandError = new TeamworkCommandError(message, message);
                return teamworkCommandError;
            }
            TeamworkCommandError teamworkCommandError = new TeamworkCommandError(remoteRefUpdate.getMessage(), remoteRefUpdate.getMessage());
            return teamworkCommandError;
        }
        catch (IOException | GitAPIException ex) {
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
    }
}

