/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;

public abstract class TeamAction {
    private final StringProperty name = new SimpleStringProperty();
    private final BooleanProperty disabled = new SimpleBooleanProperty(false);
    protected String shortDescription;

    public TeamAction(String label, boolean showsDialog) {
        this.setName(Config.getString(label), showsDialog);
    }

    public void setName(String name, boolean showsDialog) {
        this.name.set((Object)(showsDialog && !name.endsWith("...") ? name + "..." : name));
    }

    public void setEnabled(boolean enabled) {
        this.disabled.set(!enabled);
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public BooleanProperty disabledProperty() {
        return this.disabled;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public void useButton(PkgMgrFrame pmf, ButtonBase button) {
        button.textProperty().unbind();
        button.textProperty().bind((ObservableValue)this.name);
        button.disableProperty().unbind();
        button.disableProperty().bind((ObservableValue)this.disabled);
        button.setOnAction(e -> this.actionPerformed(pmf));
        if (this.shortDescription != null) {
            Tooltip.install((Node)button, (Tooltip)new Tooltip(this.shortDescription));
        }
    }

    public void useMenuItem(PkgMgrFrame pmf, MenuItem menuItem) {
        menuItem.textProperty().unbind();
        menuItem.textProperty().bind((ObservableValue)this.name);
        menuItem.disableProperty().unbind();
        menuItem.disableProperty().bind((ObservableValue)this.disabled);
        menuItem.setOnAction(e -> this.actionPerformed(pmf));
    }

    protected abstract void actionPerformed(PkgMgrFrame var1);
}

