/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.Config;
import java.io.File;
import javafx.scene.paint.Color;

public class TeamStatusInfo {
    private File file;
    private String localVersion;
    private String remoteVersion;
    private Status status;
    private Status remoteStatus;
    private static final String prefix = "team.statusinfo.";
    private static final Color UPTODATE_COLOR = Color.BLACK;
    private static final Color CONFLICT_COLOR = Color.rgb((int)137, (int)13, (int)19);
    private static final Color NEEDSUPDATE_COLOR = Color.rgb((int)11, (int)57, (int)120);
    private static final Color REMOVED_COLOR = Color.rgb((int)135, (int)150, (int)170);
    private static final Color NEEDSCOMMIT_COLOR = Color.rgb((int)10, (int)85, (int)15);
    private static final Color DELETED_COLOR = Color.rgb((int)122, (int)143, (int)123);

    public TeamStatusInfo() {
        this(new File(""), "", "", Status.BLANK, Status.BLANK);
    }

    public TeamStatusInfo(File file, String localVersion, String remoteVersion, Status status, Status remoteStatus) {
        this(file, localVersion, remoteVersion, status);
        this.remoteStatus = remoteStatus;
    }

    public TeamStatusInfo(File file, String localVersion, String remoteVersion, Status status) {
        this.file = file;
        this.localVersion = localVersion;
        this.remoteVersion = remoteVersion;
        this.status = status;
        this.remoteStatus = Status.UP_TO_DATE;
    }

    public Status getStatus(boolean local) {
        return local ? this.status : this.remoteStatus;
    }

    public File getFile() {
        return this.file;
    }

    public String getLocalVersion() {
        return this.localVersion;
    }

    public String getRepositoryVersion() {
        return this.remoteVersion;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status s) {
        this.status = s;
    }

    public Status getRemoteStatus() {
        return this.remoteStatus;
    }

    public void setRemoteStatus(Status remoteStatus) {
        this.remoteStatus = remoteStatus;
    }

    public String toString() {
        return this.getFile().getName();
    }

    static /* synthetic */ Color access$000() {
        return UPTODATE_COLOR;
    }

    static /* synthetic */ Color access$100() {
        return NEEDSUPDATE_COLOR;
    }

    static /* synthetic */ Color access$200() {
        return DELETED_COLOR;
    }

    static /* synthetic */ Color access$300() {
        return NEEDSCOMMIT_COLOR;
    }

    static /* synthetic */ Color access$400() {
        return REMOVED_COLOR;
    }

    public static enum Status {
        UP_TO_DATE("upToDate", "", "", TeamStatusInfo.access$000()),
        NEEDS_CHECKOUT("needsCheckout", "", "dcvs.remote.needs.pull", TeamStatusInfo.access$100()),
        DELETED("deleted", "dcvs.local.deleted", "dcvs.remote.deleted", TeamStatusInfo.access$200()),
        NEEDS_UPDATE("needsUpdate", "", "dcvs.remote.needs.pull", TeamStatusInfo.access$100()),
        NEEDS_COMMIT("needsCommit", "dcvs.local.modified", "dcvs.remote.modified", TeamStatusInfo.access$300()),
        NEEDS_MERGE("needsMerge", "needsMerge", "needsMerge"),
        NEEDS_ADD("needsAdd", "dcvs.local.new", "dcvs.remote.new", TeamStatusInfo.access$300()),
        REMOVED("removed", "", "dcvs.remote.needs.pull", TeamStatusInfo.access$400()),
        UNRESOLVED("unresolved", "unresolved", "unresolved"),
        HAS_CONFLICTS("hasConflicts", "hasConflicts", "hasConflicts"),
        WEIRD("weird", "weird", "weird"),
        BLANK("", "", ""),
        CONFLICT_ADD("conflictAdd", "conflictAdd", "conflictAdd"),
        CONFLICT_LMRD("conflictLMRD", "conflictLMRD", "conflictLMRD"),
        CONFLICT_LDRM("conflictLDRM", "conflictLDRM", "conflictLDRM"),
        RENAMED("renamed", "renamed", "renamed"),
        NEEDS_PUSH("dcvs.needsPush", "", "dcvs.needsPush");

        private final String statusString;
        private final String dcvsStatusString;
        private final String dcvsRemoteStatusString;
        private final Color color;

        private Status(String statusString, String dcvsStatusString, String dcvsRemoteStatusString) {
            this(statusString, dcvsStatusString, dcvsRemoteStatusString, CONFLICT_COLOR);
        }

        private Status(String statusString, String dcvsStatusString, String dcvsRemoteStatusString, Color color) {
            this.statusString = statusString;
            this.dcvsStatusString = dcvsStatusString;
            this.dcvsRemoteStatusString = dcvsRemoteStatusString;
            this.color = color;
        }

        public String getStatusString() {
            return this.statusString.isEmpty() ? "" : Config.getString(TeamStatusInfo.prefix + this.statusString);
        }

        public String getDCVSStatusString(boolean remote) {
            String label = remote ? this.dcvsRemoteStatusString : this.dcvsStatusString;
            return label.isEmpty() ? "" : Config.getString(TeamStatusInfo.prefix + label);
        }

        public Color getStatusColour() {
            return this.color;
        }
    }
}

