/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.extmgr.ExtensionWrapper;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ExtensionPrefManager
implements PrefPanelListener {
    private List<ExtensionWrapper> extensionsList;
    private final int DO_panelUpdate = 1;
    private final int DO_loadValues = 2;
    private final int DO_saveValues = 3;
    private JPanel drawPanel;
    private JPanel rootPanel;

    public ExtensionPrefManager(List<ExtensionWrapper> i_extensionsList) {
        this.extensionsList = i_extensionsList;
        this.drawPanel = new JPanel();
        this.drawPanel.setLayout(new BoxLayout(this.drawPanel, 1));
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)this.drawPanel, "North");
        JScrollPane drawScroll = new JScrollPane(middlePanel);
        drawScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        drawScroll.setHorizontalScrollBarPolicy(31);
        this.rootPanel = new JPanel(new BorderLayout());
        this.rootPanel.add((Component)drawScroll, "Center");
    }

    public JPanel getPanel() {
        return this.rootPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWorkLoop(int doAction) {
        if (doAction == 1) {
            this.drawPanel.removeAll();
        }
        List<ExtensionWrapper> list = this.extensionsList;
        synchronized (list) {
            for (ExtensionWrapper wrapper : this.extensionsList) {
                this.doWorkItem(wrapper, doAction);
            }
        }
    }

    private void doWorkItem(ExtensionWrapper aWrapper, int doAction) {
        if (!aWrapper.isValid()) {
            return;
        }
        String extensionName = aWrapper.safeGetExtensionName();
        switch (doAction) {
            case 2: {
                aWrapper.safePrefGenLoadValues();
                return;
            }
            case 3: {
                aWrapper.safePrefGenSaveValues();
                return;
            }
            case 1: {
                this.addUserPanel(aWrapper, extensionName);
                return;
            }
        }
    }

    private void addUserPanel(ExtensionWrapper aWrapper, String extensionName) {
        JPanel aPanel = aWrapper.safePrefGenGetPanel();
        if (aPanel == null) {
            return;
        }
        JPanel framePanel = new JPanel(new BorderLayout());
        framePanel.setBorder(BorderFactory.createTitledBorder(extensionName));
        framePanel.add((Component)aPanel, "North");
        this.drawPanel.add(framePanel);
    }

    @OnThread(value=Tag.Swing)
    public void panelRevalidate() {
        this.doWorkLoop(1);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void beginEditing(Project project) {
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void revertEditing(Project project) {
        SwingUtilities.invokeLater(() -> this.doWorkLoop(2));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void commitEditing(Project project) {
        SwingUtilities.invokeLater(() -> this.doWorkLoop(3));
    }
}

