/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.objectbench;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.inspector.ObjectBackground;
import bluej.debugmgr.objectbench.ArrayWrapper;
import bluej.debugmgr.objectbench.InvokeAction;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.extensions.BObject;
import bluej.extensions.ExtensionBridge;
import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.FXMenuManager;
import bluej.extmgr.ObjectExtensionMenu;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.awt.Color;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.binding.When;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ObjectWrapper
extends StackPane
implements InvokeListener,
NamedValue {
    static final @OnThread(value=Tag.Any) String methodException = Config.getString("debugger.objectwrapper.methodException");
    static final @OnThread(value=Tag.Any) String invocationException = Config.getString("debugger.objectwrapper.invocationException");
    static final @OnThread(value=Tag.Any) String inspect = Config.getString("debugger.objectwrapper.inspect");
    static final @OnThread(value=Tag.Any) String remove = Config.getString("debugger.objectwrapper.remove");
    static final @OnThread(value=Tag.Any) String redefinedIn = Config.getString("debugger.objectwrapper.redefined");
    static final @OnThread(value=Tag.Any) String inheritedFrom = Config.getString("debugger.objectwrapper.inherited");
    static final @OnThread(value=Tag.Any) Color envOpColour = new Color(152, 32, 32);
    public static final int WIDTH = 100;
    public static final int HEIGHT = 70;
    public static final double CORNER_SIZE = 10.0;
    public static final double FOCUSED_BORDER = 6.0;
    public static final double UNFOCUSED_BORDER = 2.0;
    public static final double SHADOW_RADIUS = 3.0;
    private static int itemHeight = 28;
    private static boolean itemHeightKnown = false;
    private static @OnThread(value=Tag.Any) int itemsOnScreen;
    protected final @OnThread(value=Tag.Any) DebuggerObject obj;
    private final String objClassName;
    protected @OnThread(value=Tag.Any) GenTypeClass iType;
    private final String className;
    private @OnThread(value=Tag.Any, requireSynchronized=true) String objInstanceName;
    protected String displayClassName;
    protected ContextMenu menu;
    private final Package pkg;
    private final PkgMgrFrame pmf;
    private final ObjectBench ob;
    private static final String MENU_STYLE_INBUILT = "object-action-inbuilt";
    private @OnThread(value=Tag.Any, requireSynchronized=true) BObject singleBObject;

    @OnThread(value=Tag.FXPlatform)
    public static ObjectWrapper getWrapper(PkgMgrFrame pmf, ObjectBench ob, DebuggerObject obj, GenTypeClass iType, String instanceName) {
        if (obj.isArray()) {
            return new ArrayWrapper(pmf, ob, obj, instanceName);
        }
        return new ObjectWrapper(pmf, ob, obj, iType, instanceName);
    }

    @OnThread(value=Tag.FXPlatform)
    protected ObjectWrapper(PkgMgrFrame pmf, ObjectBench ob, DebuggerObject obj, GenTypeClass iType, String instanceName) {
        if (!itemHeightKnown) {
            itemsOnScreen = (int)Config.screenBounds.getHeight() / itemHeight;
        }
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        this.ob = ob;
        this.obj = obj;
        this.objClassName = obj.getClassName();
        this.iType = iType;
        this.setName(instanceName);
        if (obj.isNullObject()) {
            this.className = "";
            this.displayClassName = "";
        } else {
            GenTypeClass objType = obj.getGenType();
            this.className = objType.toString();
            this.displayClassName = objType.toString(true);
        }
        Class<?> cl = this.findIType();
        ExtensionsManager extMgr = ExtensionsManager.getInstance();
        this.createMenu(extMgr, cl);
        JavaFXUtil.listenForContextMenu((Node)this, (x, y) -> {
            this.menu.show((Node)this, x.doubleValue(), y.doubleValue());
            return true;
        }, KeyCode.SPACE, KeyCode.ENTER);
        this.setMinWidth(100.0);
        this.setMinHeight(70.0);
        this.setMaxWidth(100.0);
        this.setMaxHeight(70.0);
        this.setCursor(Cursor.HAND);
        this.setFocusTraversable(true);
        this.setOnMouseClicked(this::clicked);
        JavaFXUtil.addFocusListener((Node)this, focused -> {
            if (focused.booleanValue()) {
                ob.objectGotFocus(this);
            } else if (ob.getSelectedObject() == this) {
                ob.setSelectedObject(null);
            }
        });
        JavaFXUtil.addStyleClass((Styleable)this, "object-wrapper");
        Label label = new Label(this.getName() + ":\n" + this.displayClassName);
        JavaFXUtil.addStyleClass((Styleable)label, "object-wrapper-text");
        this.createComponent(label);
    }

    protected void createComponent(Label label) {
        this.getChildren().addAll((Object[])new Node[]{new ObjectBackground(10.0, (ObservableDoubleValue)new When((ObservableBooleanValue)this.focusedProperty()).then(6.0).otherwise(2.0)), label});
        this.setBackground(null);
        this.setEffect((Effect)new DropShadow(3.0, 1.5, 1.5, javafx.scene.paint.Color.GRAY));
    }

    @OnThread(value=Tag.Any)
    public Package getPackage() {
        return this.pkg;
    }

    public PkgMgrFrame getFrame() {
        return this.pmf;
    }

    @OnThread(value=Tag.Any)
    public String getClassName() {
        return this.objClassName;
    }

    @OnThread(value=Tag.Any)
    public String getTypeName() {
        return this.className;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaType getGenType() {
        return this.iType;
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean isFinal() {
        return true;
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean isInitialized() {
        return true;
    }

    @OnThread(value=Tag.SwingIsFX)
    public final synchronized BObject getBObject() {
        if (this.singleBObject == null) {
            this.singleBObject = ExtensionBridge.newBObject((ObjectWrapper)this);
        }
        return this.singleBObject;
    }

    public void prepareRemove() {
        Project proj = this.pkg.getProject();
        proj.removeInspectorInstance(this.obj);
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean classIsAccessible(Class<?> cl) {
        int clMods = cl.getModifiers();
        String classPackage = JavaNames.getPrefix(cl.getName());
        return (!Modifier.isProtected(clMods) || this.pkg.getQualifiedName().equals(classPackage)) && !Modifier.isPrivate(clMods);
    }

    @OnThread(value=Tag.FXPlatform)
    private Class<?> findIType() {
        String className = this.obj.getClassName();
        Class<?> cl = this.pkg.loadClass(className);
        if (cl != null) {
            if (!this.classIsAccessible(cl)) {
                cl = this.pkg.loadClass(this.iType.classloaderName());
                while (cl != null && !this.classIsAccessible(cl)) {
                    if ((cl = cl.getSuperclass()) != null) {
                        this.iType = this.iType.mapToSuper(cl.getName());
                        continue;
                    }
                    JavaReflective objectReflective = new JavaReflective(Object.class);
                    this.iType = new GenTypeClass(objectReflective);
                }
            } else {
                this.iType = this.obj.getGenType();
            }
        }
        return cl;
    }

    protected void createMenu(ExtensionsManager extMgr, Class<?> cl) {
        this.menu = new ContextMenu();
        ObjectWrapper.createMethodMenuItems((ObservableList<MenuItem>)this.menu.getItems(), cl, this.iType, (InvokeListener)this, this.obj, this.pkg.getQualifiedName(), true);
        MenuItem item = new MenuItem(inspect);
        this.menu.getItems().add((Object)item);
        JavaFXUtil.addStyleClass((Styleable)item, MENU_STYLE_INBUILT);
        item.setOnAction(e -> this.inspectObject());
        item = new MenuItem(remove);
        this.menu.getItems().add((Object)item);
        JavaFXUtil.addStyleClass((Styleable)item, MENU_STYLE_INBUILT);
        item.setOnAction(e -> this.removeObject());
        FXMenuManager menuManager = new FXMenuManager(this.menu, extMgr, (ExtensionMenu)new ObjectExtensionMenu(this));
        menuManager.addExtensionMenu(this.pkg.getProject());
    }

    public static void createMethodMenuItems(ObservableList<MenuItem> menu, Class<?> cl, InvokeListener il, DebuggerObject obj, String currentPackageName, boolean showObjectMethods) {
        GenTypeClass gt = new GenTypeClass(new JavaReflective(cl));
        ObjectWrapper.createMethodMenuItems(menu, cl, gt, il, obj, currentPackageName, showObjectMethods);
    }

    @OnThread(value=Tag.SwingIsFX)
    public static void createMethodMenuItems(JPopupMenu jmenu, Class<?> cl, InvokeListener il, DebuggerObject obj, String currentPackageName, boolean showObjectMethods) {
        GenTypeClass gt = new GenTypeClass(new JavaReflective(cl));
        ObjectWrapper.createMethodMenuItems(jmenu, cl, gt, il, obj, currentPackageName, showObjectMethods);
    }

    public static void createMethodMenuItems(ObservableList<MenuItem> menu, Class<?> cl, GenTypeClass gtype, InvokeListener il, DebuggerObject obj, String currentPackageName, boolean showObjectMethods) {
        if (cl != null) {
            Menu subMenu;
            View view = View.getView(cl);
            Hashtable<String, String> methodsUsed = new Hashtable<String, String>();
            List<Class<?>> classes = ObjectWrapper.getClassHierarchy(cl);
            ViewFilter samePackageFilter = new ViewFilter(196613);
            ViewFilter otherPackageFilter = new ViewFilter(131073);
            ViewFilter filter = currentPackageName != null && currentPackageName.equals(view.getPackageName()) ? samePackageFilter : otherPackageFilter;
            menu.add((Object)new SeparatorMenuItem());
            MethodView[] declaredMethods = view.getDeclaredMethods();
            GenTypeClass curType = gtype;
            if (curType == null) {
                curType = new GenTypeClass(new JavaReflective(cl));
            }
            if (itemsOnScreen <= 0) {
                itemsOnScreen = 30;
            }
            int itemLimit = itemsOnScreen - 8 - classes.size();
            ObjectWrapper.createMenuItems(menu, declaredMethods, il, filter, itemLimit, curType.getMap(), methodsUsed);
            for (int i = 1; i < classes.size(); ++i) {
                Class<?> currentClass = classes.get(i);
                view = View.getView(currentClass);
                filter = currentPackageName != null && currentPackageName.equals(view.getPackageName()) ? samePackageFilter : otherPackageFilter;
                curType = curType.mapToSuper(currentClass.getName());
                if ("java.lang.Object".equals(currentClass.getName()) && !showObjectMethods) continue;
                declaredMethods = view.getDeclaredMethods();
                subMenu = new Menu(inheritedFrom + " " + JavaNames.stripPrefix(currentClass.getName()));
                ObjectWrapper.createMenuItems((List<MenuItem>)subMenu.getItems(), declaredMethods, il, filter, itemsOnScreen / 2, curType.getMap(), methodsUsed);
                menu.add(0, (Object)subMenu);
            }
            for (Class<?> iface : ObjectWrapper.getInterfacesWithDefaultMethods(cl)) {
                view = View.getView(iface);
                declaredMethods = view.getDeclaredMethods();
                subMenu = new Menu(inheritedFrom + " " + JavaNames.stripPrefix(iface.getName()));
                ObjectWrapper.createMenuItems((List<MenuItem>)subMenu.getItems(), declaredMethods, il, filter, itemsOnScreen / 2, curType.getMap(), methodsUsed);
                menu.add(0, (Object)subMenu);
            }
            menu.add((Object)new SeparatorMenuItem());
        }
    }

    @OnThread(value=Tag.SwingIsFX)
    public static void createMethodMenuItems(JPopupMenu jmenu, Class<?> cl, GenTypeClass gtype, InvokeListener il, DebuggerObject obj, String currentPackageName, boolean showObjectMethods) {
        if (cl != null) {
            JMenu subMenu;
            View view = View.getView(cl);
            Hashtable<String, String> methodsUsed = new Hashtable<String, String>();
            List<Class<?>> classes = ObjectWrapper.getClassHierarchy(cl);
            ViewFilter samePackageFilter = new ViewFilter(196613);
            ViewFilter otherPackageFilter = new ViewFilter(131073);
            ViewFilter filter = currentPackageName != null && currentPackageName.equals(view.getPackageName()) ? samePackageFilter : otherPackageFilter;
            jmenu.addSeparator();
            MethodView[] declaredMethods = view.getDeclaredMethods();
            GenTypeClass curType = gtype;
            if (curType == null) {
                curType = new GenTypeClass(new JavaReflective(cl));
            }
            if (itemsOnScreen <= 0) {
                itemsOnScreen = 30;
            }
            int itemLimit = itemsOnScreen - 8 - classes.size();
            ObjectWrapper.createMenuItems(jmenu, declaredMethods, il, filter, itemLimit, curType.getMap(), methodsUsed);
            for (int i = 1; i < classes.size(); ++i) {
                Class<?> currentClass = classes.get(i);
                view = View.getView(currentClass);
                filter = currentPackageName != null && currentPackageName.equals(view.getPackageName()) ? samePackageFilter : otherPackageFilter;
                curType = curType.mapToSuper(currentClass.getName());
                if ("java.lang.Object".equals(currentClass.getName()) && !showObjectMethods) continue;
                declaredMethods = view.getDeclaredMethods();
                subMenu = new JMenu(inheritedFrom + " " + JavaNames.stripPrefix(currentClass.getName()));
                subMenu.setFont(PrefMgr.getStandoutMenuFont());
                ObjectWrapper.createMenuItems(subMenu, declaredMethods, il, filter, itemsOnScreen / 2, curType.getMap(), methodsUsed);
                jmenu.insert(subMenu, 0);
            }
            for (Class<?> iface : ObjectWrapper.getInterfacesWithDefaultMethods(cl)) {
                view = View.getView(iface);
                declaredMethods = view.getDeclaredMethods();
                subMenu = new JMenu(inheritedFrom + " " + JavaNames.stripPrefix(iface.getName()));
                subMenu.setFont(PrefMgr.getStandoutMenuFont());
                ObjectWrapper.createMenuItems(subMenu, declaredMethods, il, filter, itemsOnScreen / 2, curType.getMap(), methodsUsed);
                jmenu.insert(subMenu, 0);
            }
            jmenu.addSeparator();
        }
    }

    private static void createMenuItems(List<MenuItem> menu, MethodView[] methods, InvokeListener il, ViewFilter filter, int sizeLimit, Map<String, GenTypeParameter> genericParams, Hashtable<String, String> methodsUsed) {
        boolean menuEmpty = true;
        Arrays.sort(methods);
        for (MethodView method : methods) {
            try {
                if (!filter.accept(method)) continue;
                menuEmpty = false;
                String methodSignature = method.getCallSignature();
                String methodDescription = method.getLongDesc(genericParams);
                if (methodsUsed.containsKey(methodSignature)) {
                    methodDescription = methodDescription + "   [ " + redefinedIn + " " + JavaNames.stripPrefix(methodsUsed.get(methodSignature)) + " ]";
                } else {
                    methodsUsed.put(methodSignature, method.getClassName());
                }
                MenuItem item = new MenuItem(methodDescription);
                item.setOnAction(e -> il.executeMethod(method));
                int itemCount = menu.size();
                if (itemCount >= sizeLimit) {
                    Menu subMenu = new Menu(Config.getString("debugger.objectwrapper.moreMethods"));
                    menu.add((MenuItem)subMenu);
                    menu = subMenu.getItems();
                    sizeLimit = itemsOnScreen / 2;
                }
                menu.add((MenuItem)item);
            }
            catch (Exception e2) {
                Debug.reportError(methodException + e2);
                e2.printStackTrace();
            }
        }
        if (menuEmpty) {
            MenuItem mi = new MenuItem(Config.getString("debugger.objectwrapper.noMethods"));
            mi.setDisable(true);
            menu.add((MenuItem)mi);
        }
    }

    @OnThread(value=Tag.SwingIsFX)
    private static void createMenuItems(JComponent jmenu, MethodView[] methods, InvokeListener il, ViewFilter filter, int sizeLimit, Map<String, GenTypeParameter> genericParams, Hashtable<String, String> methodsUsed) {
        boolean menuEmpty = true;
        Arrays.sort(methods);
        for (MethodView method : methods) {
            try {
                if (!filter.accept(method)) continue;
                menuEmpty = false;
                String methodSignature = method.getCallSignature();
                String methodDescription = method.getLongDesc(genericParams);
                if (methodsUsed.containsKey(methodSignature)) {
                    methodDescription = methodDescription + "   [ " + redefinedIn + " " + JavaNames.stripPrefix(methodsUsed.get(methodSignature)) + " ]";
                } else {
                    methodsUsed.put(methodSignature, method.getClassName());
                }
                InvokeAction a = new InvokeAction(method, il, methodDescription);
                JMenuItem item = new JMenuItem(a);
                item.setFont(PrefMgr.getPopupMenuFont());
                int itemCount = jmenu instanceof JMenu ? ((JMenu)jmenu).getMenuComponentCount() : jmenu.getComponentCount();
                if (itemCount >= sizeLimit) {
                    JMenu subMenu = new JMenu(Config.getString("debugger.objectwrapper.moreMethods"));
                    subMenu.setFont(PrefMgr.getStandoutMenuFont());
                    subMenu.setForeground(envOpColour);
                    jmenu.add(subMenu);
                    jmenu = subMenu;
                    sizeLimit = itemsOnScreen / 2;
                }
                jmenu.add(item);
            }
            catch (Exception e) {
                Debug.reportError(methodException + e);
                e.printStackTrace();
            }
        }
        if (menuEmpty) {
            JMenuItem mi = new JMenuItem(Config.getString("debugger.objectwrapper.noMethods"));
            mi.setFont(PrefMgr.getStandoutMenuFont());
            mi.setForeground(envOpColour);
            mi.setEnabled(false);
            jmenu.add(mi);
        }
    }

    @OnThread(value=Tag.Any)
    private static List<Class<?>> getClassHierarchy(Class<?> derivedClass) {
        ArrayList classVector = new ArrayList();
        for (Class<?> currentClass = derivedClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            classVector.add(currentClass);
        }
        return classVector;
    }

    @OnThread(value=Tag.Any)
    private static List<Class<?>> getInterfacesWithDefaultMethods(Class<?> cls) {
        return ObjectWrapper.getClassHierarchy(cls).stream().flatMap(c -> Arrays.stream(c.getInterfaces())).filter(i -> Arrays.stream(i.getDeclaredMethods()).anyMatch(m -> m.isDefault())).collect(Collectors.toList());
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public synchronized @OnThread(value=Tag.Any, ignoreParent=true) String getName() {
        return this.objInstanceName;
    }

    @OnThread(value=Tag.Any)
    public synchronized void setName(String newName) {
        this.objInstanceName = newName;
    }

    @OnThread(value=Tag.Any)
    public DebuggerObject getObject() {
        return this.obj;
    }

    private void clicked(MouseEvent evt) {
        if (!evt.isPopupTrigger() && evt.getButton() == MouseButton.PRIMARY) {
            if (evt.getClickCount() > 1) {
                this.inspectObject();
            } else {
                this.ob.fireObjectEvent(this);
            }
        }
        this.requestFocus();
    }

    @OnThread(value=Tag.FXPlatform)
    protected void inspectObject() {
        ObjectInspectInvokerRecord ir = new ObjectInspectInvokerRecord(this.getName());
        this.pkg.getProject().getInspectorInstance(this.obj, this.getName(), this.pkg, ir, (Window)this.pmf.getFXWindow(), (Node)this);
    }

    protected void removeObject() {
        this.ob.removeObject(this, this.pkg.getId());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void executeMethod(final MethodView method) {
        ResultWatcher watcher = null;
        this.pkg.forgetLastSource();
        watcher = new ResultWatcher(){
            private ExpressionInformation expressionInformation;
            {
                this.expressionInformation = new ExpressionInformation(method, ObjectWrapper.this.getName(), ObjectWrapper.this.obj.getGenType());
            }

            @Override
            public void beginCompile() {
                ObjectWrapper.this.pmf.setWaitCursor(true);
            }

            @Override
            public void beginExecution(InvokerRecord ir) {
                BlueJEvent.raiseEvent(3, ir);
                ObjectWrapper.this.pmf.setWaitCursor(false);
            }

            @Override
            public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                ExecutionEvent executionEvent = new ExecutionEvent(ObjectWrapper.this.pkg, ObjectWrapper.this.obj.getClassName(), ObjectWrapper.this.objInstanceName);
                executionEvent.setMethodName(method.getName());
                executionEvent.setParameters(method.getParamTypes(false), ir.getArgumentValues());
                executionEvent.setResult("Normal exit");
                executionEvent.setResultObject(result);
                BlueJEvent.raiseEvent(5, executionEvent);
                ObjectWrapper.this.pkg.getProject().updateInspectors();
                this.expressionInformation.setArgumentValues(ir.getArgumentValues());
                ObjectWrapper.this.ob.addInteraction(ir);
                if (result != null && !result.isNullObject()) {
                    ObjectWrapper.this.pkg.getProject().getResultInspectorInstance(result, name, ObjectWrapper.this.pkg, ir, this.expressionInformation, (Window)ObjectWrapper.this.pmf.getFXWindow());
                }
            }

            @Override
            public void putError(String msg, InvokerRecord ir) {
                ObjectWrapper.this.pmf.setWaitCursor(false);
            }

            @Override
            public void putException(ExceptionDescription exception, InvokerRecord ir) {
                ExecutionEvent executionEvent = new ExecutionEvent(ObjectWrapper.this.pkg, ObjectWrapper.this.obj.getClassName(), ObjectWrapper.this.objInstanceName);
                executionEvent.setParameters(method.getParamTypes(false), ir.getArgumentValues());
                executionEvent.setResult("An exception occurred");
                executionEvent.setException(exception);
                BlueJEvent.raiseEvent(5, executionEvent);
                ObjectWrapper.this.pkg.getProject().updateInspectors();
                ObjectWrapper.this.pkg.exceptionMessage(exception);
            }

            @Override
            public void putVMTerminated(InvokerRecord ir) {
                ExecutionEvent executionEvent = new ExecutionEvent(ObjectWrapper.this.pkg, ObjectWrapper.this.obj.getClassName(), ObjectWrapper.this.objInstanceName);
                executionEvent.setParameters(method.getParamTypes(false), ir.getArgumentValues());
                executionEvent.setResult("User terminated");
                BlueJEvent.raiseEvent(5, executionEvent);
            }
        };
        if (this.pmf.checkDebuggerState()) {
            Invoker invoker = new Invoker(this.pmf, method, this, watcher);
            invoker.invokeInteractive();
        }
    }

    @Override
    public void callConstructor(ConstructorView cv) {
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.pmf.setStatus(this.getName() + " : " + this.displayClassName);
        }
    }

    public void showMenu() {
        this.menu.show((Node)this, Side.LEFT, 5.0, 5.0);
    }

    public void animateIn(Optional<Point2D> animateFromScenePoint) {
        this.setScaleX(0.2);
        this.setScaleY(0.2);
        JavaFXUtil.addSelfRemovingListener(this.layoutYProperty(), layoutY -> {
            this.setVisible(true);
            ScaleTransition scale = new ScaleTransition(Duration.millis((double)300.0), (Node)this);
            scale.setFromX(0.2);
            scale.setFromY(0.2);
            scale.setToX(1.0);
            scale.setToY(1.0);
            if (animateFromScenePoint.isPresent()) {
                TranslateTransition move = new TranslateTransition(Duration.millis((double)300.0), (Node)this);
                Point2D local = this.sceneToLocal((Point2D)animateFromScenePoint.get());
                move.setFromX(local.getX());
                move.setFromY(local.getY());
                move.setToX(0.0);
                move.setToY(0.0);
                if (Math.hypot(local.getX(), local.getY()) >= 300.0) {
                    scale.setDuration(Duration.millis((double)600.0));
                    move.setDuration(Duration.millis((double)600.0));
                }
                new ParallelTransition(new Animation[]{scale, move}).play();
            } else {
                scale.play();
            }
        });
    }

    public void animateOut(FXPlatformRunnable after) {
        ScaleTransition t = new ScaleTransition(Duration.millis((double)300.0), (Node)this);
        t.setToX(0.0);
        t.setToY(0.0);
        t.setOnFinished(e -> {
            if (after != null) {
                after.run();
            }
        });
        t.play();
    }
}

