/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ResizableCanvas;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ObjectBackground
extends ResizableCanvas {
    private final double cornerSize;
    private final ObservableDoubleValue lineWidth;

    public ObjectBackground(double cornerSize, ObservableDoubleValue lineWidth) {
        this.cornerSize = cornerSize;
        this.lineWidth = lineWidth;
        JavaFXUtil.addChangeListenerPlatform(this.widthProperty(), w -> this.redrawContent());
        JavaFXUtil.addChangeListenerPlatform(this.heightProperty(), h -> this.redrawContent());
        JavaFXUtil.addChangeListenerPlatform(lineWidth, d -> this.redrawContent());
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.heightProperty());
        clip.setArcWidth(10.0);
        clip.setArcHeight(10.0);
        this.setClip((Node)clip);
    }

    private void redrawContent() {
        GraphicsContext gc = this.getGraphicsContext2D();
        double w = this.getWidth();
        double h = this.getHeight();
        Color fill = new Color(0.8901960784313725, 0.2784313725490196, 0.2784313725490196, 1.0);
        gc.setFill((Paint)fill);
        gc.fillRect(0.0, 0.0, w, h);
        gc.setStroke((Paint)Color.BLACK);
        gc.setLineWidth(this.lineWidth.get());
        gc.strokeRoundRect(0.0, 0.0, w, h, this.cornerSize, this.cornerSize);
    }
}

