/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.Config;
import bluej.debugmgr.inspector.FieldInfo;
import bluej.utility.javafx.JavaFXUtil;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class FieldList
extends TableView<FieldInfo> {
    private static final Image objectrefIcon = Config.getImageAsFXImage("image.inspector.objectref");

    public FieldList() {
        this.getSelectionModel().setCellSelectionEnabled(false);
        this.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.setColumnResizePolicy(CONSTRAINED_RESIZE_POLICY);
        int rowHeight = 30;
        this.setFixedCellSize(rowHeight);
        this.prefHeightProperty().bind((ObservableValue)Bindings.min((double)400.0, (ObservableNumberValue)this.fixedCellSizeProperty().multiply((ObservableNumberValue)Bindings.size((ObservableList)this.getItems())).add((ObservableNumberValue)JavaFXUtil.ofD(this.paddingProperty(), Insets::getTop)).add((ObservableNumberValue)JavaFXUtil.ofD(this.paddingProperty(), Insets::getBottom))));
        this.setMinHeight(3.5 * (double)rowHeight);
        this.setMinWidth(350.0);
        JavaFXUtil.addStyleClass((Styleable)this, "field-list");
        TableColumn description = new TableColumn();
        description.setMinWidth(180.0);
        JavaFXUtil.addStyleClass((Styleable)description, "inspector-field-description");
        description.setCellValueFactory(v -> new ReadOnlyStringWrapper(((FieldInfo)v.getValue()).getDescription()));
        TableColumn value = new TableColumn();
        JavaFXUtil.addStyleClass((Styleable)value, "inspector-field-value");
        value.setCellValueFactory(v -> new ReadOnlyObjectWrapper((Object)new StringOrRef(((FieldInfo)v.getValue()).getValue())));
        value.setCellFactory(col -> new ValueCell());
        value.setMinWidth(100.0);
        this.getColumns().setAll((Object[])new TableColumn[]{description, value});
        JavaFXUtil.addChangeListener(this.widthProperty(), ignore -> {
            Pane header = (Pane)this.lookup("TableHeaderRow");
            if (header.isVisible()) {
                header.setMaxHeight(0.0);
                header.setMinHeight(0.0);
                header.setPrefHeight(0.0);
                header.setVisible(false);
            }
        });
    }

    public void setData(List<FieldInfo> listData) {
        this.getItems().setAll(listData);
    }

    private static class ValueCell
    extends TableCell<FieldInfo, StringOrRef> {
        private HBox container = new HBox();
        private Label label = new Label();
        private ImageView objRefPic;
        private SimpleBooleanProperty showingLabel = new SimpleBooleanProperty(true);
        private SimpleBooleanProperty occupied = new SimpleBooleanProperty(true);

        public ValueCell() {
            this.objRefPic = new ImageView(objectrefIcon);
            this.container.getChildren().addAll((Object[])new Node[]{this.label, this.objRefPic});
            JavaFXUtil.addStyleClass((Styleable)this.container, "inspector-field-value-wrapper");
            JavaFXUtil.addStyleClass((Styleable)this.label, "inspector-field-value-label");
            this.objRefPic.managedProperty().bind((ObservableValue)this.showingLabel.not());
            this.objRefPic.visibleProperty().bind((ObservableValue)this.showingLabel.not());
            this.label.managedProperty().bind((ObservableValue)this.showingLabel);
            this.label.visibleProperty().bind((ObservableValue)this.showingLabel);
            this.container.visibleProperty().bind((ObservableValue)this.occupied);
            this.setText("");
            this.setGraphic((Node)this.container);
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        protected void updateItem(StringOrRef v, boolean empty) {
            super.updateItem((Object)v, empty);
            this.occupied.set(!empty);
            if (v != null && v.string == null) {
                this.showingLabel.set(false);
            } else {
                this.label.setText(v == null || empty ? "" : v.string);
                this.showingLabel.set(true);
            }
        }
    }

    private static class StringOrRef {
        private String string;

        public StringOrRef(String string) {
            this.string = "<object reference>".equals(string) ? null : string;
        }
    }
}

