/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.jdi.JdiThread;
import bluej.utility.Debug;
import com.sun.jdi.ThreadReference;
import java.util.HashSet;
import java.util.Iterator;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class JdiThreadSet
extends HashSet<JdiThread> {
    public JdiThread find(ThreadReference thread) {
        for (JdiThread currentThread : this) {
            if (!currentThread.getRemoteThread().equals(thread)) continue;
            return currentThread;
        }
        Debug.reportError("Encountered thread not in ThreadSet!");
        return null;
    }

    public JdiThread removeThread(ThreadReference thread) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            JdiThread jdiThread = (JdiThread)it.next();
            if (!jdiThread.getRemoteThread().equals(thread)) continue;
            it.remove();
            return jdiThread;
        }
        Debug.reportError("Unknown thread died!");
        return null;
    }
}

