/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.debugger.DebuggerTerminal;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.DebuggerThreadListener;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.RunOnThread;
import bluej.debugger.SourceLocation;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiTestResult;
import bluej.debugger.jdi.JdiTestResultError;
import bluej.debugger.jdi.JdiTestResultFailure;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.JdiThreadSet;
import bluej.debugger.jdi.JdiUtils;
import bluej.debugger.jdi.JdiVmCreationException;
import bluej.debugger.jdi.VMReference;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.javafx.FXPlatformSupplier;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMOutOfMemoryException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import threadchecker.OnThread;
import threadchecker.Tag;

public class JdiDebugger
extends Debugger {
    private static final int loaderPriority = 3;
    private @OnThread(value=Tag.Any) boolean autoRestart = true;
    private @OnThread(value=Tag.Any) boolean selfRestart = false;
    private @OnThread(value=Tag.Any) VMReference vmRef;
    private @OnThread(value=Tag.Any) MachineLoaderThread machineLoader;
    private @OnThread(value=Tag.Any) Object serverThreadLock = new Object();
    private @OnThread(value=Tag.Any) JdiThreadSet allThreads;
    private final DebuggerThreadListener threadListener;
    private final @OnThread(value=Tag.Any) List<DebuggerListener> listenerList = new ArrayList<DebuggerListener>();
    private File startingDirectory;
    private DebuggerTerminal terminal;
    private @OnThread(value=Tag.Any, requireSynchronized=true) Set<String> usedNames;
    private @OnThread(value=Tag.Any) int machineState = 1;
    private BPClassLoader lastProjectClassLoader;
    private ExceptionDescription lastException;
    private URL[] libraries = new URL[0];
    private RunOnThread runOnThread = RunOnThread.DEFAULT;

    public JdiDebugger(File startingDirectory, DebuggerTerminal terminal, DebuggerThreadListener debuggerThreadListener) {
        this.startingDirectory = startingDirectory;
        this.terminal = terminal;
        this.threadListener = debuggerThreadListener;
        this.allThreads = new JdiThreadSet();
        this.usedNames = new TreeSet<String>();
    }

    @Override
    public void setUserLibraries(URL[] libraries) {
        this.libraries = libraries;
    }

    @Override
    @OnThread(value=Tag.Any)
    public synchronized void launch() {
        if (this.vmRef != null) {
            throw new IllegalStateException("JdiDebugger.launch() was called but the debugger was already loaded");
        }
        if (this.machineLoader != null && !this.selfRestart) {
            return;
        }
        this.autoRestart = true;
        if (!this.selfRestart) {
            this.machineLoader = new MachineLoaderThread();
        }
        this.selfRestart = false;
        this.machineLoader.setPriority(3);
        this.machineLoader.start();
    }

    @Override
    public synchronized void close(boolean restart) {
        if (this.vmRef != null) {
            this.autoRestart = restart;
            this.selfRestart = restart;
            if (this.selfRestart) {
                this.machineLoader = new MachineLoaderThread();
            }
            this.vmRef.close();
        } else if (!restart) {
            this.autoRestart = false;
            this.selfRestart = false;
            this.machineLoader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDebuggerListener(DebuggerListener l) {
        List<DebuggerListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(l);
            return this.machineState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public void removeDebuggerListener(DebuggerListener l) {
        List<DebuggerListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    private DebuggerListener[] getListeners() {
        List<DebuggerListener> list = this.listenerList;
        synchronized (list) {
            return this.listenerList.toArray(new DebuggerListener[this.listenerList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String guessNewName(String className) {
        String baseName = JavaNames.getBase(className = className.replace('[', ' ').replace(']', ' ').trim());
        int stringEndIndex = baseName.length() > 8 ? 8 : baseName.length();
        String newName = Character.toLowerCase(baseName.charAt(0)) + baseName.substring(1, stringEndIndex);
        int num = 1;
        JdiDebugger jdiDebugger = this;
        synchronized (jdiDebugger) {
            while (this.usedNames.contains(newName + num)) {
                ++num;
            }
        }
        return newName + num;
    }

    @Override
    public String guessNewName(DebuggerObject obj) {
        String name = null;
        DebuggerClass cls = obj.getClassRef();
        if (cls.isEnum()) {
            ObjectReference val = obj.getObjectReference();
            name = JdiUtils.getJdiUtils().getValueString(val);
        }
        if (name == null) {
            name = cls.getName();
        }
        return this.guessNewName(name);
    }

    @Override
    public synchronized void newClassLoader(BPClassLoader bpClassLoader) {
        if (bpClassLoader == null) {
            return;
        }
        this.lastProjectClassLoader = bpClassLoader;
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            this.usedNames.clear();
            try {
                vmr.clearAllBreakpoints();
                vmr.newClassLoader(bpClassLoader.getURLs());
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeBreakpointsForClass(String className) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.clearBreakpointsForClass(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addObject(String scopeId, String newInstanceName, DebuggerObject dob) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.addObject(scopeId, newInstanceName, ((JdiObject)dob).getObjectReference());
            JdiDebugger jdiDebugger = this;
            synchronized (jdiDebugger) {
                this.usedNames.add(newInstanceName);
            }
        }
        return true;
    }

    @Override
    public void removeObject(String scopeId, String instanceName) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.removeObject(scopeId, instanceName);
        }
    }

    @Override
    public Map<String, DebuggerObject> getObjects() {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public int getStatus() {
        return this.machineState;
    }

    @Override
    public DebuggerObject getMirror(String value) {
        VMReference vmr = this.getVM();
        if (vmr != null) {
            try {
                return JdiObject.getDebuggerObject(vmr.getMirror(value));
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (VMOutOfMemoryException vMOutOfMemoryException) {
                // empty catch block
            }
        }
        return null;
    }

    public ExceptionDescription getException() {
        return this.lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public FXPlatformSupplier<Map<String, DebuggerObject>> runTestSetUp(String className) {
        ArrayReference arrayRef = null;
        VMReference vmr = this.getVM();
        try {
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    arrayRef = (ArrayReference)vmr.invokeTestSetup(className);
                }
                if (arrayRef != null) {
                    ArrayReference arrayRefFinal = arrayRef;
                    ObjectReference testObject = (ObjectReference)arrayRef.getValue(arrayRef.length() - 1);
                    return () -> {
                        HashMap<String, JdiObject> returnMap = new HashMap<String, JdiObject>();
                        JdiObject jdiTestObject = JdiObject.getDebuggerObject(testObject);
                        for (int i = 0; i < arrayRefFinal.length() - 1; i += 2) {
                            String fieldName = ((StringReference)arrayRefFinal.getValue(i)).value();
                            Field testField = testObject.referenceType().fieldByName(fieldName);
                            returnMap.put(fieldName, JdiObject.getDebuggerObject((ObjectReference)arrayRefFinal.getValue(i + 1), testField, jdiTestObject));
                        }
                        return returnMap;
                    };
                }
                return () -> Collections.emptyMap();
            }
        }
        catch (InvocationException e) {
            return () -> null;
        }
        catch (VMDisconnectedException e) {
            return () -> null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public DebuggerTestResult runTestMethod(String className, String methodName) {
        ArrayReference arrayRef = null;
        try {
            VMReference vmr = this.getVM();
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    arrayRef = (ArrayReference)vmr.invokeRunTest(className, methodName);
                }
                if (arrayRef == null || arrayRef.length() == 0) {
                    return new JdiTestResultError(className, methodName, "VM returned unknown result", "", null, 0);
                }
                int runTimeMs = Integer.parseInt(((StringReference)arrayRef.getValue(0)).value());
                if (arrayRef != null && arrayRef.length() > 5) {
                    String failureType = ((StringReference)arrayRef.getValue(7)).value();
                    String exMsg = ((StringReference)arrayRef.getValue(1)).value();
                    String traceMsg = ((StringReference)arrayRef.getValue(2)).value();
                    String failureClass = ((StringReference)arrayRef.getValue(3)).value();
                    String failureSource = ((StringReference)arrayRef.getValue(4)).value();
                    String failureMethod = ((StringReference)arrayRef.getValue(5)).value();
                    int lineNo = Integer.parseInt(((StringReference)arrayRef.getValue(6)).value());
                    SourceLocation failPoint = new SourceLocation(failureClass, failureSource, failureMethod, lineNo);
                    if (failureType.equals("failure")) {
                        return new JdiTestResultFailure(className, methodName, exMsg, traceMsg, failPoint, runTimeMs);
                    }
                    return new JdiTestResultError(className, methodName, exMsg, traceMsg, failPoint, runTimeMs);
                }
                if (arrayRef != null && arrayRef.length() == 1) {
                    return new JdiTestResult(className, methodName, runTimeMs);
                }
            }
        }
        catch (InvocationException ie) {
            return new JdiTestResultError(className, methodName, "Internal invocation error", "", null, 0);
        }
        catch (VMDisconnectedException vmde) {
            return new JdiTestResultError(className, methodName, "VM restarted", "", null, 0);
        }
        return new JdiTestResultError(className, methodName, "VM returned unknown result", "", null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public void disposeWindows() {
        VMReference vmr = this.getVMNoWait();
        try {
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    vmr.disposeWindows();
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public FXPlatformSupplier<DebuggerResult> runClassMain(String className) throws ClassNotFoundException {
        VMReference vmr = this.getVM();
        Object object = this.serverThreadLock;
        synchronized (object) {
            if (vmr != null) {
                return vmr.runShellClass(className);
            }
            return null;
        }
    }

    @Override
    public CompletableFuture<FXPlatformSupplier<DebuggerResult>> launchFXApp(final String className) {
        final CompletableFuture<FXPlatformSupplier<DebuggerResult>> result = new CompletableFuture<FXPlatformSupplier<DebuggerResult>>();
        BlueJEventListener listener = new BlueJEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void blueJEvent(int eventId, Object arg) {
                if (eventId == 2) {
                    BlueJEvent.removeListener(this);
                    VMReference vmr = JdiDebugger.this.getVM();
                    if (vmr != null) {
                        Object object = JdiDebugger.this.serverThreadLock;
                        synchronized (object) {
                            result.complete(vmr.launchFXApp(className));
                        }
                    } else {
                        result.complete(() -> new DebuggerResult(3));
                    }
                }
            }
        };
        BlueJEvent.addListener(listener);
        this.close(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public FXPlatformSupplier<DebuggerResult> instantiateClass(String className) {
        VMReference vmr = this.getVM();
        if (vmr != null) {
            Object object = this.serverThreadLock;
            synchronized (object) {
                return vmr.instantiateClass(className);
            }
        }
        return () -> new DebuggerResult(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FXPlatformSupplier<DebuggerResult> instantiateClass(String className, String[] paramTypes, DebuggerObject[] args) {
        if (paramTypes == null || args == null || paramTypes.length == 0 || args.length == 0) {
            return this.instantiateClass(className);
        }
        VMReference vmr = this.getVM();
        if (vmr != null) {
            ObjectReference[] orArgs = new ObjectReference[args.length];
            for (int i = 0; i < args.length; ++i) {
                JdiObject jdiObject = (JdiObject)args[i];
                orArgs[i] = jdiObject.getObjectReference();
            }
            Object object = this.serverThreadLock;
            synchronized (object) {
                return vmr.instantiateClass(className, paramTypes, orArgs);
            }
        }
        return () -> new DebuggerResult(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public FXPlatformSupplier<DebuggerClass> getClass(String className, boolean initialize) throws ClassNotFoundException {
        ReferenceType classMirror;
        VMReference vmr = this.getVM();
        if (vmr == null) {
            throw new ClassNotFoundException("Virtual machine terminated.");
        }
        Object object = this.serverThreadLock;
        synchronized (object) {
            classMirror = initialize && this.machineState != 3 ? vmr.loadInitClass(className) : vmr.loadClass(className);
        }
        return () -> new JdiClass(classMirror);
    }

    @OnThread(value=Tag.Any)
    private void fireTargetEvent(DebuggerEvent ce, boolean skipUpdate) {
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].processDebuggerEvent(ce, skipUpdate);
        }
    }

    @OnThread(value=Tag.Any)
    void raiseStateChangeEvent(int newState) {
        if (newState != this.machineState) {
            if (this.machineState == 4 && newState != 3) {
                this.doStateChange(4, 3);
            }
            if (this.machineState == 3 && newState == 1) {
                this.doStateChange(3, 2);
            }
            this.doStateChange(this.machineState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    private void doStateChange(int oldState, int newState) {
        DebuggerListener[] debuggerListenerArray = this.listenerList;
        synchronized (this.listenerList) {
            DebuggerListener[] ll = this.listenerList.toArray(new DebuggerListener[this.listenerList.size()]);
            this.machineState = newState;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (DebuggerListener l : ll) {
                l.processDebuggerEvent(new DebuggerEvent((Object)this, 1, oldState, newState), false);
            }
            return;
        }
    }

    @Override
    public String toggleBreakpoint(String className, int line, boolean set, Map<String, String> properties) {
        VMReference vmr = this.getVM();
        try {
            if (vmr != null) {
                if (set) {
                    return vmr.setBreakpoint(className, line, properties);
                }
                return vmr.clearBreakpoint(className, line);
            }
            return "VM terminated.";
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            e.printStackTrace(System.out);
            return Config.getString("debugger.jdiDebugger.internalErrorMsg");
        }
    }

    @Override
    public String toggleBreakpoint(String className, String method, boolean set, Map<String, String> properties) {
        VMReference vmr = this.getVM();
        try {
            if (vmr != null) {
                if (set) {
                    return vmr.setBreakpoint(className, method, properties);
                }
                return vmr.clearBreakpoint(className, method);
            }
            return "VM terminated.";
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            e.printStackTrace(System.out);
            return Config.getString("debugger.jdiDebugger.internalErrorMsg");
        }
    }

    @Override
    public String toggleBreakpoint(DebuggerClass debuggerClass, String method, boolean set, Map<String, String> properties) {
        VMReference vmr = this.getVM();
        try {
            if (vmr != null) {
                JdiClass jdiClass = (JdiClass)debuggerClass;
                if (set) {
                    return vmr.setBreakpoint(jdiClass.remoteClass, method, properties);
                }
                return vmr.clearBreakpoint(jdiClass.remoteClass, method);
            }
            return "VM terminated.";
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            e.printStackTrace(System.out);
            return Config.getString("debugger.jdiDebugger.internalErrorMsg");
        }
    }

    @OnThread(value=Tag.Any)
    public void breakpoint(ThreadReference tr, int debuggerEventType, boolean skipUpdate, DebuggerEvent.BreakpointProperties props) {
        JdiThread breakThread = this.allThreads.find(tr);
        if (!skipUpdate) {
            this.threadListener.threadStateChanged(breakThread, true);
        }
        this.fireTargetEvent(new DebuggerEvent(this, debuggerEventType, breakThread, props), skipUpdate);
    }

    @OnThread(value=Tag.Any)
    public boolean screenBreakpoint(ThreadReference thread, int debuggerEventType, DebuggerEvent.BreakpointProperties props) {
        JdiThread breakThread = this.allThreads.find(thread);
        breakThread.stopped();
        DebuggerEvent event = new DebuggerEvent(this, debuggerEventType, breakThread, props);
        boolean done = false;
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            done = done || listeners[i].examineDebuggerEvent(event);
        }
        return done;
    }

    @OnThread(value=Tag.Any)
    synchronized void vmDisconnect() {
        if (this.autoRestart) {
            this.allThreads.clear();
            if (this.vmRef != null) {
                if (!this.selfRestart) {
                    this.machineLoader = new MachineLoaderThread();
                }
                this.selfRestart = true;
                this.vmRef.closeIO();
                this.vmRef = null;
                this.raiseStateChangeEvent(1);
                this.launch();
                this.usedNames.clear();
                this.threadListener.clearThreads();
            }
        }
    }

    @OnThread(value=Tag.Any)
    void threadStart(ThreadReference tr) {
        JdiThread newThread = new JdiThread(this, tr);
        this.allThreads.add(newThread);
        this.threadListener.addThread(newThread);
    }

    @OnThread(value=Tag.Any)
    void threadDeath(ThreadReference tr) {
        JdiThread jdiThread = this.allThreads.removeThread(tr);
        if (jdiThread != null) {
            this.threadListener.removeThread(jdiThread);
        }
    }

    @OnThread(value=Tag.Any)
    private VMReference getVM() {
        MachineLoaderThread mlt = this.machineLoader;
        if (mlt == null) {
            return null;
        }
        return mlt.getVM();
    }

    @OnThread(value=Tag.Any)
    private VMReference getVMNoWait() {
        MachineLoaderThread mlt = this.machineLoader;
        if (mlt == null) {
            return null;
        }
        return mlt.getVMNoWait();
    }

    void emitThreadHaltEvent(JdiThread thread) {
        this.vmRef.emitThreadEvent(thread, true);
    }

    void emitThreadResumedEvent(JdiThread thread) {
        this.vmRef.emitThreadEvent(thread, false);
    }

    @OnThread(value=Tag.Any)
    void threadHalted(JdiThread thread) {
        DebuggerEvent event = new DebuggerEvent(this, 2, thread, null);
        boolean skipUpdate = false;
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            skipUpdate |= listeners[i].examineDebuggerEvent(event);
        }
        if (!skipUpdate) {
            this.threadListener.threadStateChanged(thread, false);
        }
        this.fireTargetEvent(event, skipUpdate);
    }

    @OnThread(value=Tag.Any)
    void threadResumed(JdiThread thread) {
        DebuggerEvent event = new DebuggerEvent(this, 6, thread, null);
        boolean skipUpdate = false;
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            skipUpdate |= listeners[i].examineDebuggerEvent(event);
        }
        if (!skipUpdate) {
            this.threadListener.threadStateChanged(thread, false);
        }
        this.fireTargetEvent(event, skipUpdate);
    }

    @OnThread(value=Tag.Any)
    public void serverThreadResumed(ThreadReference serverThread) {
        this.allThreads.find(serverThread).notifyResumed();
    }

    @Override
    public synchronized void setRunOnThread(RunOnThread runOnThread) {
        this.runOnThread = runOnThread;
        if (this.vmRef != null) {
            this.getVM().setRunOnThread(runOnThread);
        }
    }

    class MachineLoaderThread
    extends Thread {
        @OnThread(value=Tag.Any)
        MachineLoaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @OnThread(value=Tag.Unique, ignoreParent=true)
        public void run() {
            try {
                BPClassLoader lastLoader;
                VMReference newVM = new VMReference(JdiDebugger.this, JdiDebugger.this.terminal, JdiDebugger.this.startingDirectory, JdiDebugger.this.libraries);
                JdiDebugger jdiDebugger = JdiDebugger.this;
                synchronized (jdiDebugger) {
                    if (!JdiDebugger.this.autoRestart) {
                        newVM.close();
                        JdiDebugger.this.notifyAll();
                        return;
                    }
                    lastLoader = JdiDebugger.this.lastProjectClassLoader;
                }
                newVM.newClassLoader(lastLoader.getURLs());
                newVM.setRunOnThread(JdiDebugger.this.runOnThread);
                jdiDebugger = JdiDebugger.this;
                synchronized (jdiDebugger) {
                    JdiDebugger.this.vmRef = newVM;
                }
            }
            catch (JdiVmCreationException e) {
                JdiDebugger.this.raiseStateChangeEvent(5);
            }
            JdiDebugger jdiDebugger = JdiDebugger.this;
            synchronized (jdiDebugger) {
                JdiDebugger.this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnThread(value=Tag.Any)
        private VMReference getVM() {
            JdiDebugger jdiDebugger = JdiDebugger.this;
            synchronized (jdiDebugger) {
                while (JdiDebugger.this.vmRef == null && JdiDebugger.this.autoRestart) {
                    try {
                        JdiDebugger.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return JdiDebugger.this.vmRef;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnThread(value=Tag.Any)
        private VMReference getVMNoWait() {
            JdiDebugger jdiDebugger = JdiDebugger.this;
            synchronized (jdiDebugger) {
                return JdiDebugger.this.vmRef;
            }
        }
    }
}

