/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.BadInheritanceChainException;
import bluej.debugger.gentype.GenTypeArrayClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.Reflective;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GenTypeClass
extends GenTypeSolid {
    protected List<? extends GenTypeParameter> params = null;
    protected Reflective reflective = null;
    protected GenTypeClass outer = null;

    public GenTypeClass(Reflective r) {
        this.reflective = r;
    }

    public GenTypeClass(Reflective r, List<GenTypeParameter> params) {
        this(r, params, null);
    }

    public GenTypeClass(Reflective r, List<? extends GenTypeParameter> params, GenTypeClass outer) {
        this.reflective = r;
        if (params != null && !params.isEmpty()) {
            this.params = params;
        }
        this.outer = outer;
    }

    public GenTypeClass(Reflective r, Map<String, GenTypeParameter> mparams) {
        Reflective outerReflective;
        this.reflective = r;
        if (mparams == null) {
            return;
        }
        ArrayList<? extends GenTypeParameter> params = new ArrayList<GenTypeParameter>();
        for (GenTypeDeclTpar next : r.getTypeParams()) {
            String nextName = next.getTparName();
            if (mparams.get(nextName) == null) {
                params.add(new GenTypeExtends(next.getBound()));
                continue;
            }
            params.add(mparams.get(nextName));
            mparams.remove(nextName);
        }
        if (params.isEmpty()) {
            params = null;
        }
        this.params = params;
        if (!mparams.isEmpty() && !r.isStatic() && (outerReflective = r.getOuterClass()) != null) {
            this.outer = new GenTypeClass(outerReflective, mparams);
        }
    }

    @Override
    public GenTypeClass asClass() {
        return this;
    }

    @Override
    public GenTypeClass getErasedType() {
        return new GenTypeClass(this.reflective);
    }

    public String classloaderName() {
        return this.reflective.getName();
    }

    @Override
    public String arrayComponentName() {
        return "L" + this.classloaderName() + ";";
    }

    public List<? extends GenTypeParameter> getTypeParamList() {
        if (this.params == null) {
            return Collections.emptyList();
        }
        return this.params;
    }

    public GenTypeClass getOuterType() {
        return this.outer;
    }

    public boolean isInnerType() {
        return this.reflective.getName().indexOf(36) != -1;
    }

    public boolean isGeneric() {
        if (this.outer != null) {
            return true;
        }
        return this.params != null;
    }

    public boolean isRaw() {
        if (this.outer != null || this.params != null) {
            return false;
        }
        Reflective r = this.reflective;
        List<GenTypeDeclTpar> formalParams = this.reflective.getTypeParams();
        while (formalParams.isEmpty()) {
            if (r.isStatic()) {
                return false;
            }
            if ((r = r.getOuterClass()) == null) {
                return false;
            }
            formalParams = r.getTypeParams();
        }
        return true;
    }

    @Override
    public boolean isInterface() {
        return this.reflective.isInterface();
    }

    @Override
    public String toString(NameTransform nt) {
        String baseClass = this.classloaderName();
        if (this.outer != null) {
            int i = baseClass.lastIndexOf(36);
            baseClass = this.outer.toString(nt) + '.' + baseClass.substring(i + 1);
        } else {
            baseClass = nt.transform(baseClass);
            baseClass = baseClass.replace('$', '.');
        }
        if (this.params == null) {
            return baseClass;
        }
        String r = baseClass + '<';
        Iterator<? extends GenTypeParameter> i = this.params.iterator();
        while (i.hasNext()) {
            r = r + i.next().toTypeArgString(nt);
            if (!i.hasNext()) continue;
            r = r + ',';
        }
        r = r + '>';
        return r;
    }

    @Override
    public String toTypeArgString(NameTransform nt) {
        return this.toString(nt);
    }

    @Override
    public boolean equals(JavaType other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        GenTypeClass oClass = other.asClass();
        if (oClass == null) {
            return false;
        }
        JavaType arrayComponent = this.getArrayComponent();
        JavaType oarrayComponent = oClass.getArrayComponent();
        if (arrayComponent != null) {
            return arrayComponent.equals(oarrayComponent);
        }
        if (oarrayComponent != null) {
            return false;
        }
        if (!this.classloaderName().equals(oClass.classloaderName())) {
            return false;
        }
        if (this.outer == null && oClass.outer != null) {
            return false;
        }
        if (this.outer != null && !this.outer.equals(oClass.outer)) {
            return false;
        }
        if (this.params == null) {
            return oClass.params == null;
        }
        if (oClass.params == null) {
            return false;
        }
        Iterator<? extends GenTypeParameter> i = this.params.iterator();
        Iterator<? extends GenTypeParameter> j = oClass.params.iterator();
        while (i.hasNext()) {
            if (j.hasNext() && i.next().equals(j.next())) continue;
            return false;
        }
        return !j.hasNext();
    }

    public Reflective getReflective() {
        return this.reflective;
    }

    @Override
    public boolean isAssignableFrom(JavaType t) {
        if (t.isNull()) {
            return true;
        }
        if (!(t instanceof GenTypeSolid)) {
            return false;
        }
        GenTypeClass tc = t.asClass();
        if (tc != null) {
            GenTypeClass tclass;
            if (this.isRaw()) {
                return this.reflective.isAssignableFrom(tc.reflective);
            }
            GenTypeClass cclass = this;
            try {
                tclass = tc.mapToSuper(this.reflective.getName());
            }
            catch (BadInheritanceChainException bice) {
                return false;
            }
            if (tclass.isRaw()) {
                return false;
            }
            while (cclass != null) {
                if (cclass.params != null) {
                    Iterator<? extends GenTypeParameter> i = cclass.params.iterator();
                    Iterator<? extends GenTypeParameter> j = tclass.params.iterator();
                    while (i.hasNext()) {
                        GenTypeParameter tpar;
                        GenTypeParameter cpar = i.next();
                        if (cpar.contains(tpar = j.next())) continue;
                        return false;
                    }
                }
                cclass = cclass.outer;
                tclass = tclass.outer;
            }
            return true;
        }
        GenTypeClass[] stypes = ((GenTypeSolid)t).getReferenceSupertypes();
        for (int i = 0; i < stypes.length; ++i) {
            if (!this.isAssignableFrom(stypes[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableFrom(GenTypeClass c) {
        Reflective r = c.reflective;
        if (GenTypeClass.getInheritanceChain(r, this.reflective.getName()) != null) {
            GenTypeClass other = c.mapToSuper(this.reflective.getName());
            if (this.isRaw() || other.isRaw()) {
                return true;
            }
            if (this.outer != null && !this.outer.isAssignableFrom(other.outer)) {
                return false;
            }
            if (this.params != null) {
                Iterator<? extends GenTypeParameter> i = this.params.iterator();
                Iterator<? extends GenTypeParameter> j = other.params.iterator();
                while (i.hasNext()) {
                    GenTypeParameter oParam;
                    GenTypeParameter myParam = i.next();
                    if (myParam.contains(oParam = j.next())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isAssignableFromRaw(JavaType t) {
        if (!(t instanceof GenTypeClass)) {
            return false;
        }
        GenTypeClass c = (GenTypeClass)t;
        Reflective r = c.reflective;
        return GenTypeClass.getInheritanceChain(r, this.reflective.getName()) != null;
    }

    public GenTypeClass mapToSuper(String basename) {
        String bname;
        if (this.classloaderName().equals(basename)) {
            return this;
        }
        Stack<Reflective> inheritanceStack = GenTypeClass.getInheritanceChain(this.reflective, basename);
        if (inheritanceStack == null) {
            throw new BadInheritanceChainException();
        }
        Iterator i = inheritanceStack.iterator();
        i.next();
        Reflective subType = this.reflective;
        GenTypeClass ccc = this;
        do {
            Reflective baseType = (Reflective)i.next();
            bname = baseType.getName();
            Map<String, GenTypeParameter> tparams = ccc.getMap();
            ccc = GenTypeClass.mapGenericParamsToDirectBase(tparams, subType, baseType);
            subType = baseType;
        } while (!bname.equals(basename));
        return ccc;
    }

    private static GenTypeClass mapGenericParamsToDirectBase(Map<String, ? extends GenTypeParameter> tparams, Reflective subType, Reflective baseType) {
        GenTypeParameter baseClass = subType.superTypeByName(baseType.getName());
        if (tparams == null) {
            return new GenTypeClass(baseClass.reflective);
        }
        baseClass = baseClass.mapTparsToTypes((Map)tparams);
        return baseClass;
    }

    @Override
    public GenTypeClass mapTparsToTypes(Map<String, ? extends GenTypeParameter> tparams) {
        if (this.params == null && this.outer == null) {
            return this;
        }
        if (tparams == null) {
            return new GenTypeClass(this.reflective);
        }
        ArrayList<GenTypeParameter> retlist = new ArrayList<GenTypeParameter>();
        if (this.params != null) {
            Iterator<? extends GenTypeParameter> i = this.params.iterator();
            while (i.hasNext()) {
                retlist.add(i.next().mapTparsToTypes(tparams));
            }
        }
        GenTypeParameter newOuter = null;
        if (this.outer != null) {
            newOuter = this.outer.mapTparsToTypes((Map)tparams);
        }
        return new GenTypeClass(this.reflective, retlist, (GenTypeClass)newOuter);
    }

    public GenTypeClass mapToDerived(Reflective derivedType) {
        if (!this.isGeneric()) {
            return new GenTypeClass(derivedType);
        }
        if (derivedType.getName().equals(this.classloaderName())) {
            return this;
        }
        Stack<Reflective> classes = GenTypeClass.getInheritanceChain(derivedType, this.classloaderName());
        if (classes == null) {
            return null;
        }
        GenTypeClass curBaseC = this;
        classes.pop();
        while (!classes.empty()) {
            Reflective curSubtype = classes.pop();
            HashMap<String, GenTypeParameter> newMap = new HashMap<String, GenTypeParameter>();
            GenTypeClass baseDecl = curSubtype.superTypeByName(curBaseC.classloaderName());
            if (baseDecl.isRaw()) {
                return new GenTypeClass(derivedType);
            }
            baseDecl.getParamsFromTemplate(newMap, curBaseC);
            curBaseC = new GenTypeClass(curSubtype, newMap);
        }
        return curBaseC;
    }

    @OnThread(value=Tag.FXPlatform)
    public Map<String, GenTypeParameter> getMap() {
        if (this.isRaw()) {
            return null;
        }
        HashMap<String, GenTypeParameter> r = new HashMap<String, GenTypeParameter>();
        this.mergeMap(r);
        return r;
    }

    public void mergeMap(Map<String, GenTypeParameter> m) {
        if (this.outer != null) {
            this.outer.mergeMap(m);
        }
        List<GenTypeDeclTpar> formalParams = this.reflective.getTypeParams();
        if (this.params == null) {
            return;
        }
        Iterator<? extends GenTypeParameter> paramIterator = this.params.iterator();
        Iterator<GenTypeDeclTpar> formalIterator = formalParams.iterator();
        while (paramIterator.hasNext()) {
            GenTypeParameter paramType = paramIterator.next();
            GenTypeDeclTpar formalType = formalIterator.next();
            String paramName = formalType.getTparName();
            m.put(paramName, paramType);
        }
    }

    private static Stack<Reflective> getInheritanceChain(Reflective top, String bottom) {
        Stack<Reflective> r = new Stack<Reflective>();
        r.push(top);
        if (top.getName().equals(bottom)) {
            return r;
        }
        List<Reflective> l = top.getSuperTypesR();
        for (Reflective next : l) {
            Stack<Reflective> r2 = GenTypeClass.getInheritanceChain(next, bottom);
            if (r2 == null) continue;
            r.addAll(r2);
            return r;
        }
        return null;
    }

    @Override
    public void getParamsFromTemplate(Map<String, GenTypeParameter> r, GenTypeParameter template) {
        GenTypeClass classTemplate;
        if (template instanceof GenTypeClass && (classTemplate = (GenTypeClass)template).classloaderName().equals(this.classloaderName())) {
            if (this.params == null || classTemplate.params == null) {
                return;
            }
            Iterator<? extends GenTypeParameter> i = this.params.iterator();
            Iterator<? extends GenTypeParameter> j = classTemplate.params.iterator();
            if (this.outer != null) {
                this.outer.getParamsFromTemplate(r, classTemplate.outer);
            }
            while (i.hasNext() && j.hasNext()) {
                GenTypeSolid ip = (GenTypeSolid)i.next();
                GenTypeParameter jp = j.next();
                ip.getParamsFromTemplate(r, jp);
            }
        }
    }

    @Override
    public void erasedSuperTypes(Set<Reflective> s) {
        Stack<Reflective> refs = new Stack<Reflective>();
        refs.push(this.reflective);
        while (!refs.empty()) {
            Reflective r = (Reflective)refs.pop();
            if (s.contains(r)) continue;
            s.add(r);
            refs.addAll(r.getSuperTypesR());
        }
    }

    @Override
    public GenTypeClass[] getReferenceSupertypes() {
        return new GenTypeClass[]{this};
    }

    @Override
    public GenTypeClass getArray() {
        return new GenTypeArrayClass(this.reflective.getArrayOf(), this);
    }

    @Override
    public GenTypeClass getCapture() {
        if (this.outer == null && this.params == null) {
            return this;
        }
        GenTypeClass outerCapture = this.outer == null ? null : this.outer.getCapture();
        boolean isDifferent = outerCapture != this.outer;
        ArrayList<JavaType> capturedParams = null;
        if (this.params != null) {
            capturedParams = new ArrayList<JavaType>(this.params.size());
            for (GenTypeParameter genTypeParameter : this.params) {
                JavaType captured = genTypeParameter.getTparCapture();
                isDifferent |= captured != genTypeParameter;
                capturedParams.add(captured);
            }
        }
        if (isDifferent) {
            return new GenTypeClass(this.reflective, capturedParams, outerCapture);
        }
        return this;
    }
}

