/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.Config;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import javafx.css.Styleable;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Separator;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Modality;
import javax.swing.SwingUtilities;

class DataCollectionDialog
extends Dialog<Boolean> {
    public DataCollectionDialog() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.setResizable(false);
        this.setTitle("BlueJ - " + Config.getString("collect.dialog.title"));
        Config.addDialogStylesheets(this.getDialogPane());
        VBox body = new VBox();
        JavaFXUtil.addStyleClass((Styleable)body, "blackbox-optin-content");
        Pane headerPanel = this.makeHeaderPanel();
        body.getChildren().add((Object)headerPanel);
        body.getChildren().add((Object)this.makeButtonPanel());
        body.getChildren().add((Object)new Separator(Orientation.HORIZONTAL));
        body.getChildren().add((Object)this.makeExplanationText());
        this.getDialogPane().setContent((Node)body);
    }

    private Node makeExplanationText() {
        TextFlow text = new TextFlow();
        JavaFXUtil.addStyleClass((Styleable)text, "blackbox-optin-explanation");
        Hyperlink link = new Hyperlink(Config.getString("collect.dialog.ethics.seemore") + ".");
        link.setOnAction(e -> SwingUtilities.invokeLater(() -> Utility.openWebBrowser("http://www.bluej.org/blackbox.html")));
        text.getChildren().addAll((Object[])new Node[]{new Text(Config.getString("collect.dialog.ethics1")), link, new Text("\n\n"), new Text(Config.getString("collect.dialog.ethics2"))});
        return text;
    }

    private Pane makeHeaderPanel() {
        HBox headerPanel = new HBox();
        JavaFXUtil.addStyleClass((Styleable)headerPanel, "blackbox-optin-header");
        headerPanel.getChildren().add((Object)new ImageView(Config.getFixedImageAsFXImage("bluej-icon-48.png")));
        String header = Config.getString("collect.dialog.header1") + " " + Config.getString("collect.dialog.header2") + "\n\n" + Config.getString("collect.dialog.header3");
        headerPanel.getChildren().add((Object)new TextFlow(new Node[]{(Node)JavaFXUtil.withStyleClass(new Text(header), "blackbox-optin-header-text")}));
        return headerPanel;
    }

    private Pane makeButtonPanel() {
        BorderPane buttonPanel = new BorderPane();
        Button buttonNo = new Button();
        buttonNo.setText(Config.getString("collect.dialog.no"));
        buttonNo.setOnAction(e -> {
            this.setResult(false);
            this.close();
        });
        buttonPanel.setLeft((Node)buttonNo);
        Button buttonYes = new Button();
        buttonYes.setText(Config.getString("collect.dialog.yes"));
        buttonYes.setOnAction(e -> {
            this.setResult(true);
            this.close();
        });
        buttonPanel.setRight((Node)buttonYes);
        buttonYes.setDefaultButton(true);
        this.setOnShown(e -> buttonYes.requestFocus());
        return buttonPanel;
    }
}

