/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.Boot;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.extensions.event.ApplicationEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ExtensionWrapper;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.javafx.JavaFXUtil;
import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import de.codecentric.centerdevice.MenuToolkit;
import de.codecentric.centerdevice.dialogs.about.AboutStageBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Main {
    private static final int FIRST_X_LOCATION = 20;
    private static final int FIRST_Y_LOCATION = 20;
    private static boolean launched = false;
    private static List<File> initialProjects;
    private static QuitResponse macEventResponse;
    private static ClassLoader storedContextClassLoader;

    @OnThread(value=Tag.Any)
    public Main() {
        Boot boot = Boot.getInstance();
        String[] args = Boot.cmdLineArgs;
        Properties commandLineProps = boot.getCommandLineProperties();
        File bluejLibDir = Boot.getBluejLibDir();
        Config.initialise(bluejLibDir, commandLineProps, boot.isGreenfoot());
        if (Config.isMacOS()) {
            Main.prepareMacOSApp();
        }
        if (Config.isGreenfoot()) {
            System.setProperty("java.rmi.server.useCodebaseOnly", "false");
        }
        SwingUtilities.invokeLater(() -> {
            List<ExtensionWrapper> loadedExtensions = ExtensionsManager.getInstance().getLoadedExtensions(null);
            Platform.runLater(() -> {
                DataCollector.bluejOpened(Main.getOperatingSystem(), Main.getJavaVersion(), Main.getBlueJVersion(), Main.getInterfaceLanguage(), loadedExtensions);
                Main.processArgs(args);
            });
        });
        new Thread(){

            @Override
            public void run() {
                Main.updateStats();
            }
        }.start();
    }

    @OnThread(value=Tag.FXPlatform)
    private static void processArgs(String[] args) {
        boolean openOrphans;
        launched = true;
        boolean oneOpened = false;
        if (args.length > 0) {
            for (String arg : args) {
                if (arg.startsWith("-") || arg.contains("intellij") || !PkgMgrFrame.doOpen(new File(arg), null)) continue;
                oneOpened = true;
            }
        }
        if (initialProjects != null) {
            for (File initialProject : initialProjects) {
                if (initialProject.getName().contains("intellij")) continue;
                oneOpened |= PkgMgrFrame.doOpen(initialProject, null);
            }
        }
        if (!oneOpened && (openOrphans = "true".equals(Config.getPropString("bluej.autoOpenLastProject"))) && Main.hadOrphanPackages()) {
            String exists = "";
            int i = 1;
            while (exists != null) {
                Project openProj;
                exists = Config.getPropString("bluej.openPackage" + i, null);
                if (exists != null && (openProj = Project.openProject(exists)) != null) {
                    Package pkg = openProj.getPackage(openProj.getInitialPackageName());
                    PkgMgrFrame.createFrame(pkg, null);
                    oneOpened = true;
                }
                ++i;
            }
        }
        if (!oneOpened) {
            if (!Config.isGreenfoot()) {
                Main.openEmptyFrame();
            }
        } else {
            String targetName = Config.getPropString("bluej.class.open", null);
            if (targetName != null && !targetName.equals("")) {
                boolean foundTarget = false;
                for (Project proj : Project.getProjects()) {
                    Target tgt = proj.getTarget(targetName);
                    if (tgt == null || !(tgt instanceof ClassTarget)) continue;
                    ((ClassTarget)tgt).open();
                    foundTarget = true;
                }
                if (!foundTarget) {
                    Debug.message("Did not find target class in opened project: \"" + targetName + "\"");
                }
            }
        }
        if (!Config.isGreenfoot()) {
            Boot.getInstance().disposeSplashWindow();
        }
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)new ApplicationEvent(1));
    }

    private static void prepareMacOSApp() {
        storedContextClassLoader = Thread.currentThread().getContextClassLoader();
        initialProjects = Boot.getMacInitialProjects();
        Application macApp = Application.getApplication();
        Main.prepareMacOSMenuSwing(macApp);
        if (!Config.isGreenfoot() && macApp != null) {
            Main.prepareMacOSMenuFX();
        }
        if (Config.isGreenfoot()) {
            Debug.message("Disabling App Nap");
            try {
                Runtime.getRuntime().exec("defaults write org.greenfoot NSAppSleepDisabled -bool YES");
            }
            catch (IOException e) {
                Debug.reportError("Error disabling App Nap", e);
            }
        }
    }

    private static void prepareMacOSMenuFX() {
        Platform.runLater(() -> {
            FXMLLoader.setDefaultClassLoader((ClassLoader)AboutStageBuilder.class.getClassLoader());
            MenuToolkit menuToolkit = MenuToolkit.toolkit();
            Menu defaultApplicationMenu = menuToolkit.createDefaultApplicationMenu(Config.getApplicationName());
            menuToolkit.setApplicationMenu(defaultApplicationMenu);
            ((MenuItem)defaultApplicationMenu.getItems().get(0)).setOnAction(event -> PkgMgrFrame.handleAbout());
            MenuItem preferences = new MenuItem(Config.getString("menu.tools.preferences"));
            if (Config.hasAcceleratorKey("menu.tools.preferences")) {
                preferences.setAccelerator(Config.getAcceleratorKeyFX("menu.tools.preferences"));
            }
            preferences.setOnAction(event -> PkgMgrFrame.handlePreferences());
            defaultApplicationMenu.getItems().add(1, (Object)preferences);
            ((MenuItem)defaultApplicationMenu.getItems().get(defaultApplicationMenu.getItems().size() - 1)).setOnAction(event -> PkgMgrFrame.handleQuit());
        });
    }

    private static void prepareMacOSMenuSwing(Application macApp) {
        if (macApp != null) {
            macApp.setAboutHandler(new AboutHandler(){

                public void handleAbout(AppEvent.AboutEvent e) {
                    Platform.runLater(() -> PkgMgrFrame.handleAbout());
                }
            });
            macApp.setPreferencesHandler(new PreferencesHandler(){

                public void handlePreferences(AppEvent.PreferencesEvent e) {
                    Platform.runLater(() -> PkgMgrFrame.handlePreferences());
                }
            });
            macApp.setQuitHandler(new QuitHandler(){

                public void handleQuitRequestWith(AppEvent.QuitEvent e, QuitResponse response) {
                    macEventResponse = response;
                    Platform.runLater(() -> PkgMgrFrame.handleQuit());
                }
            });
            macApp.setOpenFileHandler(new OpenFilesHandler(){

                public void openFiles(AppEvent.OpenFilesEvent e) {
                    if (launched) {
                        List files = e.getFiles();
                        Platform.runLater(() -> {
                            for (File file : files) {
                                PkgMgrFrame.doOpen(file, null);
                            }
                        });
                    } else {
                        initialProjects = e.getFiles();
                    }
                }
            });
        }
        Boot.getInstance().setQuitHandler(() -> Platform.runLater(PkgMgrFrame::handleQuit));
    }

    @OnThread(value=Tag.FXPlatform)
    public static void wantToQuit() {
        int answer;
        int projectCount = Project.getOpenProjectCount();
        int n = answer = projectCount <= 1 ? 0 : DialogManager.askQuestionFX(null, "quit-all");
        if (answer == 0) {
            Main.doQuit();
        } else {
            SwingUtilities.invokeLater(() -> {
                if (macEventResponse != null) {
                    macEventResponse.cancelQuit();
                    macEventResponse = null;
                }
            });
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static void doQuit() {
        PkgMgrFrame[] pkgFrames = PkgMgrFrame.getAllFrames();
        Main.handleOrphanPackages(pkgFrames);
        int i = pkgFrames.length - 1;
        while (i >= 0) {
            PkgMgrFrame aFrame = pkgFrames[i--];
            aFrame.doSave();
            aFrame.closePackage();
            PkgMgrFrame.closeFrame(aFrame);
        }
        SwingUtilities.invokeLater(() -> {
            ExtensionsManager extMgr = ExtensionsManager.getInstance();
            extMgr.unloadExtensions();
            Platform.runLater(() -> Main.exit());
        });
    }

    @OnThread(value=Tag.FXPlatform)
    private static void handleOrphanPackages(PkgMgrFrame[] openFrames) {
        if (Main.hadOrphanPackages()) {
            Main.removeOrphanPackageList();
        }
        for (int i = 0; i < openFrames.length; ++i) {
            PkgMgrFrame aFrame = openFrames[i];
            if (aFrame.isEmptyFrame()) continue;
            Config.putPropString("bluej.openPackage" + (i + 1), aFrame.getPackage().getPath().toString());
        }
    }

    public static boolean hadOrphanPackages() {
        String dir = "";
        int i = 1;
        while (dir != null) {
            dir = Config.getPropString("bluej.openPackage" + i, null);
            if (dir != null && Project.isProject(dir)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void removeOrphanPackageList() {
        String exists = "";
        int i = 1;
        while (exists != null) {
            exists = Config.removeProperty("bluej.openPackage" + i);
            ++i;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private static void openEmptyFrame() {
        PkgMgrFrame frame = PkgMgrFrame.createFrame();
        frame.getFXWindow().setX(20.0);
        frame.getFXWindow().setY(20.0);
        frame.setVisible(true);
    }

    private static void updateStats() {
        String appVersion;
        String baseURL;
        String uidPropName;
        if (Config.isGreenfoot()) {
            uidPropName = "greenfoot.uid";
            baseURL = "http://stats.greenfoot.org/updateGreenfoot.php";
            appVersion = Boot.GREENFOOT_VERSION;
        } else {
            uidPropName = "bluej.uid";
            baseURL = "http://stats.bluej.org/updateBlueJ.php";
            appVersion = Main.getBlueJVersion();
        }
        String language = Main.getInterfaceLanguage();
        String javaVersion = Main.getJavaVersion();
        String systemID = Main.getOperatingSystem();
        String editorStats = "";
        int javaEditors = Config.getEditorCount(Config.SourceType.Java);
        int strideEditors = Config.getEditorCount(Config.SourceType.Stride);
        try {
            if (javaEditors != -1 && strideEditors != -1) {
                editorStats = "&javaeditors=" + URLEncoder.encode(Integer.toString(javaEditors), "UTF-8") + "&strideeditors=" + URLEncoder.encode(Integer.toString(strideEditors), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException ex) {
            Debug.reportError(ex);
        }
        Config.resetEditorsCount();
        String uid = Config.getPropString(uidPropName, null);
        if (uid == null) {
            uid = UUID.randomUUID().toString();
            Config.putPropString(uidPropName, uid);
        } else if (uid.equalsIgnoreCase("private")) {
            return;
        }
        try {
            URL url = new URL(baseURL + "?uid=" + URLEncoder.encode(uid, "UTF-8") + "&osname=" + URLEncoder.encode(systemID, "UTF-8") + "&appversion=" + URLEncoder.encode(appVersion, "UTF-8") + "&javaversion=" + URLEncoder.encode(javaVersion, "UTF-8") + "&language=" + URLEncoder.encode(language, "UTF-8") + editorStats);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            int rc = conn.getResponseCode();
            conn.disconnect();
            if (rc != 200) {
                Debug.reportError("Update stats failed, HTTP response code: " + rc);
            }
        }
        catch (Exception ex) {
            Debug.reportError("Update stats failed: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    private static String getBlueJVersion() {
        return "4.1.1";
    }

    private static String getOperatingSystem() {
        return System.getProperty("os.name") + "/" + System.getProperty("os.arch") + "/" + System.getProperty("os.version");
    }

    private static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    private static String getInterfaceLanguage() {
        return Config.language;
    }

    @OnThread(value=Tag.FXPlatform)
    private static void exit() {
        if (PkgMgrFrame.frameCount() > 0) {
            Debug.reportError("Frame count was not zero when exiting. Work may not have been saved");
        }
        DataCollector.bluejClosed();
        Config.handleExit();
        JavaFXUtil.runAfterCurrent(() -> SwingUtilities.invokeLater(() -> System.exit(0)));
    }

    public static ClassLoader getStoredContextClassLoader() {
        return storedContextClassLoader;
    }

    static {
        macEventResponse = null;
    }
}

