/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.SplashWindow;
import com.sun.glass.ui.Application;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Boot {
    public static final int BLUEJ_VERSION_MAJOR = 4;
    public static final int BLUEJ_VERSION_MINOR = 1;
    public static final int BLUEJ_VERSION_RELEASE = 1;
    public static final String BLUEJ_VERSION_SUFFIX = "";
    public static final String BLUEJ_VERSION = "4.1.1";
    public static final String BLUEJ_VERSION_TITLE = "BlueJ 4.1.1";
    private static final int bluejBuildJars = 3;
    private static final String[] bluejUserJars = new String[]{"bluejcore.jar", "junit-4.11.jar", "hamcrest-core-1.3.jar", "lang-stride.jar"};
    private static final int bluejUserBuildJars = 1;
    private static final String JLAYER_MP3_JAR = "jl1.0.1.jar";
    public static final String[] GREENFOOT_EXPORT_JARS = new String[]{"jl1.0.1.jar", "lang-stride.jar"};
    private static final String[] greenfootUserJars = new String[]{"extensions" + File.separatorChar + "greenfoot.jar", "bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "AppleJavaExtensions.jar", "junit-4.11.jar", "hamcrest-core-1.3.jar", "bluej.jar", "diffutils-1.2.1.jar", "commons-logging-api-1.1.2.jar", "jl1.0.1.jar", "opencsv-2.3.jar", "xom-1.2.9.jar", "lang-stride.jar", "guava-17.0.jar", "javassist-3.18.0.jar", "commons-vfs2-2.0.jar", "httpclient-4.1.1.jar", "httpcore-4.1.jar", "httpmime-4.1.1.jar"};
    private static final int greenfootUserBuildJars = 4;
    public static String GREENFOOT_VERSION = "3.1.0";
    public static String GREENFOOT_API_VERSION = "3.0.0";
    private static Boot instance;
    private static final String[] bluejJars;
    private static String[] runtimeJars;
    private static String[] userJars;
    private static int numBuildJars;
    private static int numUserBuildJars;
    private static String jfxrtJar;
    private static boolean isGreenfoot;
    private static File bluejLibDir;
    private static final ArrayList<File> macInitialProjects;
    private @OnThread(value=Tag.FXPlatform) SplashWindow splashWindow;
    public static String[] cmdLineArgs;
    private final Properties commandLineProps;
    private File javaHomeDir;
    private ClassLoader bootLoader;
    private URL[] runtimeUserClassPath;
    private URL[] runtimeClassPath;
    private Runnable quitAction;

    private Boot(Properties props, FXPlatformSupplier<Image> image) {
        CompletableFuture shown = new CompletableFuture();
        Platform.runLater(() -> {
            this.splashWindow = new SplashWindow((Image)image.get());
            shown.complete(true);
        });
        try {
            shown.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        this.commandLineProps = props;
    }

    public static void main(String[] args) {
        cmdLineArgs = args;
        javafx.application.Application.launch(App.class, (String[])args);
    }

    public static List<File> getMacInitialProjects() {
        return macInitialProjects;
    }

    @OnThread(value=Tag.Any)
    public static void subMain() {
        Properties commandLineProps = Boot.processCommandLineProperties(cmdLineArgs);
        isGreenfoot = commandLineProps.getProperty("greenfoot", "false").equals("true");
        FXPlatformSupplier<Image> image = new FXPlatformSupplier<Image>(){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public Image get() {
                URL url = this.getClass().getResource(isGreenfoot ? "gen-greenfoot-splash.png" : "gen-bluej-splash.png");
                if (url != null) {
                    return new Image(url.toString());
                }
                WritableImage writableImage = new WritableImage(500, 300);
                int y = 0;
                while ((double)y < writableImage.getHeight()) {
                    int x = 0;
                    while ((double)x < writableImage.getWidth()) {
                        writableImage.getPixelWriter().setColor(x, y, Color.WHITE);
                        ++x;
                    }
                    ++y;
                }
                return writableImage;
            }
        };
        if (isGreenfoot) {
            runtimeJars = greenfootUserJars;
            userJars = greenfootUserJars;
            numBuildJars = 4;
            numUserBuildJars = 4;
        }
        jfxrtJar = commandLineProps.getProperty("jfxrt.jarpath");
        try {
            instance = new Boot(commandLineProps, image);
            instance.bootBluej();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        Boot boot = instance;
        synchronized (boot) {
            while (true) {
                try {
                    while (true) {
                        instance.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static Boot getInstance() {
        return instance;
    }

    public static File getBluejLibDir() {
        if (bluejLibDir == null) {
            bluejLibDir = Boot.calculateBluejLibDir();
        }
        return bluejLibDir;
    }

    private static File calculateBluejLibDir() {
        File bluejDir = null;
        String bootFullName = Boot.class.getResource("Boot.class").toString();
        try {
            if (!bootFullName.startsWith("jar:")) {
                File startingDir;
                for (startingDir = new File(new URI(bootFullName)).getParentFile(); startingDir != null && !new File(startingDir.getParentFile(), "lib").isDirectory(); startingDir = startingDir.getParentFile()) {
                }
                bluejDir = startingDir == null ? null : new File(startingDir.getParentFile(), "lib");
            } else {
                int classIndex = bootFullName.indexOf("!");
                String bootName = bootFullName.substring(4, classIndex);
                File finalFile = new File(new URI(bootName));
                bluejDir = finalFile.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return bluejDir;
    }

    public static URL getJREJar(String name) throws MalformedURLException {
        String jrePathName = System.getProperty("java.home");
        if (jrePathName != null) {
            File jrePath = new File(jrePathName);
            if (jrePath.canRead()) {
                File jarPath = new File(jrePath, "lib/" + name);
                if (jarPath.canRead()) {
                    return jarPath.toURI().toURL();
                }
                System.err.println("Could not find " + name + " at: " + jarPath.getAbsolutePath());
            } else {
                System.err.println("Could not find JRE at: " + jrePath.getAbsolutePath());
            }
        } else {
            System.err.println("Could not find Java path");
        }
        return null;
    }

    private static Properties processCommandLineProperties(String[] args) {
        Properties props = new Properties();
        for (String arg : args) {
            String definition;
            int definitionEquals;
            if (!arg.startsWith("-") || (definitionEquals = (definition = arg.substring(1)).indexOf(61)) < 0) continue;
            String propName = definition.substring(0, definitionEquals);
            String propValue = definition.substring(definitionEquals + 1);
            if (propName.equals(BLUEJ_VERSION_SUFFIX) || propValue.equals(BLUEJ_VERSION_SUFFIX)) continue;
            props.put(propName, propValue);
        }
        return props;
    }

    public static boolean isTrialRecording() {
        return false;
    }

    public void disposeSplashWindow() {
        Platform.runLater(() -> {
            if (this.splashWindow != null) {
                this.splashWindow.hide();
                this.splashWindow = null;
            }
        });
    }

    public boolean isGreenfoot() {
        return isGreenfoot;
    }

    public File getJavaHome() {
        return this.javaHomeDir;
    }

    public URL[] getRuntimeClassPath() {
        return this.runtimeClassPath;
    }

    public URL[] getRuntimeUserClassPath() {
        return this.runtimeUserClassPath;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootLoader;
    }

    @OnThread(value=Tag.Any)
    private void bootBluej() {
        this.initializeBoot();
        try {
            URLClassLoader runtimeLoader = new URLClassLoader(this.runtimeClassPath, this.bootLoader);
            Class<?> mainClass = Class.forName("bluej.Main", true, runtimeLoader);
            mainClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void initializeBoot() {
        this.bootLoader = this.getClass().getClassLoader();
        this.javaHomeDir = new File(System.getProperty("java.home"));
        try {
            this.runtimeClassPath = this.getKnownJars(Boot.getBluejLibDir(), runtimeJars, true, numBuildJars);
            this.runtimeUserClassPath = this.getKnownJars(Boot.getBluejLibDir(), userJars, false, numUserBuildJars);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private URL[] getKnownJars(File libDir, String[] jars, boolean isSystem, int numBuildJars) throws MalformedURLException {
        URL toolsURL;
        File classesDir;
        boolean useClassesDir = this.commandLineProps.getProperty("useclassesdir", "false").equals("true");
        int startJar = 0;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (numBuildJars != 0 && useClassesDir && (classesDir = new File(libDir.getParentFile(), "classes")).isDirectory()) {
            String gfClassesDir;
            urlList.add(classesDir.toURI().toURL());
            urlList.add(new File(libDir.getParentFile(), "threadchecker/classes").toURI().toURL());
            if (isGreenfoot && (gfClassesDir = this.commandLineProps.getProperty("greenfootclassesdir")) != null) {
                classesDir = new File(gfClassesDir);
                urlList.add(classesDir.toURI().toURL());
            }
            startJar = numBuildJars;
        }
        for (int i = startJar; i < jars.length; ++i) {
            File toAdd = new File(libDir, jars[i]);
            if (!toAdd.canRead()) continue;
            urlList.add(toAdd.toURI().toURL());
        }
        if (isSystem && (toolsURL = this.getToolsURL()) != null) {
            urlList.add(toolsURL);
        }
        if (isGreenfoot && jfxrtJar != null && jfxrtJar.length() != 0) {
            urlList.add(new File(jfxrtJar).toURI().toURL());
        }
        return urlList.toArray(new URL[0]);
    }

    private URL getToolsURL() throws MalformedURLException {
        File toolsFile = new File(this.javaHomeDir, "lib/tools.jar");
        if (toolsFile.canRead()) {
            return toolsFile.toURI().toURL();
        }
        File parentDir = this.javaHomeDir.getParentFile();
        toolsFile = new File(parentDir, "lib/tools.jar");
        if (toolsFile.canRead()) {
            return toolsFile.toURI().toURL();
        }
        System.err.println("class Boot: tools.jar not found. Potential problem for execution.  (Java Home: " + this.javaHomeDir.getAbsolutePath() + ")");
        return null;
    }

    public Properties getCommandLineProperties() {
        return this.commandLineProps;
    }

    public void setQuitHandler(Runnable quitAction) {
        this.quitAction = quitAction;
    }

    static {
        bluejJars = new String[]{"bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "antlr-runtime-3.4.jar", "AppleJavaExtensions.jar", "commons-logging-api-1.1.2.jar", "commons-vfs2-2.0.jar", "diffutils-1.2.1.jar", "guava-17.0.jar", "hamcrest-core-1.3.jar", "httpclient-4.1.1.jar", "httpcore-4.1.jar", "httpmime-4.1.1.jar", "javassist-3.18.0.jar", "jsch-0.1.53.jar", "junit-4.11.jar", "lang-stride.jar", "nsmenufx-2.1.4.jar", "org.eclipse.jgit-4.1.0.jar", "richtextfx-fat-0.7-M5n.jar", "sequence-library-1.0.3.jar", "slf4j-api-1.7.2.jar", "slf4j-jdk14-1.7.2.jar", "sqljet-1.1.10.jar", "svnkit.jar", "svnkit-javahl.jar", "trilead.jar", "xom-1.2.9.jar"};
        runtimeJars = bluejJars;
        userJars = bluejUserJars;
        numBuildJars = 3;
        numUserBuildJars = 1;
        isGreenfoot = false;
        macInitialProjects = new ArrayList();
    }

    public static class App
    extends javafx.application.Application {
        public App() {
            if (System.getProperty("os.name").contains("OS X")) {
                Application glassApp = Application.GetApplication();
                glassApp.setEventHandler(new Application.EventHandler(){

                    public void handleOpenFilesAction(Application app, long time, String[] files) {
                        for (String f : files) {
                            if (f.contains(":") || f.equals("bluej.Boot") || f.startsWith("-")) continue;
                            macInitialProjects.add(new File(f));
                        }
                        super.handleOpenFilesAction(app, time, files);
                    }

                    public void handleQuitAction(Application app, long time) {
                        Boot.getInstance().quitAction.run();
                        super.handleQuitAction(app, time);
                    }
                });
            }
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void start(Stage s) throws Exception {
            Platform.setImplicitExit((boolean)false);
            s.setTitle("BlueJ");
            new Thread(() -> Boot.subMain()).start();
        }
    }

    @FunctionalInterface
    private static interface FXPlatformSupplier<T> {
        @OnThread(value=Tag.FXPlatform)
        public T get();
    }
}

