/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.lang.annotation.Inherited;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.Utils;

public class Store {
    private final Map<String, Multimap<String, String>> storeMap;
    private final transient boolean concurrent;
    private final transient Configuration configuration;
    private static final transient Supplier<List<String>> listSupplier = new Supplier<List<String>>(){

        public List<String> get() {
            return Lists.newArrayList();
        }
    };
    private static final Predicate<String> isConstructor = new Predicate<String>(){

        public boolean apply(String input) {
            return Utils.isConstructor(input);
        }
    };

    protected Store() {
        this(new ConfigurationBuilder());
    }

    public Store(Configuration configuration) {
        this.configuration = configuration;
        this.concurrent = configuration.getExecutorService() != null;
        this.storeMap = new HashMap<String, Multimap<String, String>>();
    }

    protected ListMultimap<String, String> createMultimap() {
        ListMultimap multimap = Multimaps.newListMultimap(new HashMap(), listSupplier);
        return this.concurrent ? Multimaps.synchronizedListMultimap((ListMultimap)multimap) : multimap;
    }

    public Multimap<String, String> getOrCreate(String indexName) {
        Multimap<String, String> mmap;
        if (indexName.contains(".")) {
            indexName = indexName.substring(indexName.lastIndexOf(".") + 1);
        }
        if ((mmap = this.storeMap.get(indexName)) == null) {
            mmap = this.createMultimap();
            this.storeMap.put(indexName, mmap);
        }
        return mmap;
    }

    public Multimap<String, String> get(Class<? extends Scanner> scannerClass) {
        return this.storeMap.get(scannerClass.getSimpleName());
    }

    public Set<String> get(Class<? extends Scanner> scannerClass, String ... keys) {
        HashSet result = Sets.newHashSet();
        Multimap<String, String> map = this.get(scannerClass);
        if (map != null) {
            for (String key : keys) {
                result.addAll(map.get((Object)key));
            }
        }
        return result;
    }

    public Set<String> get(Class<? extends Scanner> scannerClass, Iterable<String> keys) {
        HashSet result = Sets.newHashSet();
        Multimap<String, String> map = this.get(scannerClass);
        if (map != null) {
            for (String key : keys) {
                result.addAll(map.get((Object)key));
            }
        }
        return result;
    }

    public Map<String, Multimap<String, String>> getStoreMap() {
        return this.storeMap;
    }

    void merge(Store outer) {
        if (outer != null) {
            for (String indexName : outer.storeMap.keySet()) {
                this.getOrCreate(indexName).putAll(outer.storeMap.get(indexName));
            }
        }
    }

    public Integer getKeysCount() {
        Integer keys = 0;
        for (Multimap<String, String> multimap : this.storeMap.values()) {
            keys = keys + multimap.keySet().size();
        }
        return keys;
    }

    public Integer getValuesCount() {
        Integer values = 0;
        for (Multimap<String, String> multimap : this.storeMap.values()) {
            values = values + multimap.size();
        }
        return values;
    }

    public Set<String> getSubTypesOf(String type) {
        HashSet<String> result = new HashSet<String>();
        Set<String> subTypes = this.get(SubTypesScanner.class, type);
        result.addAll(subTypes);
        for (String subType : subTypes) {
            result.addAll(this.getSubTypesOf(subType));
        }
        return result;
    }

    public Set<String> getTypesAnnotatedWithDirectly(String annotation) {
        return this.get(TypeAnnotationsScanner.class, annotation);
    }

    public Set<String> getTypesAnnotatedWith(String annotation) {
        return this.getTypesAnnotatedWith(annotation, true);
    }

    public Set<String> getTypesAnnotatedWith(String annotation, boolean honorInherited) {
        HashSet<String> result = new HashSet<String>();
        if (this.isAnnotation(annotation)) {
            Set<String> types = this.getTypesAnnotatedWithDirectly(annotation);
            Set<String> inherited = this.getInheritedSubTypes(types, annotation, honorInherited);
            result.addAll(inherited);
        }
        return result;
    }

    public Set<String> getInheritedSubTypes(Iterable<String> types, String annotation, boolean honorInherited) {
        HashSet result;
        block4: {
            block3: {
                result = Sets.newHashSet(types);
                if (!honorInherited || !this.isInheritedAnnotation(annotation)) break block3;
                for (String type : types) {
                    if (!this.isClass(type)) continue;
                    result.addAll(this.getSubTypesOf(type));
                }
                break block4;
            }
            if (honorInherited) break block4;
            for (String type : types) {
                if (this.isAnnotation(type)) {
                    result.addAll(this.getTypesAnnotatedWith(type, false));
                    continue;
                }
                result.addAll(this.getSubTypesOf(type));
            }
        }
        return result;
    }

    public Set<String> getMethodsAnnotatedWith(String annotation) {
        return Sets.filter(this.get(MethodAnnotationsScanner.class, annotation), (Predicate)Predicates.not(isConstructor));
    }

    public Set<String> getFieldsAnnotatedWith(String annotation) {
        return this.get(FieldAnnotationsScanner.class, annotation);
    }

    public Set<String> getConstructorsAnnotatedWith(String annotation) {
        return Sets.filter(this.get(MethodAnnotationsScanner.class, annotation), isConstructor);
    }

    public Set<String> getResources(String key) {
        return this.get(ResourcesScanner.class, key);
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        Multimap<String, String> mmap = this.get(ResourcesScanner.class);
        if (mmap != null) {
            return this.get(ResourcesScanner.class, Collections2.filter((Collection)mmap.keySet(), namePredicate));
        }
        return Sets.newHashSet();
    }

    public Set<String> getResources(final Pattern pattern) {
        return this.getResources(new Predicate<String>(){

            public boolean apply(String input) {
                return pattern.matcher(input).matches();
            }
        });
    }

    public boolean isClass(String type) {
        return !ReflectionUtils.forName(type, this.configuration.getClassLoaders()).isInterface();
    }

    public boolean isAnnotation(String typeAnnotatedWith) {
        Multimap<String, String> mmap = this.get(TypeAnnotationsScanner.class);
        return mmap != null && mmap.keySet().contains(typeAnnotatedWith);
    }

    public boolean isInheritedAnnotation(String typeAnnotatedWith) {
        Multimap<String, String> mmap = this.get(TypeAnnotationsScanner.class);
        return mmap != null && mmap.get((Object)Inherited.class.getName()).contains(typeAnnotatedWith);
    }
}

