/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.Config;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.editor.stride.FXTab;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameEditorTab;
import bluej.editor.stride.MoeFXTab;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class TabMenuManager {
    protected final FXTab tab;
    private final MenuItem contextMoveNew;
    private final Menu contextMoveMenu;
    protected final Menu mainMoveMenu;
    private final MenuItem mainMoveNew;

    @OnThread(value=Tag.FXPlatform)
    public TabMenuManager(FXTab tab) {
        this.tab = tab;
        this.contextMoveMenu = JavaFXUtil.makeMenu((String)Config.getString((String)"frame.classmenu.move"), (MenuItem[])new MenuItem[0]);
        this.contextMoveNew = JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.classmenu.move.new"), () -> tab.getParent().moveToNewLater(tab), null);
        this.mainMoveNew = JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.classmenu.move.new"), () -> tab.getParent().moveToNewLater(tab), null);
        this.mainMoveMenu = JavaFXUtil.makeMenu((String)Config.getString((String)"frame.classmenu.move"), (MenuItem[])new MenuItem[0]);
        JavaFXUtil.runAfterCurrent(() -> {
            if (tab.getParent() != null) {
                this.updateMoveMenus();
            }
            tab.setContextMenu(new ContextMenu(new MenuItem[]{this.contextMoveMenu, JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.classmenu.close"), () -> tab.getParent().close(tab), null)}));
            if (tab instanceof FrameEditorTab) {
                tab.getContextMenu().getItems().add((Object)JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.classmenu.compile"), () -> ((FrameEditorTab)tab).getFrameEditor().getWatcher().scheduleCompilation(true, CompileReason.USER, CompileType.EXPLICIT_USER_COMPILE), null));
            }
            if (tab instanceof MoeFXTab) {
                tab.getContextMenu().getItems().add((Object)JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.classmenu.compile"), () -> ((MoeFXTab)tab).getMoeEditor().getWatcher().scheduleCompilation(true, CompileReason.USER, CompileType.EXPLICIT_USER_COMPILE), null));
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    protected void updateMoveMenus() {
        ArrayList<Object> classMoveItems = new ArrayList<Object>();
        ArrayList<Object> contextMoveItems = new ArrayList<Object>();
        classMoveItems.add(this.mainMoveNew);
        contextMoveItems.add(this.contextMoveNew);
        this.mainMoveNew.setDisable(this.tab.getParent().hasOneTab());
        this.contextMoveNew.setDisable(this.tab.getParent().hasOneTab());
        List allWindows = this.tab.getParent().getProject().getAllFXTabbedEditorWindows();
        if (allWindows.size() > 1) {
            classMoveItems.add(new SeparatorMenuItem());
            contextMoveItems.add(new SeparatorMenuItem());
            allWindows.stream().filter(w -> w != this.tab.getParent()).forEach(w -> {
                StringExpression itemText = new ReadOnlyStringWrapper(Config.getString((String)"frame.classmenu.move.existing") + ": ").concat((Object)w.titleProperty());
                contextMoveItems.add(JavaFXUtil.makeMenuItem((StringExpression)itemText, () -> this.tab.getParent().moveTabTo(this.tab, (FXTabbedEditor)w), null));
                classMoveItems.add(JavaFXUtil.makeMenuItem((StringExpression)itemText, () -> this.tab.getParent().moveTabTo(this.tab, (FXTabbedEditor)w), null));
            });
        }
        if (this.mainMoveMenu != null) {
            this.mainMoveMenu.getItems().setAll(classMoveItems);
        }
        if (this.contextMoveMenu != null) {
            this.contextMoveMenu.getItems().setAll(contextMoveItems);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    abstract List<Menu> getMenus();
}

