/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.editor.moe.MoeEditor;
import bluej.editor.stride.FXTab;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.TabMenuManager;
import bluej.utility.javafx.JavaFXUtil;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class MoeFXTab
extends FXTab {
    private boolean initialised = false;
    private final MoeEditor moeEditor;
    private final TabMenuManager menuManager;
    private final StringProperty windowTitleProperty = new SimpleStringProperty();
    private FXTabbedEditor parent;

    @OnThread(value=Tag.FXPlatform)
    public MoeFXTab(final MoeEditor moeEditor, String windowTitle) {
        super(false);
        this.moeEditor = moeEditor;
        this.windowTitleProperty.set((Object)windowTitle);
        this.menuManager = new TabMenuManager(this){

            @Override
            @OnThread(value=Tag.FXPlatform)
            List<Menu> getMenus() {
                this.updateMoveMenus();
                List<Menu> moeFXMenu = moeEditor.getFXMenu();
                if (moeFXMenu.get(0).getItems().get(0) != this.mainMoveMenu) {
                    moeFXMenu.get(0).getItems().add(0, (Object)this.mainMoveMenu);
                    moeFXMenu.get(0).getItems().add(1, (Object)new SeparatorMenuItem());
                }
                return moeFXMenu;
            }
        };
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"moe-tab"});
    }

    public void setWindowTitle(String title) {
        this.windowTitleProperty.set((Object)title);
    }

    public void setErrorStatus(boolean errorStatus) {
        if (errorStatus) {
            JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"bj-tab-error"});
        } else {
            this.getStyleClass().removeAll((Object[])new String[]{"bj-tab-error"});
        }
    }

    @Override
    void focusWhenShown() {
        this.moeEditor.requestEditorFocus();
    }

    @Override
    List<Menu> getMenus() {
        return this.menuManager.getMenus();
    }

    @Override
    FXTabbedEditor getParent() {
        return this.parent;
    }

    @Override
    String getWebAddress() {
        return null;
    }

    @Override
    void initialiseFX() {
        if (!this.initialised) {
            this.initialised = true;
        }
        this.setContent((Node)this.moeEditor);
        this.setText("");
        Label titleLabel = new Label((String)this.windowTitleProperty.get());
        titleLabel.textProperty().bind((ObservableValue)this.windowTitleProperty);
        HBox tabHeader = new HBox(new Node[]{titleLabel});
        tabHeader.setAlignment(Pos.CENTER);
        tabHeader.setSpacing(3.0);
        tabHeader.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getButton() == MouseButton.MIDDLE) {
                this.moeEditor.setEditorVisible(false);
            }
        });
        this.setGraphic((Node)tabHeader);
    }

    @Override
    public void notifySelected() {
        this.moeEditor.notifyVisibleTab(true);
    }

    @Override
    public void notifyUnselected() {
        this.moeEditor.notifyVisibleTab(false);
        this.moeEditor.cancelFreshState();
    }

    @Override
    void setParent(FXTabbedEditor parent, boolean partOfMove) {
        this.parent = parent;
        this.moeEditor.setParent(parent, partOfMove);
        this.moeEditor.notifyVisibleTab(false);
    }

    @Override
    ObservableStringValue windowTitleProperty() {
        return this.windowTitleProperty;
    }

    public MoeEditor getMoeEditor() {
        return this.moeEditor;
    }
}

