/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.Config;
import bluej.collect.StrideEditReason;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.editor.TextEditor;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.stride.FrameEditorTab;
import bluej.parser.AssistContent;
import bluej.parser.CodeSuggestions;
import bluej.parser.ParseUtils;
import bluej.parser.PrefixCompletionWrapper;
import bluej.parser.SourceLocation;
import bluej.parser.entity.EntityResolver;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.ClassTarget;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.LocalCompletion;
import bluej.stride.framedjava.frames.LocalTypeCompletion;
import bluej.stride.framedjava.frames.PrimitiveDebugVarInfo;
import bluej.stride.framedjava.frames.ReferenceDebugVarInfo;
import bluej.stride.framedjava.frames.TopLevelFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import bluej.utility.JavaReflective;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.print.PrinterJob;
import javax.swing.text.BadLocationException;
import nu.xom.Element;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class FrameEditor
implements Editor {
    private @OnThread(value=Tag.FXPlatform) boolean isCompiled;
    private @OnThread(value=Tag.FXPlatform) boolean changedSinceLastSave = true;
    private @OnThread(value=Tag.FX) String lastSavedSource = null;
    private @OnThread(value=Tag.FX) SaveJavaResult lastSavedJavaFX = null;
    private @OnThread(value=Tag.FXPlatform) SaveJavaResult lastSavedJavaSwing = null;
    private final @OnThread(value=Tag.Any) ReadWriteLock filenameLock = new ReentrantReadWriteLock();
    private @OnThread(value=Tag.Any) File frameFilename;
    private @OnThread(value=Tag.Any) File javaFilename;
    private final @OnThread(value=Tag.FX) EntityResolver resolver;
    private final EditorWatcher watcher;
    private final JavadocResolver javadocResolver;
    private final @OnThread(value=Tag.FX) SimpleObjectProperty<JavaSource> javaSource;
    private final Package pkg;
    private @OnThread(value=Tag.FX) FrameEditorTab panel;
    private final DebugInfo debugInfo = new DebugInfo();
    private @OnThread(value=Tag.FXPlatform) HighlightedBreakpoint curBreakpoint;
    private final @OnThread(value=Tag.FXPlatform) List<HighlightedBreakpoint> execHistory = new ArrayList<HighlightedBreakpoint>();
    private volatile TopLevelCodeElement lastSource;
    private final @OnThread(value=Tag.FX) List<QueuedError> queuedErrors = new ArrayList<QueuedError>();
    private final @OnThread(value=Tag.Any) FXPlatformRunnable callbackOnOpen;
    private @OnThread(value=Tag.Any, requireSynchronized=true) List<Integer> latestBreakpoints = Collections.emptyList();
    private @OnThread(value=Tag.FXPlatform) boolean foundLateErrorsForMostRecentCompile;
    private int mostRecentCompileIdentifier = -1;

    @OnThread(value=Tag.Any)
    public synchronized List<Integer> getBreakpoints() {
        return new ArrayList<Integer>(this.latestBreakpoints);
    }

    @OnThread(value=Tag.FX)
    public FrameEditor(File frameFilename, File javaFilename, EditorWatcher watcher, EntityResolver resolver, JavadocResolver javadocResolver, Package pkg, FXPlatformRunnable callbackOnOpen) {
        this.frameFilename = frameFilename;
        this.javaFilename = javaFilename;
        this.watcher = watcher;
        this.resolver = resolver;
        this.javadocResolver = javadocResolver;
        this.pkg = pkg;
        this.javaSource = new SimpleObjectProperty();
        this.callbackOnOpen = callbackOnOpen;
        this.lastSource = Loader.loadTopLevelElement((File)frameFilename, (EntityResolver)resolver);
    }

    @OnThread(value=Tag.FXPlatform)
    private void createPanel(boolean visible, boolean toFront) {
        this.panel = new FrameEditorTab(this.pkg.getProject(), this.resolver, this, this.lastSource);
        if (visible) {
            this.pkg.getProject().getDefaultFXTabbedEditor().addTab(this.panel, visible, toFront);
        } else {
            this.panel.initialiseFX();
        }
        this.panel.initialisedProperty().addListener((a, b, newVal) -> {
            if (newVal.booleanValue()) {
                JavaFXUtil.runPlatformLater(() -> {
                    this._saveFX();
                    this.findLateErrors(-1);
                });
            }
        });
        this.debugInfo.bindVarVisible(this.panel.debugVarVisibleProperty());
    }

    @Override
    public void close() {
        if (this.panel != null) {
            this.lastSource = this.panel.getSource();
            this.panel.setWindowVisible(false, false);
            this.panel.cleanup();
            this.panel = null;
        }
    }

    @Override
    public void save() throws IOException {
        SaveResult result = this._saveFX();
        if (result != null && result.exception != null) {
            throw new IOException(result.exception);
        }
        this.setSaved();
        if (this.watcher != null) {
            this.watcher.recordStrideEdit(result.javaResult.javaSourceStringContent, result.savedSource, null);
        }
        if (result.javaResult != null) {
            this.lastSavedJavaSwing = result.javaResult;
        }
    }

    private void setSaved() {
        if (this.watcher != null) {
            this.watcher.saveEvent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.FXPlatform)
    private SaveResult _saveFX() {
        if (!this.changedSinceLastSave) {
            return new SaveResult(this.lastSavedSource, this.lastSavedJavaFX);
        }
        try {
            if (this.panel == null || this.panel.getSource() == null) {
                SaveJavaResult javaResult = this.saveJava(this.lastSource, true);
                return new SaveResult(Utility.serialiseCodeToString((Element)this.lastSource.toXML()), javaResult);
            }
            this.panel.regenerateAndReparse();
            TopLevelCodeElement source = this.panel.getSource();
            if (source == null) {
                return new SaveResult(Utility.serialiseCodeToString((Element)this.lastSource.toXML()), null);
            }
            Lock readLock = this.filenameLock.readLock();
            readLock.lock();
            try (FileOutputStream os = new FileOutputStream(this.frameFilename);){
                Utility.serialiseCodeTo((Element)source.toXML(), (OutputStream)os);
            }
            finally {
                readLock.unlock();
            }
            this.lastSavedJavaFX = this.saveJava(this.panel.getSource(), true);
            this.changedSinceLastSave = false;
            this.lastSavedSource = Utility.serialiseCodeToString((Element)source.toXML());
            this.panel.saved();
            this.lastSource = this.panel.getSource();
            return new SaveResult(this.lastSavedSource, this.lastSavedJavaFX);
        }
        catch (IOException e) {
            return new SaveResult(e);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void saveJavaWithoutWarning() throws IOException {
        this.saveJava(this.lastSource, false);
    }

    @OnThread(value=Tag.FXPlatform)
    private SaveJavaResult saveJava(TopLevelCodeElement source, boolean warning) throws IOException {
        if (source == null) {
            return null;
        }
        FileOutputStream fos = new FileOutputStream(this.javaFilename);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8"));
        JavaSource js = source.toJavaSource(warning);
        String javaString = js.toDiskJavaCodeString();
        w.write(javaString);
        w.close();
        fos.close();
        this.javaSource.set((Object)js);
        return new SaveJavaResult(js, javaString, source.toXML().buildLocationMap());
    }

    @Override
    public TextEditor assumeText() {
        return new TextEditor(){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void writeMessage(String msg) {
                FrameEditor.this.writeMessage(msg);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void showInterface(boolean interfaceStatus) {
                FrameEditor.this.showInterface(interfaceStatus);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setEditorVisible(boolean vis) {
                FrameEditor.this.setEditorVisible(vis);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setReadOnly(boolean readOnly) {
                FrameEditor.this.setReadOnly(readOnly);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setProperty(String propertyKey, Object value) {
                FrameEditor.this.setProperty(propertyKey, value);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setCompiled(boolean compiled) {
                FrameEditor.this.setCompiled(compiled);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void save() throws IOException {
                FrameEditor.this.save();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void removeStepMark() {
                FrameEditor.this.removeStepMark();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void removeBreakpoints() {
                FrameEditor.this.removeBreakpoints();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void reloadFile() {
                FrameEditor.this.reloadFile();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void refresh() {
                FrameEditor.this.refresh();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void reInitBreakpoints() {
                FrameEditor.this.reInitBreakpoints();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public FXRunnable printTo(PrinterJob printerJob, boolean printLineNumbers, boolean printBackground) {
                return FrameEditor.this.printTo(printerJob, printLineNumbers, printBackground);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public boolean isOpen() {
                return FrameEditor.this.isOpen();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public boolean isReadOnly() {
                return FrameEditor.this.isReadOnly();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public boolean isModified() {
                return FrameEditor.this.isModified();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public Object getProperty(String propertyKey) {
                return FrameEditor.this.getProperty(propertyKey);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void displayMessage(String message, int lineNumber, int column) {
                FrameEditor.this.displayMessage(message, lineNumber, column);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public boolean displayDiagnostic(Diagnostic diagnostic, int errorIndex, CompileType compileType) {
                return FrameEditor.this.displayDiagnostic(diagnostic, errorIndex, compileType);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setStepMark(int lineNumber, String message, boolean isBreak, DebuggerThread thread) {
                FrameEditor.this.setStepMark(lineNumber, message, isBreak, thread);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void close() {
                FrameEditor.this.close();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void changeName(String title, String filename, String javaFilename, String docFileName) {
                FrameEditor.this.changeName(title, filename, javaFilename, docFileName);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public TextEditor assumeText() {
                return this;
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public boolean showFile(String filename, Charset charset, boolean compiled, String docFilename) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setText(SourceLocation begin, SourceLocation end, String newText) throws BadLocationException {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setSelection(int firstlineNumber, int firstColumn, int secondLineNumber, int SecondColumn) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setSelection(SourceLocation begin, SourceLocation end) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setSelection(int lineNumber, int column, int len) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setCaretLocation(SourceLocation location) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public int numberOfLines() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void insertText(String text, boolean caretBack) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public int getTextLength() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public String getText(SourceLocation begin, SourceLocation end) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public MoeSyntaxDocument getSourceDocument() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public SourceLocation getSelectionEnd() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public SourceLocation getSelectionBegin() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public ParsedCUNode getParsedNode() {
                return null;
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public int getOffsetFromLineColumn(SourceLocation location) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public int getLineLength(int line) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public SourceLocation getLineColumnFromOffset(int offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public SourceLocation getCaretLocation() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void compileFinished(boolean successful, boolean classesKept) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void insertAppendMethod(bluej.extensions.editor.Editor e, NormalMethodElement method, Consumer<Boolean> after) {
                FrameEditor.this.insertAppendMethod(e, method, after);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void insertMethodCallInConstructor(bluej.extensions.editor.Editor e, String className, CallElement methodName, Consumer<Boolean> after) {
                FrameEditor.this.insertMethodCallInConstructor(e, className, methodName, after);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public FrameEditor assumeFrame() {
                return FrameEditor.this;
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public boolean compileStarted(int compilationSequence) {
                return FrameEditor.this.compileStarted(compilationSequence);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void cancelFreshState() {
                FrameEditor.this.cancelFreshState();
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void focusMethod(String methodName, List<String> paramTypes) {
                FrameEditor.this.focusMethod(methodName, paramTypes);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void setExtendsClass(String className, ClassInfo classInfo) {
                FrameEditor.this.setExtendsClass(className, classInfo);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void addImplements(String className, ClassInfo classInfo) {
                FrameEditor.this.addImplements(className, classInfo);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void removeExtendsClass(ClassInfo classInfo) {
                FrameEditor.this.removeExtendsClass(classInfo);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void addExtendsInterface(String interfaceName, ClassInfo classInfo) {
                FrameEditor.this.addExtendsInterface(interfaceName, classInfo);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void removeExtendsOrImplementsInterface(String interfaceName, ClassInfo classInfo) {
                FrameEditor.this.removeExtendsOrImplementsInterface(interfaceName, classInfo);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void removeImports(List<String> importTargets) {
                FrameEditor.this.removeImports(importTargets);
            }
        };
    }

    @Override
    public void reloadFile() {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void displayMessage(String message, int lineNumber, int column) {
        JavaFXUtil.onceNotNull(this.javaSource, js -> JavaFXUtil.runNowOrLater(() -> {
            this.setVisibleFX(true, true);
            js.handleException(lineNumber);
        }));
    }

    @Override
    public boolean displayDiagnostic(Diagnostic diagnostic, int errorIndex, CompileType compileType) {
        JavaFragment fragment;
        if (this.lastSavedJavaSwing != null && this.lastSavedJavaSwing.javaSource != null && this.lastSavedJavaSwing.xpathLocations != null && (fragment = this.lastSavedJavaSwing.javaSource.findError((int)diagnostic.getStartLine(), (int)diagnostic.getStartColumn(), (int)diagnostic.getEndLine(), (int)diagnostic.getEndColumn(), diagnostic.getMessage())) != null) {
            String xpath = this.lastSavedJavaSwing.xpathLocations.locationFor(fragment);
            int start = fragment.getErrorStartPos((int)diagnostic.getStartLine(), (int)diagnostic.getStartColumn());
            int end = fragment.getErrorEndPos((int)diagnostic.getEndLine(), (int)diagnostic.getEndColumn());
            if (xpath != null) {
                diagnostic.setXPath(xpath, start, end);
            }
        }
        if (this.panel != null && this.panel.getSource() != null) {
            JavaFXUtil.onceNotNull(this.javaSource, js -> js.handleError((int)diagnostic.getStartLine(), (int)diagnostic.getStartColumn(), (int)diagnostic.getEndLine(), (int)diagnostic.getEndColumn(), diagnostic.getMessage(), diagnostic.getIdentifier()));
        } else {
            this.queuedErrors.add(new QueuedError(diagnostic.getStartLine(), diagnostic.getStartColumn(), diagnostic.getEndLine(), diagnostic.getEndColumn(), diagnostic.getMessage(), diagnostic.getIdentifier()));
        }
        if (compileType.showEditorOnError()) {
            this.setVisibleFX(true, true);
        }
        return false;
    }

    @Override
    public void setStepMark(int lineNumber, String message, boolean isBreak, DebuggerThread thread) {
        DebuggerObject currentObject;
        this.removeStepMark();
        this.setVisibleFX(true, true);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (thread != null && (currentObject = thread.getCurrentObject(0)) != null && !currentObject.isNullObject()) {
            Map restrictedClasses = this.pkg.getProject().getExecControls().getRestrictedClasses();
            List fields = currentObject.getFields();
            for (DebuggerField field : fields) {
                String declaringClass;
                Set whiteList;
                if (Modifier.isStatic(field.getModifiers()) || (whiteList = (Set)restrictedClasses.get(declaringClass = field.getDeclaringClassName())) != null && !whiteList.contains(field.getName())) continue;
                if (field.isReferenceType()) {
                    vars.put(field.getName(), new ReferenceDebugVarInfo(this.pkg, null, field));
                    continue;
                }
                vars.put(field.getName(), new PrimitiveDebugVarInfo(field.getValueString()));
            }
        }
        this.debugInfo.addVarState(vars, this.execHistory.size());
        this.panel.showDebuggerControls(thread);
        if (this.curBreakpoint != null) {
            this.curBreakpoint.removeHighlight();
            this.curBreakpoint = null;
        }
        try {
            JavaSource js = (JavaSource)this.javaSource.get();
            if (js == null) {
                js = this.saveJava(this.lastSource, true).javaSource;
            }
            this.curBreakpoint = js.handleStop(lineNumber, this.debugInfo);
            if (this.curBreakpoint.isBreakpointFrame()) {
                thread.step();
            } else {
                if (this.execHistory.isEmpty() || this.execHistory.get(this.execHistory.size() - 1) != this.curBreakpoint) {
                    this.execHistory.add(this.curBreakpoint);
                }
                this.panel.redrawExecHistory(this.execHistory);
            }
        }
        catch (IOException ioe) {
            Debug.reportError((String)"Exception attempting to save Java source for Stride class", (Throwable)ioe);
        }
    }

    @Override
    public void writeMessage(String msg) {
    }

    @Override
    public void removeStepMark() {
    }

    @Override
    public void changeName(String title, String filename, String javaFilename, String docFileName) {
        this.frameFilename = new File(filename);
        this.javaFilename = new File(javaFilename);
    }

    @Override
    public void setCompiled(boolean compiled) {
        this.isCompiled = compiled;
    }

    @Override
    public void removeBreakpoints() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reInitBreakpoints() {
        IOException e;
        this.watcher.clearAllBreakpoints();
        if (this.javaSource.get() == null && (e = this._saveFX().exception) != null) {
            Debug.reportError((Throwable)e);
        }
        if (this.javaSource.get() != null) {
            JavaSource latestSource = (JavaSource)this.javaSource.get();
            this.watcher.clearAllBreakpoints();
            List breaks = latestSource.registerBreakpoints((Editor)this, this.watcher);
            FrameEditor frameEditor = this;
            synchronized (frameEditor) {
                this.latestBreakpoints = breaks;
            }
        }
    }

    @Override
    public boolean isModified() {
        return !this.isCompiled;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public FXRunnable printTo(PrinterJob job, boolean printLineNumbers, boolean printBackground) {
        CompletableFuture inited = new CompletableFuture();
        if (this.panel == null) {
            this.setVisibleFX(true, false);
        }
        JavaFXUtil.onceTrue((ObservableValue)this.panel.initialisedProperty(), init -> inited.complete(init));
        return () -> {
            try {
                inited.get();
                CompletableFuture done = new CompletableFuture();
                JavaFXUtil.runPlatformLater(() -> {
                    job.printPage(this.panel.getSource().getFrame().getNode());
                    done.complete(true);
                });
                done.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Debug.reportError((Throwable)e);
            }
        };
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void showInterface(boolean interfaceStatus) {
    }

    @Override
    public Object getProperty(String propertyKey) {
        return null;
    }

    @Override
    public void setProperty(String propertyKey, Object value) {
    }

    @Override
    public void setEditorVisible(boolean vis) {
        this.setVisibleFX(vis, true);
    }

    @OnThread(value=Tag.FXPlatform)
    private void setVisibleFX(boolean show, boolean bringToFront) {
        if (this.panel == null && show) {
            this.createPanel(show, bringToFront);
        }
        if (this.panel != null) {
            this.panel.setWindowVisible(show, bringToFront);
            if (this.callbackOnOpen != null && show) {
                this.callbackOnOpen.run();
            }
        }
        if (show) {
            this.panel.withTopLevelFrame((FXConsumer<TopLevelFrame<? extends TopLevelCodeElement>>)((FXConsumer)f -> JavaFXUtil.runPlatformLater(() -> {
                if (!this.queuedErrors.isEmpty()) {
                    IOException ex = this._saveFX().exception;
                    if (ex != null) {
                        Debug.reportError((Throwable)ex);
                        return;
                    }
                    ArrayList<QueuedError> queueCopy = new ArrayList<QueuedError>(this.queuedErrors);
                    this.queuedErrors.clear();
                    JavaFXUtil.onceNotNull(this.javaSource, js -> {
                        for (QueuedError e : queueCopy) {
                            JavaFXUtil.runPlatformLater(() -> js.handleError((int)e.startLine, (int)e.startColumn, (int)e.endLine, (int)e.endColumn, e.message, e.identifier));
                        }
                        JavaFXUtil.runPlatformLater(() -> this.panel.updateErrorOverviewBar(false));
                    });
                }
            })));
        }
    }

    @OnThread(value=Tag.FX)
    public void codeModified() {
        JavaFXUtil.runNowOrLater(() -> {
            this.changedSinceLastSave = true;
            this.isCompiled = false;
            this.watcher.modificationEvent(this);
            this.watcher.scheduleCompilation(false, CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
        });
    }

    @Override
    @OnThread(value=Tag.FX)
    public FrameEditor assumeFrame() {
        return this;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public void compileFinished(boolean successful, boolean classesKept) {
        if (this.panel != null && this.panel.isWindowVisible()) {
            if (!this.foundLateErrorsForMostRecentCompile) {
                this.foundLateErrorsForMostRecentCompile = true;
                this.findLateErrors(this.mostRecentCompileIdentifier);
                this.mostRecentCompileIdentifier = -1;
            }
            this.panel.compiled();
        }
        this.reInitBreakpoints();
    }

    @OnThread(value=Tag.FXPlatform)
    private void findLateErrors(int compilationIdentifier) {
        this.panel.removeOldErrors();
        TopLevelCodeElement el = this.panel.getSource();
        if (el == null) {
            return;
        }
        Stream<CodeElement> allElements = Stream.concat(Stream.of((CodeElement)el), el.streamContained());
        LocatableElement.LocationMap rootPathMap = el.toXML().buildLocationMap();
        List futures = allElements.flatMap(e -> e.findDirectLateErrors((InteractionManager)this.panel, rootPathMap)).collect(Collectors.toList());
        Utility.runBackground(() -> {
            ArrayList allLates = new ArrayList();
            try {
                for (Future f : futures) {
                    allLates.addAll((Collection)f.get());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Debug.reportError((Throwable)e);
            }
            Platform.runLater(() -> {
                this.panel.updateErrorOverviewBar(false);
                List diagnostics = Utility.mapList((Collection)allLates, e -> e.toDiagnostic(this.javaFilename.getName(), this.frameFilename));
                this.watcher.recordLateErrors(diagnostics, compilationIdentifier);
            });
        });
    }

    @Override
    public boolean compileStarted(int compilationSequence) {
        this.foundLateErrorsForMostRecentCompile = false;
        this.mostRecentCompileIdentifier = compilationSequence;
        if (this.panel != null) {
            this.panel.flagErrorsAsOld();
        } else {
            this.queuedErrors.clear();
        }
        return this.earlyErrorCheck(this.lastSource.findEarlyErrors(), compilationSequence);
    }

    @OnThread(value=Tag.FXPlatform)
    boolean earlyErrorCheck(Stream<SyntaxCodeError> earlyErrors, int compilationIdentifier) {
        List earlyList = earlyErrors.collect(Collectors.toList());
        List diagnostics = Utility.mapList(earlyList, e -> e.toDiagnostic(this.javaFilename.getName(), this.frameFilename));
        this.watcher.recordEarlyErrors(diagnostics, compilationIdentifier);
        return !earlyList.isEmpty();
    }

    public AssistContent[] getCompletions(TopLevelCodeElement allCode, JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing, CodeElement codeEl) {
        AssistContent[] assists;
        CodeSuggestions suggests = allCode.getCodeSuggestions(pos, completing);
        ArrayList<AssistContent> joined = new ArrayList<AssistContent>();
        if (suggests != null && (assists = ParseUtils.getPossibleCompletions((CodeSuggestions)suggests, (JavadocResolver)this.javadocResolver, null)) != null) {
            joined.addAll(Arrays.asList(assists));
        }
        if (suggests != null && suggests.isPlain()) {
            if (Config.isGreenfoot()) {
                JavaReflective greenfootClassRef = new JavaReflective(this.pkg.loadClass("greenfoot.Greenfoot"));
                CodeSuggestions greenfootClass = new CodeSuggestions((JavaType)new GenTypeClass((Reflective)greenfootClassRef), null, null, true, false);
                AssistContent[] greenfootStatic = ParseUtils.getPossibleCompletions((CodeSuggestions)greenfootClass, (JavadocResolver)this.javadocResolver, null);
                Arrays.stream(greenfootStatic).filter(ac -> ac.getKind() == AssistContent.CompletionKind.METHOD).forEach(ac -> joined.add((AssistContent)new PrefixCompletionWrapper(ac, "Greenfoot.")));
            }
            for (CodeElement.LocalParamInfo v : ASTUtility.findLocalsAndParamsInScopeAt((CodeElement)codeEl, (boolean)false, (boolean)false)) {
                AssistContent c = LocalCompletion.getCompletion((String)v.getType(), (String)v.getName(), (boolean)v.isParam());
                if (c == null) continue;
                joined.add(c);
            }
        }
        return joined.toArray(new AssistContent[0]);
    }

    public List<AssistContent> getAvailableMembers(TopLevelCodeElement allCode, JavaFragment.PosInSourceDoc pos, Set<AssistContent.CompletionKind> kinds, boolean includeOverridden) {
        List<Object> members;
        CodeSuggestions suggests = allCode.getCodeSuggestions(pos, null);
        if (suggests == null) {
            return Collections.emptyList();
        }
        if (includeOverridden) {
            members = new ArrayList();
            ParseUtils.getPossibleCompletions((CodeSuggestions)suggests, (JavadocResolver)this.javadocResolver, (ac, isOverridden) -> members.add(ac));
        } else {
            AssistContent[] result = ParseUtils.getPossibleCompletions((CodeSuggestions)suggests, (JavadocResolver)this.javadocResolver, null);
            members = result == null ? Collections.emptyList() : Arrays.asList(result);
        }
        return members.stream().filter(ac -> kinds == null || kinds.contains(ac.getKind())).collect(Collectors.toList());
    }

    @Override
    public void insertAppendMethod(bluej.extensions.editor.Editor e, NormalMethodElement method, Consumer<Boolean> after) {
        if (this.panel == null) {
            this.createPanel(false, false);
        }
        this.panel.insertAppendMethod(method, after);
    }

    @Override
    public void insertMethodCallInConstructor(bluej.extensions.editor.Editor e, String className, CallElement methodName, Consumer<Boolean> after) {
        if (this.panel == null) {
            this.createPanel(false, false);
        }
        this.panel.insertMethodCallInConstructor(className, methodName, after);
    }

    @Override
    public void removeImports(List<String> importTargets) {
        if (this.panel == null) {
            this.createPanel(false, false);
        }
        this.panel.removeImports(importTargets);
    }

    @OnThread(value=Tag.FX)
    public TopLevelCodeElement getSource() {
        return this.panel.getSource();
    }

    @OnThread(value=Tag.FXPlatform)
    public List<AssistContentThreadSafe> getLocalTypes(Class<?> superType, boolean includeSelf, Set<InteractionManager.Kind> kinds) {
        return this.pkg.getClassTargets().stream().filter(ct -> {
            if (superType != null) {
                ClassInfo info = ct.getSourceInfo().getInfoIfAvailable();
                if (info == null) {
                    return false;
                }
                boolean hasSuperType = false;
                hasSuperType |= superType.getName().equals(info.getSuperclass());
                if (!(hasSuperType |= info.getImplements().stream().anyMatch(s -> superType.getName().equals(s)))) {
                    return false;
                }
            }
            if (ct.isInterface()) {
                return kinds.contains(InteractionManager.Kind.INTERFACE);
            }
            if (ct.isEnum()) {
                return kinds.contains(InteractionManager.Kind.ENUM);
            }
            return kinds.contains(InteractionManager.Kind.CLASS_FINAL) || kinds.contains(InteractionManager.Kind.CLASS_NON_FINAL);
        }).map(ct -> new AssistContentThreadSafe(LocalTypeCompletion.getCompletion((ClassTarget)ct))).collect(Collectors.toList());
    }

    public void showNextError() {
        this.panel.nextError();
    }

    @Override
    public void cancelFreshState() {
        if (this.panel != null) {
            this.panel.cancelFreshState();
        }
    }

    @Override
    public void focusMethod(String methodName, List<String> paramTypes) {
        if (this.panel == null) {
            this.createPanel(true, true);
        }
        this.panel.focusMethod(methodName);
    }

    public JavadocResolver getJavadocResolver() {
        return this.javadocResolver;
    }

    @OnThread(value=Tag.Any)
    public EditorWatcher getWatcher() {
        return this.watcher;
    }

    @OnThread(value=Tag.FXPlatform)
    public void recordEdits(StrideEditReason reason) {
        SaveResult result = this._saveFX();
        if (result.exception == null) {
            this.watcher.recordStrideEdit(result.javaResult.javaSourceStringContent, result.savedSource, reason);
        } else {
            Debug.reportError((Throwable)result.exception);
        }
    }

    @Override
    public void addImplements(String className, ClassInfo classInfo) {
        if (this.panel == null) {
            this.createPanel(false, false);
        }
        JavaFXUtil.onceTrue((ObservableValue)this.panel.initialisedProperty(), p -> this.panel.addImplements(className));
    }

    @Override
    public void setExtendsClass(String className, ClassInfo classInfo) {
        if (this.panel == null) {
            this.createPanel(false, false);
        }
        JavaFXUtil.onceTrue((ObservableValue)this.panel.initialisedProperty(), p -> this.panel.addExtends(className));
    }

    @Override
    public void removeExtendsClass(ClassInfo classInfo) {
        if (this.panel == null) {
            this.createPanel(false, false);
        }
        JavaFXUtil.onceTrue((ObservableValue)this.panel.initialisedProperty(), p -> this.panel.removeExtendsClass());
    }

    @Override
    public void addExtendsInterface(String interfaceName, ClassInfo classInfo) {
        if (this.panel == null) {
            this.createPanel(false, false);
        }
        JavaFXUtil.onceTrue((ObservableValue)this.panel.initialisedProperty(), p -> this.panel.addExtends(interfaceName));
    }

    @Override
    public void removeExtendsOrImplementsInterface(String interfaceName, ClassInfo classInfo) {
        if (this.panel == null) {
            this.createPanel(false, false);
        }
        JavaFXUtil.onceTrue((ObservableValue)this.panel.initialisedProperty(), p -> this.panel.removeExtendsOrImplementsInterface(interfaceName));
    }

    private class SaveJavaResult {
        private final JavaSource javaSource;
        private final String javaSourceStringContent;
        private final LocatableElement.LocationMap xpathLocations;

        public SaveJavaResult(JavaSource javaSource, String javaSourceStringContent, LocatableElement.LocationMap xpathLocations) {
            this.javaSource = javaSource;
            this.javaSourceStringContent = javaSourceStringContent;
            this.xpathLocations = xpathLocations;
        }
    }

    private static class SaveResult {
        private final IOException exception;
        private final String savedSource;
        private final SaveJavaResult javaResult;

        public SaveResult(IOException exception) {
            this.exception = exception;
            this.savedSource = null;
            this.javaResult = null;
        }

        public SaveResult(String savedSource, SaveJavaResult javaResult) {
            this.savedSource = savedSource;
            this.javaResult = javaResult;
            this.exception = null;
        }
    }

    @OnThread(value=Tag.Any)
    private static class QueuedError {
        private final long startLine;
        private final long startColumn;
        private final long endLine;
        private final long endColumn;
        private final String message;
        private final int identifier;

        private QueuedError(long startLine, long startColumn, long endLine, long endColumn, String message, int identifier) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
            this.message = message;
            this.identifier = identifier;
        }
    }
}

