/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.MoeSyntaxDocument;
import javax.swing.text.BadLocationException;

public class TextUtilities {
    public static int findMatchingBracket(MoeSyntaxDocument doc, int offset) throws BadLocationException {
        int i;
        int len;
        int texttOffset;
        int step;
        boolean direction;
        char cprime;
        if (doc.getLength() == 0) {
            return -1;
        }
        char c = doc.getText(offset, 1).charAt(0);
        switch (c) {
            case '(': {
                cprime = ')';
                direction = false;
                break;
            }
            case ')': {
                cprime = '(';
                direction = true;
                break;
            }
            case '[': {
                cprime = ']';
                direction = false;
                break;
            }
            case ']': {
                cprime = '[';
                direction = true;
                break;
            }
            case '{': {
                cprime = '}';
                direction = false;
                break;
            }
            case '}': {
                cprime = '{';
                direction = true;
                break;
            }
            default: {
                return -1;
            }
        }
        int count = 1;
        if (direction) {
            step = -1;
            texttOffset = 0;
            len = offset;
            i = len - 1;
        } else {
            step = 1;
            texttOffset = offset + 1;
            len = doc.getLength() - texttOffset;
            i = 0;
        }
        String textt = doc.getText(texttOffset, len);
        block8: while (len > 0) {
            char x = textt.charAt(i);
            if (x == c) {
                ++count;
            } else if (x == cprime && --count == 0) {
                return i + texttOffset;
            }
            --len;
            i += step;
            if (x != '\"' && x != '\'') continue;
            char quoteChar = x;
            while (len > 0) {
                x = textt.charAt(i);
                if (x == quoteChar && (i == 0 || textt.charAt(i - 1) != '\\')) {
                    --len;
                    i += step;
                    continue block8;
                }
                --len;
                i += step;
            }
        }
        return -1;
    }

    public static int findWordStart(String line, int pos, String noWordSep) {
        char ch = line.charAt(pos - 1);
        if (noWordSep == null) {
            noWordSep = "";
        }
        boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
        int wordStart = 0;
        for (int i = pos - 1; i >= 0; --i) {
            ch = line.charAt(i);
            if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
            wordStart = i + 1;
            break;
        }
        return wordStart;
    }

    public static int findWordEnd(String line, int pos, String noWordSep) {
        char ch = line.charAt(pos);
        if (noWordSep == null) {
            noWordSep = "";
        }
        boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
        int wordEnd = line.length();
        for (int i = pos; i < line.length(); ++i) {
            ch = line.charAt(i);
            if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
            wordEnd = i;
            break;
        }
        return wordEnd;
    }
}

